/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.validation;

import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DSSNotETSICompliantException;
import eu.europa.esig.dss.DSSUtils;
import eu.europa.esig.dss.DigestAlgorithm;
import eu.europa.esig.dss.EncryptionAlgorithm;
import eu.europa.esig.dss.SignatureAlgorithm;
import eu.europa.esig.dss.SignatureForm;
import eu.europa.esig.dss.SignatureLevel;
import eu.europa.esig.dss.TokenIdentifier;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.CRLRef;
import eu.europa.esig.dss.validation.CandidatesForSigningCertificate;
import eu.europa.esig.dss.validation.CertificateRef;
import eu.europa.esig.dss.validation.CertificateValidity;
import eu.europa.esig.dss.validation.CertifiedRole;
import eu.europa.esig.dss.validation.CommitmentType;
import eu.europa.esig.dss.validation.DefaultAdvancedSignature;
import eu.europa.esig.dss.validation.OCSPRef;
import eu.europa.esig.dss.validation.SignatureCryptographicVerification;
import eu.europa.esig.dss.validation.SignatureProductionPlace;
import eu.europa.esig.dss.validation.TimestampInclude;
import eu.europa.esig.dss.validation.TimestampReference;
import eu.europa.esig.dss.validation.TimestampReferenceCategory;
import eu.europa.esig.dss.validation.TimestampToken;
import eu.europa.esig.dss.x509.ArchiveTimestampType;
import eu.europa.esig.dss.x509.CertificatePool;
import eu.europa.esig.dss.x509.CertificateToken;
import eu.europa.esig.dss.x509.SignaturePolicy;
import eu.europa.esig.dss.x509.TimestampType;
import eu.europa.esig.dss.x509.Token;
import eu.europa.esig.dss.x509.crl.OfflineCRLSource;
import eu.europa.esig.dss.x509.ocsp.OfflineOCSPSource;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.XPathQueryHolder;
import eu.europa.esig.dss.xades.validation.OfflineResolver;
import eu.europa.esig.dss.xades.validation.SignatureRSARIPEMD160AT;
import eu.europa.esig.dss.xades.validation.XAdESCRLSource;
import eu.europa.esig.dss.xades.validation.XAdESCertificateSource;
import eu.europa.esig.dss.xades.validation.XAdESOCSPSource;
import eu.europa.esig.dss.xades.validation.XPointerResourceResolver;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.math.BigInteger;
import java.security.Key;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import javax.xml.bind.DatatypeConverter;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.xml.security.Init;
import org.apache.xml.security.algorithms.JCEMapper;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.keyresolver.KeyResolverException;
import org.apache.xml.security.signature.Reference;
import org.apache.xml.security.signature.ReferenceNotInitializedException;
import org.apache.xml.security.signature.SignedInfo;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.tsp.TimeStampToken;
import org.digidoc4j.dss.xades.BDocTmSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XAdESSignature
extends DefaultAdvancedSignature {
    private static final Logger LOG = LoggerFactory.getLogger(XAdESSignature.class);
    private static SignatureLevel[] signatureLevels = new SignatureLevel[]{SignatureLevel.XML_NOT_ETSI, SignatureLevel.XAdES_BASELINE_B, SignatureLevel.XAdES_BASELINE_T, SignatureLevel.XAdES_C, SignatureLevel.XAdES_X, SignatureLevel.XAdES_BASELINE_LT, SignatureLevel.XAdES_BASELINE_LTA};
    private final List<XPathQueryHolder> xPathQueryHolders;
    protected XPathQueryHolder xPathQueryHolder;
    public static final String DEFAULT_TIMESTAMP_VALIDATION_CANONICALIZATION_METHOD = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
    private final Element signatureElement;
    private String signatureId;
    private XAdESCertificateSource certificatesSource;
    private transient List<Reference> references = new ArrayList<Reference>();
    private List<TimestampReference> signingCertificateTimestampReferences;

    public XAdESSignature(Element signatureElement, CertificatePool certPool) {
        this(signatureElement, (List<XPathQueryHolder>)new ArrayList<XPathQueryHolder>(){
            {
                this.add(new XPathQueryHolder());
            }
        }, certPool);
    }

    public XAdESSignature(Element signatureElement, List<XPathQueryHolder> xPathQueryHolders, CertificatePool certPool) {
        super(certPool);
        if (signatureElement == null) {
            throw new NullPointerException("signatureElement");
        }
        this.signatureElement = signatureElement;
        this.xPathQueryHolders = xPathQueryHolders;
        this.initialiseSettings();
    }

    private void initialiseSettings() {
        this.recursiveNamespaceBrowser(this.signatureElement);
        if (this.xPathQueryHolder == null) {
            LOG.warn("There is no suitable XPathQueryHolder to manage the signature. The default one will be used.");
            this.xPathQueryHolder = new XPathQueryHolder();
        }
    }

    public void recursiveNamespaceBrowser(Element element) {
        for (int ii = 0; ii < element.getChildNodes().getLength(); ++ii) {
            Node node = element.getChildNodes().item(ii);
            if (node.getNodeType() != 1) continue;
            Element childElement = (Element)node;
            String namespaceURI = childElement.getNamespaceURI();
            String localName = childElement.getLocalName();
            if ("Transform".equals(localName) && "http://www.w3.org/2000/09/xmldsig#".equals(namespaceURI)) continue;
            if ("QualifyingProperties".equals(localName)) {
                this.setXPathQueryHolder(namespaceURI);
                return;
            }
            this.recursiveNamespaceBrowser(childElement);
        }
    }

    private void setXPathQueryHolder(String namespaceURI) {
        for (XPathQueryHolder xPathQueryHolder : this.xPathQueryHolders) {
            boolean canUseThisXPathQueryHolder = xPathQueryHolder.canUseThisXPathQueryHolder(namespaceURI);
            if (!canUseThisXPathQueryHolder) continue;
            this.xPathQueryHolder = xPathQueryHolder;
        }
    }

    public XPathQueryHolder getXPathQueryHolder() {
        return this.xPathQueryHolder;
    }

    public CertificatePool getCertPool() {
        return this.certPool;
    }

    public Element getSignatureElement() {
        return this.signatureElement;
    }

    public SignatureForm getSignatureForm() {
        return SignatureForm.XAdES;
    }

    public EncryptionAlgorithm getEncryptionAlgorithm() {
        String xmlName = DSSXMLUtils.getElement(this.signatureElement, this.xPathQueryHolder.XPATH_SIGNATURE_METHOD).getAttribute("Algorithm");
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.forXML((String)xmlName, null);
        if (signatureAlgorithm == null) {
            return null;
        }
        return signatureAlgorithm.getEncryptionAlgorithm();
    }

    public DigestAlgorithm getDigestAlgorithm() {
        String xmlName = DSSXMLUtils.getElement(this.signatureElement, this.xPathQueryHolder.XPATH_SIGNATURE_METHOD).getAttribute("Algorithm");
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.forXML((String)xmlName, null);
        if (signatureAlgorithm == null) {
            return null;
        }
        return signatureAlgorithm.getDigestAlgorithm();
    }

    public XAdESCertificateSource getCertificateSource() {
        if (this.certificatesSource == null) {
            this.certificatesSource = new XAdESCertificateSource(this.signatureElement, this.xPathQueryHolder, this.certPool);
        }
        return this.certificatesSource;
    }

    public void resetCertificateSource() {
        this.certificatesSource = null;
    }

    public OfflineCRLSource getCRLSource() {
        if (this.offlineCRLSource == null) {
            this.offlineCRLSource = new XAdESCRLSource(this.signatureElement, this.xPathQueryHolder);
        }
        return this.offlineCRLSource;
    }

    public OfflineOCSPSource getOCSPSource() {
        if (this.offlineOCSPSource == null) {
            this.offlineOCSPSource = new XAdESOCSPSource(this.signatureElement, this.xPathQueryHolder);
        }
        return this.offlineOCSPSource;
    }

    public void resetRevocationSources() {
        this.offlineCRLSource = null;
        this.offlineOCSPSource = null;
    }

    public CandidatesForSigningCertificate getCandidatesForSigningCertificate() {
        if (this.candidatesForSigningCertificate != null) {
            return this.candidatesForSigningCertificate;
        }
        this.candidatesForSigningCertificate = new CandidatesForSigningCertificate();
        XAdESCertificateSource certSource = this.getCertificateSource();
        for (CertificateToken certificateToken : certSource.getKeyInfoCertificates()) {
            CertificateValidity certificateValidity = new CertificateValidity(certificateToken);
            this.candidatesForSigningCertificate.add(certificateValidity);
        }
        return this.candidatesForSigningCertificate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkSigningCertificate() {
        Element element;
        CandidatesForSigningCertificate candidates = this.getCandidatesForSigningCertificate();
        boolean isEn319132 = false;
        NodeList list = DSSXMLUtils.getNodeList(this.signatureElement, this.xPathQueryHolder.XPATH_SIGNING_CERTIFICATE_CERT);
        int length = list.getLength();
        if (length == 0) {
            list = DSSXMLUtils.getNodeList(this.signatureElement, this.xPathQueryHolder.XPATH_SIGNING_CERTIFICATE_CERT_V2);
            length = list.getLength();
            isEn319132 = true;
        }
        if (length == 0) {
            CertificateValidity theCertificateValidity = candidates.getTheCertificateValidity();
            CertificateToken certificateToken = theCertificateValidity == null ? null : theCertificateValidity.getCertificateToken();
            for (Reference reference : this.references) {
                String uri = reference.getURI();
                if (!uri.startsWith("#")) continue;
                String id = uri.substring(1);
                element = this.signatureElement.getOwnerDocument().getElementById(id);
                if (!this.hasSignatureAsParent(element) || certificateToken == null || !id.equals(certificateToken.getXmlId())) continue;
                theCertificateValidity.setSigned(element.getNodeName());
                return;
            }
        }
        HashMap<Element, Boolean> alreadyProcessedElements = new HashMap<Element, Boolean>();
        List certificateValidityList = candidates.getCertificateValidityList();
        block9: for (CertificateValidity certificateValidity : certificateValidityList) {
            CertificateToken certificateToken = certificateValidity.getCertificateToken();
            for (int ii = 0; ii < length; ++ii) {
                X500Principal candidateIssuerName;
                boolean issuerNameMatches;
                X500Principal issuerName;
                BigInteger serialNumber;
                block15: {
                    String textContent;
                    Element issuerNameEl;
                    block14: {
                        certificateValidity.setAttributePresent(true);
                        element = (Element)list.item(ii);
                        if (alreadyProcessedElements.containsKey(element)) continue;
                        Element certDigestElement = DSSXMLUtils.getElement(element, this.xPathQueryHolder.XPATH__CERT_DIGEST);
                        certificateValidity.setDigestPresent(certDigestElement != null);
                        Element digestMethodElement = DSSXMLUtils.getElement(certDigestElement, this.xPathQueryHolder.XPATH__DIGEST_METHOD);
                        if (digestMethodElement == null) continue;
                        String xmlAlgorithmName = digestMethodElement.getAttribute("Algorithm");
                        DigestAlgorithm digestAlgorithm = DigestAlgorithm.forXML((String)xmlAlgorithmName, (DigestAlgorithm)DigestAlgorithm.SHA1);
                        Element digestValueElement = DSSXMLUtils.getElement(element, this.xPathQueryHolder.XPATH__CERT_DIGEST_DIGEST_VALUE);
                        if (digestValueElement == null) continue;
                        byte[] storedBase64DigestValue = DSSUtils.base64StringToBase64Binary((String)digestValueElement.getTextContent());
                        byte[] digest = DSSUtils.digest((DigestAlgorithm)digestAlgorithm, (byte[])certificateToken.getEncoded());
                        byte[] recalculatedBase64DigestValue = Base64.encodeBase64((byte[])digest);
                        certificateValidity.setDigestEqual(false);
                        serialNumber = new BigInteger("0");
                        if (!Arrays.equals(recalculatedBase64DigestValue, storedBase64DigestValue)) continue;
                        issuerName = null;
                        if (!isEn319132) break block14;
                        issuerNameEl = DSSXMLUtils.getElement(element, this.xPathQueryHolder.XPATH__X509_ISSUER_V2);
                        if (issuerNameEl == null) break block15;
                        textContent = issuerNameEl.getTextContent();
                        ASN1InputStream is = null;
                        GeneralName name = null;
                        ASN1Integer serial = null;
                        try {
                            is = new ASN1InputStream(Base64.decodeBase64((String)textContent));
                            ASN1Sequence seq = (ASN1Sequence)is.readObject();
                            ASN1Sequence obj = (ASN1Sequence)seq.getObjectAt(0);
                            name = GeneralName.getInstance((Object)obj.getObjectAt(0));
                            serial = (ASN1Integer)seq.getObjectAt(1);
                        }
                        catch (IOException e) {
                            try {
                                LOG.error("Unable to decode textContent " + textContent + " : " + e.getMessage(), (Throwable)e);
                            }
                            catch (Throwable throwable) {
                                IOUtils.closeQuietly(is);
                                throw throwable;
                            }
                            IOUtils.closeQuietly((InputStream)is);
                        }
                        IOUtils.closeQuietly((InputStream)is);
                        try {
                            issuerName = new X500Principal(name.getName().toASN1Primitive().getEncoded());
                        }
                        catch (Exception e) {
                            LOG.error("Unable to decode X500Principal : " + e.getMessage(), (Throwable)e);
                        }
                        try {
                            serialNumber = serial.getValue();
                        }
                        catch (Exception e) {
                            LOG.error("Unable to decode serialNumber : " + e.getMessage(), (Throwable)e);
                        }
                        break block15;
                    }
                    issuerNameEl = DSSXMLUtils.getElement(element, this.xPathQueryHolder.XPATH__X509_ISSUER_NAME);
                    textContent = issuerNameEl.getTextContent();
                    issuerName = DSSUtils.getX500PrincipalOrNull((String)textContent);
                    Element serialNumberEl = DSSXMLUtils.getElement(element, this.xPathQueryHolder.XPATH__X509_SERIAL_NUMBER);
                    String serialNumberText = serialNumberEl.getTextContent();
                    serialNumber = new BigInteger(serialNumberText.trim());
                }
                if (!(issuerNameMatches = DSSUtils.x500PrincipalAreEquals((X500Principal)(candidateIssuerName = certificateToken.getIssuerX500Principal()), (X500Principal)issuerName))) {
                    String c14nCandidateIssuerName = candidateIssuerName.getName("CANONICAL");
                    LOG.info("candidateIssuerName: " + c14nCandidateIssuerName);
                    String c14nIssuerName = issuerName == null ? "" : issuerName.getName("CANONICAL");
                    LOG.info("issuerName         : " + c14nIssuerName);
                }
                BigInteger candidateSerialNumber = certificateToken.getSerialNumber();
                boolean serialNumberMatches = candidateSerialNumber.equals(serialNumber);
                certificateValidity.setDigestEqual(true);
                certificateValidity.setSerialNumberEqual(serialNumberMatches);
                certificateValidity.setDistinguishedNameEqual(issuerNameMatches);
                alreadyProcessedElements.put(element, true);
                if (candidates.getTheCertificateValidity() != null) continue block9;
                candidates.setTheCertificateValidity(certificateValidity);
                continue block9;
            }
        }
    }

    private boolean hasSignatureAsParent(Element element) {
        if (element == null) {
            return false;
        }
        Node node = element;
        String nodeName = node.getNodeName();
        if ("X509Certificate".equals(nodeName)) {
            if ((node = node.getParentNode()) == null) {
                return false;
            }
            nodeName = node.getNodeName();
        }
        if ("X509Data".equals(nodeName)) {
            if ((node = node.getParentNode()) == null) {
                return false;
            }
            nodeName = node.getNodeName();
        }
        if ("KeyInfo".equals(nodeName) && (node = node.getParentNode()) == null) {
            return false;
        }
        return node.equals(this.signatureElement);
    }

    public Date getSigningTime() {
        Element signingTimeEl = DSSXMLUtils.getElement(this.signatureElement, this.xPathQueryHolder.XPATH_SIGNING_TIME);
        if (signingTimeEl == null) {
            return null;
        }
        String text = signingTimeEl.getTextContent();
        return DSSXMLUtils.getDate(text);
    }

    public SignaturePolicy getPolicyId() {
        Element policyIdentifier = DSSXMLUtils.getElement(this.signatureElement, this.xPathQueryHolder.XPATH_SIGNATURE_POLICY_IDENTIFIER);
        if (policyIdentifier != null) {
            Element policyId = DSSXMLUtils.getElement(policyIdentifier, this.xPathQueryHolder.XPATH__POLICY_ID);
            if (policyId != null) {
                String policyIdString = policyId.getTextContent();
                SignaturePolicy signaturePolicy = new SignaturePolicy(policyIdString);
                Node policyDigestMethod = DSSXMLUtils.getNode(policyIdentifier, this.xPathQueryHolder.XPATH__POLICY_DIGEST_METHOD);
                String policyDigestMethodString = policyDigestMethod.getTextContent();
                if (StringUtils.isNotEmpty((String)policyDigestMethodString)) {
                    DigestAlgorithm digestAlgorithm = DigestAlgorithm.forXML((String)policyDigestMethodString);
                    signaturePolicy.setDigestAlgorithm(digestAlgorithm);
                }
                Element policyDigestValue = DSSXMLUtils.getElement(policyIdentifier, this.xPathQueryHolder.XPATH__POLICY_DIGEST_VALUE);
                String digestValue = policyDigestValue.getTextContent().trim();
                signaturePolicy.setDigestValue(DatatypeConverter.parseBase64Binary((String)digestValue));
                Element policyUrl = DSSXMLUtils.getElement(policyIdentifier, this.xPathQueryHolder.XPATH__POLICY_SPURI);
                if (policyUrl != null) {
                    signaturePolicy.setUrl(policyUrl.getTextContent().trim());
                }
                return signaturePolicy;
            }
            Element signaturePolicyImplied = DSSXMLUtils.getElement(policyIdentifier, this.xPathQueryHolder.XPATH__SIGNATURE_POLICY_IMPLIED);
            if (signaturePolicyImplied != null) {
                return new SignaturePolicy();
            }
        }
        return null;
    }

    public SignatureProductionPlace getSignatureProductionPlace() {
        NodeList nodeList = DSSXMLUtils.getNodeList(this.signatureElement, this.xPathQueryHolder.XPATH_PRODUCTION_PLACE);
        if (!(nodeList.getLength() != 0 && nodeList.item(0) != null || (nodeList = DSSXMLUtils.getNodeList(this.signatureElement, this.xPathQueryHolder.XPATH_PRODUCTION_PLACE_V2)).getLength() != 0 && nodeList.item(0) != null)) {
            return null;
        }
        SignatureProductionPlace signatureProductionPlace = new SignatureProductionPlace();
        NodeList list = nodeList.item(0).getChildNodes();
        for (int ii = 0; ii < list.getLength(); ++ii) {
            Node item = list.item(ii);
            String name = item.getLocalName();
            String nodeValue = item.getTextContent();
            if ("City".equals(name)) {
                signatureProductionPlace.setCity(nodeValue);
                continue;
            }
            if ("StateOrProvince".equals(name)) {
                signatureProductionPlace.setStateOrProvince(nodeValue);
                continue;
            }
            if ("PostalCode".equals(name)) {
                signatureProductionPlace.setPostalCode(nodeValue);
                continue;
            }
            if ("CountryName".equals(name)) {
                signatureProductionPlace.setCountryName(nodeValue);
                continue;
            }
            if (!"StreetAddress".equals(name)) continue;
            signatureProductionPlace.setStreetAddress(nodeValue);
        }
        return signatureProductionPlace;
    }

    public String[] getClaimedSignerRoles() {
        NodeList nodeList = DSSXMLUtils.getNodeList(this.signatureElement, this.xPathQueryHolder.XPATH_CLAIMED_ROLE);
        if (nodeList.getLength() == 0 && (nodeList = DSSXMLUtils.getNodeList(this.signatureElement, this.xPathQueryHolder.XPATH_CLAIMED_ROLE_V2)).getLength() == 0) {
            return null;
        }
        String[] roles = new String[nodeList.getLength()];
        for (int ii = 0; ii < nodeList.getLength(); ++ii) {
            roles[ii] = nodeList.item(ii).getTextContent();
        }
        return roles;
    }

    public List<CertifiedRole> getCertifiedSignerRoles() {
        NodeList nodeList = DSSXMLUtils.getNodeList(this.signatureElement, this.xPathQueryHolder.XPATH_CERTIFIED_ROLE);
        if (nodeList.getLength() == 0 && (nodeList = DSSXMLUtils.getNodeList(this.signatureElement, this.xPathQueryHolder.XPATH_CERTIFIED_ROLE_V2)).getLength() == 0) {
            return null;
        }
        ArrayList<CertifiedRole> roles = new ArrayList<CertifiedRole>();
        for (int ii = 0; ii < nodeList.getLength(); ++ii) {
            Element certEl = (Element)nodeList.item(ii);
            String textContent = certEl.getTextContent();
            CertificateToken x509Certificate = DSSUtils.loadCertificateFromBase64EncodedString((String)textContent);
            if (roles.contains(x509Certificate)) continue;
            roles.add(new CertifiedRole());
        }
        return roles;
    }

    public String getContentType() {
        return "text/xml";
    }

    public String getContentIdentifier() {
        return null;
    }

    public String getContentHints() {
        return null;
    }

    private TimestampToken makeTimestampToken(Element timestampElement, TimestampType timestampType) throws DSSException {
        Element timestampTokenNode = DSSXMLUtils.getElement(timestampElement, this.xPathQueryHolder.XPATH__ENCAPSULATED_TIMESTAMP);
        if (timestampTokenNode == null) {
            LOG.warn("The timestamp (" + timestampType.name() + ") cannot be extracted from the signature!");
            return null;
        }
        String base64EncodedTimestamp = timestampTokenNode.getTextContent();
        TimeStampToken timeStampToken = this.createTimeStampToken(base64EncodedTimestamp);
        TimestampToken timestampToken = new TimestampToken(timeStampToken, timestampType, this.certPool);
        timestampToken.setHashCode(timestampElement.hashCode());
        this.setTimestampCanonicalizationMethod(timestampElement, timestampToken);
        return timestampToken;
    }

    private TimeStampToken createTimeStampToken(String base64EncodedTimestamp) throws DSSException {
        try {
            byte[] tokenBytes = Base64.decodeBase64((String)base64EncodedTimestamp);
            CMSSignedData signedData = new CMSSignedData(tokenBytes);
            return new TimeStampToken(signedData);
        }
        catch (Exception e) {
            throw new DSSException((Throwable)e);
        }
    }

    public Element getSignatureValue() {
        return DSSXMLUtils.getElement(this.signatureElement, this.xPathQueryHolder.XPATH_SIGNATURE_VALUE);
    }

    public Element getObject() {
        return DSSXMLUtils.getElement(this.signatureElement, "./ds:Object");
    }

    public NodeList getObjects() {
        return DSSXMLUtils.getNodeList(this.signatureElement, "./ds:Object");
    }

    public Element getCompleteCertificateRefs() {
        return DSSXMLUtils.getElement(this.signatureElement, this.xPathQueryHolder.XPATH_COMPLETE_CERTIFICATE_REFS);
    }

    public Element getCompleteRevocationRefs() {
        return DSSXMLUtils.getElement(this.signatureElement, this.xPathQueryHolder.XPATH_COMPLETE_REVOCATION_REFS);
    }

    public NodeList getSigAndRefsTimeStamp() {
        NodeList nodeList = DSSXMLUtils.getNodeList(this.signatureElement, this.xPathQueryHolder.XPATH_SIG_AND_REFS_TIMESTAMP);
        if (nodeList == null || nodeList.getLength() == 0) {
            nodeList = DSSXMLUtils.getNodeList(this.signatureElement, this.xPathQueryHolder.XPATH_SIG_AND_REFS_TIMESTAMP_V2);
        }
        return nodeList;
    }

    public Element getCertificateValues() {
        return DSSXMLUtils.getElement(this.signatureElement, this.xPathQueryHolder.XPATH_CERTIFICATE_VALUES);
    }

    public Element getRevocationValues() {
        return DSSXMLUtils.getElement(this.signatureElement, this.xPathQueryHolder.XPATH_REVOCATION_VALUES);
    }

    public boolean hasBProfile() {
        return DSSXMLUtils.isNotEmpty(this.signatureElement, this.xPathQueryHolder.XPATH_SIGNED_SIGNATURE_PROPERTIES);
    }

    public boolean hasTProfile() {
        if (BDocTmSupport.hasBDocTmPolicyId(this.signatureElement, this.xPathQueryHolder)) {
            boolean hasOcspResponse = StringUtils.isNotBlank((String)DSSXMLUtils.getValue(this.signatureElement, this.xPathQueryHolder.XPATH_OCSP_VALUES_ENCAPSULATED_OCSP));
            return hasOcspResponse;
        }
        return DSSXMLUtils.isNotEmpty(this.signatureElement, this.xPathQueryHolder.XPATH_SIGNATURE_TIMESTAMP);
    }

    public boolean hasCProfile() {
        boolean certRefs = DSSXMLUtils.isNotEmpty(this.signatureElement, this.xPathQueryHolder.XPATH_COMPLETE_CERTIFICATE_REFS);
        boolean revocationRefs = DSSXMLUtils.isNotEmpty(this.signatureElement, this.xPathQueryHolder.XPATH_COMPLETE_REVOCATION_REFS);
        return certRefs || revocationRefs;
    }

    public boolean hasXProfile() {
        return DSSXMLUtils.isNotEmpty(this.signatureElement, this.xPathQueryHolder.XPATH_SIG_AND_REFS_TIMESTAMP);
    }

    public boolean hasLTProfile() {
        boolean isLTProfile;
        boolean certValues = DSSXMLUtils.isNotEmpty(this.signatureElement, this.xPathQueryHolder.XPATH_CERTIFICATE_VALUES);
        boolean revocationValues = DSSXMLUtils.isNotEmpty(this.signatureElement, this.xPathQueryHolder.XPATH_REVOCATION_VALUES);
        boolean notEmptyCRL = DSSXMLUtils.isNotEmpty(this.signatureElement, this.xPathQueryHolder.XPATH_ENCAPSULATED_CRL_VALUES);
        boolean notEmptyOCSP = DSSXMLUtils.isNotEmpty(this.signatureElement, this.xPathQueryHolder.XPATH_OCSP_VALUES_ENCAPSULATED_OCSP);
        boolean bl = isLTProfile = revocationValues && (notEmptyCRL || notEmptyOCSP);
        if (!isLTProfile && certValues) {
            isLTProfile = this.hasTProfile();
        }
        return isLTProfile;
    }

    public boolean hasLTAProfile() {
        boolean archiveTimestamp = DSSXMLUtils.isNotEmpty(this.signatureElement, this.xPathQueryHolder.XPATH_ARCHIVE_TIMESTAMP);
        boolean archiveTimestamp141 = DSSXMLUtils.isNotEmpty(this.signatureElement, this.xPathQueryHolder.XPATH_ARCHIVE_TIMESTAMP_141);
        boolean archiveTimestampV2 = DSSXMLUtils.isNotEmpty(this.signatureElement, this.xPathQueryHolder.XPATH_ARCHIVE_TIMESTAMP_V2);
        return archiveTimestamp || archiveTimestamp141 || archiveTimestampV2;
    }

    public void addContentTimestamps(List<TimestampToken> timestampTokens, NodeList nodes, TimestampType timestampType) {
        for (int ii = 0; ii < nodes.getLength(); ++ii) {
            Element element;
            TimestampToken timestampToken;
            Node node = nodes.item(ii);
            if (node.getNodeType() != 1 || (timestampToken = this.makeTimestampToken(element = (Element)node, timestampType)) == null) continue;
            if (timestampToken.getTimestampIncludes() == null) {
                timestampToken.setTimestampIncludes(new ArrayList());
            }
            NodeList timestampIncludes = DSSXMLUtils.getNodeList(element, this.xPathQueryHolder.XPATH__INCLUDE);
            for (int jj = 0; jj < timestampIncludes.getLength(); ++jj) {
                Element include = (Element)timestampIncludes.item(jj);
                String uri = include.getAttribute("URI").substring(1);
                timestampToken.getTimestampIncludes().add(new TimestampInclude(uri, include.getAttribute("referencedData")));
            }
            timestampTokens.add(timestampToken);
        }
    }

    public byte[] getContentTimestampData(TimestampToken timestampToken) {
        switch (timestampToken.getTimeStampType()) {
            case INDIVIDUAL_DATA_OBJECTS_TIMESTAMP: {
                return this.getIndividualDataObjectsTimestampData(timestampToken);
            }
            case ALL_DATA_OBJECTS_TIMESTAMP: {
                return this.getAllDataObjectsTimestampData(timestampToken);
            }
        }
        return null;
    }

    public byte[] getIndividualDataObjectsTimestampData(TimestampToken timestampToken) {
        if (!this.checkTimestampTokenIncludes(timestampToken)) {
            throw new DSSException("The Included referencedData attribute is either not present or set to false!");
        }
        if (this.references.size() == 0) {
            throw new DSSException("The method 'checkSignatureIntegrity' must be invoked first!");
        }
        List includes = timestampToken.getTimestampIncludes();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        for (TimestampInclude include : includes) {
            for (Reference reference : this.references) {
                String id = include.getURI();
                if (!reference.getId().equals(id)) continue;
                try {
                    byte[] referencedBytes = reference.getReferencedBytes();
                    outputStream.write(referencedBytes);
                }
                catch (IOException e) {
                    throw new DSSException((Throwable)e);
                }
                catch (ReferenceNotInitializedException e) {
                    throw new DSSException((Throwable)e);
                }
                catch (XMLSignatureException e) {
                    throw new DSSException((Throwable)e);
                }
            }
        }
        byte[] octetStream = outputStream.toByteArray();
        return octetStream;
    }

    public byte[] getAllDataObjectsTimestampData(TimestampToken timestampToken) {
        if (!this.checkTimestampTokenIncludes(timestampToken)) {
            throw new DSSException("The Included referencedData attribute is either not present or set to false!");
        }
        if (this.references.size() == 0) {
            throw new DSSException("The method 'checkSignatureIntegrity' must be invoked first!");
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        for (Reference reference : this.references) {
            if (this.xPathQueryHolder.XADES_SIGNED_PROPERTIES.equals(reference.getType())) continue;
            try {
                byte[] referencedBytes = reference.getReferencedBytes();
                outputStream.write(referencedBytes);
            }
            catch (IOException e) {
                throw new DSSException((Throwable)e);
            }
            catch (ReferenceNotInitializedException e) {
                throw new DSSException((Throwable)e);
            }
            catch (XMLSignatureException e) {
                throw new DSSException((Throwable)e);
            }
        }
        byte[] toTimestampBytes = outputStream.toByteArray();
        if (LOG.isTraceEnabled()) {
            LOG.trace("AllDataObjectsTimestampData bytes: " + new String(toTimestampBytes));
        }
        return toTimestampBytes;
    }

    private List<TimestampReference> getSignatureTimestampedReferences() {
        ArrayList<TimestampReference> references = new ArrayList<TimestampReference>();
        TimestampReference signatureReference = this.getSignatureTimestampReference();
        references.add(signatureReference);
        List<TimestampReference> signingCertificateTimestampReferences = this.getSigningCertificateTimestampReferences();
        references.addAll(signingCertificateTimestampReferences);
        return references;
    }

    private List<TimestampReference> getSigningCertificateTimestampReferences() {
        if (this.signingCertificateTimestampReferences == null) {
            this.signingCertificateTimestampReferences = new ArrayList<TimestampReference>();
            NodeList list = DSSXMLUtils.getNodeList(this.signatureElement, this.xPathQueryHolder.XPATH_CERT_DIGEST);
            for (int jj = 0; jj < list.getLength(); ++jj) {
                Element element = (Element)list.item(jj);
                TimestampReference signingCertReference = this.createCertificateTimestampReference(element);
                this.signingCertificateTimestampReferences.add(signingCertReference);
            }
        }
        return this.signingCertificateTimestampReferences;
    }

    public boolean checkTimestampTokenIncludes(TimestampToken timestampToken) {
        List timestampIncludes = timestampToken.getTimestampIncludes();
        for (TimestampInclude timestampInclude : timestampIncludes) {
            if (timestampInclude.isReferencedData()) continue;
            return false;
        }
        return true;
    }

    public List<TimestampToken> getContentTimestamps() {
        if (this.contentTimestamps == null) {
            this.makeTimestampTokens();
        }
        return this.contentTimestamps;
    }

    public List<TimestampToken> getSignatureTimestamps() {
        if (this.signatureTimestamps == null) {
            this.makeTimestampTokens();
        }
        return this.signatureTimestamps;
    }

    public List<TimestampToken> getTimestampsX1() {
        if (this.sigAndRefsTimestamps == null) {
            this.makeTimestampTokens();
        }
        return this.sigAndRefsTimestamps;
    }

    public List<TimestampToken> getTimestampsX2() {
        if (this.refsOnlyTimestamps == null) {
            this.makeTimestampTokens();
        }
        return this.refsOnlyTimestamps;
    }

    public List<TimestampToken> getArchiveTimestamps() {
        if (this.archiveTimestamps == null) {
            this.makeTimestampTokens();
        }
        return this.archiveTimestamps;
    }

    private void makeTimestampTokens() {
        this.contentTimestamps = new ArrayList();
        this.signatureTimestamps = new ArrayList();
        this.refsOnlyTimestamps = new ArrayList();
        this.sigAndRefsTimestamps = new ArrayList();
        this.archiveTimestamps = new ArrayList();
        NodeList allDataObjectsTimestamps = DSSXMLUtils.getNodeList(this.signatureElement, this.xPathQueryHolder.XPATH_ALL_DATA_OBJECTS_TIMESTAMP);
        this.addContentTimestamps(this.contentTimestamps, allDataObjectsTimestamps, TimestampType.ALL_DATA_OBJECTS_TIMESTAMP);
        NodeList individualDataObjectsTimestampsNodes = DSSXMLUtils.getNodeList(this.signatureElement, this.xPathQueryHolder.XPATH_INDIVIDUAL_DATA_OBJECTS_TIMESTAMP);
        this.addContentTimestamps(this.contentTimestamps, individualDataObjectsTimestampsNodes, TimestampType.INDIVIDUAL_DATA_OBJECTS_TIMESTAMP);
        Element unsignedSignaturePropertiesDom = this.getUnsignedSignaturePropertiesDom();
        if (unsignedSignaturePropertiesDom == null) {
            return;
        }
        ArrayList<String> timestampedTimestamps = new ArrayList<String>();
        NodeList unsignedProperties = unsignedSignaturePropertiesDom.getChildNodes();
        for (int ii = 0; ii < unsignedProperties.getLength(); ++ii) {
            TimestampToken timestampToken;
            Node node = unsignedProperties.item(ii);
            if (node.getNodeType() != 1) continue;
            String localName = node.getLocalName();
            if ("SignatureTimeStamp".equals(localName)) {
                timestampToken = this.makeTimestampToken((Element)node, TimestampType.SIGNATURE_TIMESTAMP);
                if (timestampToken == null) continue;
                timestampToken.setTimestampedReferences(this.getSignatureTimestampedReferences());
                this.signatureTimestamps.add(timestampToken);
            } else if ("RefsOnlyTimeStamp".equals(localName) || "RefsOnlyTimeStampV2".equals(localName)) {
                timestampToken = this.makeTimestampToken((Element)node, TimestampType.VALIDATION_DATA_REFSONLY_TIMESTAMP);
                if (timestampToken == null) continue;
                timestampToken.setTimestampedReferences(this.getTimestampedReferences());
                this.refsOnlyTimestamps.add(timestampToken);
            } else if ("SigAndRefsTimeStamp".equals(localName) || "SigAndRefsTimeStampV2".equals(localName)) {
                timestampToken = this.makeTimestampToken((Element)node, TimestampType.VALIDATION_DATA_TIMESTAMP);
                if (timestampToken == null) continue;
                List<TimestampReference> references = this.getSignatureTimestampedReferences();
                references.addAll(this.getTimestampedReferences());
                timestampToken.setTimestampedReferences(references);
                this.sigAndRefsTimestamps.add(timestampToken);
            } else {
                if (!this.isArchiveTimestamp(localName) || (timestampToken = this.makeTimestampToken((Element)node, TimestampType.ARCHIVE_TIMESTAMP)) == null) continue;
                ArchiveTimestampType archiveTimestampType = this.getArchiveTimestampType(node, localName);
                timestampToken.setArchiveTimestampType(archiveTimestampType);
                List<TimestampReference> references = this.getSignatureTimestampedReferences();
                for (String timestampId : timestampedTimestamps) {
                    references.add(new TimestampReference(timestampId, TimestampReferenceCategory.TIMESTAMP));
                }
                references.addAll(this.getTimestampedReferences());
                List<CertificateToken> encapsulatedCertificates = this.getCertificateSource().getEncapsulatedCertificates();
                for (CertificateToken certificateToken : encapsulatedCertificates) {
                    TimestampReference certificateTimestampReference = this.createCertificateTimestampReference(certificateToken);
                    if (references.contains(certificateTimestampReference)) continue;
                    references.add(certificateTimestampReference);
                }
                this.addReferencesFromOfflineCRLSource(references);
                this.addReferencesFromOfflineOCSPSource(references);
                timestampToken.setTimestampedReferences(references);
                this.archiveTimestamps.add(timestampToken);
            }
            timestampedTimestamps.add(timestampToken.getDSSId().asXmlId());
        }
    }

    private ArchiveTimestampType getArchiveTimestampType(Node node, String localName) {
        String namespaceURI;
        if ("ArchiveTimeStampV2".equals(localName)) {
            return ArchiveTimestampType.XAdES_141_V2;
        }
        if ("ArchiveTimeStamp".equals(localName) && "http://uri.etsi.org/01903/v1.4.1#".equals(namespaceURI = node.getNamespaceURI())) {
            return ArchiveTimestampType.XAdES_141;
        }
        return ArchiveTimestampType.XAdES;
    }

    private TimestampReference getSignatureTimestampReference() {
        TimestampReference signatureReference = new TimestampReference(this.getId());
        return signatureReference;
    }

    private void setTimestampCanonicalizationMethod(Element timestampElement, TimestampToken timestampToken) {
        Element canonicalizationMethodElement = DSSXMLUtils.getElement(timestampElement, this.xPathQueryHolder.XPATH__CANONICALIZATION_METHOD);
        String canonicalizationMethod = DEFAULT_TIMESTAMP_VALIDATION_CANONICALIZATION_METHOD;
        if (canonicalizationMethodElement != null) {
            canonicalizationMethod = canonicalizationMethodElement.getAttribute("Algorithm");
        }
        timestampToken.setCanonicalizationMethod(canonicalizationMethod);
    }

    public List<CertificateToken> getCertificates() {
        return this.getCertificateSource().getCertificates();
    }

    public List<CertificateToken> getKeyInfoCertificates() {
        return this.getCertificateSource().getKeyInfoCertificates();
    }

    public List<CertificateToken> getTimestampCertificates() {
        return this.getCertificateSource().getTimestampCertificates();
    }

    public SignatureCryptographicVerification checkSignatureIntegrity() {
        if (this.signatureCryptographicVerification != null) {
            return this.signatureCryptographicVerification;
        }
        this.signatureCryptographicVerification = new SignatureCryptographicVerification();
        Document document = this.signatureElement.getOwnerDocument();
        Element rootElement = document.getDocumentElement();
        DSSXMLUtils.setIDIdentifier(rootElement);
        DSSXMLUtils.recursiveIdBrowse(rootElement);
        try {
            SignedInfo signedInfo;
            int length;
            XMLSignature santuarioSignature = new XMLSignature(this.signatureElement, "");
            santuarioSignature.addResourceResolver((ResourceResolverSpi)new XPointerResourceResolver(this.signatureElement));
            santuarioSignature.addResourceResolver((ResourceResolverSpi)new OfflineResolver(this.detachedContents));
            boolean coreValidity = false;
            List<CertificateValidity> certificateValidityList = this.getSigningCertificateValidityList(santuarioSignature, this.signatureCryptographicVerification, this.providedSigningCertificateToken);
            for (CertificateValidity certificateValidity : certificateValidityList) {
                try {
                    PublicKey publicKey = certificateValidity.getPublicKey();
                    coreValidity = santuarioSignature.checkSignatureValue((Key)publicKey);
                    if (!coreValidity) continue;
                    this.candidatesForSigningCertificate.setTheCertificateValidity(certificateValidity);
                    break;
                }
                catch (XMLSignatureException e) {
                    LOG.warn("Exception when validating signature: " + e.getMessage());
                    this.signatureCryptographicVerification.setErrorMessage(e.getMessage());
                }
            }
            boolean referenceDataFound = (length = (signedInfo = santuarioSignature.getSignedInfo()).getLength()) > 0;
            boolean referenceDataHashValid = length > 0;
            boolean foundSignedProperties = false;
            for (int ii = 0; ii < length; ++ii) {
                Reference reference = signedInfo.item(ii);
                if (this.xPathQueryHolder.XADES_SIGNED_PROPERTIES.equals(reference.getType())) {
                    foundSignedProperties = true;
                }
                if (!coreValidity) {
                    referenceDataHashValid = referenceDataHashValid && reference.verify();
                }
                this.references.add(reference);
            }
            referenceDataFound = referenceDataFound && foundSignedProperties;
            this.signatureCryptographicVerification.setReferenceDataFound(referenceDataFound);
            this.signatureCryptographicVerification.setReferenceDataIntact(referenceDataHashValid);
            this.signatureCryptographicVerification.setSignatureIntact(coreValidity);
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
            LOG.debug(e.getMessage(), (Throwable)e);
            StackTraceElement[] stackTrace = e.getStackTrace();
            String name = XAdESSignature.class.getName();
            int lineNumber = 0;
            for (StackTraceElement element : stackTrace) {
                String className = element.getClassName();
                if (!className.equals(name)) continue;
                lineNumber = element.getLineNumber();
                break;
            }
            this.signatureCryptographicVerification.setErrorMessage(e.getMessage() + "/ XAdESSignature/Line number/" + lineNumber);
        }
        return this.signatureCryptographicVerification;
    }

    private List<CertificateValidity> getSigningCertificateValidityList(XMLSignature santuarioSignature, SignatureCryptographicVerification scv, CertificateToken providedSigningCertificate) throws KeyResolverException {
        List<CertificateValidity> certificateValidityList;
        if (providedSigningCertificate == null) {
            CandidatesForSigningCertificate candidates = this.getCandidatesForSigningCertificate();
            certificateValidityList = candidates.getCertificateValidityList();
            if (certificateValidityList.size() == 0) {
                PublicKey publicKey;
                KeyInfo extractedKeyInfo = santuarioSignature.getKeyInfo();
                if (extractedKeyInfo == null || (publicKey = extractedKeyInfo.getPublicKey()) == null) {
                    scv.setErrorMessage("There is no signing certificate within the signature.");
                    return certificateValidityList;
                }
                certificateValidityList = this.getSigningCertificateValidityList(publicKey);
            }
        } else {
            this.candidatesForSigningCertificate = new CandidatesForSigningCertificate();
            CertificateValidity certificateValidity = new CertificateValidity(providedSigningCertificate);
            this.candidatesForSigningCertificate.add(certificateValidity);
            certificateValidityList = this.candidatesForSigningCertificate.getCertificateValidityList();
        }
        return certificateValidityList;
    }

    protected List<CertificateValidity> getSigningCertificateValidityList(PublicKey extractedPublicKey) {
        this.candidatesForSigningCertificate = new CandidatesForSigningCertificate();
        CertificateValidity certificateValidity = new CertificateValidity(extractedPublicKey);
        this.candidatesForSigningCertificate.add(certificateValidity);
        List certificateValidityList = this.candidatesForSigningCertificate.getCertificateValidityList();
        return certificateValidityList;
    }

    public List<AdvancedSignature> getCounterSignatures() {
        NodeList counterSignatures = DSSXMLUtils.getNodeList(this.signatureElement, this.xPathQueryHolder.XPATH_COUNTER_SIGNATURE);
        if (counterSignatures == null) {
            return null;
        }
        ArrayList<AdvancedSignature> xadesList = new ArrayList<AdvancedSignature>();
        for (int ii = 0; ii < counterSignatures.getLength(); ++ii) {
            Element counterSignatureElement = (Element)counterSignatures.item(ii);
            Element signatureElement = DSSXMLUtils.getElement(counterSignatureElement, this.xPathQueryHolder.XPATH__SIGNATURE);
            XAdESSignature xadesCounterSignature = new XAdESSignature(signatureElement, this.xPathQueryHolders, this.certPool);
            if (!this.isCounterSignature(xadesCounterSignature)) continue;
            xadesCounterSignature.setMasterSignature((AdvancedSignature)this);
            xadesList.add((AdvancedSignature)xadesCounterSignature);
        }
        return xadesList;
    }

    private boolean isCounterSignature(XAdESSignature xadesCounterSignature) {
        List<Element> signatureReferences = xadesCounterSignature.getSignatureReferences();
        for (Element reference : signatureReferences) {
            String type = reference.getAttribute("Type");
            if (!this.xPathQueryHolder.XADES_COUNTERSIGNED_SIGNATURE.equals(type)) continue;
            return true;
        }
        return false;
    }

    public List<CertificateRef> getCertificateRefs() {
        Element signingCertEl = DSSXMLUtils.getElement(this.signatureElement, this.xPathQueryHolder.XPATH_CERT_REFS);
        if (signingCertEl == null) {
            return null;
        }
        ArrayList<CertificateRef> certIds = new ArrayList<CertificateRef>();
        NodeList certIdnodes = DSSXMLUtils.getNodeList(signingCertEl, "./xades:Cert");
        for (int i = 0; i < certIdnodes.getLength(); ++i) {
            Element certId = (Element)certIdnodes.item(i);
            Element issuerNameEl = DSSXMLUtils.getElement(certId, this.xPathQueryHolder.XPATH__X509_ISSUER_NAME);
            Element issuerSerialEl = DSSXMLUtils.getElement(certId, this.xPathQueryHolder.XPATH__X509_SERIAL_NUMBER);
            Element digestAlgorithmEl = DSSXMLUtils.getElement(certId, this.xPathQueryHolder.XPATH__CERT_DIGEST_DIGEST_METHOD);
            Element digestValueEl = DSSXMLUtils.getElement(certId, this.xPathQueryHolder.XPATH__CERT_DIGEST_DIGEST_VALUE);
            CertificateRef genericCertId = new CertificateRef();
            if (issuerNameEl != null && issuerSerialEl != null) {
                genericCertId.setIssuerName(issuerNameEl.getTextContent());
                genericCertId.setIssuerSerial(issuerSerialEl.getTextContent());
            }
            String xmlName = digestAlgorithmEl.getAttribute("Algorithm");
            genericCertId.setDigestAlgorithm(DigestAlgorithm.forXML((String)xmlName));
            genericCertId.setDigestValue(Base64.decodeBase64((String)digestValueEl.getTextContent()));
            certIds.add(genericCertId);
        }
        return certIds;
    }

    public List<CRLRef> getCRLRefs() {
        ArrayList<CRLRef> certIds = new ArrayList<CRLRef>();
        Element signingCertEl = DSSXMLUtils.getElement(this.signatureElement, this.xPathQueryHolder.XPATH_REVOCATION_CRL_REFS);
        if (signingCertEl != null) {
            NodeList crlRefNodes = DSSXMLUtils.getNodeList(signingCertEl, this.xPathQueryHolder.XPATH__CRL_REF);
            for (int i = 0; i < crlRefNodes.getLength(); ++i) {
                Element certId = (Element)crlRefNodes.item(i);
                Element digestAlgorithmEl = DSSXMLUtils.getElement(certId, this.xPathQueryHolder.XPATH__DAAV_DIGEST_METHOD);
                Element digestValueEl = DSSXMLUtils.getElement(certId, this.xPathQueryHolder.XPATH__DAAV_DIGEST_VALUE);
                String xmlName = digestAlgorithmEl.getAttribute("Algorithm");
                DigestAlgorithm digestAlgo = DigestAlgorithm.forXML((String)xmlName);
                CRLRef ref = new CRLRef(digestAlgo, Base64.decodeBase64((String)digestValueEl.getTextContent()));
                certIds.add(ref);
            }
        }
        return certIds;
    }

    public List<OCSPRef> getOCSPRefs() {
        ArrayList<OCSPRef> certIds = new ArrayList<OCSPRef>();
        Element signingCertEl = DSSXMLUtils.getElement(this.signatureElement, this.xPathQueryHolder.XPATH_OCSP_REFS);
        if (signingCertEl != null) {
            NodeList ocspRefNodes = DSSXMLUtils.getNodeList(signingCertEl, this.xPathQueryHolder.XPATH__OCSPREF);
            for (int i = 0; i < ocspRefNodes.getLength(); ++i) {
                Element certId = (Element)ocspRefNodes.item(i);
                Element digestAlgorithmEl = DSSXMLUtils.getElement(certId, this.xPathQueryHolder.XPATH__DAAV_DIGEST_METHOD);
                Element digestValueEl = DSSXMLUtils.getElement(certId, this.xPathQueryHolder.XPATH__DAAV_DIGEST_VALUE);
                if (digestAlgorithmEl == null || digestValueEl == null) {
                    throw new DSSNotETSICompliantException(DSSNotETSICompliantException.MSG.XADES_DIGEST_ALG_AND_VALUE_ENCODING);
                }
                String xmlName = digestAlgorithmEl.getAttribute("Algorithm");
                DigestAlgorithm digestAlgo = DigestAlgorithm.forXML((String)xmlName);
                String digestValue = digestValueEl.getTextContent();
                byte[] base64EncodedDigestValue = Base64.decodeBase64((String)digestValue);
                OCSPRef ocspRef = new OCSPRef(digestAlgo, base64EncodedDigestValue, false);
                certIds.add(ocspRef);
            }
        }
        return certIds;
    }

    public byte[] getSignatureTimestampData(TimestampToken timestampToken, String canonicalizationMethod) {
        canonicalizationMethod = timestampToken != null ? timestampToken.getCanonicalizationMethod() : canonicalizationMethod;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            this.writeCanonicalizedValue(this.xPathQueryHolder.XPATH_SIGNATURE_VALUE, canonicalizationMethod, buffer);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Signature timestamp: canonicalization method  --> {}", (Object)canonicalizationMethod);
                LOG.trace("                   : canonicalized string     --> {}", (Object)buffer.toString());
            }
        }
        catch (IOException e) {
            throw new DSSException("Error when computing the SignatureTimestamp", (Throwable)e);
        }
        return buffer.toByteArray();
    }

    public byte[] getTimestampX1Data(TimestampToken timestampToken, String canonicalizationMethod) {
        canonicalizationMethod = timestampToken != null ? timestampToken.getCanonicalizationMethod() : canonicalizationMethod;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            this.writeCanonicalizedValue(this.xPathQueryHolder.XPATH_SIGNATURE_VALUE, canonicalizationMethod, buffer);
            NodeList signatureTimeStampNode = DSSXMLUtils.getNodeList(this.signatureElement, this.xPathQueryHolder.XPATH_SIGNATURE_TIMESTAMP);
            if (signatureTimeStampNode != null) {
                for (int ii = 0; ii < signatureTimeStampNode.getLength(); ++ii) {
                    Node item = signatureTimeStampNode.item(ii);
                    byte[] canonicalizedValue = DSSXMLUtils.canonicalizeSubtree(canonicalizationMethod, item);
                    buffer.write(canonicalizedValue);
                }
            }
            this.writeCanonicalizedValue(this.xPathQueryHolder.XPATH_COMPLETE_CERTIFICATE_REFS, canonicalizationMethod, buffer);
            this.writeCanonicalizedValue(this.xPathQueryHolder.XPATH_COMPLETE_REVOCATION_REFS, canonicalizationMethod, buffer);
            if (LOG.isTraceEnabled()) {
                LOG.trace("X1Timestamp (SigAndRefsTimeStamp) canonicalised string:\n" + buffer.toString());
            }
            return buffer.toByteArray();
        }
        catch (IOException e) {
            throw new DSSException("Error when computing the SigAndRefsTimeStamp (X1Timestamp)", (Throwable)e);
        }
    }

    public byte[] getTimestampX2Data(TimestampToken timestampToken, String canonicalizationMethod) {
        canonicalizationMethod = timestampToken != null ? timestampToken.getCanonicalizationMethod() : canonicalizationMethod;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            this.writeCanonicalizedValue(this.xPathQueryHolder.XPATH_COMPLETE_CERTIFICATE_REFS, canonicalizationMethod, buffer);
            this.writeCanonicalizedValue(this.xPathQueryHolder.XPATH_COMPLETE_REVOCATION_REFS, canonicalizationMethod, buffer);
            if (LOG.isTraceEnabled()) {
                LOG.trace("TimestampX2Data (RefsOnlyTimeStamp) canonicalised string:\n" + buffer.toString());
            }
            return buffer.toByteArray();
        }
        catch (IOException e) {
            throw new DSSException("Error when computing the RefsOnlyTimeStamp (TimestampX2D)", (Throwable)e);
        }
    }

    public byte[] getArchiveTimestampData(TimestampToken timestampToken, String canonicalizationMethod) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("--->Get archive timestamp data:" + (timestampToken == null ? "--> CREATION" : "--> VALIDATION"));
        }
        canonicalizationMethod = timestampToken != null ? timestampToken.getCanonicalizationMethod() : canonicalizationMethod;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            HashSet<String> referenceURIs = new HashSet<String>();
            for (Reference reference : this.references) {
                try {
                    String uri = reference.getURI();
                    if (uri.startsWith("#")) {
                        uri = uri.substring(1);
                    }
                    referenceURIs.add(uri);
                    byte[] bytes = reference.getReferencedBytes();
                    DSSUtils.write((byte[])bytes, (OutputStream)buffer);
                }
                catch (XMLSignatureException e) {
                    throw new DSSException((Throwable)e);
                }
            }
            this.writeCanonicalizedValue(this.xPathQueryHolder.XPATH_SIGNED_INFO, canonicalizationMethod, buffer);
            this.writeCanonicalizedValue(this.xPathQueryHolder.XPATH_SIGNATURE_VALUE, canonicalizationMethod, buffer);
            this.writeCanonicalizedValue(this.xPathQueryHolder.XPATH_KEY_INFO, canonicalizationMethod, buffer);
            Element unsignedSignaturePropertiesDom = this.getUnsignedSignaturePropertiesDom();
            if (unsignedSignaturePropertiesDom == null) {
                throw new NullPointerException(this.xPathQueryHolder.XPATH_UNSIGNED_SIGNATURE_PROPERTIES);
            }
            NodeList unsignedProperties = unsignedSignaturePropertiesDom.getChildNodes();
            for (int ii = 0; ii < unsignedProperties.getLength(); ++ii) {
                byte[] canonicalizedValue;
                Node node = unsignedProperties.item(ii);
                if (node.getNodeType() != 1) continue;
                String localName = node.getLocalName();
                if (this.isArchiveTimestamp(localName)) {
                    if (timestampToken != null && timestampToken.getHashCode() == node.hashCode()) {
                        break;
                    }
                } else if ("TimeStampValidationData".equals(localName)) {
                    // empty if block
                }
                if (timestampToken == null) {
                    byte[] bytesToCanonicalize = DSSXMLUtils.serializeNode(node);
                    canonicalizedValue = DSSXMLUtils.canonicalize(canonicalizationMethod, bytesToCanonicalize);
                } else {
                    canonicalizedValue = DSSXMLUtils.canonicalizeSubtree(canonicalizationMethod, node);
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace(localName + ": Canonicalization: " + canonicalizationMethod);
                    LOG.trace(new String(canonicalizedValue) + "\n");
                }
                buffer.write(canonicalizedValue);
            }
            boolean xades141 = timestampToken == null || !ArchiveTimestampType.XAdES.equals((Object)timestampToken.getArchiveTimestampType());
            NodeList objects = this.getObjects();
            for (int ii = 0; ii < objects.getLength(); ++ii) {
                Node node = objects.item(ii);
                Element qualifyingProperties = DSSXMLUtils.getElement(node, this.xPathQueryHolder.XPATH__QUALIFYING_PROPERTIES);
                if (qualifyingProperties != null) continue;
                if (!xades141) {
                    boolean contains;
                    NamedNodeMap attributes = node.getAttributes();
                    int length = attributes.getLength();
                    String id = "";
                    for (int jj = 0; jj < length; ++jj) {
                        Node item = attributes.item(jj);
                        String nodeName = item.getNodeName();
                        if (!"ID".equals(nodeName.toUpperCase())) continue;
                        id = item.getNodeValue();
                        break;
                    }
                    if (contains = referenceURIs.contains(id)) continue;
                }
                byte[] canonicalizedValue = DSSXMLUtils.canonicalizeSubtree(canonicalizationMethod, node);
                buffer.write(canonicalizedValue);
            }
            byte[] bytes = buffer.toByteArray();
            return bytes;
        }
        catch (IOException e) {
            throw new DSSException("Error when computing the archive data", (Throwable)e);
        }
    }

    private void writeCanonicalizedValue(String xPathString, String canonicalizationMethod, ByteArrayOutputStream buffer) throws IOException {
        Element element = DSSXMLUtils.getElement(this.signatureElement, xPathString);
        if (element != null) {
            byte[] canonicalizedValue = DSSXMLUtils.canonicalizeSubtree(canonicalizationMethod, element);
            buffer.write(canonicalizedValue);
        }
    }

    private boolean isArchiveTimestamp(String localName) {
        return "ArchiveTimeStamp".equals(localName) || "ArchiveTimeStampV2".equals(localName);
    }

    public String getId() {
        if (this.signatureId == null) {
            String idValue = DSSXMLUtils.getIDIdentifier(this.signatureElement);
            if (idValue != null) {
                this.signatureId = idValue;
            } else {
                CertificateToken certificateToken = this.getSigningCertificateToken();
                TokenIdentifier identifier = certificateToken == null ? null : certificateToken.getDSSId();
                this.signatureId = DSSUtils.getDeterministicId((Date)this.getSigningTime(), (TokenIdentifier)identifier);
            }
        }
        return this.signatureId;
    }

    public List<TimestampReference> getTimestampedReferences() {
        Element completeRevocationRefsNode;
        ArrayList<TimestampReference> references = new ArrayList<TimestampReference>();
        Element completeCertificateRefsNode = DSSXMLUtils.getElement(this.signatureElement, this.xPathQueryHolder.XPATH_COMPLETE_CERTIFICATE_REFS);
        if (completeCertificateRefsNode != null) {
            NodeList nodes = DSSXMLUtils.getNodeList(completeCertificateRefsNode, this.xPathQueryHolder.XPATH__COMPLETE_CERTIFICATE_REFS__CERT_DIGEST);
            for (int ii = 0; ii < nodes.getLength(); ++ii) {
                Element certDigestElement = (Element)nodes.item(ii);
                TimestampReference certificateReference = this.createCertificateTimestampReference(certDigestElement);
                references.add(certificateReference);
            }
        }
        if ((completeRevocationRefsNode = DSSXMLUtils.getElement(this.signatureElement, this.xPathQueryHolder.XPATH_COMPLETE_REVOCATION_REFS)) != null) {
            NodeList nodes = DSSXMLUtils.getNodeList(completeRevocationRefsNode, "./*/*/xades:DigestAlgAndValue");
            for (int ii = 0; ii < nodes.getLength(); ++ii) {
                Element element = (Element)nodes.item(ii);
                TimestampReference revocationReference = this.createRevocationTimestampReference(element);
                references.add(revocationReference);
            }
        }
        return references;
    }

    private TimestampReference createRevocationTimestampReference(Element element) {
        String digestAlgorithmStr = DSSXMLUtils.getNode(element, this.xPathQueryHolder.XPATH__DIGEST_METHOD_ALGORITHM).getTextContent();
        DigestAlgorithm digestAlgorithm = DigestAlgorithm.forXML((String)digestAlgorithmStr);
        String digestValue = DSSXMLUtils.getElement(element, this.xPathQueryHolder.XPATH__DIGEST_VALUE).getTextContent();
        TimestampReference revocationReference = new TimestampReference(digestAlgorithm, digestValue);
        return revocationReference;
    }

    public List<String> getUnsignedSignatureProperties() {
        List<String> childrenNames = DSSXMLUtils.getChildrenNames(this.signatureElement, this.xPathQueryHolder.XPATH_UNSIGNED_SIGNATURE_PROPERTIES);
        return childrenNames;
    }

    public List<String> getSignedSignatureProperties() {
        List<String> childrenNames = DSSXMLUtils.getChildrenNames(this.signatureElement, this.xPathQueryHolder.XPATH_SIGNED_SIGNATURE_PROPERTIES);
        return childrenNames;
    }

    public List<String> getSignedProperties() {
        List<String> childrenNames = DSSXMLUtils.getChildrenNames(this.signatureElement, this.xPathQueryHolder.XPATH_SIGNED_PROPERTIES);
        return childrenNames;
    }

    public List<String> getUnsignedProperties() {
        List<String> childrenNames = DSSXMLUtils.getChildrenNames(this.signatureElement, this.xPathQueryHolder.XPATH_UNSIGNED_PROPERTIES);
        return childrenNames;
    }

    public List<String> getSignedDataObjectProperties() {
        List<String> childrenNames = DSSXMLUtils.getChildrenNames(this.signatureElement, this.xPathQueryHolder.XPATH_SIGNED_DATA_OBJECT_PROPERTIES);
        return childrenNames;
    }

    private TimestampReference createCertificateTimestampReference(Element element) throws DSSException {
        String xmlDigestAlgorithm = DSSXMLUtils.getNode(element, this.xPathQueryHolder.XPATH__DIGEST_METHOD_ALGORITHM).getTextContent();
        DigestAlgorithm digestAlgorithm = DigestAlgorithm.forXML((String)xmlDigestAlgorithm);
        this.usedCertificatesDigestAlgorithms.add(digestAlgorithm);
        Element digestValueElement = DSSXMLUtils.getElement(element, this.xPathQueryHolder.XPATH__DIGEST_VALUE);
        String digestValue = digestValueElement == null ? "" : digestValueElement.getTextContent();
        TimestampReference reference = new TimestampReference(digestAlgorithm, digestValue);
        return reference;
    }

    private TimestampReference createCertificateTimestampReference(CertificateToken certificateToken) throws DSSException {
        this.usedCertificatesDigestAlgorithms.add(DigestAlgorithm.SHA1);
        TimestampReference reference = new TimestampReference(DigestAlgorithm.SHA1, DSSUtils.digest((DigestAlgorithm)DigestAlgorithm.SHA1, (Token)certificateToken));
        return reference;
    }

    public boolean isDataForSignatureLevelPresent(SignatureLevel signatureLevel) {
        boolean dataForLevelPresent = true;
        switch (signatureLevel) {
            case XML_NOT_ETSI: {
                break;
            }
            case XAdES_BASELINE_LTA: {
                dataForLevelPresent = this.hasLTAProfile();
                break;
            }
            case XAdES_BASELINE_LT: {
                dataForLevelPresent &= this.hasLTProfile();
                break;
            }
            case XAdES_BASELINE_T: {
                dataForLevelPresent &= this.hasTProfile();
                break;
            }
            case XAdES_BASELINE_B: {
                dataForLevelPresent &= this.hasBProfile();
                break;
            }
            case XAdES_X: {
                dataForLevelPresent &= this.hasXProfile();
                break;
            }
            case XAdES_C: {
                dataForLevelPresent &= this.hasCProfile();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown level " + signatureLevel);
            }
        }
        return dataForLevelPresent;
    }

    public SignatureLevel[] getSignatureLevels() {
        return signatureLevels;
    }

    public String validateStructure() {
        String string = DSSXMLUtils.xmlToString(this.signatureElement);
        StringReader stringReader = new StringReader(string);
        String validated = DSSXMLUtils.validateAgainstXSD(new StreamSource(stringReader));
        return validated;
    }

    public Element getLastTimestampValidationData() {
        List<TimestampToken> archiveTimestamps = this.getArchiveTimestamps();
        TimestampToken mostRecentTimestamp = null;
        for (TimestampToken archiveTimestamp : archiveTimestamps) {
            Date mostRecentGenerationTime;
            if (mostRecentTimestamp == null) {
                mostRecentTimestamp = archiveTimestamp;
                continue;
            }
            Date generationTime = archiveTimestamp.getGenerationTime();
            if (!generationTime.after(mostRecentGenerationTime = mostRecentTimestamp.getGenerationTime())) continue;
            mostRecentTimestamp = archiveTimestamp;
        }
        int timestampHashCode = mostRecentTimestamp.getHashCode();
        NodeList nodeList = DSSXMLUtils.getNodeList(this.signatureElement, this.xPathQueryHolder.XPATH_UNSIGNED_SIGNATURE_PROPERTIES + "/*");
        boolean found = false;
        for (int ii = 0; ii < nodeList.getLength(); ++ii) {
            String nodeName;
            Element unsignedSignatureElement = (Element)nodeList.item(ii);
            int nodeHashCode = unsignedSignatureElement.hashCode();
            if (nodeHashCode == timestampHashCode) {
                found = true;
                continue;
            }
            if (!found || !"TimeStampValidationData".equals(nodeName = unsignedSignatureElement.getLocalName())) continue;
            return unsignedSignatureElement;
        }
        return null;
    }

    public CommitmentType getCommitmentTypeIndication() {
        return null;
    }

    public List<Element> getSignatureReferences() {
        NodeList list = DSSXMLUtils.getNodeList(this.signatureElement, this.xPathQueryHolder.XPATH_REFERENCE);
        ArrayList<Element> references = new ArrayList<Element>(list.getLength());
        for (int ii = 0; ii < list.getLength(); ++ii) {
            Node node = list.item(ii);
            references.add((Element)node);
        }
        return references;
    }

    public List<Reference> getReferences() {
        return this.references;
    }

    public List<Element> getSignatureObjects() {
        NodeList list = DSSXMLUtils.getNodeList(this.signatureElement, "./ds:Object");
        ArrayList<Element> references = new ArrayList<Element>(list.getLength());
        for (int ii = 0; ii < list.getLength(); ++ii) {
            Node node = list.item(ii);
            Element element = (Element)node;
            if (DSSXMLUtils.getElement(element, this.xPathQueryHolder.XPATH__QUALIFYING_PROPERTIES_SIGNED_PROPERTIES) != null) continue;
            references.add(element);
        }
        return references;
    }

    public void registerXPathQueryHolder(XPathQueryHolder xPathQueryHolder) {
        this.xPathQueryHolders.add(xPathQueryHolder);
    }

    public Element getUnsignedSignaturePropertiesDom() {
        return DSSXMLUtils.getElement(this.signatureElement, this.xPathQueryHolder.XPATH_UNSIGNED_SIGNATURE_PROPERTIES);
    }

    public Element getUnsignedPropertiesDom() {
        return DSSXMLUtils.getElement(this.signatureElement, this.xPathQueryHolder.XPATH_UNSIGNED_PROPERTIES);
    }

    public Element getQualifyingPropertiesDom() {
        return DSSXMLUtils.getElement(this.signatureElement, this.xPathQueryHolder.XPATH_QUALIFYING_PROPERTIES);
    }

    static {
        Init.init();
        JCEMapper.Algorithm notStandardAlgorithm = new JCEMapper.Algorithm("", SignatureAlgorithm.RSA_RIPEMD160.getJCEId(), "Signature");
        JCEMapper.register((String)"http://www.w3.org/2001/04/xmldsig-more/rsa-ripemd160", (JCEMapper.Algorithm)notStandardAlgorithm);
        try {
            org.apache.xml.security.algorithms.SignatureAlgorithm.register((String)"http://www.w3.org/2001/04/xmldsig-more/rsa-ripemd160", SignatureRSARIPEMD160AT.class);
        }
        catch (Exception e) {
            LOG.error("ECDSA_RIPEMD160AT algorithm initialisation failed.", (Throwable)e);
        }
    }
}

