/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.validation;

import eu.europa.esig.dss.validation.FullSignatureScope;
import eu.europa.esig.dss.validation.SignatureScope;
import eu.europa.esig.dss.validation.SignatureScopeFinder;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.XAdESNamespaces;
import eu.europa.esig.dss.xades.validation.XAdESSignature;
import eu.europa.esig.dss.xades.validation.XPointerResourceResolver;
import eu.europa.esig.dss.xades.validation.XPointerSignatureScope;
import eu.europa.esig.dss.xades.validation.XmlElementSignatureScope;
import eu.europa.esig.dss.xades.validation.XmlRootSignatureScope;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XAdESSignatureScopeFinder
implements SignatureScopeFinder<XAdESSignature> {
    private final List<String> transformationToIgnore = new ArrayList<String>();
    private final Map<String, String> presentableTransformationNames = new HashMap<String, String>();

    public XAdESSignatureScopeFinder() {
        this.transformationToIgnore.add("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
        this.transformationToIgnore.add("http://www.w3.org/2000/09/xmldsig#base64");
        this.transformationToIgnore.add("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments");
        this.transformationToIgnore.add("http://www.w3.org/2006/12/xml-c14n11#WithComments");
        this.transformationToIgnore.add("http://www.w3.org/2001/10/xml-exc-c14n#WithComments");
        this.presentableTransformationNames.put("http://www.w3.org/2002/06/xmldsig-filter2", "XPath filtering");
        this.presentableTransformationNames.put("http://www.w3.org/TR/1999/REC-xpath-19991116", "XPath filtering");
        this.presentableTransformationNames.put("http://www.w3.org/TR/1999/REC-xslt-19991116", "XSLT Transform");
        this.presentableTransformationNames.put("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", "Canonical XML 1.0 (omits comments)");
        this.presentableTransformationNames.put("http://www.w3.org/2006/12/xml-c14n11#", "Canonical XML 1.1 (omits comments)");
        this.presentableTransformationNames.put("http://www.w3.org/2001/10/xml-exc-c14n#", "Exclusive Canonical XML (omits comments)");
    }

    public List<SignatureScope> findSignatureScope(XAdESSignature xadesSignature) {
        ArrayList<SignatureScope> result = new ArrayList<SignatureScope>();
        HashSet<Element> unsignedObjects = new HashSet<Element>();
        unsignedObjects.addAll(xadesSignature.getSignatureObjects());
        HashSet<Element> signedObjects = new HashSet<Element>();
        List<Element> signatureReferences = xadesSignature.getSignatureReferences();
        for (Element signatureReference : signatureReferences) {
            String type = DSSXMLUtils.getValue(signatureReference, "@Type");
            if (xadesSignature.getXPathQueryHolder().XADES_SIGNED_PROPERTIES.equals(type)) continue;
            String uri = DSSXMLUtils.getValue(signatureReference, "@URI");
            List<String> transformations = this.getTransformationNames(signatureReference);
            if (StringUtils.isBlank((String)uri)) {
                result.add(new XmlRootSignatureScope(transformations));
                continue;
            }
            if (uri.startsWith("#")) {
                String namespaceURI;
                boolean xPointerQuery = XPointerResourceResolver.isXPointerQuery(uri, true);
                if (xPointerQuery) {
                    String id = DSSXMLUtils.getIDIdentifier(signatureReference);
                    XPointerSignatureScope xPointerSignatureScope = new XPointerSignatureScope(id, uri);
                    result.add(xPointerSignatureScope);
                    continue;
                }
                String xmlIdOfSignedElement = uri.substring(1);
                String xPathString = "./ds:Object[@Id='" + xmlIdOfSignedElement + "']";
                Element signedElement = DSSXMLUtils.getElement(xadesSignature.getSignatureElement(), xPathString);
                if (signedElement != null) {
                    if (!unsignedObjects.remove(signedElement)) continue;
                    signedObjects.add(signedElement);
                    result.add(new XmlElementSignatureScope(xmlIdOfSignedElement, transformations));
                    continue;
                }
                signedElement = DSSXMLUtils.getElement(xadesSignature.getSignatureElement().getOwnerDocument().getDocumentElement(), "//*[@Id='" + xmlIdOfSignedElement + "']");
                if (signedElement == null || (namespaceURI = signedElement.getNamespaceURI()) != null && (XAdESNamespaces.exists(namespaceURI) || namespaceURI.equals("http://www.w3.org/2000/09/xmldsig#"))) continue;
                signedObjects.add(signedElement);
                result.add(new XmlElementSignatureScope(xmlIdOfSignedElement, transformations));
                continue;
            }
            result.add((SignatureScope)new FullSignatureScope(uri));
        }
        return result;
    }

    private List<String> getTransformationNames(Element signatureReference) {
        NodeList nodeList = DSSXMLUtils.getNodeList(signatureReference, "./ds:Transforms/ds:Transform");
        ArrayList<String> algorithms = new ArrayList<String>(nodeList.getLength());
        for (int ii = 0; ii < nodeList.getLength(); ++ii) {
            Element transformation = (Element)nodeList.item(ii);
            String algorithm = DSSXMLUtils.getValue(transformation, "@Algorithm");
            if (this.transformationToIgnore.contains(algorithm)) continue;
            if (this.presentableTransformationNames.containsKey(algorithm)) {
                algorithms.add(this.presentableTransformationNames.get(algorithm));
                continue;
            }
            algorithms.add(algorithm);
        }
        return algorithms;
    }
}

