/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.validation;

import eu.europa.esig.dss.DSSDocument;
import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DSSUtils;
import eu.europa.esig.dss.InMemoryDocument;
import eu.europa.esig.dss.MimeType;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.SignatureScopeFinder;
import eu.europa.esig.dss.validation.SignedDocumentValidator;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.XPathQueryHolder;
import eu.europa.esig.dss.xades.validation.XAdES111XPathQueryHolder;
import eu.europa.esig.dss.xades.validation.XAdES122XPathQueryHolder;
import eu.europa.esig.dss.xades.validation.XAdESSignature;
import eu.europa.esig.dss.xades.validation.XAdESSignatureScopeFinder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.bouncycastle.util.encoders.Base64;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLDocumentValidator
extends SignedDocumentValidator {
    private static final byte[] xmlPreamble = new byte[]{60, 63, 120, 109, 108};
    private static final byte[] xmlUtf8 = new byte[]{-17, -69, -65, 60, 63};
    private static final String BASE64_REGEX = "^([A-Za-z0-9+/]{4})*([A-Za-z0-9+/]{4}|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{2}==)$";
    protected List<XPathQueryHolder> xPathQueryHolders;
    protected Document rootElement;
    private List<AdvancedSignature> signatures;

    private XMLDocumentValidator() {
        super(null);
    }

    public XMLDocumentValidator(DSSDocument dssDocument) throws DSSException {
        super((SignatureScopeFinder)new XAdESSignatureScopeFinder());
        this.document = dssDocument;
        this.rootElement = DSSXMLUtils.buildDOM(dssDocument);
        this.xPathQueryHolders = new ArrayList<XPathQueryHolder>();
        XAdES111XPathQueryHolder xades111xPathQueryHolder = new XAdES111XPathQueryHolder();
        this.xPathQueryHolders.add(xades111xPathQueryHolder);
        XAdES122XPathQueryHolder xades122XPathQueryHolder = new XAdES122XPathQueryHolder();
        this.xPathQueryHolders.add(xades122XPathQueryHolder);
        XPathQueryHolder xPathQueryHolder = new XPathQueryHolder();
        this.xPathQueryHolders.add(xPathQueryHolder);
    }

    public boolean isSupported(DSSDocument dssDocument) {
        String dssDocumentName = dssDocument.getName();
        if (dssDocumentName != null && MimeType.XML.equals((Object)MimeType.fromFileName((String)dssDocumentName))) {
            return true;
        }
        int headerLength = 500;
        byte[] preamble = new byte[headerLength];
        DSSUtils.readToArray((DSSDocument)dssDocument, (int)headerLength, (byte[])preamble);
        return this.isXmlPreamble(preamble);
    }

    private boolean isXmlPreamble(byte[] preamble) {
        byte[] startOfPramble = ArrayUtils.subarray((byte[])preamble, (int)0, (int)xmlPreamble.length);
        return Arrays.equals(startOfPramble, xmlPreamble) || Arrays.equals(startOfPramble, xmlUtf8);
    }

    public List<AdvancedSignature> getSignatures() {
        if (this.signatures != null) {
            return this.signatures;
        }
        this.signatures = new ArrayList<AdvancedSignature>();
        NodeList signatureNodeList = DSSXMLUtils.getNodeList(this.rootElement, "//ds:Signature[not(parent::xades:CounterSignature)]");
        for (int ii = 0; ii < signatureNodeList.getLength(); ++ii) {
            Element signatureEl = (Element)signatureNodeList.item(ii);
            XAdESSignature xadesSignature = new XAdESSignature(signatureEl, this.xPathQueryHolders, this.validationCertPool);
            xadesSignature.setDetachedContents(this.detachedContents);
            xadesSignature.setProvidedSigningCertificateToken(this.providedSigningCertificateToken);
            this.signatures.add((AdvancedSignature)xadesSignature);
        }
        return this.signatures;
    }

    public AdvancedSignature getSignatureById(String signatureId) throws DSSException {
        if (StringUtils.isBlank((String)signatureId)) {
            throw new NullPointerException("signatureId");
        }
        List<AdvancedSignature> advancedSignatures = this.getSignatures();
        for (AdvancedSignature advancedSignature : advancedSignatures) {
            String advancedSignatureId = advancedSignature.getId();
            if (!signatureId.equals(advancedSignatureId)) continue;
            return advancedSignature;
        }
        throw new DSSException("The signature with the given id was not found!");
    }

    public DSSDocument getOriginalDocument(String signatureId) throws DSSException {
        if (StringUtils.isBlank((String)signatureId)) {
            throw new NullPointerException("signatureId");
        }
        NodeList signatureNodeList = this.rootElement.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        List<AdvancedSignature> signatureList = this.getSignatures();
        for (int ii = 0; ii < signatureNodeList.getLength(); ++ii) {
            Element signatureEl = (Element)signatureNodeList.item(ii);
            String idIdentifier = DSSXMLUtils.getIDIdentifier(signatureEl);
            if (!signatureId.equals(idIdentifier)) continue;
            XAdESSignature signature = (XAdESSignature)signatureList.get(ii);
            signature.checkSignatureIntegrity();
            if (this.getSignatureObjects(signatureEl).isEmpty() && signature.getReferences().isEmpty()) {
                throw new DSSException("The signature must be enveloped or enveloping!");
            }
            if (this.isEnveloping(signatureEl)) {
                List<Element> references = this.getSignatureObjects(signatureEl);
                InMemoryDocument firstDocument = null;
                InMemoryDocument inMemoryDocument = null;
                for (Element element : references) {
                    String content = element.getTextContent();
                    String string = content = this.isBase64Encoded(content) ? new String(Base64.decode((String)content)) : content;
                    if (inMemoryDocument == null) {
                        firstDocument = inMemoryDocument = new InMemoryDocument(content.getBytes());
                        continue;
                    }
                    InMemoryDocument document = new InMemoryDocument(content.getBytes());
                    inMemoryDocument.setNextDocument((DSSDocument)document);
                    inMemoryDocument = document;
                }
                return firstDocument;
            }
            signatureEl.getParentNode().removeChild(signatureEl);
            Element documentElement = this.rootElement.getDocumentElement();
            byte[] documentBytes = DSSXMLUtils.serializeNode(documentElement);
            documentBytes = this.isBase64Encoded(documentBytes) ? Base64.decode((byte[])documentBytes) : documentBytes;
            InMemoryDocument inMemoryDocument = new InMemoryDocument(documentBytes);
            return inMemoryDocument;
        }
        throw new DSSException("The signature with the given id was not found!");
    }

    private boolean isBase64Encoded(byte[] array) {
        return this.isBase64Encoded(new String(array));
    }

    private boolean isBase64Encoded(String text) {
        Pattern pattern = Pattern.compile(BASE64_REGEX);
        Matcher matcher = pattern.matcher(text);
        return matcher.matches();
    }

    private boolean isEnveloping(Element signatureEl) {
        NodeList objectNodeList = signatureEl.getChildNodes();
        int objectTagNumber = 0;
        for (int i = 0; i < objectNodeList.getLength(); ++i) {
            String nodeName = objectNodeList.item(i).getNodeName();
            if (!"ds:Object".equals(nodeName)) continue;
            ++objectTagNumber;
        }
        return objectTagNumber >= 2;
    }

    private List<Element> getSignatureObjects(Element signatureEl) {
        NodeList list = DSSXMLUtils.getNodeList(signatureEl, "./ds:Object");
        ArrayList<Element> references = new ArrayList<Element>(list.getLength());
        for (int ii = 0; ii < list.getLength(); ++ii) {
            Node node = list.item(ii);
            Element element = (Element)node;
            XPathQueryHolder queryHolder = new XPathQueryHolder();
            if (DSSXMLUtils.getElement(element, queryHolder.XPATH__QUALIFYING_PROPERTIES_SIGNED_PROPERTIES) != null) continue;
            references.add(element);
        }
        return references;
    }

    public List<XPathQueryHolder> getXPathQueryHolder() {
        return this.xPathQueryHolders;
    }

    public void addXPathQueryHolder(XPathQueryHolder xPathQueryHolder) {
        this.xPathQueryHolders.add(xPathQueryHolder);
    }

    public void clearQueryHolders() {
        this.xPathQueryHolders.clear();
    }

    public Document getRootElement() {
        return this.rootElement;
    }
}

