/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.EncryptionAlgorithm;
import eu.europa.esig.dss.utils.Utils;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.util.BigIntegers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DSSSignatureUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DSSSignatureUtils.class);

    private DSSSignatureUtils() {
    }

    public static byte[] convertToXmlDSig(EncryptionAlgorithm algorithm, byte[] signatureValue) {
        if (EncryptionAlgorithm.ECDSA == algorithm && DSSSignatureUtils.isAsn1Encoded(signatureValue)) {
            return DSSSignatureUtils.convertASN1toXMLDSIG(signatureValue);
        }
        if (EncryptionAlgorithm.DSA == algorithm) {
            return DSSSignatureUtils.convertASN1toXMLDSIG(signatureValue);
        }
        return signatureValue;
    }

    private static byte[] convertASN1toXMLDSIG(byte[] binaries) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        ASN1InputStream is = null;
        try {
            byte[] sBytes;
            int sSize;
            is = new ASN1InputStream(binaries);
            ASN1Sequence seq = (ASN1Sequence)is.readObject();
            if (seq.size() != 2) {
                throw new IllegalArgumentException("ASN1 Sequence size should be 2 !");
            }
            ASN1Integer r = (ASN1Integer)seq.getObjectAt(0);
            ASN1Integer s = (ASN1Integer)seq.getObjectAt(1);
            byte[] rBytes = BigIntegers.asUnsignedByteArray((BigInteger)r.getValue());
            int rSize = rBytes.length;
            int max = Math.max(rSize, sSize = (sBytes = BigIntegers.asUnsignedByteArray((BigInteger)s.getValue())).length);
            max = max % 2 == 0 ? max : max + 1;
            DSSSignatureUtils.leftPad(buffer, max, rBytes);
            buffer.write(rBytes);
            DSSSignatureUtils.leftPad(buffer, max, sBytes);
            buffer.write(sBytes);
        }
        catch (Exception e) {
            try {
                throw new DSSException("Unable to convert to xmlDsig : " + e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                Utils.closeQuietly(is);
                throw throwable;
            }
        }
        Utils.closeQuietly((Closeable)is);
        return buffer.toByteArray();
    }

    private static void leftPad(ByteArrayOutputStream stream, int size, byte[] array) {
        int diff = size - array.length;
        if (diff > 0) {
            for (int i = 0; i < diff; ++i) {
                stream.write(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAsn1Encoded(byte[] signatureValue) {
        boolean bl;
        ASN1InputStream is = null;
        try {
            is = new ASN1InputStream(signatureValue);
            ASN1Sequence seq = (ASN1Sequence)is.readObject();
            bl = seq != null && seq.size() == 2;
        }
        catch (Exception e) {
            boolean bl2;
            try {
                bl2 = false;
            }
            catch (Throwable throwable) {
                Utils.closeQuietly(is);
                throw throwable;
            }
            Utils.closeQuietly((Closeable)is);
            return bl2;
        }
        Utils.closeQuietly((Closeable)is);
        return bl;
    }
}

