/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DSSUtils;
import eu.europa.esig.dss.DigestAlgorithm;
import eu.europa.esig.dss.SignatureLevel;
import eu.europa.esig.dss.TimestampParameters;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.x509.TimestampType;
import eu.europa.esig.dss.xades.signature.XAdESLevelC;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XAdESLevelX
extends XAdESLevelC {
    public XAdESLevelX(CertificateVerifier certificateVerifier) {
        super(certificateVerifier);
    }

    @Override
    protected void extendSignatureTag() throws DSSException {
        super.extendSignatureTag();
        SignatureLevel signatureLevel = this.params.getSignatureLevel();
        if (!this.xadesSignature.hasXProfile() || SignatureLevel.XAdES_X.equals((Object)signatureLevel) || SignatureLevel.XAdES_XL.equals((Object)signatureLevel)) {
            if (SignatureLevel.XAdES_XL.equals((Object)this.params.getSignatureLevel())) {
                NodeList toRemoveList = this.xadesSignature.getSigAndRefsTimeStamp();
                for (int index = 0; index < toRemoveList.getLength(); ++index) {
                    Node item = toRemoveList.item(index);
                    this.unsignedSignaturePropertiesDom.removeChild(item);
                }
            }
            TimestampParameters signatureTimestampParameters = this.params.getSignatureTimestampParameters();
            String canonicalizationMethod = signatureTimestampParameters.getCanonicalizationMethod();
            byte[] timestampX1Data = this.xadesSignature.getTimestampX1Data(null, canonicalizationMethod);
            DigestAlgorithm timestampDigestAlgorithm = signatureTimestampParameters.getDigestAlgorithm();
            byte[] digestValue = DSSUtils.digest((DigestAlgorithm)timestampDigestAlgorithm, (byte[])timestampX1Data);
            this.createXAdESTimeStampType(TimestampType.VALIDATION_DATA_TIMESTAMP, canonicalizationMethod, digestValue);
        }
    }
}

