/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.DSSDocument;
import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DSSUtils;
import eu.europa.esig.dss.DigestAlgorithm;
import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.EncryptionAlgorithm;
import eu.europa.esig.dss.InMemoryDocument;
import eu.europa.esig.dss.MimeType;
import eu.europa.esig.dss.Policy;
import eu.europa.esig.dss.SignatureAlgorithm;
import eu.europa.esig.dss.SignerLocation;
import eu.europa.esig.dss.XAdESNamespaces;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.TimestampInclude;
import eu.europa.esig.dss.validation.TimestampToken;
import eu.europa.esig.dss.x509.CertificatePool;
import eu.europa.esig.dss.x509.CertificateToken;
import eu.europa.esig.dss.x509.TimestampType;
import eu.europa.esig.dss.xades.DSSReference;
import eu.europa.esig.dss.xades.DSSTransform;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.SignatureBuilder;
import eu.europa.esig.dss.xades.XAdESSignatureParameters;
import eu.europa.esig.dss.xades.signature.DSSSignatureUtils;
import eu.europa.esig.dss.xades.signature.DetachedSignatureBuilder;
import eu.europa.esig.dss.xades.signature.EnvelopedSignatureBuilder;
import eu.europa.esig.dss.xades.signature.EnvelopingSignatureBuilder;
import eu.europa.esig.dss.xades.signature.XAdESBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.datatype.XMLGregorianCalendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public abstract class XAdESSignatureBuilder
extends XAdESBuilder
implements SignatureBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(XAdESSignatureBuilder.class);
    protected boolean built = false;
    protected DSSDocument detachedDocument;
    protected String signedInfoCanonicalizationMethod;
    protected String signedPropertiesCanonicalizationMethod;
    protected String deterministicId;
    protected Element signatureDom;
    protected Element signedInfoDom;
    protected Element signatureValueDom;
    protected Element qualifyingPropertiesDom;
    protected Element signedPropertiesDom;
    protected Element signedSignaturePropertiesDom;
    protected Element signedDataObjectPropertiesDom;
    protected Element unsignedSignaturePropertiesDom;

    public static XAdESSignatureBuilder getSignatureBuilder(XAdESSignatureParameters params, DSSDocument document, CertificateVerifier certificateVerifier) {
        switch (params.getSignaturePackaging()) {
            case ENVELOPED: {
                return new EnvelopedSignatureBuilder(params, document, certificateVerifier);
            }
            case ENVELOPING: {
                return new EnvelopingSignatureBuilder(params, document, certificateVerifier);
            }
            case DETACHED: {
                return new DetachedSignatureBuilder(params, document, certificateVerifier);
            }
        }
        throw new DSSException("Unsupported packaging " + params.getSignaturePackaging());
    }

    public XAdESSignatureBuilder(XAdESSignatureParameters params, DSSDocument detachedDocument, CertificateVerifier certificateVerifier) {
        super(certificateVerifier);
        this.params = params;
        this.detachedDocument = detachedDocument;
    }

    protected void setCanonicalizationMethods(XAdESSignatureParameters params, String canonicalizationMethod) {
        String signedInfoCanonicalizationMethod_ = params.getSignedInfoCanonicalizationMethod();
        this.signedInfoCanonicalizationMethod = Utils.isStringNotBlank((String)signedInfoCanonicalizationMethod_) ? signedInfoCanonicalizationMethod_ : canonicalizationMethod;
        String signedPropertiesCanonicalizationMethod_ = params.getSignedPropertiesCanonicalizationMethod();
        this.signedPropertiesCanonicalizationMethod = Utils.isStringNotBlank((String)signedPropertiesCanonicalizationMethod_) ? signedPropertiesCanonicalizationMethod_ : canonicalizationMethod;
    }

    public byte[] build() throws DSSException {
        this.documentDom = this.buildRootDocumentDom();
        this.deterministicId = this.params.getDeterministicId();
        List<DSSReference> references = this.params.getReferences();
        if (Utils.isCollectionEmpty(references)) {
            List<DSSReference> defaultReferences = this.createDefaultReferences();
            this.params.setReferences(defaultReferences);
        }
        this.incorporateSignatureDom();
        this.incorporateSignedInfo();
        this.incorporateSignatureValue();
        this.incorporateKeyInfo();
        this.incorporateObject();
        this.incorporateReferences();
        this.incorporateReferenceSignedProperties();
        byte[] canonicalizedSignedInfo = DSSXMLUtils.canonicalizeSubtree(this.signedInfoCanonicalizationMethod, this.signedInfoDom);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Canonicalized SignedInfo         --> {}", (Object)new String(canonicalizedSignedInfo));
            byte[] digest = DSSUtils.digest((DigestAlgorithm)DigestAlgorithm.SHA256, (byte[])canonicalizedSignedInfo);
            LOG.trace("Canonicalized SignedInfo SHA256  --> {}", (Object)Utils.toBase64((byte[])digest));
        }
        this.built = true;
        return canonicalizedSignedInfo;
    }

    protected Document buildRootDocumentDom() {
        return DomUtils.buildDOM();
    }

    public void incorporateSignatureDom() {
        this.signatureDom = this.documentDom.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:Signature");
        this.signatureDom.setAttribute("xmlns:ds", "http://www.w3.org/2000/09/xmldsig#");
        this.signatureDom.setAttribute("Id", this.deterministicId);
        Node parentNodeOfSignature = this.getParentNodeOfSignature();
        parentNodeOfSignature.appendChild(this.signatureDom);
    }

    protected Node getParentNodeOfSignature() {
        return this.documentDom;
    }

    public void incorporateSignedInfo() {
        this.signedInfoDom = DomUtils.addElement((Document)this.documentDom, (Element)this.signatureDom, (String)"http://www.w3.org/2000/09/xmldsig#", (String)"ds:SignedInfo");
        this.incorporateCanonicalizationMethod(this.signedInfoDom, this.signedInfoCanonicalizationMethod);
        Element signatureMethod = DomUtils.addElement((Document)this.documentDom, (Element)this.signedInfoDom, (String)"http://www.w3.org/2000/09/xmldsig#", (String)"ds:SignatureMethod");
        EncryptionAlgorithm encryptionAlgorithm = this.params.getEncryptionAlgorithm();
        DigestAlgorithm digestAlgorithm = this.params.getDigestAlgorithm();
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.getAlgorithm((EncryptionAlgorithm)encryptionAlgorithm, (DigestAlgorithm)digestAlgorithm);
        String signatureAlgorithmXMLId = signatureAlgorithm.getXMLId();
        signatureMethod.setAttribute("Algorithm", signatureAlgorithmXMLId);
    }

    private void incorporateCanonicalizationMethod(Element parentDom, String signedInfoCanonicalizationMethod) {
        Element canonicalizationMethodDom = DomUtils.addElement((Document)this.documentDom, (Element)parentDom, (String)"http://www.w3.org/2000/09/xmldsig#", (String)"ds:CanonicalizationMethod");
        canonicalizationMethodDom.setAttribute("Algorithm", signedInfoCanonicalizationMethod);
    }

    private void incorporateReferences() {
        List<DSSReference> references = this.params.getReferences();
        for (DSSReference reference : references) {
            this.incorporateReference(reference);
        }
    }

    protected void incorporateKeyInfo() throws DSSException {
        Element keyInfoDom = DomUtils.addElement((Document)this.documentDom, (Element)this.signatureDom, (String)"http://www.w3.org/2000/09/xmldsig#", (String)"ds:KeyInfo");
        Element x509DataDom = DomUtils.addElement((Document)this.documentDom, (Element)keyInfoDom, (String)"http://www.w3.org/2000/09/xmldsig#", (String)"ds:X509Data");
        boolean trustAnchorBPPolicy = this.params.bLevel().isTrustAnchorBPPolicy();
        CertificatePool certificatePool = this.getCertificatePool();
        HashSet<CertificateToken> certificateChains = new HashSet<CertificateToken>();
        certificateChains.add(this.params.getSigningCertificate());
        certificateChains.addAll(this.params.getCertificateChain());
        for (CertificateToken x509Certificate : certificateChains) {
            if (trustAnchorBPPolicy && certificatePool != null && !certificatePool.get(x509Certificate.getSubjectX500Principal()).isEmpty()) continue;
            this.addCertificate(x509DataDom, x509Certificate);
        }
    }

    private void addCertificate(Element x509DataDom, CertificateToken x509Certificate) {
        byte[] encoded = x509Certificate.getEncoded();
        String base64Encoded = Utils.toBase64((byte[])encoded);
        DomUtils.addTextElement((Document)this.documentDom, (Element)x509DataDom, (String)"http://www.w3.org/2000/09/xmldsig#", (String)"ds:X509Certificate", (String)base64Encoded);
    }

    protected void incorporateObject() throws DSSException {
        Element objectDom = DomUtils.addElement((Document)this.documentDom, (Element)this.signatureDom, (String)"http://www.w3.org/2000/09/xmldsig#", (String)"ds:Object");
        this.qualifyingPropertiesDom = DomUtils.addElement((Document)this.documentDom, (Element)objectDom, (String)XAdESNamespaces.XAdES, (String)"xades:QualifyingProperties");
        this.qualifyingPropertiesDom.setAttribute("xmlns:xades", XAdESNamespaces.XAdES);
        this.qualifyingPropertiesDom.setAttribute("Target", "#" + this.deterministicId);
        this.incorporateSignedProperties();
    }

    protected void incorporateReferenceSignedProperties() throws DSSException {
        Element reference = DomUtils.addElement((Document)this.documentDom, (Element)this.signedInfoDom, (String)"http://www.w3.org/2000/09/xmldsig#", (String)"ds:Reference");
        reference.setAttribute("Type", this.xPathQueryHolder.XADES_SIGNED_PROPERTIES);
        reference.setAttribute("URI", "#xades-" + this.deterministicId);
        Element transforms = DomUtils.addElement((Document)this.documentDom, (Element)reference, (String)"http://www.w3.org/2000/09/xmldsig#", (String)"ds:Transforms");
        Element transform = DomUtils.addElement((Document)this.documentDom, (Element)transforms, (String)"http://www.w3.org/2000/09/xmldsig#", (String)"ds:Transform");
        transform.setAttribute("Algorithm", this.signedPropertiesCanonicalizationMethod);
        DigestAlgorithm digestAlgorithm = this.params.getDigestAlgorithm();
        this.incorporateDigestMethod(reference, digestAlgorithm);
        byte[] canonicalizedBytes = DSSXMLUtils.canonicalizeSubtree(this.signedPropertiesCanonicalizationMethod, this.signedPropertiesDom);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Canonicalization method  --> {}", (Object)this.signedPropertiesCanonicalizationMethod);
            LOG.trace("Canonicalised REF_2      --> {}", (Object)new String(canonicalizedBytes));
        }
        this.incorporateDigestValue(reference, digestAlgorithm, (DSSDocument)new InMemoryDocument(canonicalizedBytes));
    }

    private void incorporateReference(DSSReference dssReference) {
        Element referenceDom = DomUtils.addElement((Document)this.documentDom, (Element)this.signedInfoDom, (String)"http://www.w3.org/2000/09/xmldsig#", (String)"ds:Reference");
        referenceDom.setAttribute("Id", dssReference.getId());
        String uri = dssReference.getUri();
        referenceDom.setAttribute("URI", uri);
        referenceDom.setAttribute("Type", dssReference.getType());
        List<DSSTransform> dssTransforms = dssReference.getTransforms();
        if (dssTransforms != null) {
            Element transformsDom = DomUtils.addElement((Document)this.documentDom, (Element)referenceDom, (String)"http://www.w3.org/2000/09/xmldsig#", (String)"ds:Transforms");
            for (DSSTransform dssTransform : dssTransforms) {
                Element transformDom = DomUtils.addElement((Document)this.documentDom, (Element)transformsDom, (String)"http://www.w3.org/2000/09/xmldsig#", (String)"ds:Transform");
                XAdESSignatureBuilder.createTransform(this.documentDom, dssTransform, transformDom);
            }
        }
        DigestAlgorithm digestAlgorithm = dssReference.getDigestMethodAlgorithm();
        this.incorporateDigestMethod(referenceDom, digestAlgorithm);
        DSSDocument canonicalizedDocument = this.transformReference(dssReference);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Reference canonicalization method  -->" + this.signedInfoCanonicalizationMethod);
        }
        this.incorporateDigestValue(referenceDom, digestAlgorithm, canonicalizedDocument);
    }

    static void createTransform(Document document, DSSTransform dssTransform, Element transformDom) {
        transformDom.setAttribute("Algorithm", dssTransform.getAlgorithm());
        String elementName = dssTransform.getElementName();
        String textContent = dssTransform.getTextContent();
        if (Utils.isStringNotBlank((String)elementName)) {
            String namespace = dssTransform.getNamespace();
            DomUtils.addTextElement((Document)document, (Element)transformDom, (String)namespace, (String)elementName, (String)textContent);
        } else if (Utils.isStringNotBlank((String)textContent)) {
            Document transformContentDoc = DomUtils.buildDOM((String)textContent);
            Element contextDocumentElement = transformContentDoc.getDocumentElement();
            document.adoptNode(contextDocumentElement);
            transformDom.appendChild(contextDocumentElement);
        }
    }

    private List<DSSReference> createDefaultReferences() {
        ArrayList<DSSReference> references = new ArrayList<DSSReference>();
        references.add(this.createReference(this.detachedDocument, 1));
        return references;
    }

    List<DSSReference> createReferencesForDocuments(List<DSSDocument> documents) {
        ArrayList<DSSReference> references = new ArrayList<DSSReference>();
        int referenceIndex = 1;
        for (DSSDocument dssDocument : documents) {
            references.add(this.createReference(dssDocument, referenceIndex));
            ++referenceIndex;
        }
        return references;
    }

    protected abstract DSSReference createReference(DSSDocument var1, int var2);

    protected abstract DSSDocument transformReference(DSSReference var1);

    protected void incorporateSignatureValue() {
        this.signatureValueDom = DomUtils.addElement((Document)this.documentDom, (Element)this.signatureDom, (String)"http://www.w3.org/2000/09/xmldsig#", (String)"ds:SignatureValue");
        this.signatureValueDom.setAttribute("Id", "value-" + this.deterministicId);
    }

    protected void incorporateSignedProperties() throws DSSException {
        this.signedPropertiesDom = DomUtils.addElement((Document)this.documentDom, (Element)this.qualifyingPropertiesDom, (String)XAdESNamespaces.XAdES, (String)"xades:SignedProperties");
        this.signedPropertiesDom.setAttribute("Id", "xades-" + this.deterministicId);
        this.incorporateSignedSignatureProperties();
    }

    protected void incorporateSignedSignatureProperties() {
        this.signedSignaturePropertiesDom = DomUtils.addElement((Document)this.documentDom, (Element)this.signedPropertiesDom, (String)XAdESNamespaces.XAdES, (String)"xades:SignedSignatureProperties");
        this.incorporateSigningTime();
        this.incorporateSigningCertificate();
        this.incorporateSignedDataObjectProperties();
        this.incorporatePolicy();
        this.incorporateSignatureProductionPlace();
        this.incorporateSignerRole();
        this.incorporateCommitmentTypeIndications();
    }

    private void incorporatePolicy() {
        Policy signaturePolicy = this.params.bLevel().getSignaturePolicy();
        if (signaturePolicy != null) {
            Element signaturePolicyIdentifierDom = DomUtils.addElement((Document)this.documentDom, (Element)this.signedSignaturePropertiesDom, (String)XAdESNamespaces.XAdES, (String)"xades:SignaturePolicyIdentifier");
            String signaturePolicyId = signaturePolicy.getId();
            if (Utils.isStringEmpty((String)signaturePolicyId)) {
                DomUtils.addElement((Document)this.documentDom, (Element)signaturePolicyIdentifierDom, (String)XAdESNamespaces.XAdES, (String)"xades:SignaturePolicyImplied");
            } else {
                String spuri;
                String description;
                Element signaturePolicyIdDom = DomUtils.addElement((Document)this.documentDom, (Element)signaturePolicyIdentifierDom, (String)XAdESNamespaces.XAdES, (String)"xades:SignaturePolicyId");
                Element sigPolicyIdDom = DomUtils.addElement((Document)this.documentDom, (Element)signaturePolicyIdDom, (String)XAdESNamespaces.XAdES, (String)"xades:SigPolicyId");
                Element identifierDom = DomUtils.addTextElement((Document)this.documentDom, (Element)sigPolicyIdDom, (String)XAdESNamespaces.XAdES, (String)"xades:Identifier", (String)signaturePolicyId);
                String qualifier = signaturePolicy.getQualifier();
                if (Utils.isStringNotBlank((String)qualifier)) {
                    identifierDom.setAttribute("Qualifier", qualifier);
                }
                if (Utils.isStringNotEmpty((String)(description = signaturePolicy.getDescription()))) {
                    DomUtils.addTextElement((Document)this.documentDom, (Element)sigPolicyIdDom, (String)XAdESNamespaces.XAdES, (String)"xades:Description", (String)description);
                }
                if (signaturePolicy.getDigestAlgorithm() != null && signaturePolicy.getDigestValue() != null) {
                    Element sigPolicyHashDom = DomUtils.addElement((Document)this.documentDom, (Element)signaturePolicyIdDom, (String)XAdESNamespaces.XAdES, (String)"xades:SigPolicyHash");
                    DigestAlgorithm digestAlgorithm = signaturePolicy.getDigestAlgorithm();
                    this.incorporateDigestMethod(sigPolicyHashDom, digestAlgorithm);
                    byte[] hashValue = signaturePolicy.getDigestValue();
                    String bas64EncodedHashValue = Utils.toBase64((byte[])hashValue);
                    DomUtils.addTextElement((Document)this.documentDom, (Element)sigPolicyHashDom, (String)"http://www.w3.org/2000/09/xmldsig#", (String)"ds:DigestValue", (String)bas64EncodedHashValue);
                }
                if (Utils.isStringNotEmpty((String)(spuri = signaturePolicy.getSpuri()))) {
                    Element sigPolicyQualifiers = DomUtils.addElement((Document)this.documentDom, (Element)signaturePolicyIdDom, (String)XAdESNamespaces.XAdES, (String)"xades:SigPolicyQualifiers");
                    Element sigPolicyQualifier = DomUtils.addElement((Document)this.documentDom, (Element)sigPolicyQualifiers, (String)XAdESNamespaces.XAdES, (String)"xades:SigPolicyQualifier");
                    DomUtils.addTextElement((Document)this.documentDom, (Element)sigPolicyQualifier, (String)XAdESNamespaces.XAdES, (String)"xades:SPURI", (String)spuri);
                }
            }
        }
    }

    private void incorporateSigningTime() {
        Date signingDate = this.params.bLevel().getSigningDate();
        XMLGregorianCalendar xmlGregorianCalendar = DomUtils.createXMLGregorianCalendar((Date)signingDate);
        String xmlSigningTime = xmlGregorianCalendar.toXMLFormat();
        Element signingTimeDom = this.documentDom.createElementNS(XAdESNamespaces.XAdES, "xades:SigningTime");
        this.signedSignaturePropertiesDom.appendChild(signingTimeDom);
        Text textNode = this.documentDom.createTextNode(xmlSigningTime);
        signingTimeDom.appendChild(textNode);
    }

    private void incorporateSigningCertificate() {
        HashSet<CertificateToken> certificates = new HashSet<CertificateToken>();
        certificates.add(this.params.getSigningCertificate());
        if (this.params.isEn319132()) {
            this.incorporateSigningCertificateV2(certificates);
        } else {
            this.incorporateSigningCertificateV1(certificates);
        }
    }

    private void incorporateSigningCertificateV1(Set<CertificateToken> certificates) {
        Element signingCertificateDom = DomUtils.addElement((Document)this.documentDom, (Element)this.signedSignaturePropertiesDom, (String)XAdESNamespaces.XAdES, (String)XAdESNamespaces.getXADES_SIGNING_CERTIFICATE());
        for (CertificateToken certificate : certificates) {
            Element certDom = this.incorporateCert(signingCertificateDom, certificate);
            this.incorporateIssuerV1(certDom, certificate);
        }
    }

    private void incorporateSigningCertificateV2(Set<CertificateToken> certificates) {
        Element signingCertificateDom = DomUtils.addElement((Document)this.documentDom, (Element)this.signedSignaturePropertiesDom, (String)XAdESNamespaces.XAdES, (String)XAdESNamespaces.getXADES_SIGNING_CERTIFICATE_V2());
        for (CertificateToken certificate : certificates) {
            Element certDom = this.incorporateCert(signingCertificateDom, certificate);
            this.incorporateIssuerV2(certDom, certificate);
        }
    }

    private void incorporateSignedDataObjectProperties() {
        this.signedDataObjectPropertiesDom = DomUtils.addElement((Document)this.documentDom, (Element)this.signedPropertiesDom, (String)XAdESNamespaces.XAdES, (String)"xades:SignedDataObjectProperties");
        List<DSSReference> references = this.params.getReferences();
        for (DSSReference reference : references) {
            String dataObjectFormatObjectReference = "#" + reference.getId();
            Element dataObjectFormatDom = DomUtils.addElement((Document)this.documentDom, (Element)this.signedDataObjectPropertiesDom, (String)XAdESNamespaces.XAdES, (String)"xades:DataObjectFormat");
            dataObjectFormatDom.setAttribute("ObjectReference", dataObjectFormatObjectReference);
            Element mimeTypeDom = DomUtils.addElement((Document)this.documentDom, (Element)dataObjectFormatDom, (String)XAdESNamespaces.XAdES, (String)"xades:MimeType");
            MimeType dataObjectFormatMimeType = this.getReferenceMimeType(reference);
            DomUtils.setTextNode((Document)this.documentDom, (Element)mimeTypeDom, (String)dataObjectFormatMimeType.getMimeTypeString());
        }
        this.incorporateContentTimestamps();
    }

    private MimeType getReferenceMimeType(DSSReference reference) {
        MimeType dataObjectFormatMimeType = reference.getContents().getMimeType();
        if (dataObjectFormatMimeType == null) {
            dataObjectFormatMimeType = MimeType.BINARY;
        }
        return dataObjectFormatMimeType;
    }

    private void incorporateContentTimestamps() {
        List contentTimestamps = this.params.getContentTimestamps();
        if (contentTimestamps == null) {
            return;
        }
        Element allDataObjectsTimestampDom = null;
        Element individualDataObjectsTimestampDom = null;
        for (TimestampToken contentTimestamp : contentTimestamps) {
            TimestampType timeStampType = contentTimestamp.getTimeStampType();
            if (TimestampType.ALL_DATA_OBJECTS_TIMESTAMP.equals((Object)timeStampType)) {
                if (allDataObjectsTimestampDom == null) {
                    allDataObjectsTimestampDom = DomUtils.addElement((Document)this.documentDom, (Element)this.signedDataObjectPropertiesDom, (String)XAdESNamespaces.XAdES, (String)"xades:AllDataObjectsTimeStamp");
                }
                this.addTimestamp(allDataObjectsTimestampDom, contentTimestamp);
                continue;
            }
            if (!TimestampType.INDIVIDUAL_DATA_OBJECTS_TIMESTAMP.equals((Object)timeStampType)) continue;
            if (individualDataObjectsTimestampDom == null) {
                individualDataObjectsTimestampDom = DomUtils.addElement((Document)this.documentDom, (Element)this.signedDataObjectPropertiesDom, (String)XAdESNamespaces.XAdES, (String)"xades:IndividualDataObjectsTimeStamp");
            }
            this.addTimestamp(individualDataObjectsTimestampDom, contentTimestamp);
        }
    }

    private void incorporateSignerRole() {
        List claimedSignerRoles = this.params.bLevel().getClaimedSignerRoles();
        List certifiedSignerRoles = this.params.bLevel().getCertifiedSignerRoles();
        if (claimedSignerRoles != null || certifiedSignerRoles != null) {
            Element signerRoleDom = this.params.isEn319132() ? DomUtils.addElement((Document)this.documentDom, (Element)this.signedSignaturePropertiesDom, (String)XAdESNamespaces.XAdES, (String)"xades:SignerRoleV2") : DomUtils.addElement((Document)this.documentDom, (Element)this.signedSignaturePropertiesDom, (String)XAdESNamespaces.XAdES, (String)"xades:SignerRole");
            if (Utils.isCollectionNotEmpty((Collection)claimedSignerRoles)) {
                Element claimedRolesDom = DomUtils.addElement((Document)this.documentDom, (Element)signerRoleDom, (String)XAdESNamespaces.XAdES, (String)"xades:ClaimedRoles");
                this.addRoles(claimedSignerRoles, claimedRolesDom, "xades:ClaimedRole");
            }
            if (Utils.isCollectionNotEmpty((Collection)certifiedSignerRoles)) {
                Element certifiedRolesDom = this.params.isEn319132() ? DomUtils.addElement((Document)this.documentDom, (Element)signerRoleDom, (String)XAdESNamespaces.XAdES, (String)"xades:CertifiedRolesV2") : DomUtils.addElement((Document)this.documentDom, (Element)signerRoleDom, (String)XAdESNamespaces.XAdES, (String)"xades:CertifiedRoles");
                this.addRoles(certifiedSignerRoles, certifiedRolesDom, "xades:CertifiedRole");
            }
        }
    }

    private void addRoles(List<String> signerRoles, Element rolesDom, String roleType) {
        for (String signerRole : signerRoles) {
            Element roleDom = DomUtils.addElement((Document)this.documentDom, (Element)rolesDom, (String)XAdESNamespaces.XAdES, (String)roleType);
            DomUtils.setTextNode((Document)this.documentDom, (Element)roleDom, (String)signerRole);
        }
    }

    private void incorporateSignatureProductionPlace() {
        SignerLocation signatureProductionPlace = this.params.bLevel().getSignerLocation();
        if (signatureProductionPlace != null) {
            String country;
            String postalCode;
            String stateOrProvince;
            String streetAddress;
            Element signatureProductionPlaceDom = this.params.isEn319132() ? DomUtils.addElement((Document)this.documentDom, (Element)this.signedSignaturePropertiesDom, (String)XAdESNamespaces.XAdES, (String)"xades:SignatureProductionPlaceV2") : DomUtils.addElement((Document)this.documentDom, (Element)this.signedSignaturePropertiesDom, (String)XAdESNamespaces.XAdES, (String)"xades:SignatureProductionPlace");
            String city = signatureProductionPlace.getLocality();
            if (city != null) {
                DomUtils.addTextElement((Document)this.documentDom, (Element)signatureProductionPlaceDom, (String)XAdESNamespaces.XAdES, (String)"xades:City", (String)city);
            }
            if (this.params.isEn319132() && (streetAddress = signatureProductionPlace.getStreet()) != null) {
                DomUtils.addTextElement((Document)this.documentDom, (Element)signatureProductionPlaceDom, (String)XAdESNamespaces.XAdES, (String)"xades:StreetAddress", (String)streetAddress);
            }
            if ((stateOrProvince = signatureProductionPlace.getStateOrProvince()) != null) {
                DomUtils.addTextElement((Document)this.documentDom, (Element)signatureProductionPlaceDom, (String)XAdESNamespaces.XAdES, (String)"xades:StateOrProvince", (String)stateOrProvince);
            }
            if ((postalCode = signatureProductionPlace.getPostalCode()) != null) {
                DomUtils.addTextElement((Document)this.documentDom, (Element)signatureProductionPlaceDom, (String)XAdESNamespaces.XAdES, (String)"xades:PostalCode", (String)postalCode);
            }
            if ((country = signatureProductionPlace.getCountry()) != null) {
                DomUtils.addTextElement((Document)this.documentDom, (Element)signatureProductionPlaceDom, (String)XAdESNamespaces.XAdES, (String)"xades:CountryName", (String)country);
            }
        }
    }

    private void incorporateCommitmentTypeIndications() {
        List commitmentTypeIndications = this.params.bLevel().getCommitmentTypeIndications();
        if (commitmentTypeIndications != null) {
            Element commitmentTypeIndicationDom = DomUtils.addElement((Document)this.documentDom, (Element)this.signedDataObjectPropertiesDom, (String)XAdESNamespaces.XAdES, (String)"xades:CommitmentTypeIndication");
            Element commitmentTypeIdDom = DomUtils.addElement((Document)this.documentDom, (Element)commitmentTypeIndicationDom, (String)XAdESNamespaces.XAdES, (String)"xades:CommitmentTypeId");
            for (String commitmentTypeIndication : commitmentTypeIndications) {
                DomUtils.addTextElement((Document)this.documentDom, (Element)commitmentTypeIdDom, (String)XAdESNamespaces.XAdES, (String)"xades:Identifier", (String)commitmentTypeIndication);
            }
            DomUtils.addElement((Document)this.documentDom, (Element)commitmentTypeIndicationDom, (String)XAdESNamespaces.XAdES, (String)"xades:AllSignedDataObjects");
        }
    }

    @Override
    public DSSDocument signDocument(byte[] signatureValue) throws DSSException {
        if (!this.built) {
            this.build();
        }
        EncryptionAlgorithm encryptionAlgorithm = this.params.getEncryptionAlgorithm();
        byte[] signatureValueBytes = DSSSignatureUtils.convertToXmlDSig(encryptionAlgorithm, signatureValue);
        String signatureValueBase64Encoded = Utils.toBase64((byte[])signatureValueBytes);
        Text signatureValueNode = this.documentDom.createTextNode(signatureValueBase64Encoded);
        this.signatureValueDom.appendChild(signatureValueNode);
        byte[] documentBytes = DSSXMLUtils.serializeNode(this.documentDom);
        InMemoryDocument inMemoryDocument = new InMemoryDocument(documentBytes);
        inMemoryDocument.setMimeType(MimeType.XML);
        return inMemoryDocument;
    }

    protected void addTimestamp(Element timestampElement, TimestampToken token) {
        List includes = token.getTimestampIncludes();
        if (includes != null) {
            for (TimestampInclude include : includes) {
                Element timestampIncludeElement = this.documentDom.createElementNS(XAdESNamespaces.XAdES, "xades:Include");
                String uri = include.getURI();
                if (!uri.startsWith("#")) {
                    uri = "#" + uri;
                }
                timestampIncludeElement.setAttribute("URI", uri);
                timestampIncludeElement.setAttribute("referencedData", "true");
                timestampElement.appendChild(timestampIncludeElement);
            }
        }
        Element canonicalizationMethodElement = this.documentDom.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:CanonicalizationMethod");
        canonicalizationMethodElement.setAttribute("Algorithm", token.getCanonicalizationMethod());
        timestampElement.appendChild(canonicalizationMethodElement);
        Element encapsulatedTimestampElement = this.documentDom.createElementNS(XAdESNamespaces.XAdES, "xades:EncapsulatedTimeStamp");
        encapsulatedTimestampElement.setTextContent(Utils.toBase64((byte[])token.getEncoded()));
        timestampElement.appendChild(encapsulatedTimestampElement);
    }
}

