/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.validation;

import eu.europa.esig.dss.DSSUtils;
import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.x509.crl.OfflineCRLSource;
import eu.europa.esig.dss.xades.XPathQueryHolder;
import java.security.cert.X509CRL;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XAdESCRLSource
extends OfflineCRLSource {
    public XAdESCRLSource(Element signatureElement, XPathQueryHolder xPathQueryHolder) {
        if (signatureElement == null) {
            throw new NullPointerException("signatureElement");
        }
        if (xPathQueryHolder == null) {
            throw new NullPointerException("xPathQueryHolder");
        }
        this.x509CRLList = new ArrayList();
        this.addCRLs(signatureElement, xPathQueryHolder.XPATH_CRL_VALUES_ENCAPSULATED_CRL);
        this.addCRLs(signatureElement, xPathQueryHolder.XPATH_TSVD_ENCAPSULATED_CRL_VALUES);
    }

    private void addCRLs(Element signatureElement, String xPathQuery) {
        NodeList nodeList = DomUtils.getNodeList((Node)signatureElement, (String)xPathQuery);
        for (int ii = 0; ii < nodeList.getLength(); ++ii) {
            Element certEl = (Element)nodeList.item(ii);
            String textContent = certEl.getTextContent();
            X509CRL x509CRL = DSSUtils.loadCRLBase64Encoded((String)textContent);
            if (this.x509CRLList.contains(x509CRL)) continue;
            this.x509CRLList.add(x509CRL);
        }
    }
}

