/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.validation;

import eu.europa.esig.dss.xades.validation.DSigNamespaceContext;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashSet;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.utils.resolver.ResourceResolverContext;
import org.apache.xml.security.utils.resolver.ResourceResolverException;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPointerResourceResolver
extends ResourceResolverSpi {
    private static final Logger LOG = LoggerFactory.getLogger(XPointerResourceResolver.class);
    private static final String XP_OPEN = "xpointer(";
    private static final String XNS_OPEN = "xmlns(";
    private XPathFactory xPathFactory = XPathFactory.newInstance();
    private Node baseNode;

    public XPointerResourceResolver(Node baseNode) {
        this.baseNode = baseNode;
    }

    public boolean engineCanResolveURI(ResourceResolverContext context) {
        boolean xPointerQuery = false;
        String uri = "?";
        Attr uriAttr = context.attr;
        if (uriAttr != null) {
            uri = uriAttr.getNodeValue();
            xPointerQuery = XPointerResourceResolver.isXPointerQuery(uri, false);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("I state that I " + (xPointerQuery ? "can" : "cannot") + " resolve Uri/Base Uri:'" + uri + "'/'" + context.baseUri + "'");
        }
        return xPointerQuery;
    }

    public static boolean isXPointerQuery(String uriValue, boolean strict) {
        int ii;
        String decodedUri;
        if (uriValue.isEmpty() || uriValue.charAt(0) != '#') {
            return false;
        }
        try {
            decodedUri = URLDecoder.decode(uriValue, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            LOG.warn("utf-8 not a valid encoding", (Throwable)e);
            return false;
        }
        String[] parts = decodedUri.substring(1).split("\\s");
        if (parts.length == 1 && !parts[0].startsWith(XNS_OPEN)) {
            return !strict;
        }
        for (ii = 0; ii < parts.length - 1; ++ii) {
            if (parts[ii].endsWith(")") && parts[ii].startsWith(XNS_OPEN)) continue;
            return false;
        }
        return parts[ii].endsWith(")") && parts[ii].startsWith(XP_OPEN);
    }

    public XMLSignatureInput engineResolveURI(ResourceResolverContext context) throws ResourceResolverException {
        int i;
        String xpURI;
        Attr uriAttr = context.attr;
        String baseUri = context.baseUri;
        String uriNodeValue = uriAttr.getNodeValue();
        if (uriNodeValue.charAt(0) != '#') {
            return null;
        }
        try {
            xpURI = URLDecoder.decode(uriNodeValue, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            LOG.warn("utf-8 not a valid encoding", (Throwable)e);
            return null;
        }
        String[] parts = xpURI.substring(1).split("\\s");
        DSigNamespaceContext nsContext = null;
        if (parts.length > 1) {
            nsContext = new DSigNamespaceContext();
            for (i = 0; i < parts.length - 1; ++i) {
                if (!parts[i].endsWith(")") || !parts[i].startsWith(XNS_OPEN)) {
                    return null;
                }
                String mapping = parts[i].substring(XNS_OPEN.length(), parts[i].length() - 1);
                int pos = mapping.indexOf(61);
                if (pos <= 0 || pos >= mapping.length() - 1) {
                    throw new ResourceResolverException("malformed namespace part of XPointer expression", uriNodeValue, baseUri);
                }
                nsContext.addNamespace(mapping.substring(0, pos), mapping.substring(pos + 1));
            }
        }
        try {
            Node node = null;
            NodeList nodes = null;
            if (i == 0 && !parts[i].startsWith(XP_OPEN)) {
                node = this.baseNode.getOwnerDocument().getElementById(parts[i]);
            } else {
                if (!parts[i].endsWith(")") || !parts[i].startsWith(XP_OPEN)) {
                    return null;
                }
                XPath xp = this.xPathFactory.newXPath();
                if (nsContext != null) {
                    xp.setNamespaceContext(nsContext);
                }
                if ((nodes = (NodeList)xp.evaluate(parts[i].substring(XP_OPEN.length(), parts[i].length() - 1), this.baseNode, XPathConstants.NODESET)).getLength() == 0) {
                    return null;
                }
                if (nodes.getLength() == 1) {
                    node = nodes.item(0);
                }
            }
            XMLSignatureInput result = null;
            if (node != null) {
                result = new XMLSignatureInput(node);
            } else if (nodes != null) {
                HashSet<Node> nodeSet = new HashSet<Node>(nodes.getLength());
                for (int j = 0; j < nodes.getLength(); ++j) {
                    nodeSet.add(nodes.item(j));
                }
                result = new XMLSignatureInput(nodeSet);
            } else {
                return null;
            }
            result.setMIMEType("text/xml");
            result.setExcludeComments(true);
            result.setSourceURI(baseUri != null ? baseUri.concat(uriNodeValue) : uriNodeValue);
            return result;
        }
        catch (XPathExpressionException e) {
            throw new ResourceResolverException((Exception)e, "malformed XPath inside XPointer expression", uriNodeValue, baseUri);
        }
    }
}

