/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.xades.SantuarioInitializer;
import eu.europa.esig.dss.xades.XPathQueryHolder;
import eu.europa.esig.dss.xades.signature.PrettyPrintTransformer;
import eu.europa.esig.xades.XAdESUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Validator;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.exceptions.XMLSecurityRuntimeException;
import org.apache.xml.security.signature.Reference;
import org.apache.xml.security.signature.ReferenceNotInitializedException;
import org.apache.xml.security.transforms.Transforms;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class DSSXMLUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DSSXMLUtils.class);
    public static final String ID_ATTRIBUTE_NAME = "id";
    public static final String URI_ATTRIBUTE_NAME = "uri";
    private static final Set<String> transforms;
    private static final Set<String> canonicalizers;
    private static final String TRANSFORMATION_EXCLUDE_SIGNATURE = "not(ancestor-or-self::ds:Signature)";
    private static final String TRANSFORMATION_XPATH_NODE_NAME = "XPath";
    public static final String HTTP_WWW_W3_ORG_2000_09_XMLDSIG_OBJECT = "http://www.w3.org/2000/09/xmldsig#Object";
    public static final String HTTP_WWW_W3_ORG_2000_09_XMLDSIG_MANIFEST = "http://www.w3.org/2000/09/xmldsig#Manifest";

    private static void registerDefaultTransforms() {
        DSSXMLUtils.registerTransform("http://www.w3.org/2000/09/xmldsig#base64");
        DSSXMLUtils.registerTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
        DSSXMLUtils.registerTransform("http://www.w3.org/TR/1999/REC-xpath-19991116");
        DSSXMLUtils.registerTransform("http://www.w3.org/2002/06/xmldsig-filter2");
        DSSXMLUtils.registerTransform("http://www.w3.org/TR/2001/WD-xptr-20010108");
        DSSXMLUtils.registerTransform("http://www.w3.org/TR/1999/REC-xslt-19991116");
    }

    private static void registerDefaultCanonicalizers() {
        DSSXMLUtils.registerCanonicalizer("http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
        DSSXMLUtils.registerCanonicalizer("http://www.w3.org/2001/10/xml-exc-c14n#");
        DSSXMLUtils.registerCanonicalizer("http://www.w3.org/2006/12/xml-c14n11");
        DSSXMLUtils.registerCanonicalizer("http://santuario.apache.org/c14n/physical");
        DSSXMLUtils.registerCanonicalizer("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments");
        DSSXMLUtils.registerCanonicalizer("http://www.w3.org/2001/10/xml-exc-c14n#WithComments");
        DSSXMLUtils.registerCanonicalizer("http://www.w3.org/2006/12/xml-c14n11#WithComments");
    }

    private DSSXMLUtils() {
    }

    public static boolean registerTransform(String transformURI) {
        boolean added = transforms.add(transformURI);
        return added;
    }

    public static boolean registerCanonicalizer(String c14nAlgorithmURI) {
        boolean added = canonicalizers.add(c14nAlgorithmURI);
        return added;
    }

    public static Node indentAndReplace(Document document, Node node) {
        Node indentedNode = DSSXMLUtils.getIndentedNode(document, node);
        Node importedNode = document.importNode(indentedNode, true);
        node.getParentNode().replaceChild(importedNode, node);
        return importedNode;
    }

    public static Node indentAndExtend(Document document, Node newNode, Node oldNode) {
        Node indentedNode = DSSXMLUtils.getIndentedNode(document, newNode);
        indentedNode = DSSXMLUtils.alignChildrenIndents(indentedNode);
        Node importedNode = document.importNode(indentedNode, true);
        NodeList nodeList = importedNode.getChildNodes();
        for (int i = DSSXMLUtils.getPositionToStartExtension(oldNode, importedNode); i < nodeList.getLength(); ++i) {
            Node nodeToAppend = nodeList.item(i).cloneNode(true);
            if (1 == nodeToAppend.getNodeType() && DSSXMLUtils.checkIfExists(oldNode, nodeToAppend)) continue;
            oldNode.appendChild(nodeToAppend);
        }
        newNode.getParentNode().replaceChild(oldNode, newNode);
        return oldNode;
    }

    private static int getPositionToStartExtension(Node oldNode, Node indentedNode) {
        NodeList nodeList = oldNode.getChildNodes();
        int startPosition = nodeList.getLength();
        Node child = null;
        while (oldNode.hasChildNodes() && 3 == (child = oldNode.getLastChild()).getNodeType()) {
            oldNode.removeChild(child);
        }
        Integer position = DSSXMLUtils.getPosition(indentedNode, child);
        if (position != null) {
            return position;
        }
        return startPosition;
    }

    private static boolean checkIfExists(Node parentNode, Node childToCheck) {
        return DSSXMLUtils.getPosition(parentNode, childToCheck) != null;
    }

    private static Integer getPosition(Node parentNode, Node childToCheck) {
        if (parentNode != null && childToCheck != null) {
            String nodeName = childToCheck.getLocalName();
            NodeList newNodeChildList = parentNode.getChildNodes();
            for (int i = 0; i < newNodeChildList.getLength(); ++i) {
                String idIdentifier;
                Node newChildNode = newNodeChildList.item(i);
                if (!nodeName.equals(newChildNode.getLocalName()) || (idIdentifier = DSSXMLUtils.getIDIdentifier(childToCheck)) != null && !idIdentifier.equals(DSSXMLUtils.getIDIdentifier(newChildNode))) continue;
                return i + 1;
            }
        }
        return null;
    }

    public static Element getFirstElementChildNode(Node parentNode) {
        if (parentNode.hasChildNodes()) {
            NodeList nodeList = parentNode.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node child = nodeList.item(i);
                if (1 != child.getNodeType()) continue;
                return (Element)child;
            }
        }
        return null;
    }

    public static Document getDocWithIndentedSignatures(Document documentDom, String signatureId, List<String> noIndentObjectIds) {
        NodeList signatures = DomUtils.getNodeList((Node)documentDom, (String)"//ds:Signature");
        for (int i = 0; i < signatures.getLength(); ++i) {
            Element signature = (Element)signatures.item(i);
            String signatureAttrIdValue = DSSXMLUtils.getIDIdentifier(signature);
            if (!Utils.isStringNotEmpty((String)signatureAttrIdValue) || !signatureAttrIdValue.contains(signatureId)) continue;
            Node unsignedSignatureProperties = DomUtils.getNode((Node)signature, (String)".//xades:UnsignedSignatureProperties");
            Node indentedSignature = DSSXMLUtils.getIndentedSignature(signature, noIndentObjectIds);
            Node importedSignature = documentDom.importNode(indentedSignature, true);
            signature.getParentNode().replaceChild(importedSignature, signature);
            if (unsignedSignatureProperties == null) continue;
            Node newUnsignedSignatureProperties = DomUtils.getNode((Node)signature, (String)".//xades:UnsignedSignatureProperties");
            newUnsignedSignatureProperties.getParentNode().replaceChild(unsignedSignatureProperties, newUnsignedSignatureProperties);
        }
        return documentDom;
    }

    private static Node getIndentedSignature(Node signature, List<String> noIndentObjectIds) {
        Node indentedSignature = DSSXMLUtils.getIndentedNode(signature);
        NodeList sigChildNodes = signature.getChildNodes();
        for (int i = 0; i < sigChildNodes.getLength(); ++i) {
            Element sigChild;
            String idAttribute;
            Node childNode = sigChildNodes.item(i);
            if (childNode.getNodeType() != 1 || !noIndentObjectIds.contains(idAttribute = DSSXMLUtils.getIDIdentifier(sigChild = (Element)childNode))) continue;
            Node nodeToReplace = DomUtils.getNode((Node)indentedSignature, (String)(".//*" + DomUtils.getXPathByIdAttribute((String)idAttribute)));
            Node importedNode = indentedSignature.getOwnerDocument().importNode(sigChild, true);
            indentedSignature.replaceChild(importedNode, nodeToReplace);
        }
        return indentedSignature;
    }

    public static Node getIndentedNode(Node documentDom, Node xmlNode) {
        NodeList signatures = DomUtils.getNodeList((Node)documentDom, (String)"//ds:Signature");
        for (int i = 0; i < signatures.getLength(); ++i) {
            Node signature = signatures.item(i);
            String idAttribute = DSSXMLUtils.getIDIdentifier(xmlNode);
            NodeList candidateList = idAttribute != null ? DomUtils.getNodeList((Node)signature, (String)(".//*" + DomUtils.getXPathByIdAttribute((String)idAttribute))) : DomUtils.getNodeList((Node)signature, (String)(".//" + xmlNode.getNodeName()));
            if (!DSSXMLUtils.isNodeListContains(candidateList, xmlNode)) continue;
            Node indentedSignature = DSSXMLUtils.getIndentedNode(signature);
            Node indentedXmlNode = idAttribute != null ? DomUtils.getNode((Node)indentedSignature, (String)(".//*" + DomUtils.getXPathByIdAttribute((String)idAttribute))) : DomUtils.getNode((Node)indentedSignature, (String)(".//" + xmlNode.getNodeName()));
            if (indentedXmlNode == null) continue;
            return indentedXmlNode;
        }
        return xmlNode;
    }

    private static Node getIndentedNode(Node xmlNode) {
        PrettyPrintTransformer prettyPrintTransformer = new PrettyPrintTransformer();
        return prettyPrintTransformer.transform(xmlNode);
    }

    private static boolean isNodeListContains(NodeList nodeList, Node node) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node child = nodeList.item(i);
            if (child != node) continue;
            return true;
        }
        return false;
    }

    public static Node alignChildrenIndents(Node parentNode) {
        NodeList nodeChildren;
        String targetIndent;
        if (parentNode.hasChildNodes() && (targetIndent = DSSXMLUtils.getTargetIndent(nodeChildren = parentNode.getChildNodes())) != null) {
            for (int i = 0; i < nodeChildren.getLength() - 1; ++i) {
                Node node = nodeChildren.item(i);
                if (3 != node.getNodeType()) continue;
                node.setNodeValue(targetIndent);
            }
            Node lastChild = parentNode.getLastChild();
            targetIndent = targetIndent.substring(0, targetIndent.length() - 4);
            switch (lastChild.getNodeType()) {
                case 1: {
                    DomUtils.setTextNode((Document)parentNode.getOwnerDocument(), (Element)((Element)parentNode), (String)targetIndent);
                    break;
                }
                case 3: {
                    lastChild.setNodeValue(targetIndent);
                    break;
                }
            }
        }
        return parentNode;
    }

    private static String getTargetIndent(NodeList nodeChildren) {
        for (int i = 0; i < nodeChildren.getLength() - 1; ++i) {
            Node node = nodeChildren.item(i);
            if (3 != node.getNodeType()) continue;
            return node.getNodeValue();
        }
        return null;
    }

    public static byte[] serializeNode(Node xmlNode) {
        byte[] byArray;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            String xmlEncoding;
            Transformer transformer = DomUtils.getSecureTransformer();
            Document document = null;
            document = 9 == xmlNode.getNodeType() ? (Document)xmlNode : xmlNode.getOwnerDocument();
            if (document != null && Utils.isStringNotBlank((String)(xmlEncoding = document.getXmlEncoding()))) {
                transformer.setOutputProperty("encoding", xmlEncoding);
            }
            StreamResult result = new StreamResult(bos);
            DOMSource source = new DOMSource(xmlNode);
            transformer.transform(source, result);
            byArray = bos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    bos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new DSSException("An error occurred during a node serialization.", (Throwable)e);
            }
        }
        bos.close();
        return byArray;
    }

    public static boolean canCanonicalize(String canonicalizationMethod) {
        return canonicalizers.contains(canonicalizationMethod);
    }

    public static byte[] canonicalize(String canonicalizationMethod, byte[] toCanonicalizeBytes) throws DSSException {
        try {
            Canonicalizer c14n = Canonicalizer.getInstance((String)canonicalizationMethod);
            return c14n.canonicalize(toCanonicalizeBytes);
        }
        catch (Exception e) {
            throw new DSSException("Cannot canonicalize the binaries", (Throwable)e);
        }
    }

    public static byte[] canonicalizeSubtree(String canonicalizationMethod, Node node) {
        try {
            Canonicalizer c14n = Canonicalizer.getInstance((String)canonicalizationMethod);
            return c14n.canonicalizeSubtree(node);
        }
        catch (Exception e) {
            throw new DSSException("Cannot canonicalize the subtree", (Throwable)e);
        }
    }

    public static byte[] canonicalizeOrSerializeSubtree(String canonicalizationMethod, Node node) {
        if (Utils.isStringEmpty((String)canonicalizationMethod)) {
            return DSSXMLUtils.serializeNode(node);
        }
        return DSSXMLUtils.canonicalizeSubtree(canonicalizationMethod, node);
    }

    public static void recursiveIdBrowse(Element element) {
        for (int ii = 0; ii < element.getChildNodes().getLength(); ++ii) {
            Node node = element.getChildNodes().item(ii);
            if (node.getNodeType() != 1) continue;
            Element childElement = (Element)node;
            DSSXMLUtils.setIDIdentifier(childElement);
            DSSXMLUtils.recursiveIdBrowse(childElement);
        }
    }

    public static String getIDIdentifier(Node node) {
        return DSSXMLUtils.getAttribute(node, ID_ATTRIBUTE_NAME);
    }

    public static String getAttribute(Node node, String attributeName) {
        NamedNodeMap attributes = node.getAttributes();
        for (int jj = 0; jj < attributes.getLength(); ++jj) {
            String localName;
            Node item = attributes.item(jj);
            String string = localName = item.getLocalName() != null ? item.getLocalName() : item.getNodeName();
            if (localName == null || !Utils.areStringsEqualIgnoreCase((String)attributeName, (String)localName)) continue;
            return item.getTextContent();
        }
        return null;
    }

    public static void setIDIdentifier(Element childElement) {
        NamedNodeMap attributes = childElement.getAttributes();
        for (int jj = 0; jj < attributes.getLength(); ++jj) {
            Node item = attributes.item(jj);
            String localName = item.getLocalName();
            String nodeName = item.getNodeName();
            if (localName == null || !Utils.areStringsEqualIgnoreCase((String)ID_ATTRIBUTE_NAME, (String)localName)) continue;
            childElement.setIdAttribute(nodeName, true);
            break;
        }
    }

    public static void validateAgainstXSD(DSSDocument document) throws SAXException {
        try (InputStream is = document.openStream();){
            Validator validator = XAdESUtils.getSchemaETSI_EN_319_132().newValidator();
            DSSXMLUtils.avoidXXE(validator);
            validator.validate(new StreamSource(is));
        }
        catch (IOException e) {
            throw new DSSException("Unable to read document", (Throwable)e);
        }
    }

    public static String validateAgainstXSD(StreamSource streamSource) {
        try {
            Validator validator = XAdESUtils.getSchemaETSI_EN_319_132().newValidator();
            DSSXMLUtils.avoidXXE(validator);
            validator.validate(streamSource);
            return "";
        }
        catch (Exception e) {
            LOG.warn("Error during the XML schema validation!", (Throwable)e);
            return e.getMessage();
        }
    }

    public static void avoidXXE(Validator validator) throws SAXException {
        validator.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        validator.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
    }

    public static boolean isOid(String policyId) {
        return policyId != null && policyId.matches("^(?i)urn:oid:.*$");
    }

    public static String getOidCode(String oid) {
        return oid.substring(oid.lastIndexOf(58) + 1);
    }

    public static boolean isDuplicateIdsDetected(DSSDocument doc) {
        try {
            Document dom = DomUtils.buildDOM((DSSDocument)doc);
            Element root = dom.getDocumentElement();
            DSSXMLUtils.recursiveIdBrowse(root);
            XPathExpression xPathExpression = DomUtils.createXPathExpression((String)"//*/@*");
            NodeList nodeList = (NodeList)xPathExpression.evaluate(root, XPathConstants.NODESET);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                XPathExpression xpathAllById;
                NodeList nodeListById;
                Attr attr = (Attr)nodeList.item(i);
                if (!Utils.areStringsEqualIgnoreCase((String)ID_ATTRIBUTE_NAME, (String)attr.getName()) || (nodeListById = (NodeList)(xpathAllById = DomUtils.createXPathExpression((String)("//*[@" + attr.getName() + "='" + attr.getValue() + "']"))).evaluate(root, XPathConstants.NODESET)).getLength() == 1) continue;
                LOG.warn("Problem detected with Id '{}', nb occurences = {}", (Object)attr.getValue(), (Object)nodeListById.getLength());
                return true;
            }
        }
        catch (XPathExpressionException e) {
            throw new DSSException("Unable to check if duplicate ids are present", (Throwable)e);
        }
        return false;
    }

    public static byte[] getNodeBytes(Node node) {
        Node firstChild = node.getFirstChild();
        if (firstChild.getNodeType() == 1) {
            byte[] bytes = DSSXMLUtils.serializeNode(firstChild);
            String str = new String(bytes);
            str = str.substring(str.indexOf("?>") + 2);
            return str.getBytes();
        }
        if (firstChild.getNodeType() == 3) {
            String textContent = firstChild.getTextContent();
            if (Utils.isBase64Encoded((String)textContent)) {
                return Utils.fromBase64((String)firstChild.getTextContent());
            }
            return textContent.getBytes();
        }
        return null;
    }

    public static byte[] getReferenceOriginalContentBytes(Reference reference) {
        try {
            Element transformsElement;
            NodeList transformChildNodes;
            Transforms transforms = reference.getTransforms();
            if (transforms != null && (transformChildNodes = (transformsElement = transforms.getElement()).getChildNodes()) != null && transformChildNodes.getLength() > 0) {
                for (int i = 0; i < transformChildNodes.getLength(); ++i) {
                    Node transformation = transformChildNodes.item(i);
                    if (!DSSXMLUtils.isEnvelopedTransform(transformation)) continue;
                    return reference.getReferencedBytes();
                }
            }
        }
        catch (XMLSecurityException | XMLSecurityRuntimeException e) {
            LOG.warn("Signature reference with id [{}] is corrupted or has an invalid format. Original data cannot be obtained. Reason: [{}]", (Object)reference.getId(), (Object)e.getMessage());
        }
        return DSSXMLUtils.getBytesBeforeTransformation(reference);
    }

    private static boolean isEnvelopedTransform(Node transformation) {
        String algorithm = DomUtils.getValue((Node)transformation, (String)"@Algorithm");
        if ("http://www.w3.org/2000/09/xmldsig#enveloped-signature".equals(algorithm)) {
            return true;
        }
        if ("http://www.w3.org/TR/1999/REC-xpath-19991116".equals(algorithm) || "http://www.w3.org/2002/06/xmldsig-filter2".equals(algorithm)) {
            NodeList childNodes = transformation.getChildNodes();
            for (int j = 0; j < childNodes.getLength(); ++j) {
                Node item = childNodes.item(j);
                if (1 != item.getNodeType() || !TRANSFORMATION_XPATH_NODE_NAME.equals(item.getLocalName()) || !TRANSFORMATION_EXCLUDE_SIGNATURE.equals(item.getTextContent())) continue;
                return true;
            }
        }
        return false;
    }

    private static byte[] getBytesBeforeTransformation(Reference reference) {
        try {
            return reference.getContentsBeforeTransformation().getBytes();
        }
        catch (ReferenceNotInitializedException e) {
            LOG.warn("Original data is not provided for the reference with id [" + reference.getId() + "]. Reason: [{}]", (Object)e.getMessage());
        }
        catch (IOException | CanonicalizationException e) {
            LOG.error("Unable to retrieve the content of reference with id [" + reference.getId() + "].", e);
        }
        return null;
    }

    public static Digest getCertDigest(Element element, XPathQueryHolder xPathQueryHolder) {
        Element certDigestElement = DomUtils.getElement((Node)element, (String)xPathQueryHolder.XPATH__CERT_DIGEST);
        if (certDigestElement == null) {
            return null;
        }
        Element digestMethodElement = DomUtils.getElement((Node)certDigestElement, (String)xPathQueryHolder.XPATH__DIGEST_METHOD);
        Element digestValueElement = DomUtils.getElement((Node)element, (String)xPathQueryHolder.XPATH__CERT_DIGEST_DIGEST_VALUE);
        if (digestMethodElement == null || digestValueElement == null) {
            return null;
        }
        byte[] digestValue = Utils.fromBase64((String)digestValueElement.getTextContent());
        try {
            String xmlAlgorithmName = digestMethodElement.getAttribute("Algorithm");
            DigestAlgorithm digestAlgorithm = DigestAlgorithm.forXML((String)xmlAlgorithmName);
            return new Digest(digestAlgorithm, digestValue);
        }
        catch (DSSException e) {
            LOG.warn("CertRef DigestMethod is not supported. Reason: {}", (Object)e.getMessage());
            return null;
        }
    }

    public static Digest getRevocationDigest(Element revocationRefNode, XPathQueryHolder xPathQueryHolder) {
        Element digestAlgorithmEl = DomUtils.getElement((Node)revocationRefNode, (String)xPathQueryHolder.XPATH__DAAV_DIGEST_METHOD);
        Element digestValueEl = DomUtils.getElement((Node)revocationRefNode, (String)xPathQueryHolder.XPATH__DAAV_DIGEST_VALUE);
        DigestAlgorithm digestAlgo = null;
        byte[] digestValue = null;
        if (digestAlgorithmEl != null && digestValueEl != null) {
            String xmlName = digestAlgorithmEl.getAttribute("Algorithm");
            digestAlgo = DigestAlgorithm.forXML((String)xmlName);
            digestValue = Utils.fromBase64((String)digestValueEl.getTextContent());
            return new Digest(digestAlgo, digestValue);
        }
        return null;
    }

    public static boolean isSignedProperties(Reference reference, XPathQueryHolder xPathQueryHolder) {
        return xPathQueryHolder.XADES_SIGNED_PROPERTIES.equals(reference.getType());
    }

    public static boolean isCounerSignature(Reference reference, XPathQueryHolder xPathQueryHolder) {
        return xPathQueryHolder.XADES_COUNTERSIGNED_SIGNATURE.equals(reference.getType());
    }

    public static boolean isKeyInfoReference(Reference reference, Element signature, XPathQueryHolder xPathQueryHolder) {
        String uri = reference.getURI();
        uri = DomUtils.getId((String)uri);
        Element element = DomUtils.getElement((Node)signature, (String)("./" + xPathQueryHolder.XPATH_KEY_INFO + DomUtils.getXPathByIdAttribute((String)uri)));
        return element != null;
    }

    public static boolean isObjectReferenceType(String referenceType) {
        return HTTP_WWW_W3_ORG_2000_09_XMLDSIG_OBJECT.equals(referenceType);
    }

    public static boolean isManifestReferenceType(String referenceType) {
        return HTTP_WWW_W3_ORG_2000_09_XMLDSIG_MANIFEST.equals(referenceType);
    }

    static {
        SantuarioInitializer.init();
        transforms = new HashSet<String>();
        DSSXMLUtils.registerDefaultTransforms();
        canonicalizers = new HashSet<String>();
        DSSXMLUtils.registerDefaultCanonicalizers();
    }
}

