/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.reference;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.xades.reference.DSSTransform;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractTransform
implements DSSTransform {
    public static final String ALGORITHM_ATTRIBUTE_NAME = "Algorithm";
    public static final String DS_TRANSFORM = "ds:Transform";
    protected final String algorithm;
    protected String namespace = "http://www.w3.org/2000/09/xmldsig#";

    public AbstractTransform(String algorithm) {
        this.algorithm = algorithm;
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public Element createTransform(Document document, Element parentNode) {
        Element transformDom = DomUtils.addElement((Document)document, (Element)parentNode, (String)this.namespace, (String)DS_TRANSFORM);
        transformDom.setAttribute(ALGORITHM_ATTRIBUTE_NAME, this.algorithm);
        return transformDom;
    }
}

