/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.reference;

import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.reference.AbstractTransform;
import org.w3c.dom.Node;

public class CanonicalizationTransform
extends AbstractTransform {
    public CanonicalizationTransform(String canonicalizationAlgorithm) {
        super(canonicalizationAlgorithm);
        if (!DSSXMLUtils.canCanonicalize(canonicalizationAlgorithm)) {
            throw new DSSException(String.format("The provided canonicalization method [%s] is not supported!", canonicalizationAlgorithm));
        }
    }

    @Override
    public byte[] getBytesAfterTranformation(Node node) {
        return DSSXMLUtils.canonicalizeSubtree(this.algorithm, node);
    }
}

