/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.reference;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.xades.reference.AbstractTransform;
import java.io.IOException;
import java.util.Map;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.transforms.Transform;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class ComplexTransform
extends AbstractTransform {
    private Transform transformObject;

    public ComplexTransform(String algorithm) {
        super(algorithm);
    }

    private void buildTransformObject() {
        try {
            Document document = DomUtils.buildDOM();
            Element transformsDom = document.createElementNS(this.namespace, "ds:Transforms");
            document.appendChild(transformsDom);
            this.createTransform(document, transformsDom);
            NodeList childNodes = transformsDom.getFirstChild().getChildNodes();
            Transform transformObject = new Transform(document, this.algorithm, childNodes);
            for (Map.Entry namespace : DomUtils.getCurrentNamespaces().entrySet()) {
                transformObject.setXPathNamespaceContext((String)namespace.getKey(), (String)namespace.getValue());
            }
            this.transformObject = transformObject;
        }
        catch (XMLSecurityException e) {
            throw new DSSException(String.format("Cannot initialize a transform [%s]", this.algorithm), (Throwable)e);
        }
    }

    @Override
    public byte[] getBytesAfterTranformation(Node node) {
        if (this.transformObject == null) {
            this.buildTransformObject();
        }
        try {
            XMLSignatureInput xmlSignatureInput = new XMLSignatureInput(node);
            XMLSignatureInput xmlSignatureInputOut = this.transformObject.performTransform(xmlSignatureInput);
            return xmlSignatureInputOut.getBytes();
        }
        catch (IOException | XMLSecurityException e) {
            throw new DSSException(String.format("Cannot process transformation [%s] on the given DOM object", this.algorithm), e);
        }
    }
}

