/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.reference;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.xades.reference.XPathTransform;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XPath2FilterTransform
extends XPathTransform {
    private static final String FILTER_ATTRIBUTE = "Filter";
    private static final String XPATH2_FILTER_NAMESPACE = "http://www.w3.org/2002/06/xmldsig-filter2";
    private final String filter;

    public XPath2FilterTransform(String xPathExpression, String filter) {
        super(XPATH2_FILTER_NAMESPACE, xPathExpression);
        this.filter = filter;
    }

    @Override
    public Element createTransform(Document document, Element parentNode) {
        Element transform = DomUtils.addElement((Document)document, (Element)parentNode, (String)this.namespace, (String)"ds:Transform");
        transform.setAttribute("Algorithm", this.algorithm);
        Element xPathElement = DomUtils.addTextElement((Document)document, (Element)transform, (String)XPATH2_FILTER_NAMESPACE, (String)"ds:XPath", (String)this.xPathExpression);
        xPathElement.setPrefix("dsig-xpath");
        xPathElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:dsig-xpath", XPATH2_FILTER_NAMESPACE);
        xPathElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:ds", this.namespace);
        xPathElement.setAttribute(FILTER_ATTRIBUTE, this.filter);
        return xPathElement;
    }
}

