/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.XAdESSignatureParameters;
import eu.europa.esig.dss.xades.reference.CanonicalizationTransform;
import eu.europa.esig.dss.xades.reference.DSSReference;
import eu.europa.esig.dss.xades.reference.DSSTransform;
import eu.europa.esig.dss.xades.reference.XPathEnvelopedSignatureTransform;
import eu.europa.esig.dss.xades.signature.XAdESSignatureBuilder;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class EnvelopedSignatureBuilder
extends XAdESSignatureBuilder {
    public EnvelopedSignatureBuilder(XAdESSignatureParameters params, DSSDocument origDoc, CertificateVerifier certificateVerifier) {
        super(params, origDoc, certificateVerifier);
        this.setCanonicalizationMethods(params, "http://www.w3.org/2001/10/xml-exc-c14n#");
    }

    @Override
    protected Document buildRootDocumentDom() {
        return DomUtils.buildDOM((DSSDocument)this.detachedDocument);
    }

    @Override
    protected Node getParentNodeOfSignature() {
        String xPathLocationString = this.params.getXPathLocationString();
        if (Utils.isStringNotEmpty((String)xPathLocationString)) {
            return DomUtils.getElement((Node)this.documentDom, (String)xPathLocationString);
        }
        return this.documentDom.getDocumentElement();
    }

    @Override
    protected DSSReference createReference(DSSDocument document, int referenceIndex) {
        DSSReference dssReference = new DSSReference();
        dssReference.setId("r-" + this.deterministicId + "-" + referenceIndex);
        dssReference.setUri("");
        dssReference.setContents(document);
        DigestAlgorithm digestAlgorithm = this.getReferenceDigestAlgorithmOrDefault(this.params);
        dssReference.setDigestMethodAlgorithm(digestAlgorithm);
        ArrayList<DSSTransform> dssTransformList = new ArrayList<DSSTransform>();
        XPathEnvelopedSignatureTransform xPathTransform = new XPathEnvelopedSignatureTransform();
        dssTransformList.add(xPathTransform);
        CanonicalizationTransform canonicalizationTransform = new CanonicalizationTransform("http://www.w3.org/2001/10/xml-exc-c14n#");
        dssTransformList.add(canonicalizationTransform);
        dssReference.setTransforms(dssTransformList);
        return dssReference;
    }

    @Override
    protected DSSDocument transformReference(DSSReference reference) {
        DSSDocument dssDocument = reference.getContents();
        List<DSSTransform> transforms = reference.getTransforms();
        if (Utils.isCollectionEmpty(transforms)) {
            return dssDocument;
        }
        Element nodeToTransform = null;
        String uri = reference.getUri();
        if (Utils.isStringNotBlank((String)uri) && uri.startsWith("#") && !EnvelopedSignatureBuilder.isXPointer(uri)) {
            Document document = DomUtils.buildDOM((DSSDocument)dssDocument);
            DSSXMLUtils.recursiveIdBrowse(document.getDocumentElement());
            String uri_id = uri.substring(1);
            nodeToTransform = document.getElementById(uri_id);
        }
        byte[] transformedReferenceBytes = this.applyTransformations(dssDocument, transforms, nodeToTransform);
        return new InMemoryDocument(transformedReferenceBytes);
    }

    private static boolean isXPointer(String uri) {
        boolean xPointer = uri.startsWith("#xpointer(") || uri.startsWith("#xmlns(");
        return xPointer;
    }

    protected void removeExistingSignatures(Document domDoc) {
        NodeList signatureNodeList = domDoc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        for (int ii = signatureNodeList.getLength() - 1; ii >= 0; --ii) {
            Element signatureDOM = (Element)signatureNodeList.item(ii);
            signatureDOM.getParentNode().removeChild(signatureDOM);
        }
    }
}

