/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.XAdESNamespaces;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.model.MimeType;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.Token;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.ProfileParameters;
import eu.europa.esig.dss.xades.XAdESSignatureParameters;
import eu.europa.esig.dss.xades.XPathQueryHolder;
import eu.europa.esig.dss.xades.reference.CanonicalizationTransform;
import eu.europa.esig.dss.xades.reference.DSSReference;
import eu.europa.esig.dss.xades.reference.DSSTransform;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x509.IssuerSerial;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public abstract class XAdESBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(XAdESBuilder.class);
    public static final String DS_CANONICALIZATION_METHOD = "ds:CanonicalizationMethod";
    public static final String DS_DIGEST_METHOD = "ds:DigestMethod";
    public static final String DS_DIGEST_VALUE = "ds:DigestValue";
    public static final String DS_KEY_INFO = "ds:KeyInfo";
    public static final String DS_OBJECT = "ds:Object";
    public static final String DS_REFERENCE = "ds:Reference";
    public static final String DS_SIGNATURE = "ds:Signature";
    public static final String DS_SIGNATURE_METHOD = "ds:SignatureMethod";
    public static final String DS_SIGNATURE_VALUE = "ds:SignatureValue";
    public static final String DS_SIGNED_INFO = "ds:SignedInfo";
    public static final String DS_TRANSFORM = "ds:Transform";
    public static final String DS_TRANSFORMS = "ds:Transforms";
    public static final String DS_X509_CERTIFICATE = "ds:X509Certificate";
    public static final String DS_X509_DATA = "ds:X509Data";
    public static final String DS_X509_SUBJECT_NAME = "ds:X509SubjectName";
    public static final String DS_X509_ISSUER_NAME = "ds:X509IssuerName";
    public static final String DS_X509_SERIAL_NUMBER = "ds:X509SerialNumber";
    public static final String DS_XPATH = "ds:XPath";
    public static final String DS_MANIFEST = "ds:Manifest";
    public static final String XADES_ALL_DATA_OBJECTS_TIME_STAMP = "xades:AllDataObjectsTimeStamp";
    public static final String XADES_ALL_SIGNED_DATA_OBJECTS = "xades:AllSignedDataObjects";
    public static final String XADES_BY_KEY = "xades:ByKey";
    public static final String XADES_BY_NAME = "xades:ByName";
    public static final String XADES_COUNTER_SIGNATURE = "xades:CounterSignature";
    public static final String XADES_CERT = "xades:Cert";
    public static final String XADES_CERT_DIGEST = "xades:CertDigest";
    public static final String XADES_CERT_REFS = "xades:CertRefs";
    public static final String XADES_CERTIFICATE_VALUES = "xades:CertificateValues";
    public static final String XADES_REVOCATION_VALUES = "xades:RevocationValues";
    public static final String XADES_CERTIFIED_ROLES = "xades:CertifiedRoles";
    public static final String XADES_CERTIFIED_ROLES_V2 = "xades:CertifiedRolesV2";
    public static final String XADES_CERTIFIED_ROLE = "xades:CertifiedRole";
    public static final String XADES_CITY = "xades:City";
    public static final String XADES_CLAIMED_ROLES = "xades:ClaimedRoles";
    public static final String XADES_CLAIMED_ROLE = "xades:ClaimedRole";
    public static final String XADES_COMMITMENT_TYPE_ID = "xades:CommitmentTypeId";
    public static final String XADES_COMMITMENT_TYPE_INDICATION = "xades:CommitmentTypeIndication";
    public static final String XADES_COMPLETE_CERTIFICATE_REFS = "xades:CompleteCertificateRefs";
    public static final String XADES_COMPLETE_REVOCATION_REFS = "xades:CompleteRevocationRefs";
    public static final String XADES_COUNTRY_NAME = "xades:CountryName";
    public static final String XADES_CRL_IDENTIFIER = "xades:CRLIdentifier";
    public static final String XADES_CRL_REF = "xades:CRLRef";
    public static final String XADES_CRL_REFS = "xades:CRLRefs";
    public static final String XADES_DATA_OBJECT_FORMAT = "xades:DataObjectFormat";
    public static final String XADES_DESCRIPTION = "xades:Description";
    public static final String XADES_DIGEST_ALG_AND_VALUE = "xades:DigestAlgAndValue";
    public static final String XADES_ENCAPSULATED_TIME_STAMP = "xades:EncapsulatedTimeStamp";
    public static final String XADES_ENCAPSULATED_X509_CERTIFICATE = "xades:EncapsulatedX509Certificate";
    public static final String XADES_IDENTIFIER = "xades:Identifier";
    public static final String XADES_INCLUDE = "xades:Include";
    public static final String XADES_INDIVIDUAL_DATA_OBJECTS_TIME_STAMP = "xades:IndividualDataObjectsTimeStamp";
    public static final String XADES_ISSUER = "xades:Issuer";
    public static final String XADES_ISSUER_SERIAL = "xades:IssuerSerial";
    public static final String XADES_ISSUER_SERIAL_V2 = "xades:IssuerSerialV2";
    public static final String XADES_ISSUER_TIME = "xades:IssueTime";
    public static final String XADES_MIME_TYPE = "xades:MimeType";
    public static final String XADES_OCSP_IDENTIFIER = "xades:OCSPIdentifier";
    public static final String XADES_OCSP_REF = "xades:OCSPRef";
    public static final String XADES_OCSP_REFS = "xades:OCSPRefs";
    public static final String XADES_OCSP_RESPONDER_ID = "xades:ResponderID";
    public static final String XADES_POSTAL_CODE = "xades:PostalCode";
    public static final String XADES_PRODUCED_AT = "xades:ProducedAt";
    public static final String XADES_QUALIFYING_PROPERTIES = "xades:QualifyingProperties";
    public static final String XADES_SIG_AND_REFS_TIME_STAMP = "xades:SigAndRefsTimeStamp";
    public static final String XADES_SIG_AND_REFS_TIME_STAMP_V2 = "xades:SigAndRefsTimeStampV2";
    public static final String XADES_SIG_POLICY_HASH = "xades:SigPolicyHash";
    public static final String XADES_SIG_POLICY_ID = "xades:SigPolicyId";
    public static final String XADES_SIGNATURE_POLICY_ID = "xades:SignaturePolicyId";
    public static final String XADES_SIGNATURE_POLICY_IDENTIFIER = "xades:SignaturePolicyIdentifier";
    public static final String XADES_SIGNATURE_POLICY_IMPLIED = "xades:SignaturePolicyImplied";
    public static final String XADES_SIGNATURE_POLICY_QUALIFIERS = "xades:SigPolicyQualifiers";
    public static final String XADES_SIGNATURE_POLICY_QUALIFIER = "xades:SigPolicyQualifier";
    public static final String XADES_SIGNATURE_PRODUCTION_PLACE = "xades:SignatureProductionPlace";
    public static final String XADES_SIGNATURE_PRODUCTION_PLACE_V2 = "xades:SignatureProductionPlaceV2";
    public static final String XADES_SIGNATURE_TIME_STAMP = "xades:SignatureTimeStamp";
    public static final String XADES_SIGNED_DATA_OBJECT_PROPERTIES = "xades:SignedDataObjectProperties";
    public static final String XADES_SIGNED_PROPERTIES = "xades:SignedProperties";
    public static final String XADES_SIGNED_SIGNATURE_PROPERTIES = "xades:SignedSignatureProperties";
    public static final String XADES_SIGNER_ROLE = "xades:SignerRole";
    public static final String XADES_SIGNER_ROLE_V2 = "xades:SignerRoleV2";
    public static final String XADES_SIGNING_TIME = "xades:SigningTime";
    public static final String XADES_SPURI = "xades:SPURI";
    public static final String XADES_STREET_ADDRESS = "xades:StreetAddress";
    public static final String XADES_UNSIGNED_PROPERTIES = "xades:UnsignedProperties";
    public static final String XADES_UNSIGNED_SIGNATURE_PROPERTIES = "xades:UnsignedSignatureProperties";
    public static final String XADES_STATE_OR_PROVINCE = "xades:StateOrProvince";
    public static final String XADES141_ARCHIVE_TIME_STAMP = "xades141:ArchiveTimeStamp";
    public static final String XADES141_TIME_STAMP_VALIDATION_DATA = "xades141:TimeStampValidationData";
    public static final String ALGORITHM = "Algorithm";
    public static final String ID = "Id";
    public static final String OBJECT_REFERENCE = "ObjectReference";
    public static final String REFERENCED_DATA = "referencedData";
    public static final String SIGNATURE = "Signature";
    public static final String TARGET = "Target";
    public static final String TYPE = "Type";
    public static final String URI = "URI";
    public static final String MIMETYPE = "MimeType";
    public static final String QUALIFIER = "Qualifier";
    public static final String XMLNS_DS = "xmlns:ds";
    public static final String XMLNS_XADES = "xmlns:xades";
    protected final XPathQueryHolder xPathQueryHolder = new XPathQueryHolder();
    protected XAdESSignatureParameters params;
    protected Document documentDom;
    protected CertificateVerifier certificateVerifier;

    public XAdESBuilder(CertificateVerifier certificateVerifier) {
        this.certificateVerifier = certificateVerifier;
    }

    protected void incorporateDigestMethod(Element parentDom, DigestAlgorithm digestAlgorithm) {
        Element digestMethodDom = this.documentDom.createElementNS("http://www.w3.org/2000/09/xmldsig#", DS_DIGEST_METHOD);
        String digestAlgorithmXmlId = digestAlgorithm.getUri();
        digestMethodDom.setAttribute(ALGORITHM, digestAlgorithmXmlId);
        parentDom.appendChild(digestMethodDom);
    }

    protected void incorporateDigestValue(Element parentDom, DSSReference dssReference, DigestAlgorithm digestAlgorithm, DSSDocument originalDocument) {
        DSSTransform dssTransform;
        Element digestValueDom = this.documentDom.createElementNS("http://www.w3.org/2000/09/xmldsig#", DS_DIGEST_VALUE);
        String base64EncodedDigestBytes = null;
        if (this.params.isManifestSignature()) {
            dssTransform = this.getUniqueCanonicalizationTransform(dssReference);
            Document doc = DomUtils.buildDOM((DSSDocument)originalDocument);
            byte[] bytes = dssTransform.getBytesAfterTranformation(doc);
            base64EncodedDigestBytes = Utils.toBase64((byte[])DSSUtils.digest((DigestAlgorithm)digestAlgorithm, (byte[])bytes));
        } else if (this.params.isEmbedXML()) {
            dssTransform = this.getUniqueCanonicalizationTransform(dssReference);
            Document doc = DomUtils.buildDOM((DSSDocument)originalDocument);
            Element root = doc.getDocumentElement();
            Document doc2 = DomUtils.buildDOM();
            Element dom = doc2.createElementNS("http://www.w3.org/2000/09/xmldsig#", DS_OBJECT);
            Element dom2 = doc2.createElementNS("http://www.w3.org/2000/09/xmldsig#", DS_OBJECT);
            doc2.appendChild(dom2);
            dom2.appendChild(dom);
            dom.setAttribute(ID, dssReference.getUri().substring(1));
            Node adopted = doc2.adoptNode(root);
            dom.appendChild(adopted);
            byte[] bytes = dssTransform.getBytesAfterTranformation(dom);
            base64EncodedDigestBytes = Utils.toBase64((byte[])DSSUtils.digest((DigestAlgorithm)digestAlgorithm, (byte[])bytes));
        } else {
            base64EncodedDigestBytes = originalDocument.getDigest(digestAlgorithm);
        }
        LOG.trace("C14n Digest value {} --> {}", (Object)parentDom.getNodeName(), (Object)base64EncodedDigestBytes);
        Text textNode = this.documentDom.createTextNode(base64EncodedDigestBytes);
        digestValueDom.appendChild(textNode);
        parentDom.appendChild(digestValueDom);
    }

    private DSSTransform getUniqueCanonicalizationTransform(DSSReference dssReference) {
        List<DSSTransform> transforms = dssReference.getTransforms();
        if (Utils.collectionSize(transforms) != 1) {
            throw new DSSException("Only one transformation is supported");
        }
        DSSTransform dssTransform = transforms.get(0);
        if (!(dssTransform instanceof CanonicalizationTransform)) {
            throw new DSSException("Only canonicalization transform is allowed in the given use case");
        }
        return dssTransform;
    }

    protected void incorporateDigestValue(Element parentDom, DigestAlgorithm digestAlgorithm, Token token) {
        Element digestValueDom = this.documentDom.createElementNS("http://www.w3.org/2000/09/xmldsig#", DS_DIGEST_VALUE);
        String base64EncodedDigestBytes = Utils.toBase64((byte[])token.getDigest(digestAlgorithm));
        if (LOG.isTraceEnabled()) {
            LOG.trace("Digest value {} --> {}", (Object)parentDom.getNodeName(), (Object)base64EncodedDigestBytes);
        }
        Text textNode = this.documentDom.createTextNode(base64EncodedDigestBytes);
        digestValueDom.appendChild(textNode);
        parentDom.appendChild(digestValueDom);
    }

    protected void incorporateCertificateRef(Element signingCertificateDom, Set<CertificateToken> certificates) {
        for (CertificateToken certificate : certificates) {
            Element certDom = this.incorporateCert(signingCertificateDom, certificate);
            this.incorporateIssuerV1(certDom, certificate);
        }
    }

    protected Element incorporateCert(Element parentDom, CertificateToken certificate) {
        Element certDom = DomUtils.addElement((Document)this.documentDom, (Element)parentDom, (String)XAdESNamespaces.getXAdESDefaultNamespace(), (String)XADES_CERT);
        Element certDigestDom = DomUtils.addElement((Document)this.documentDom, (Element)certDom, (String)XAdESNamespaces.getXAdESDefaultNamespace(), (String)XADES_CERT_DIGEST);
        DigestAlgorithm signingCertificateDigestMethod = this.params.getSigningCertificateDigestMethod();
        this.incorporateDigestMethod(certDigestDom, signingCertificateDigestMethod);
        this.incorporateDigestValue(certDigestDom, signingCertificateDigestMethod, (Token)certificate);
        return certDom;
    }

    protected void incorporateIssuerV1(Element parentDom, CertificateToken certificate) {
        Element issuerSerialDom = DomUtils.addElement((Document)this.documentDom, (Element)parentDom, (String)XAdESNamespaces.getXAdESDefaultNamespace(), (String)XADES_ISSUER_SERIAL);
        Element x509IssuerNameDom = DomUtils.addElement((Document)this.documentDom, (Element)issuerSerialDom, (String)"http://www.w3.org/2000/09/xmldsig#", (String)DS_X509_ISSUER_NAME);
        String issuerX500PrincipalName = certificate.getIssuerX500Principal().getName();
        DomUtils.setTextNode((Document)this.documentDom, (Element)x509IssuerNameDom, (String)issuerX500PrincipalName);
        Element x509SerialNumberDom = DomUtils.addElement((Document)this.documentDom, (Element)issuerSerialDom, (String)"http://www.w3.org/2000/09/xmldsig#", (String)DS_X509_SERIAL_NUMBER);
        BigInteger serialNumber = certificate.getSerialNumber();
        String serialNumberString = serialNumber.toString();
        DomUtils.setTextNode((Document)this.documentDom, (Element)x509SerialNumberDom, (String)serialNumberString);
    }

    protected void incorporateIssuerV2(Element parentDom, CertificateToken certificate) {
        Element issuerSerialDom = DomUtils.addElement((Document)this.documentDom, (Element)parentDom, (String)XAdESNamespaces.getXAdESDefaultNamespace(), (String)XADES_ISSUER_SERIAL_V2);
        IssuerSerial issuerSerial = DSSASN1Utils.getIssuerSerial((CertificateToken)certificate);
        String issuerBase64 = Utils.toBase64((byte[])DSSASN1Utils.getDEREncoded((ASN1Encodable)issuerSerial));
        DomUtils.setTextNode((Document)this.documentDom, (Element)issuerSerialDom, (String)issuerBase64);
    }

    private List<String> getNotIndentedObjectIds() {
        ArrayList<String> ids = new ArrayList<String>();
        List<DSSReference> dssReferences = this.params.getReferences();
        if (dssReferences != null) {
            for (DSSReference reference : dssReferences) {
                if (!DSSXMLUtils.isObjectReferenceType(reference.getType())) continue;
                ids.add(DomUtils.getId((String)reference.getUri()));
            }
        }
        return ids;
    }

    protected DSSDocument createXmlDocument() {
        byte[] bytes;
        if (ProfileParameters.Operation.SIGNING.equals((Object)this.params.getContext().getOperationKind()) && this.params.isPrettyPrint()) {
            this.alignNodes();
            bytes = DSSXMLUtils.serializeNode(DSSXMLUtils.getDocWithIndentedSignatures(this.documentDom, this.params.getDeterministicId(), this.getNotIndentedObjectIds()));
        } else {
            bytes = DSSXMLUtils.serializeNode(this.documentDom);
        }
        InMemoryDocument inMemoryDocument = new InMemoryDocument(bytes);
        inMemoryDocument.setMimeType(MimeType.XML);
        return inMemoryDocument;
    }

    protected abstract void alignNodes();
}

