/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.TimestampParameters;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.xades.signature.XAdESLevelXL;
import org.w3c.dom.Element;

public class XAdESLevelA
extends XAdESLevelXL {
    public XAdESLevelA(CertificateVerifier certificateVerifier) {
        super(certificateVerifier);
    }

    @Override
    protected void extendSignatureTag() throws DSSException {
        super.extendSignatureTag();
        Element levelXLUnsignedProperties = (Element)this.unsignedSignaturePropertiesDom.cloneNode(true);
        this.xadesSignature.checkSignatureIntegrity();
        TimestampParameters archiveTimestampParameters = this.params.getArchiveTimestampParameters();
        String canonicalizationMethod = archiveTimestampParameters.getCanonicalizationMethod();
        byte[] data = this.xadesSignature.getTimestampSource().getArchiveTimestampData(canonicalizationMethod);
        DigestAlgorithm timestampDigestAlgorithm = archiveTimestampParameters.getDigestAlgorithm();
        byte[] digestBytes = DSSUtils.digest((DigestAlgorithm)timestampDigestAlgorithm, (byte[])data);
        this.createXAdESTimeStampType(TimestampType.ARCHIVE_TIMESTAMP, canonicalizationMethod, digestBytes);
        this.unsignedSignaturePropertiesDom = this.indentIfPrettyPrint(this.unsignedSignaturePropertiesDom, levelXLUnsignedProperties);
    }
}

