/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.TimestampParameters;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.ValidationContext;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.signature.XAdESLevelBaselineLT;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XAdESLevelBaselineLTA
extends XAdESLevelBaselineLT
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(XAdESLevelBaselineLTA.class);

    public XAdESLevelBaselineLTA(CertificateVerifier certVerifier) {
        super(certVerifier);
    }

    @Override
    protected void extendSignatureTag() throws DSSException {
        super.extendSignatureTag();
        Element levelLTUnsignedProperties = (Element)this.unsignedSignaturePropertiesDom.cloneNode(true);
        if (this.xadesSignature.hasLTAProfile()) {
            this.checkSignatureIntegrity();
            ValidationContext validationContext = this.xadesSignature.getSignatureValidationContext(this.certificateVerifier);
            String indent = this.removeLastTimestampValidationData();
            this.incorporateTimestampValidationData(validationContext, indent);
        }
        this.incorporateArchiveTimestamp();
        this.unsignedSignaturePropertiesDom = this.indentIfPrettyPrint(this.unsignedSignaturePropertiesDom, levelLTUnsignedProperties);
    }

    private String removeLastTimestampValidationData() {
        Element toRemove = this.xadesSignature.getLastTimestampValidationData();
        if (toRemove != null) {
            this.xadesSignature.resetCertificateSource();
            this.xadesSignature.resetRevocationSources();
            return this.removeChild(this.unsignedSignaturePropertiesDom, toRemove);
        }
        return null;
    }

    private void incorporateTimestampValidationData(ValidationContext validationContext, String indent) {
        Element timeStampValidationDataDom = DomUtils.addElement((Document)this.documentDom, (Element)this.unsignedSignaturePropertiesDom, (String)"http://uri.etsi.org/01903/v1.4.1#", (String)"xades141:TimeStampValidationData");
        this.incorporateCertificateValues(timeStampValidationDataDom, validationContext, indent);
        this.incorporateRevocationValues(timeStampValidationDataDom, validationContext, indent);
        String id = "1";
        List archiveTimestamps = this.xadesSignature.getArchiveTimestamps();
        if (archiveTimestamps.size() > 0) {
            TimestampToken timestampToken = (TimestampToken)archiveTimestamps.get(archiveTimestamps.size() - 1);
            id = timestampToken.getDSSIdAsString();
        }
        timeStampValidationDataDom.setAttribute("Id", "id-" + id);
        if (this.params.isPrettyPrint()) {
            DSSXMLUtils.indentAndReplace(this.documentDom, timeStampValidationDataDom);
        }
    }

    private void incorporateArchiveTimestamp() {
        TimestampParameters archiveTimestampParameters = this.params.getArchiveTimestampParameters();
        String canonicalizationMethod = archiveTimestampParameters.getCanonicalizationMethod();
        byte[] archiveTimestampData = this.xadesSignature.getTimestampSource().getArchiveTimestampData(canonicalizationMethod);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Data to be signed by the ArchiveTimestamp:");
            LOG.trace(new String(archiveTimestampData));
        }
        DigestAlgorithm timestampDigestAlgorithm = archiveTimestampParameters.getDigestAlgorithm();
        byte[] digestBytes = DSSUtils.digest((DigestAlgorithm)timestampDigestAlgorithm, (byte[])archiveTimestampData);
        this.createXAdESTimeStampType(TimestampType.ARCHIVE_TIMESTAMP, canonicalizationMethod, digestBytes);
    }
}

