/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.ValidationContext;
import eu.europa.esig.dss.xades.signature.XAdESLevelX;
import org.w3c.dom.Element;

public class XAdESLevelXL
extends XAdESLevelX {
    public XAdESLevelXL(CertificateVerifier certificateVerifier) {
        super(certificateVerifier);
    }

    @Override
    protected void extendSignatureTag() throws DSSException {
        super.extendSignatureTag();
        Element levelXUnsignedProperties = (Element)this.unsignedSignaturePropertiesDom.cloneNode(true);
        if (!this.xadesSignature.hasLTProfile() || SignatureLevel.XAdES_XL.equals((Object)this.params.getSignatureLevel())) {
            this.xadesSignature.resetTimestampSource();
            ValidationContext valContext = this.xadesSignature.getSignatureValidationContext(this.certificateVerifier);
            String afterCertificateText = this.removeOldCertificateValues();
            this.removeOldRevocationValues();
            this.incorporateCertificateValues(this.unsignedSignaturePropertiesDom, valContext, afterCertificateText);
            this.incorporateRevocationValues(this.unsignedSignaturePropertiesDom, valContext, afterCertificateText);
            this.unsignedSignaturePropertiesDom = this.indentIfPrettyPrint(this.unsignedSignaturePropertiesDom, levelXUnsignedProperties);
        }
    }

    private String removeOldCertificateValues() {
        String text = null;
        Element toRemove = this.xadesSignature.getCertificateValues();
        if (toRemove != null) {
            text = this.removeChild(this.unsignedSignaturePropertiesDom, toRemove);
            this.xadesSignature.resetCertificateSource();
        }
        return text;
    }

    private void removeOldRevocationValues() {
        Element toRemove = this.xadesSignature.getRevocationValues();
        if (toRemove != null) {
            this.removeChild(this.unsignedSignaturePropertiesDom, toRemove);
            this.xadesSignature.resetRevocationSources();
        }
    }
}

