/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.AbstractSignatureParameters;
import eu.europa.esig.dss.enumerations.SignaturePackaging;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.SignatureValue;
import eu.europa.esig.dss.model.ToBeSigned;
import eu.europa.esig.dss.signature.AbstractSignatureService;
import eu.europa.esig.dss.signature.MultipleDocumentsSignatureService;
import eu.europa.esig.dss.signature.SignatureExtension;
import eu.europa.esig.dss.signature.SigningOperation;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import eu.europa.esig.dss.xades.ProfileParameters;
import eu.europa.esig.dss.xades.SantuarioInitializer;
import eu.europa.esig.dss.xades.SignatureProfile;
import eu.europa.esig.dss.xades.XAdESSignatureParameters;
import eu.europa.esig.dss.xades.reference.DSSReference;
import eu.europa.esig.dss.xades.signature.AllDataObjectsTimeStampBuilder;
import eu.europa.esig.dss.xades.signature.XAdESLevelA;
import eu.europa.esig.dss.xades.signature.XAdESLevelBaselineB;
import eu.europa.esig.dss.xades.signature.XAdESLevelBaselineLT;
import eu.europa.esig.dss.xades.signature.XAdESLevelBaselineLTA;
import eu.europa.esig.dss.xades.signature.XAdESLevelBaselineT;
import eu.europa.esig.dss.xades.signature.XAdESLevelC;
import eu.europa.esig.dss.xades.signature.XAdESLevelX;
import eu.europa.esig.dss.xades.signature.XAdESLevelXL;
import eu.europa.esig.dss.xades.signature.XAdESSignatureBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XAdESService
extends AbstractSignatureService<XAdESSignatureParameters>
implements MultipleDocumentsSignatureService<XAdESSignatureParameters> {
    private static final Logger LOG;

    public XAdESService(CertificateVerifier certificateVerifier) {
        super(certificateVerifier);
        LOG.debug("+ XAdESService created");
    }

    public TimestampToken getContentTimestamp(DSSDocument toSignDocument, XAdESSignatureParameters parameters) {
        return this.getContentTimestamp(Arrays.asList(toSignDocument), parameters);
    }

    public TimestampToken getContentTimestamp(List<DSSDocument> toSignDocuments, XAdESSignatureParameters parameters) {
        if (this.tspSource == null) {
            throw new DSSException("A TSPSource is required !");
        }
        AllDataObjectsTimeStampBuilder builder = new AllDataObjectsTimeStampBuilder(this.tspSource, parameters.getContentTimestampParameters());
        return builder.build(toSignDocuments);
    }

    public ToBeSigned getDataToSign(DSSDocument toSignDocument, XAdESSignatureParameters parameters) throws DSSException {
        this.assertSigningDateInCertificateValidityRange(parameters);
        XAdESLevelBaselineB levelBaselineB = new XAdESLevelBaselineB(this.certificateVerifier);
        byte[] dataToSign = levelBaselineB.getDataToSign(toSignDocument, parameters);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Data to sign: ");
            LOG.trace(new String(dataToSign));
        }
        parameters.getContext().setProfile(levelBaselineB);
        return new ToBeSigned(dataToSign);
    }

    public ToBeSigned getDataToSign(List<DSSDocument> toSignDocuments, XAdESSignatureParameters parameters) throws DSSException {
        this.assertMultiDocumentsAllowed(parameters);
        DSSDocument firstDoc = toSignDocuments.get(0);
        XAdESSignatureBuilder xadesSignatureBuilder = XAdESSignatureBuilder.getSignatureBuilder(parameters, firstDoc, this.certificateVerifier);
        List<DSSReference> references = xadesSignatureBuilder.createReferencesForDocuments(toSignDocuments);
        parameters.setReferences(references);
        return this.getDataToSign(firstDoc, parameters);
    }

    private void assertMultiDocumentsAllowed(XAdESSignatureParameters parameters) {
        SignaturePackaging signaturePackaging = parameters.getSignaturePackaging();
        if (signaturePackaging == null || SignaturePackaging.ENVELOPED == signaturePackaging) {
            throw new DSSException("Not supported operation (only DETACHED or ENVELOPING are allowed)");
        }
    }

    public DSSDocument signDocument(DSSDocument toSignDocument, XAdESSignatureParameters parameters, SignatureValue signatureValue) throws DSSException {
        if (parameters.getSignatureLevel() == null) {
            throw new NullPointerException();
        }
        this.assertSigningDateInCertificateValidityRange(parameters);
        parameters.getContext().setOperationKind(ProfileParameters.Operation.SIGNING);
        ProfileParameters context = parameters.getContext();
        SignatureProfile profile = context.getProfile() != null ? context.getProfile() : new XAdESLevelBaselineB(this.certificateVerifier);
        DSSDocument signedDoc = profile.signDocument(toSignDocument, parameters, signatureValue.getValue());
        SignatureExtension<XAdESSignatureParameters> extension = this.getExtensionProfile(parameters);
        if (extension != null) {
            if (SignaturePackaging.DETACHED.equals((Object)parameters.getSignaturePackaging()) && Utils.isCollectionEmpty((Collection)parameters.getDetachedContents())) {
                ArrayList<DSSDocument> detachedContents = new ArrayList<DSSDocument>();
                detachedContents.add(toSignDocument);
                parameters.setDetachedContents(detachedContents);
            }
            DSSDocument dssExtendedDocument = extension.extendSignatures(signedDoc, (AbstractSignatureParameters)parameters);
            parameters.reinitDeterministicId();
            dssExtendedDocument.setName(this.getFinalFileName(toSignDocument, SigningOperation.SIGN, parameters.getSignatureLevel()));
            return dssExtendedDocument;
        }
        parameters.reinitDeterministicId();
        signedDoc.setName(this.getFinalFileName(toSignDocument, SigningOperation.SIGN, parameters.getSignatureLevel()));
        return signedDoc;
    }

    public DSSDocument signDocument(List<DSSDocument> toSignDocuments, XAdESSignatureParameters parameters, SignatureValue signatureValue) throws DSSException {
        this.assertMultiDocumentsAllowed(parameters);
        DSSDocument firstDoc = toSignDocuments.get(0);
        XAdESSignatureBuilder xadesSignatureBuilder = XAdESSignatureBuilder.getSignatureBuilder(parameters, firstDoc, this.certificateVerifier);
        List<DSSReference> references = xadesSignatureBuilder.createReferencesForDocuments(toSignDocuments);
        parameters.setReferences(references);
        parameters.setDetachedContents(toSignDocuments);
        return this.signDocument(firstDoc, parameters, signatureValue);
    }

    public DSSDocument extendDocument(DSSDocument toExtendDocument, XAdESSignatureParameters parameters) throws DSSException {
        parameters.getContext().setOperationKind(ProfileParameters.Operation.EXTENDING);
        SignatureExtension<XAdESSignatureParameters> extension = this.getExtensionProfile(parameters);
        if (extension != null) {
            DSSDocument dssDocument = extension.extendSignatures(toExtendDocument, (AbstractSignatureParameters)parameters);
            dssDocument.setName(this.getFinalFileName(toExtendDocument, SigningOperation.EXTEND, parameters.getSignatureLevel()));
            return dssDocument;
        }
        throw new DSSException("Cannot extend to " + parameters.getSignatureLevel().name());
    }

    private SignatureExtension<XAdESSignatureParameters> getExtensionProfile(XAdESSignatureParameters parameters) {
        switch (parameters.getSignatureLevel()) {
            case XAdES_BASELINE_B: {
                return null;
            }
            case XAdES_BASELINE_T: {
                XAdESLevelBaselineT extensionT = new XAdESLevelBaselineT(this.certificateVerifier);
                extensionT.setTspSource(this.tspSource);
                return extensionT;
            }
            case XAdES_C: {
                XAdESLevelC extensionC = new XAdESLevelC(this.certificateVerifier);
                extensionC.setTspSource(this.tspSource);
                return extensionC;
            }
            case XAdES_X: {
                XAdESLevelX extensionX = new XAdESLevelX(this.certificateVerifier);
                extensionX.setTspSource(this.tspSource);
                return extensionX;
            }
            case XAdES_XL: {
                XAdESLevelXL extensionXL = new XAdESLevelXL(this.certificateVerifier);
                extensionXL.setTspSource(this.tspSource);
                return extensionXL;
            }
            case XAdES_A: {
                XAdESLevelA extensionA = new XAdESLevelA(this.certificateVerifier);
                extensionA.setTspSource(this.tspSource);
                return extensionA;
            }
            case XAdES_BASELINE_LT: {
                XAdESLevelBaselineLT extensionLT = new XAdESLevelBaselineLT(this.certificateVerifier);
                extensionLT.setTspSource(this.tspSource);
                return extensionLT;
            }
            case XAdES_BASELINE_LTA: {
                XAdESLevelBaselineLTA extensionLTA = new XAdESLevelBaselineLTA(this.certificateVerifier);
                extensionLTA.setTspSource(this.tspSource);
                return extensionLTA;
            }
        }
        throw new DSSException("Unsupported signature format " + parameters.getSignatureLevel());
    }

    static {
        SantuarioInitializer.init();
        LOG = LoggerFactory.getLogger(XAdESService.class);
    }
}

