/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.validation;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.validation.ISignatureAttribute;
import eu.europa.esig.dss.validation.timestamp.TimestampInclude;
import eu.europa.esig.dss.xades.XPathQueryHolder;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XAdESAttribute
implements ISignatureAttribute {
    private static final String DEFAULT_TIMESTAMP_VALIDATION_CANONICALIZATION_METHOD = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
    private final Element element;
    private final XPathQueryHolder xPathQueryHolder;
    private String localName;

    XAdESAttribute(Element element, XPathQueryHolder xPathQueryHolder) {
        this.element = element;
        this.xPathQueryHolder = xPathQueryHolder;
    }

    public String getName() {
        if (this.localName == null) {
            this.localName = this.element.getLocalName();
        }
        return this.localName;
    }

    public String getNamespace() {
        return this.element.getNamespaceURI();
    }

    public final Element findElement(String xPathExpression) {
        return DomUtils.getElement((Node)this.element, (String)xPathExpression);
    }

    public final NodeList getNodeList(String xPathExpression) {
        return DomUtils.getNodeList((Node)this.element, (String)xPathExpression);
    }

    public String getTimestampCanonicalizationMethod() {
        Element canonicalizationMethodElement = DomUtils.getElement((Node)this.element, (String)this.xPathQueryHolder.XPATH__CANONICALIZATION_METHOD);
        if (canonicalizationMethodElement != null) {
            return canonicalizationMethodElement.getAttribute("Algorithm");
        }
        return DEFAULT_TIMESTAMP_VALIDATION_CANONICALIZATION_METHOD;
    }

    public List<TimestampInclude> getTimestampIncludedReferences() {
        NodeList timestampIncludes = DomUtils.getNodeList((Node)this.element, (String)this.xPathQueryHolder.XPATH__INCLUDE);
        if (timestampIncludes != null && timestampIncludes.getLength() > 0) {
            ArrayList<TimestampInclude> includes = new ArrayList<TimestampInclude>();
            for (int jj = 0; jj < timestampIncludes.getLength(); ++jj) {
                Element include = (Element)timestampIncludes.item(jj);
                String uri = DomUtils.getId((String)include.getAttribute("URI"));
                String referencedData = include.getAttribute("referencedData");
                includes.add(new TimestampInclude(uri, Boolean.parseBoolean(referencedData)));
            }
            return includes;
        }
        return null;
    }

    public int getElementHashCode() {
        return this.element.hashCode();
    }

    public String toString() {
        return this.getName();
    }
}

