/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.validation;

import eu.europa.esig.dss.validation.SignatureProperties;
import eu.europa.esig.dss.xades.XPathQueryHolder;
import eu.europa.esig.dss.xades.validation.XAdESAttribute;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class XAdESSigProperties
implements SignatureProperties<XAdESAttribute> {
    private final Element signatureProptiesDom;
    private final XPathQueryHolder xPathQueryHolder;

    XAdESSigProperties(Element signaturePropties, XPathQueryHolder xPathQueryHolder) {
        this.signatureProptiesDom = signaturePropties;
        this.xPathQueryHolder = xPathQueryHolder;
    }

    public boolean isExist() {
        return this.signatureProptiesDom != null;
    }

    public List<XAdESAttribute> getAttributes() {
        ArrayList<XAdESAttribute> unsignedAttributes = new ArrayList<XAdESAttribute>();
        if (this.signatureProptiesDom != null && this.signatureProptiesDom.hasChildNodes()) {
            NodeList unsignedProperties = this.signatureProptiesDom.getChildNodes();
            for (int ii = 0; ii < unsignedProperties.getLength(); ++ii) {
                Node node = unsignedProperties.item(ii);
                if (!this.isElementNode(node)) continue;
                XAdESAttribute unsignedAttribute = new XAdESAttribute((Element)node, this.xPathQueryHolder);
                unsignedAttributes.add(unsignedAttribute);
            }
        }
        return unsignedAttributes;
    }

    private boolean isElementNode(Node node) {
        return node.getNodeType() == 1;
    }
}

