/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.validation;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.DigestMatcherType;
import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.enumerations.EndorsementType;
import eu.europa.esig.dss.enumerations.MaskGenerationFunction;
import eu.europa.esig.dss.enumerations.SignatureAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureForm;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.identifier.TokenIdentifier;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.x509.CertificatePool;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.CandidatesForSigningCertificate;
import eu.europa.esig.dss.validation.CertificateRef;
import eu.europa.esig.dss.validation.CertificateValidity;
import eu.europa.esig.dss.validation.CommitmentType;
import eu.europa.esig.dss.validation.DefaultAdvancedSignature;
import eu.europa.esig.dss.validation.IssuerSerialInfo;
import eu.europa.esig.dss.validation.ReferenceValidation;
import eu.europa.esig.dss.validation.SignatureCRLSource;
import eu.europa.esig.dss.validation.SignatureCertificateSource;
import eu.europa.esig.dss.validation.SignatureCryptographicVerification;
import eu.europa.esig.dss.validation.SignatureDigestReference;
import eu.europa.esig.dss.validation.SignatureIdentifier;
import eu.europa.esig.dss.validation.SignatureOCSPSource;
import eu.europa.esig.dss.validation.SignaturePolicy;
import eu.europa.esig.dss.validation.SignaturePolicyProvider;
import eu.europa.esig.dss.validation.SignatureProductionPlace;
import eu.europa.esig.dss.validation.SignerRole;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.SantuarioInitializer;
import eu.europa.esig.dss.xades.XPathQueryHolder;
import eu.europa.esig.dss.xades.reference.XAdESReferenceValidation;
import eu.europa.esig.dss.xades.validation.DetachedSignatureResolver;
import eu.europa.esig.dss.xades.validation.ManifestValidator;
import eu.europa.esig.dss.xades.validation.SignatureRSARIPEMD160AT;
import eu.europa.esig.dss.xades.validation.XAdESCRLSource;
import eu.europa.esig.dss.xades.validation.XAdESCertificateSource;
import eu.europa.esig.dss.xades.validation.XAdESOCSPSource;
import eu.europa.esig.dss.xades.validation.XAdESTimestampSource;
import java.io.StringReader;
import java.math.BigInteger;
import java.security.Key;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import javax.xml.transform.stream.StreamSource;
import org.apache.xml.security.algorithms.JCEMapper;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.keyresolver.KeyResolverException;
import org.apache.xml.security.signature.Reference;
import org.apache.xml.security.signature.ReferenceNotInitializedException;
import org.apache.xml.security.signature.SignedInfo;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.utils.XMLUtils;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.digidoc4j.dss.xades.BDocTmSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XAdESSignature
extends DefaultAdvancedSignature {
    private static final long serialVersionUID = -2639858392612722185L;
    private static final Logger LOG = LoggerFactory.getLogger(XAdESSignature.class);
    private static SignatureLevel[] signatureLevels = new SignatureLevel[]{SignatureLevel.XML_NOT_ETSI, SignatureLevel.XAdES_BASELINE_B, SignatureLevel.XAdES_BASELINE_T, SignatureLevel.XAdES_C, SignatureLevel.XAdES_X, SignatureLevel.XAdES_BASELINE_LT, SignatureLevel.XAdES_BASELINE_LTA};
    protected static final String DEFAULT_CANONICALIZATION_METHOD = "http://www.w3.org/2001/10/xml-exc-c14n#";
    private final List<XPathQueryHolder> xPathQueryHolders;
    protected XPathQueryHolder xPathQueryHolder;
    private final Element signatureElement;
    private transient XMLSignature santuarioSignature;
    private String daIdentifier;
    private transient List<Reference> references;
    private List<ReferenceValidation> referenceValidations;

    public XAdESSignature(Element signatureElement) {
        this(signatureElement, Arrays.asList(new XPathQueryHolder()), new CertificatePool());
    }

    public XAdESSignature(Element signatureElement, List<XPathQueryHolder> xPathQueryHolders, CertificatePool certPool) {
        super(certPool);
        if (signatureElement == null) {
            throw new NullPointerException("signatureElement");
        }
        this.signatureElement = signatureElement;
        this.xPathQueryHolders = xPathQueryHolders;
        this.initialiseSettings();
    }

    private void initialiseSettings() {
        this.recursiveNamespaceBrowser(this.signatureElement);
        if (this.xPathQueryHolder == null) {
            LOG.warn("There is no suitable XPathQueryHolder to manage the signature. The default one will be used.");
            this.xPathQueryHolder = new XPathQueryHolder();
        }
    }

    public void recursiveNamespaceBrowser(Element element) {
        for (int ii = 0; ii < element.getChildNodes().getLength(); ++ii) {
            Node node = element.getChildNodes().item(ii);
            if (node.getNodeType() != 1) continue;
            Element childElement = (Element)node;
            String namespaceURI = childElement.getNamespaceURI();
            String localName = childElement.getLocalName();
            if ("Transform".equals(localName) && "http://www.w3.org/2000/09/xmldsig#".equals(namespaceURI)) continue;
            if ("QualifyingProperties".equals(localName)) {
                this.setXPathQueryHolder(namespaceURI);
                return;
            }
            this.recursiveNamespaceBrowser(childElement);
        }
    }

    private void setXPathQueryHolder(String namespaceURI) {
        for (XPathQueryHolder xPathQueryHolder : this.xPathQueryHolders) {
            boolean canUseThisXPathQueryHolder = xPathQueryHolder.canUseThisXPathQueryHolder(namespaceURI);
            if (!canUseThisXPathQueryHolder) continue;
            this.xPathQueryHolder = xPathQueryHolder;
        }
    }

    public XPathQueryHolder getXPathQueryHolder() {
        return this.xPathQueryHolder;
    }

    public Element getSignatureElement() {
        return this.signatureElement;
    }

    public SignatureForm getSignatureForm() {
        return SignatureForm.XAdES;
    }

    public EncryptionAlgorithm getEncryptionAlgorithm() {
        SignatureAlgorithm signatureAlgorithm = this.getSignatureAlgorithm();
        if (signatureAlgorithm == null) {
            return null;
        }
        return signatureAlgorithm.getEncryptionAlgorithm();
    }

    public DigestAlgorithm getDigestAlgorithm() {
        SignatureAlgorithm signatureAlgorithm = this.getSignatureAlgorithm();
        if (signatureAlgorithm == null) {
            return null;
        }
        return signatureAlgorithm.getDigestAlgorithm();
    }

    public MaskGenerationFunction getMaskGenerationFunction() {
        SignatureAlgorithm signatureAlgorithm = this.getSignatureAlgorithm();
        if (signatureAlgorithm == null) {
            return null;
        }
        return signatureAlgorithm.getMaskGenerationFunction();
    }

    public SignatureAlgorithm getSignatureAlgorithm() {
        String xmlName = DomUtils.getElement((Node)this.signatureElement, (String)this.xPathQueryHolder.XPATH_SIGNATURE_METHOD).getAttribute("Algorithm");
        return SignatureAlgorithm.forXML((String)xmlName, null);
    }

    public SignatureCertificateSource getCertificateSource() {
        if (this.offlineCertificateSource == null) {
            this.offlineCertificateSource = new XAdESCertificateSource(this.signatureElement, this.xPathQueryHolder, this.certPool);
        }
        return this.offlineCertificateSource;
    }

    public void resetCertificateSource() {
        this.offlineCertificateSource = null;
    }

    public SignatureCRLSource getCRLSource() {
        if (this.signatureCRLSource == null) {
            this.signatureCRLSource = new XAdESCRLSource(this.signatureElement, this.xPathQueryHolder);
        }
        return this.signatureCRLSource;
    }

    public SignatureOCSPSource getOCSPSource() {
        if (this.signatureOCSPSource == null) {
            this.signatureOCSPSource = new XAdESOCSPSource(this.signatureElement, this.xPathQueryHolder);
        }
        return this.signatureOCSPSource;
    }

    public void resetRevocationSources() {
        this.signatureCRLSource = null;
        this.signatureOCSPSource = null;
    }

    public XAdESTimestampSource getTimestampSource() {
        if (this.signatureTimestampSource == null) {
            this.signatureTimestampSource = new XAdESTimestampSource(this, this.signatureElement, this.xPathQueryHolder, this.certPool);
        }
        return (XAdESTimestampSource)this.signatureTimestampSource;
    }

    public void resetTimestampSource() {
        this.signatureTimestampSource = null;
    }

    public CandidatesForSigningCertificate getCandidatesForSigningCertificate() {
        if (this.candidatesForSigningCertificate != null) {
            return this.candidatesForSigningCertificate;
        }
        this.candidatesForSigningCertificate = new CandidatesForSigningCertificate();
        SignatureCertificateSource certSource = this.getCertificateSource();
        for (CertificateToken certificateToken : certSource.getKeyInfoCertificates()) {
            CertificateValidity certificateValidity = new CertificateValidity(certificateToken);
            this.candidatesForSigningCertificate.add(certificateValidity);
        }
        return this.candidatesForSigningCertificate;
    }

    public void checkSigningCertificate() {
        CandidatesForSigningCertificate candidates = this.getCandidatesForSigningCertificate();
        List potentialSigningCertificates = this.getCertificateSource().getSigningCertificateValues();
        if (Utils.isCollectionNotEmpty((Collection)potentialSigningCertificates)) {
            CertificateRef signingCert = (CertificateRef)potentialSigningCertificates.get(0);
            Digest certDigest = signingCert.getCertDigest();
            IssuerSerialInfo issuerInfo = signingCert.getIssuerInfo();
            List certificateValidityList = candidates.getCertificateValidityList();
            for (CertificateValidity certificateValidity : certificateValidityList) {
                certificateValidity.setAttributePresent(signingCert != null);
                certificateValidity.setDigestPresent(certDigest != null);
                CertificateToken certificateToken = certificateValidity.getCertificateToken();
                if (certificateToken == null) continue;
                if (certDigest != null) {
                    DigestAlgorithm digestAlgorithm = certDigest.getAlgorithm();
                    byte[] expectedDigest = certDigest.getValue();
                    byte[] currentDigest = certificateToken.getDigest(digestAlgorithm);
                    boolean digestEqual = Arrays.equals(expectedDigest, currentDigest);
                    certificateValidity.setDigestEqual(digestEqual);
                }
                if (issuerInfo != null) {
                    BigInteger serialNumber = issuerInfo.getSerialNumber();
                    X500Principal issuerName = issuerInfo.getIssuerName();
                    BigInteger certSerialNumber = certificateToken.getSerialNumber();
                    X500Principal certIssuerName = certificateToken.getIssuerX500Principal();
                    certificateValidity.setSerialNumberEqual(certSerialNumber.equals(serialNumber));
                    boolean issuerNameMatches = DSSUtils.x500PrincipalAreEquals((X500Principal)certIssuerName, (X500Principal)issuerName);
                    certificateValidity.setDistinguishedNameEqual(issuerNameMatches);
                    if (!issuerNameMatches) {
                        String c14nCandidateIssuerName = certIssuerName.getName("CANONICAL");
                        LOG.info("candidateIssuerName : {}", (Object)c14nCandidateIssuerName);
                        String c14nIssuerName = issuerName == null ? "" : issuerName.getName("CANONICAL");
                        LOG.info("issuerName : {}", (Object)c14nIssuerName);
                    }
                }
                if (candidates.getTheCertificateValidity() != null) continue;
                candidates.setTheCertificateValidity(certificateValidity);
            }
        }
    }

    public Date getSigningTime() {
        Element signingTimeEl = DomUtils.getElement((Node)this.signatureElement, (String)this.xPathQueryHolder.XPATH_SIGNING_TIME);
        if (signingTimeEl == null) {
            return null;
        }
        String text = signingTimeEl.getTextContent();
        return DomUtils.getDate((String)text);
    }

    public void checkSignaturePolicy(SignaturePolicyProvider signaturePolicyProvider) {
        Element policyIdentifier = DomUtils.getElement((Node)this.signatureElement, (String)this.xPathQueryHolder.XPATH_SIGNATURE_POLICY_IDENTIFIER);
        if (policyIdentifier != null) {
            Element policyId = DomUtils.getElement((Node)policyIdentifier, (String)this.xPathQueryHolder.XPATH__POLICY_ID);
            if (policyId != null) {
                Element policyDescription;
                String policyUrlString = null;
                String policyIdString = policyId.getTextContent();
                if (Utils.isStringNotEmpty((String)policyIdString)) {
                    policyIdString = policyIdString.replaceAll("\n", "");
                    if (DSSXMLUtils.isOid(policyIdString = policyIdString.trim())) {
                        policyIdString = DSSXMLUtils.getOidCode(policyIdString);
                    } else {
                        policyUrlString = policyIdString;
                    }
                }
                this.signaturePolicy = new SignaturePolicy(policyIdString);
                Node policyDigestMethod = DomUtils.getNode((Node)policyIdentifier, (String)this.xPathQueryHolder.XPATH__POLICY_DIGEST_METHOD);
                String policyDigestMethodString = policyDigestMethod.getTextContent();
                DigestAlgorithm digestAlgorithm = DigestAlgorithm.forXML((String)policyDigestMethodString);
                Element policyDigestValue = DomUtils.getElement((Node)policyIdentifier, (String)this.xPathQueryHolder.XPATH__POLICY_DIGEST_VALUE);
                byte[] digestValue = Utils.fromBase64((String)policyDigestValue.getTextContent().trim());
                this.signaturePolicy.setDigest(new Digest(digestAlgorithm, digestValue));
                Element policyUrl = DomUtils.getElement((Node)policyIdentifier, (String)this.xPathQueryHolder.XPATH__POLICY_SPURI);
                if (policyUrl != null) {
                    policyUrlString = policyUrl.getTextContent().trim();
                }
                if ((policyDescription = DomUtils.getElement((Node)policyIdentifier, (String)this.xPathQueryHolder.XPATH__POLICY_DESCRIPTION)) != null && Utils.isStringNotEmpty((String)policyDescription.getTextContent())) {
                    this.signaturePolicy.setDescription(policyDescription.getTextContent());
                }
                this.signaturePolicy.setUrl(policyUrlString);
                this.signaturePolicy.setPolicyContent(signaturePolicyProvider.getSignaturePolicy(policyIdString, policyUrlString));
            } else {
                Element signaturePolicyImplied = DomUtils.getElement((Node)policyIdentifier, (String)this.xPathQueryHolder.XPATH__SIGNATURE_POLICY_IMPLIED);
                if (signaturePolicyImplied != null) {
                    this.signaturePolicy = new SignaturePolicy();
                }
            }
        }
    }

    public SignatureProductionPlace getSignatureProductionPlace() {
        NodeList nodeList = DomUtils.getNodeList((Node)this.signatureElement, (String)this.xPathQueryHolder.XPATH_PRODUCTION_PLACE);
        if (!(nodeList.getLength() != 0 && nodeList.item(0) != null || (nodeList = DomUtils.getNodeList((Node)this.signatureElement, (String)this.xPathQueryHolder.XPATH_PRODUCTION_PLACE_V2)).getLength() != 0 && nodeList.item(0) != null)) {
            return null;
        }
        SignatureProductionPlace signatureProductionPlace = new SignatureProductionPlace();
        NodeList list = nodeList.item(0).getChildNodes();
        for (int ii = 0; ii < list.getLength(); ++ii) {
            Node item = list.item(ii);
            String name = item.getLocalName();
            String nodeValue = item.getTextContent();
            if ("City".equals(name)) {
                signatureProductionPlace.setCity(nodeValue);
                continue;
            }
            if ("StateOrProvince".equals(name)) {
                signatureProductionPlace.setStateOrProvince(nodeValue);
                continue;
            }
            if ("PostalCode".equals(name)) {
                signatureProductionPlace.setPostalCode(nodeValue);
                continue;
            }
            if ("CountryName".equals(name)) {
                signatureProductionPlace.setCountryName(nodeValue);
                continue;
            }
            if (!"StreetAddress".equals(name)) continue;
            signatureProductionPlace.setStreetAddress(nodeValue);
        }
        return signatureProductionPlace;
    }

    public List<SignerRole> getClaimedSignerRoles() {
        NodeList nodeList = DomUtils.getNodeList((Node)this.signatureElement, (String)this.xPathQueryHolder.XPATH_CLAIMED_ROLE);
        if (nodeList.getLength() == 0 && (nodeList = DomUtils.getNodeList((Node)this.signatureElement, (String)this.xPathQueryHolder.XPATH_CLAIMED_ROLE_V2)).getLength() == 0) {
            return Collections.emptyList();
        }
        ArrayList<SignerRole> claimedRoles = new ArrayList<SignerRole>();
        for (int ii = 0; ii < nodeList.getLength(); ++ii) {
            claimedRoles.add(new SignerRole(nodeList.item(ii).getTextContent(), EndorsementType.CLAIMED));
        }
        return claimedRoles;
    }

    public List<SignerRole> getCertifiedSignerRoles() {
        NodeList nodeList = DomUtils.getNodeList((Node)this.signatureElement, (String)this.xPathQueryHolder.XPATH_CERTIFIED_ROLE);
        if (nodeList.getLength() == 0 && (nodeList = DomUtils.getNodeList((Node)this.signatureElement, (String)this.xPathQueryHolder.XPATH_CERTIFIED_ROLE_V2)).getLength() == 0) {
            return Collections.emptyList();
        }
        ArrayList<SignerRole> certifiedRoles = new ArrayList<SignerRole>();
        for (int ii = 0; ii < nodeList.getLength(); ++ii) {
            Element certEl = (Element)nodeList.item(ii);
            String textContent = certEl.getTextContent();
            certifiedRoles.add(new SignerRole(textContent, EndorsementType.CERTIFIED));
        }
        return certifiedRoles;
    }

    public String getContentType() {
        String contentType = null;
        NodeList allContentTypes = DomUtils.getNodeList((Node)this.signatureElement, (String)this.xPathQueryHolder.XPATH_ALL_DATA_OBJECT_FORMAT_OBJECT_IDENTIFIER);
        if (allContentTypes != null && allContentTypes.getLength() > 0) {
            for (int i = 0; i < allContentTypes.getLength(); ++i) {
                Node node = allContentTypes.item(i);
                if (!(node instanceof Element)) continue;
                Element element = (Element)node;
                contentType = element.getTextContent();
                break;
            }
        }
        return contentType;
    }

    public String getMimeType() {
        String mimeType = null;
        NodeList allMimeTypes = DomUtils.getNodeList((Node)this.signatureElement, (String)this.xPathQueryHolder.XPATH_ALL_DATA_OBJECT_FORMAT_MIMETYPE);
        if (allMimeTypes != null && allMimeTypes.getLength() > 0) {
            for (int i = 0; i < allMimeTypes.getLength(); ++i) {
                Node node = allMimeTypes.item(i);
                if (!(node instanceof Element)) continue;
                Element element = (Element)node;
                mimeType = element.getTextContent();
                break;
            }
        }
        return mimeType;
    }

    public String getContentIdentifier() {
        return null;
    }

    public String getContentHints() {
        return null;
    }

    public byte[] getSignatureValue() {
        Element signatureValueElement = DomUtils.getElement((Node)this.signatureElement, (String)this.xPathQueryHolder.XPATH_SIGNATURE_VALUE);
        if (signatureValueElement != null) {
            return Utils.fromBase64((String)signatureValueElement.getTextContent());
        }
        return null;
    }

    public NodeList getObjects() {
        return DomUtils.getNodeList((Node)this.signatureElement, (String)"./ds:Object");
    }

    public Element getCompleteCertificateRefs() {
        return DomUtils.getElement((Node)this.signatureElement, (String)this.xPathQueryHolder.XPATH_COMPLETE_CERTIFICATE_REFS);
    }

    public Element getCompleteRevocationRefs() {
        return DomUtils.getElement((Node)this.signatureElement, (String)this.xPathQueryHolder.XPATH_COMPLETE_REVOCATION_REFS);
    }

    public NodeList getSigAndRefsTimeStamp() {
        NodeList nodeList = DomUtils.getNodeList((Node)this.signatureElement, (String)this.xPathQueryHolder.XPATH_SIG_AND_REFS_TIMESTAMP);
        if (nodeList == null || nodeList.getLength() == 0) {
            nodeList = DomUtils.getNodeList((Node)this.signatureElement, (String)this.xPathQueryHolder.XPATH_SIG_AND_REFS_TIMESTAMP_V2);
        }
        return nodeList;
    }

    public Element getCertificateValues() {
        return DomUtils.getElement((Node)this.signatureElement, (String)this.xPathQueryHolder.XPATH_CERTIFICATE_VALUES);
    }

    public Element getRevocationValues() {
        return DomUtils.getElement((Node)this.signatureElement, (String)this.xPathQueryHolder.XPATH_REVOCATION_VALUES);
    }

    public boolean hasBProfile() {
        return DomUtils.isNotEmpty((Node)this.signatureElement, (String)this.xPathQueryHolder.XPATH_SIGNED_SIGNATURE_PROPERTIES);
    }

    public boolean hasTProfile() {
        if (BDocTmSupport.hasBDocTmPolicyId(this.signatureElement, this.xPathQueryHolder)) {
            boolean hasOcspResponse = Utils.isStringNotBlank((String)DomUtils.getValue((Node)this.signatureElement, (String)this.xPathQueryHolder.XPATH_OCSP_VALUES_ENCAPSULATED_OCSP));
            return hasOcspResponse;
        }
        return super.hasTProfile();
    }

    public boolean hasCProfile() {
        boolean certRefs = DomUtils.isNotEmpty((Node)this.signatureElement, (String)this.xPathQueryHolder.XPATH_COMPLETE_CERTIFICATE_REFS);
        boolean revocationRefs = DomUtils.isNotEmpty((Node)this.signatureElement, (String)this.xPathQueryHolder.XPATH_COMPLETE_REVOCATION_REFS);
        return certRefs || revocationRefs;
    }

    public boolean hasXProfile() {
        return DomUtils.isNotEmpty((Node)this.signatureElement, (String)this.xPathQueryHolder.XPATH_SIG_AND_REFS_TIMESTAMP);
    }

    public void checkSignatureIntegrity() {
        if (this.signatureCryptographicVerification != null) {
            return;
        }
        this.signatureCryptographicVerification = new SignatureCryptographicVerification();
        try {
            XMLSignature santuarioSignature = this.getSantuarioSignature();
            boolean coreValidity = false;
            List<CertificateValidity> certificateValidityList = this.getSigningCertificateValidityList(santuarioSignature, this.signatureCryptographicVerification, this.providedSigningCertificateToken);
            LOG.debug("Determining signing certificate from certificate candidates list");
            ArrayList<String> preliminaryErrorMessages = new ArrayList<String>();
            int certificateNumber = 0;
            for (CertificateValidity certificateValidity : certificateValidityList) {
                String errorMessagePrefix = "Certificate #" + (certificateNumber + 1) + ": ";
                try {
                    PublicKey publicKey = certificateValidity.getPublicKey();
                    coreValidity = santuarioSignature.checkSignatureValue((Key)publicKey);
                    if (coreValidity) {
                        LOG.info("Determining signing certificate from certificate candidates list succeeded");
                        this.candidatesForSigningCertificate.setTheCertificateValidity(certificateValidity);
                        break;
                    }
                    preliminaryErrorMessages.add(errorMessagePrefix + "Signature verification failed");
                }
                catch (XMLSignatureException e) {
                    LOG.debug("Exception while probing candidate certificate as signing certificate: {}", (Object)e.getMessage());
                    preliminaryErrorMessages.add(errorMessagePrefix + e.getMessage());
                }
                catch (Exception e) {
                    LOG.error("Technical Exception : " + e.getMessage());
                }
                ++certificateNumber;
            }
            if (!coreValidity) {
                LOG.warn("Determining signing certificate from certificate candidates list failed: {}", preliminaryErrorMessages);
                for (String preliminaryErrorMessage : preliminaryErrorMessages) {
                    this.signatureCryptographicVerification.setErrorMessage(preliminaryErrorMessage);
                }
            }
            boolean allReferenceDataFound = true;
            boolean allReferenceDataIntact = true;
            List<ReferenceValidation> refValidations = this.getReferenceValidations();
            for (ReferenceValidation referenceValidation : refValidations) {
                allReferenceDataFound = allReferenceDataFound && referenceValidation.isFound();
                allReferenceDataIntact = allReferenceDataIntact && referenceValidation.isIntact();
            }
            this.signatureCryptographicVerification.setReferenceDataFound(allReferenceDataFound);
            this.signatureCryptographicVerification.setReferenceDataIntact(allReferenceDataIntact);
            this.signatureCryptographicVerification.setSignatureIntact(coreValidity);
        }
        catch (Exception e) {
            LOG.error("checkSignatureIntegrity : {}", (Object)e.getMessage());
            LOG.debug("checkSignatureIntegrity : " + e.getMessage(), (Throwable)e);
            StackTraceElement[] stackTrace = e.getStackTrace();
            String name = XAdESSignature.class.getName();
            int lineNumber = 0;
            for (StackTraceElement element : stackTrace) {
                String className = element.getClassName();
                if (!className.equals(name)) continue;
                lineNumber = element.getLineNumber();
                break;
            }
            this.signatureCryptographicVerification.setErrorMessage(e.getMessage() + "/ XAdESSignature/Line number/" + lineNumber);
        }
    }

    private void extractReferences() {
        this.references = new ArrayList<Reference>();
        XMLSignature santuarioSignature = this.getSantuarioSignature();
        SignedInfo signedInfo = santuarioSignature.getSignedInfo();
        int numberOfReferences = signedInfo.getLength();
        for (int ii = 0; ii < numberOfReferences; ++ii) {
            try {
                Reference reference = signedInfo.item(ii);
                this.references.add(reference);
                continue;
            }
            catch (XMLSecurityException e) {
                LOG.warn("Unable to retrieve reference #{} : {}", (Object)ii, (Object)e.getMessage());
            }
        }
    }

    public List<ReferenceValidation> getReferenceValidations() {
        if (this.referenceValidations == null) {
            this.referenceValidations = new ArrayList<ReferenceValidation>();
            XMLSignature santuarioSignature = this.getSantuarioSignature();
            boolean atLeastOneReferenceElementFound = false;
            List<Reference> references = this.getReferences();
            for (Reference reference : references) {
                XAdESReferenceValidation validation = new XAdESReferenceValidation(reference);
                validation.setType(DigestMatcherType.REFERENCE);
                boolean found = false;
                boolean intact = false;
                try {
                    Digest digest = new Digest();
                    digest.setValue(reference.getDigestValue());
                    digest.setAlgorithm(DigestAlgorithm.forXML((String)reference.getMessageDigestAlgorithm().getAlgorithmURI()));
                    validation.setDigest(digest);
                    try {
                        found = reference.getContentsBeforeTransformation() != null;
                    }
                    catch (ReferenceNotInitializedException referenceNotInitializedException) {
                        // empty catch block
                    }
                    String uri = validation.getUriOrEmpty();
                    boolean noDuplicateIdFound = XMLUtils.protectAgainstWrappingAttack((Node)santuarioSignature.getDocument(), (String)DomUtils.getId((String)uri));
                    boolean isElementReference = DomUtils.isElementReference((String)uri);
                    if (isElementReference && DSSXMLUtils.isSignedProperties(reference, this.xPathQueryHolder)) {
                        validation.setType(DigestMatcherType.SIGNED_PROPERTIES);
                        found = found && noDuplicateIdFound && this.findSignedPropertiesById(uri);
                    } else if (DomUtils.isXPointerQuery((String)uri)) {
                        validation.setType(DigestMatcherType.XPOINTER);
                        found = found && noDuplicateIdFound;
                    } else if (isElementReference && DSSXMLUtils.isKeyInfoReference(reference, santuarioSignature.getElement(), this.xPathQueryHolder)) {
                        validation.setType(DigestMatcherType.KEY_INFO);
                        found = true;
                    } else if (isElementReference && reference.typeIsReferenceToObject()) {
                        validation.setType(DigestMatcherType.OBJECT);
                        found = found && noDuplicateIdFound && this.findObjectById(uri);
                    } else if (isElementReference && reference.typeIsReferenceToManifest()) {
                        validation.setType(DigestMatcherType.MANIFEST);
                        Node manifestNode = this.getManifestById(uri);
                        boolean bl = found = found && noDuplicateIdFound && manifestNode != null;
                        if (manifestNode != null) {
                            validation.getDependentValidations().addAll(this.getManifestReferences(manifestNode));
                        }
                    } else {
                        boolean bl = found = found && noDuplicateIdFound;
                    }
                    if (found) {
                        intact = reference.verify();
                    }
                }
                catch (Exception e) {
                    LOG.warn("Unable to verify reference with Id [{}] : {}", new Object[]{reference.getId(), e.getMessage(), e});
                }
                if (DigestMatcherType.REFERENCE.equals((Object)validation.getType()) || DigestMatcherType.OBJECT.equals((Object)validation.getType()) || DigestMatcherType.MANIFEST.equals((Object)validation.getType()) || DigestMatcherType.XPOINTER.equals((Object)validation.getType())) {
                    atLeastOneReferenceElementFound = true;
                }
                validation.setFound(found);
                validation.setIntact(intact);
                this.referenceValidations.add(validation);
            }
            if (!atLeastOneReferenceElementFound) {
                this.referenceValidations.add(this.notFound(DigestMatcherType.REFERENCE));
            }
            if (this.referenceValidations.size() < references.size()) {
                LOG.warn("Not all references were validated!");
            }
        }
        return this.referenceValidations;
    }

    public SignatureDigestReference getSignatureDigestReference(DigestAlgorithm digestAlgorithm) {
        byte[] signatureElementBytes = DSSXMLUtils.canonicalizeSubtree(DEFAULT_CANONICALIZATION_METHOD, this.signatureElement);
        byte[] digestValue = DSSUtils.digest((DigestAlgorithm)digestAlgorithm, (byte[])signatureElementBytes);
        return new SignatureDigestReference(DEFAULT_CANONICALIZATION_METHOD, new Digest(digestAlgorithm, digestValue));
    }

    public List<ReferenceValidation> getManifestReferences(Node manifestNode) {
        ManifestValidator mv = new ManifestValidator(this.signatureElement, manifestNode, this.detachedContents, this.xPathQueryHolder);
        return mv.validate();
    }

    private boolean findSignedPropertiesById(String uri) {
        return this.getSignedPropertiesById(uri) != null;
    }

    private Node getSignedPropertiesById(String uri) {
        if (Utils.isStringNotBlank((String)uri)) {
            String signedPropertiesById = this.xPathQueryHolder.XPATH_SIGNED_PROPERTIES + DomUtils.getXPathByIdAttribute((String)uri);
            return DomUtils.getNode((Node)this.signatureElement, (String)signedPropertiesById);
        }
        return null;
    }

    private boolean findObjectById(String uri) {
        return this.getObjectById(uri) != null;
    }

    public Node getObjectById(String uri) {
        if (Utils.isStringNotBlank((String)uri)) {
            String objectById = "./ds:Object" + DomUtils.getXPathByIdAttribute((String)uri);
            return DomUtils.getNode((Node)this.signatureElement, (String)objectById);
        }
        return null;
    }

    public Node getManifestById(String uri) {
        if (Utils.isStringNotBlank((String)uri)) {
            String manifestById = "./ds:Object/ds:Manifest" + DomUtils.getXPathByIdAttribute((String)uri);
            return DomUtils.getNode((Node)this.signatureElement, (String)manifestById);
        }
        return null;
    }

    private ReferenceValidation notFound(DigestMatcherType type) {
        ReferenceValidation validation = new ReferenceValidation();
        validation.setType(type);
        validation.setFound(false);
        return validation;
    }

    private XMLSignature getSantuarioSignature() {
        if (this.santuarioSignature != null) {
            return this.santuarioSignature;
        }
        try {
            Document document = this.signatureElement.getOwnerDocument();
            Element rootElement = document.getDocumentElement();
            DSSXMLUtils.setIDIdentifier(rootElement);
            DSSXMLUtils.recursiveIdBrowse(rootElement);
            this.santuarioSignature = new XMLSignature(this.signatureElement, "", false);
            if (Utils.isCollectionNotEmpty((Collection)this.detachedContents)) {
                this.initDetachedSignatureResolvers(this.detachedContents);
            }
            return this.santuarioSignature;
        }
        catch (XMLSecurityException e) {
            throw new DSSException("Unable to initialize santuario XMLSignature", (Throwable)e);
        }
    }

    private void initDetachedSignatureResolvers(List<DSSDocument> detachedContents) {
        List<Reference> currentReferences = this.getReferences();
        for (Reference reference : currentReferences) {
            try {
                DigestAlgorithm digestAlgorithm = DigestAlgorithm.forXML((String)reference.getMessageDigestAlgorithm().getAlgorithmURI());
                this.santuarioSignature.addResourceResolver((ResourceResolverSpi)new DetachedSignatureResolver(detachedContents, digestAlgorithm));
            }
            catch (XMLSignatureException e) {
                LOG.warn("Unable to retrieve reference digest algorithm {}", (Object)reference.getId(), (Object)e);
            }
        }
    }

    private List<CertificateValidity> getSigningCertificateValidityList(XMLSignature santuarioSignature, SignatureCryptographicVerification scv, CertificateToken providedSigningCertificate) throws KeyResolverException {
        List<CertificateValidity> certificateValidityList;
        if (providedSigningCertificate == null) {
            CandidatesForSigningCertificate candidates = this.getCandidatesForSigningCertificate();
            certificateValidityList = candidates.getCertificateValidityList();
            if (certificateValidityList.isEmpty()) {
                PublicKey publicKey;
                KeyInfo extractedKeyInfo = santuarioSignature.getKeyInfo();
                if (extractedKeyInfo == null || (publicKey = extractedKeyInfo.getPublicKey()) == null) {
                    scv.setErrorMessage("There is no signing certificate within the signature.");
                    return certificateValidityList;
                }
                certificateValidityList = this.getSigningCertificateValidityList(publicKey);
            }
        } else {
            this.candidatesForSigningCertificate = new CandidatesForSigningCertificate();
            CertificateValidity certificateValidity = new CertificateValidity(providedSigningCertificate);
            this.candidatesForSigningCertificate.add(certificateValidity);
            certificateValidityList = this.candidatesForSigningCertificate.getCertificateValidityList();
        }
        return certificateValidityList;
    }

    protected List<CertificateValidity> getSigningCertificateValidityList(PublicKey extractedPublicKey) {
        this.candidatesForSigningCertificate = new CandidatesForSigningCertificate();
        List certsWithExtractedPublicKey = this.certPool.get(extractedPublicKey);
        if (Utils.isCollectionNotEmpty((Collection)certsWithExtractedPublicKey)) {
            for (CertificateToken certificateToken : certsWithExtractedPublicKey) {
                this.candidatesForSigningCertificate.add(new CertificateValidity(certificateToken));
            }
        } else {
            this.candidatesForSigningCertificate.add(new CertificateValidity(extractedPublicKey));
        }
        return this.candidatesForSigningCertificate.getCertificateValidityList();
    }

    public List<AdvancedSignature> getCounterSignatures() {
        NodeList counterSignatures = DomUtils.getNodeList((Node)this.signatureElement, (String)this.xPathQueryHolder.XPATH_COUNTER_SIGNATURE);
        if (counterSignatures == null) {
            return null;
        }
        ArrayList<AdvancedSignature> xadesList = new ArrayList<AdvancedSignature>();
        for (int ii = 0; ii < counterSignatures.getLength(); ++ii) {
            Element counterSignatureElement = (Element)counterSignatures.item(ii);
            Element signatureElement = DomUtils.getElement((Node)counterSignatureElement, (String)this.xPathQueryHolder.XPATH__SIGNATURE);
            XAdESSignature xadesCounterSignature = new XAdESSignature(signatureElement, this.xPathQueryHolders, this.certPool);
            if (!this.isCounterSignature(xadesCounterSignature)) continue;
            xadesCounterSignature.setMasterSignature((AdvancedSignature)this);
            xadesList.add((AdvancedSignature)xadesCounterSignature);
        }
        return xadesList;
    }

    private boolean isCounterSignature(XAdESSignature xadesCounterSignature) {
        List<Reference> references = xadesCounterSignature.getReferences();
        for (Reference reference : references) {
            if (!DSSXMLUtils.isCounerSignature(reference, this.xPathQueryHolder)) continue;
            return true;
        }
        return false;
    }

    public List<CertificateRef> getCertificateRefs() {
        return this.getCertificateSource().getCompleteCertificateRefs();
    }

    protected SignatureIdentifier buildSignatureIdentifier() {
        CertificateToken certificateToken = this.getSigningCertificateToken();
        TokenIdentifier identifier = certificateToken == null ? null : certificateToken.getDSSId();
        return SignatureIdentifier.buildSignatureIdentifier((Date)this.getSigningTime(), (TokenIdentifier)identifier, (String)this.getDAIdentifier());
    }

    public String getDAIdentifier() {
        if (this.daIdentifier == null) {
            this.daIdentifier = DSSXMLUtils.getIDIdentifier(this.signatureElement);
        }
        return this.daIdentifier;
    }

    public List<String> getUnsignedSignatureProperties() {
        List childrenNames = DomUtils.getChildrenNames((Node)this.signatureElement, (String)this.xPathQueryHolder.XPATH_UNSIGNED_SIGNATURE_PROPERTIES);
        return childrenNames;
    }

    public List<String> getSignedSignatureProperties() {
        List childrenNames = DomUtils.getChildrenNames((Node)this.signatureElement, (String)this.xPathQueryHolder.XPATH_SIGNED_SIGNATURE_PROPERTIES);
        return childrenNames;
    }

    public List<String> getSignedProperties() {
        List childrenNames = DomUtils.getChildrenNames((Node)this.signatureElement, (String)this.xPathQueryHolder.XPATH_SIGNED_PROPERTIES);
        return childrenNames;
    }

    public List<String> getUnsignedProperties() {
        List childrenNames = DomUtils.getChildrenNames((Node)this.signatureElement, (String)this.xPathQueryHolder.XPATH_UNSIGNED_PROPERTIES);
        return childrenNames;
    }

    public List<String> getSignedDataObjectProperties() {
        List childrenNames = DomUtils.getChildrenNames((Node)this.signatureElement, (String)this.xPathQueryHolder.XPATH_SIGNED_DATA_OBJECT_PROPERTIES);
        return childrenNames;
    }

    public boolean isDataForSignatureLevelPresent(SignatureLevel signatureLevel) {
        boolean dataForLevelPresent = true;
        switch (signatureLevel) {
            case XML_NOT_ETSI: {
                break;
            }
            case XAdES_BASELINE_LTA: {
                dataForLevelPresent = this.hasLTAProfile();
                dataForLevelPresent = dataForLevelPresent && this.isDataForSignatureLevelPresent(SignatureLevel.XAdES_BASELINE_LT);
                break;
            }
            case XAdES_BASELINE_LT: {
                dataForLevelPresent = this.hasLTProfile();
                dataForLevelPresent = dataForLevelPresent && this.isDataForSignatureLevelPresent(SignatureLevel.XAdES_BASELINE_T);
                break;
            }
            case XAdES_BASELINE_T: {
                dataForLevelPresent = this.hasTProfile();
                dataForLevelPresent = dataForLevelPresent && this.isDataForSignatureLevelPresent(SignatureLevel.XAdES_BASELINE_B);
                break;
            }
            case XAdES_BASELINE_B: {
                dataForLevelPresent = this.hasBProfile();
                break;
            }
            case XAdES_X: {
                dataForLevelPresent = this.hasXProfile();
                dataForLevelPresent = dataForLevelPresent && this.isDataForSignatureLevelPresent(SignatureLevel.XAdES_C);
                break;
            }
            case XAdES_C: {
                dataForLevelPresent = this.hasCProfile();
                dataForLevelPresent = dataForLevelPresent && this.isDataForSignatureLevelPresent(SignatureLevel.XAdES_BASELINE_T);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown level " + signatureLevel);
            }
        }
        return dataForLevelPresent;
    }

    public SignatureLevel[] getSignatureLevels() {
        return signatureLevels;
    }

    public void validateStructure() {
        String string = DomUtils.xmlToString((Node)this.signatureElement);
        StringReader stringReader = new StringReader(string);
        this.structureValidation = DSSXMLUtils.validateAgainstXSD(new StreamSource(stringReader));
    }

    public Element getLastTimestampValidationData() {
        Element unsignedSignatureElement;
        String nodeName;
        NodeList nodeList = DomUtils.getNodeList((Node)this.signatureElement, (String)(this.xPathQueryHolder.XPATH_UNSIGNED_SIGNATURE_PROPERTIES + "/*"));
        if (nodeList.getLength() > 0 && "TimeStampValidationData".equals(nodeName = (unsignedSignatureElement = (Element)nodeList.item(nodeList.getLength() - 1)).getLocalName())) {
            return unsignedSignatureElement;
        }
        return null;
    }

    public CommitmentType getCommitmentTypeIndication() {
        CommitmentType result = null;
        NodeList nodeList = DomUtils.getNodeList((Node)this.signatureElement, (String)this.xPathQueryHolder.XPATH_COMMITMENT_IDENTIFICATION);
        if (nodeList != null && nodeList.getLength() > 0) {
            result = new CommitmentType();
            for (int ii = 0; ii < nodeList.getLength(); ++ii) {
                result.addIdentifier(DomUtils.getValue((Node)nodeList.item(ii), (String)this.xPathQueryHolder.XPATH_COMITMENT_IDENTIFIERS));
            }
        }
        return result;
    }

    public List<Reference> getReferences() {
        if (this.references == null) {
            this.extractReferences();
        }
        return this.references;
    }

    public List<Element> getSignatureObjects() {
        NodeList list = DomUtils.getNodeList((Node)this.signatureElement, (String)"./ds:Object");
        ArrayList<Element> references = new ArrayList<Element>(list.getLength());
        for (int ii = 0; ii < list.getLength(); ++ii) {
            Node node = list.item(ii);
            Element element = (Element)node;
            if (DomUtils.getElement((Node)element, (String)this.xPathQueryHolder.XPATH__QUALIFYING_PROPERTIES_SIGNED_PROPERTIES) != null) continue;
            references.add(element);
        }
        return references;
    }

    public void registerXPathQueryHolder(XPathQueryHolder xPathQueryHolder) {
        this.xPathQueryHolders.add(xPathQueryHolder);
    }

    static {
        SantuarioInitializer.init();
        JCEMapper.Algorithm notStandardAlgorithm = new JCEMapper.Algorithm("", SignatureAlgorithm.RSA_RIPEMD160.getJCEId(), "Signature");
        JCEMapper.register((String)"http://www.w3.org/2001/04/xmldsig-more/rsa-ripemd160", (JCEMapper.Algorithm)notStandardAlgorithm);
        try {
            org.apache.xml.security.algorithms.SignatureAlgorithm.register((String)"http://www.w3.org/2001/04/xmldsig-more/rsa-ripemd160", SignatureRSARIPEMD160AT.class);
        }
        catch (Exception e) {
            LOG.error("ECDSA_RIPEMD160AT algorithm initialisation failed.", (Throwable)e);
        }
    }
}

