/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.validation;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.enumerations.ArchiveTimestampType;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.timestamp.TimestampDataBuilder;
import eu.europa.esig.dss.validation.timestamp.TimestampInclude;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.XPathQueryHolder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XAdESTimestampDataBuilder
implements TimestampDataBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(XAdESTimestampDataBuilder.class);
    private final List<Reference> references;
    private final Element signature;
    private final XPathQueryHolder xPathQueryHolder;

    public XAdESTimestampDataBuilder(Element signature, List<Reference> references, XPathQueryHolder xPathQueryHolder) {
        this.signature = signature;
        this.references = references;
        this.xPathQueryHolder = xPathQueryHolder;
    }

    public byte[] getContentTimestampData(TimestampToken timestampToken) {
        byte[] byArray;
        TimestampType timeStampType = timestampToken.getTimeStampType();
        if (!timeStampType.isContentTimestamp()) {
            return null;
        }
        if (!this.checkTimestampTokenIncludes(timestampToken)) {
            throw new DSSException("The Included referencedData attribute is either not present or set to false!");
        }
        if (this.references.isEmpty()) {
            throw new DSSException("The method 'checkSignatureIntegrity' must be invoked first!");
        }
        String canonicalizationMethod = timestampToken.getCanonicalizationMethod();
        List includes = timestampToken.getTimestampIncludes();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            for (Reference reference : this.references) {
                if (!this.isContentTimestampedReference(reference, timeStampType, includes)) continue;
                byte[] referenceBytes = this.getReferenceBytes(reference, canonicalizationMethod);
                outputStream.write(referenceBytes);
            }
            byte[] byteArray = outputStream.toByteArray();
            if (LOG.isTraceEnabled()) {
                LOG.trace("IndividualDataObjectsTimestampData/AllDataObjectsTimestampData bytes: {}", (Object)new String(byteArray));
            }
            byArray = byteArray;
        }
        catch (Throwable throwable) {
            try {
                try {
                    outputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | XMLSecurityException e) {
                LOG.warn("Unable to extract IndividualDataObjectsTimestampData/AllDataObjectsTimestampData", e);
                return null;
            }
        }
        outputStream.close();
        return byArray;
    }

    private byte[] getReferenceBytes(Reference reference, String canonicalizationMethod) throws XMLSecurityException {
        byte[] referencedBytes = reference.getReferencedBytes();
        if (Utils.isStringNotBlank((String)canonicalizationMethod) && DomUtils.isDOM((byte[])referencedBytes)) {
            referencedBytes = DSSXMLUtils.canonicalize(canonicalizationMethod, referencedBytes);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("ReferencedBytes : {}", (Object)new String(referencedBytes));
        }
        return referencedBytes;
    }

    private boolean checkTimestampTokenIncludes(TimestampToken timestampToken) {
        List timestampIncludes = timestampToken.getTimestampIncludes();
        if (Utils.isCollectionNotEmpty((Collection)timestampIncludes)) {
            for (TimestampInclude timestampInclude : timestampIncludes) {
                if (timestampInclude.isReferencedData()) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isContentTimestampedReference(Reference reference, TimestampType timeStampType, List<TimestampInclude> includes) {
        if (TimestampType.ALL_DATA_OBJECTS_TIMESTAMP.equals((Object)timeStampType)) {
            return !DSSXMLUtils.isSignedProperties(reference, new XPathQueryHolder());
        }
        for (TimestampInclude timestampInclude : includes) {
            String id = timestampInclude.getURI();
            if (!reference.getId().equals(id)) continue;
            return true;
        }
        return false;
    }

    public byte[] getSignatureTimestampData(TimestampToken timestampToken) {
        return this.getSignatureTimestampData(timestampToken, null);
    }

    public byte[] getSignatureTimestampData(String canonicalizationMethod) {
        return this.getSignatureTimestampData(null, canonicalizationMethod);
    }

    protected byte[] getSignatureTimestampData(TimestampToken timestampToken, String canonicalizationMethod) {
        byte[] byArray;
        canonicalizationMethod = timestampToken != null ? timestampToken.getCanonicalizationMethod() : canonicalizationMethod;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            this.writeCanonicalizedValue(this.xPathQueryHolder.XPATH_SIGNATURE_VALUE, canonicalizationMethod, buffer);
            byte[] byteArray = buffer.toByteArray();
            if (LOG.isTraceEnabled()) {
                LOG.trace("Signature timestamp canonicalized string : \n{}", (Object)new String(byteArray));
            }
            byArray = byteArray;
        }
        catch (Throwable throwable) {
            try {
                try {
                    buffer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new DSSException("Error when computing the SignatureTimestamp", (Throwable)e);
            }
        }
        buffer.close();
        return byArray;
    }

    public byte[] getTimestampX1Data(TimestampToken timestampToken) {
        return this.getTimestampX1Data(timestampToken, null);
    }

    public byte[] getTimestampX1Data(String canonicalizationMethod) {
        return this.getTimestampX1Data(null, canonicalizationMethod);
    }

    protected byte[] getTimestampX1Data(TimestampToken timestampToken, String canonicalizationMethod) {
        byte[] byArray;
        canonicalizationMethod = timestampToken != null ? timestampToken.getCanonicalizationMethod() : canonicalizationMethod;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            this.writeCanonicalizedValue(this.xPathQueryHolder.XPATH_SIGNATURE_VALUE, canonicalizationMethod, buffer);
            NodeList signatureTimeStampNode = DomUtils.getNodeList((Node)this.signature, (String)this.xPathQueryHolder.XPATH_SIGNATURE_TIMESTAMP);
            if (signatureTimeStampNode != null) {
                for (int ii = 0; ii < signatureTimeStampNode.getLength(); ++ii) {
                    Node item = signatureTimeStampNode.item(ii);
                    byte[] canonicalizedValue = DSSXMLUtils.canonicalizeSubtree(canonicalizationMethod, item);
                    buffer.write(canonicalizedValue);
                }
            }
            this.writeCanonicalizedValue(this.xPathQueryHolder.XPATH_COMPLETE_CERTIFICATE_REFS, canonicalizationMethod, buffer);
            this.writeCanonicalizedValue(this.xPathQueryHolder.XPATH_COMPLETE_REVOCATION_REFS, canonicalizationMethod, buffer);
            byte[] byteArray = buffer.toByteArray();
            if (LOG.isTraceEnabled()) {
                LOG.trace("X1Timestamp (SigAndRefsTimeStamp) canonicalised string : \n{}", (Object)new String(byteArray));
            }
            byArray = byteArray;
        }
        catch (Throwable throwable) {
            try {
                try {
                    buffer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new DSSException("Error when computing the SigAndRefsTimeStamp (X1Timestamp)", (Throwable)e);
            }
        }
        buffer.close();
        return byArray;
    }

    public byte[] getTimestampX2Data(TimestampToken timestampToken) {
        return this.getTimestampX2Data(timestampToken, null);
    }

    public byte[] getTimestampX2Data(String canonicalizationMethod) {
        return this.getTimestampX2Data(null, canonicalizationMethod);
    }

    protected byte[] getTimestampX2Data(TimestampToken timestampToken, String canonicalizationMethod) {
        byte[] byArray;
        canonicalizationMethod = timestampToken != null ? timestampToken.getCanonicalizationMethod() : canonicalizationMethod;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            this.writeCanonicalizedValue(this.xPathQueryHolder.XPATH_COMPLETE_CERTIFICATE_REFS, canonicalizationMethod, buffer);
            this.writeCanonicalizedValue(this.xPathQueryHolder.XPATH_COMPLETE_REVOCATION_REFS, canonicalizationMethod, buffer);
            byte[] byteArray = buffer.toByteArray();
            if (LOG.isTraceEnabled()) {
                LOG.trace("TimestampX2Data (RefsOnlyTimeStamp) canonicalised string : \n{}", (Object)new String(byteArray));
            }
            byArray = byteArray;
        }
        catch (Throwable throwable) {
            try {
                try {
                    buffer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new DSSException("Error when computing the RefsOnlyTimeStamp (TimestampX2D)", (Throwable)e);
            }
        }
        buffer.close();
        return byArray;
    }

    public byte[] getArchiveTimestampData(TimestampToken timestampToken) {
        return this.getArchiveTimestampData(timestampToken, null);
    }

    public byte[] getArchiveTimestampData(String canonicalizationMethod) {
        return this.getArchiveTimestampData(null, canonicalizationMethod);
    }

    protected byte[] getArchiveTimestampData(TimestampToken timestampToken, String canonicalizationMethod) {
        byte[] byArray;
        if (LOG.isTraceEnabled()) {
            LOG.trace("--->Get archive timestamp data : {}", (Object)(timestampToken == null ? "--> CREATION" : "--> VALIDATION"));
        }
        canonicalizationMethod = timestampToken != null ? timestampToken.getCanonicalizationMethod() : canonicalizationMethod;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            HashSet<String> referenceURIs = new HashSet<String>();
            for (Reference reference : this.references) {
                referenceURIs.add(DomUtils.getId((String)reference.getURI()));
                this.writeReferenceBytes(reference, buffer);
            }
            this.writeCanonicalizedValue(this.xPathQueryHolder.XPATH_SIGNED_INFO, canonicalizationMethod, buffer);
            this.writeCanonicalizedValue(this.xPathQueryHolder.XPATH_SIGNATURE_VALUE, canonicalizationMethod, buffer);
            this.writeCanonicalizedValue(this.xPathQueryHolder.XPATH_KEY_INFO, canonicalizationMethod, buffer);
            Element unsignedSignaturePropertiesDom = this.getUnsignedSignaturePropertiesDom();
            if (unsignedSignaturePropertiesDom == null) {
                throw new NullPointerException(this.xPathQueryHolder.XPATH_UNSIGNED_SIGNATURE_PROPERTIES);
            }
            this.writeTimestampedUnsignedProperties(unsignedSignaturePropertiesDom, timestampToken, canonicalizationMethod, buffer);
            boolean xades141 = timestampToken == null || !ArchiveTimestampType.XAdES.equals((Object)timestampToken.getArchiveTimestampType());
            NodeList objects = this.getObjects();
            this.writeObjectBytes(objects, referenceURIs, canonicalizationMethod, xades141, buffer);
            byte[] bytes = buffer.toByteArray();
            if (LOG.isTraceEnabled()) {
                LOG.trace("Data to TimeStamp:");
                LOG.trace(new String(bytes));
            }
            byArray = bytes;
        }
        catch (Throwable throwable) {
            try {
                try {
                    buffer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new DSSException("Error when computing the archive data", (Throwable)e);
            }
        }
        buffer.close();
        return byArray;
    }

    private void writeReferenceBytes(Reference reference, ByteArrayOutputStream buffer) throws IOException {
        try {
            byte[] referencedBytes = reference.getReferencedBytes();
            if (referencedBytes != null) {
                buffer.write(referencedBytes);
            } else {
                LOG.warn("No binaries found for URI '{}'", (Object)reference.getURI());
            }
        }
        catch (XMLSecurityException e) {
            LOG.warn("Unable to retrieve content for URI '{}' : {}", (Object)reference.getURI(), (Object)e.getMessage());
        }
    }

    private void writeCanonicalizedValue(String xPathString, String canonicalizationMethod, ByteArrayOutputStream buffer) throws IOException {
        Element element = DomUtils.getElement((Node)this.signature, (String)xPathString);
        if (element != null) {
            buffer.write(DSSXMLUtils.canonicalizeOrSerializeSubtree(canonicalizationMethod, element));
        }
    }

    private Element getUnsignedSignaturePropertiesDom() {
        return DomUtils.getElement((Node)this.signature, (String)this.xPathQueryHolder.XPATH_UNSIGNED_SIGNATURE_PROPERTIES);
    }

    private void writeTimestampedUnsignedProperties(Element unsignedSignaturePropertiesDom, TimestampToken timestampToken, String canonicalizationMethod, ByteArrayOutputStream buffer) throws IOException {
        NodeList unsignedProperties = unsignedSignaturePropertiesDom.getChildNodes();
        for (int ii = 0; ii < unsignedProperties.getLength(); ++ii) {
            byte[] canonicalizedValue;
            Node node = unsignedProperties.item(ii);
            if (node.getNodeType() != 1) continue;
            String localName = node.getLocalName();
            if ("ArchiveTimeStamp".equals(localName)) {
                if (timestampToken != null && timestampToken.getHashCode() == node.hashCode()) {
                    break;
                }
            } else if ("TimeStampValidationData".equals(localName)) {
                // empty if block
            }
            if (timestampToken == null) {
                byte[] bytesToCanonicalize = DSSXMLUtils.serializeNode(node);
                canonicalizedValue = DSSXMLUtils.canonicalize(canonicalizationMethod, bytesToCanonicalize);
            } else {
                canonicalizedValue = DSSXMLUtils.canonicalizeOrSerializeSubtree(canonicalizationMethod, node);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("{}: Canonicalization: {} : \n{}", new Object[]{localName, canonicalizationMethod, new String(canonicalizedValue)});
            }
            buffer.write(canonicalizedValue);
        }
    }

    private NodeList getObjects() {
        return DomUtils.getNodeList((Node)this.signature, (String)"./ds:Object");
    }

    private void writeObjectBytes(NodeList objects, Set<String> referenceURIs, String canonicalizationMethod, boolean xades141, ByteArrayOutputStream buffer) throws IOException {
        for (int ii = 0; ii < objects.getLength(); ++ii) {
            Node node = objects.item(ii);
            Element qualifyingProperties = DomUtils.getElement((Node)node, (String)this.xPathQueryHolder.XPATH__QUALIFYING_PROPERTIES);
            if (qualifyingProperties != null) continue;
            if (!xades141) {
                boolean contains;
                NamedNodeMap attributes = node.getAttributes();
                int length = attributes.getLength();
                String id = "";
                for (int jj = 0; jj < length; ++jj) {
                    Node item = attributes.item(jj);
                    String nodeName = item.getNodeName();
                    if (!Utils.areStringsEqualIgnoreCase((String)"ID", (String)nodeName)) continue;
                    id = item.getNodeValue();
                    break;
                }
                if (contains = referenceURIs.contains(id)) continue;
            }
            byte[] canonicalizedValue = DSSXMLUtils.canonicalizeOrSerializeSubtree(canonicalizationMethod, node);
            buffer.write(canonicalizedValue);
        }
    }
}

