/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.validation;

import eu.europa.esig.dss.crl.CRLBinary;
import eu.europa.esig.dss.enumerations.ArchiveTimestampType;
import eu.europa.esig.dss.enumerations.DigestMatcherType;
import eu.europa.esig.dss.enumerations.TimestampLocation;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.enumerations.TimestampedObjectType;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.x509.EncapsulatedCertificateTokenIdentifier;
import eu.europa.esig.dss.spi.DSSRevocationUtils;
import eu.europa.esig.dss.spi.x509.CertificatePool;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPResponseBinary;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.ReferenceValidation;
import eu.europa.esig.dss.validation.SignatureProperties;
import eu.europa.esig.dss.validation.scope.SignatureScope;
import eu.europa.esig.dss.validation.timestamp.AbstractTimestampSource;
import eu.europa.esig.dss.validation.timestamp.TimestampInclude;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import eu.europa.esig.dss.validation.timestamp.TimestampedReference;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.XPathQueryHolder;
import eu.europa.esig.dss.xades.validation.XAdESAttribute;
import eu.europa.esig.dss.xades.validation.XAdESSignature;
import eu.europa.esig.dss.xades.validation.XAdESSignedDataObjectProperties;
import eu.europa.esig.dss.xades.validation.XAdESTimestampDataBuilder;
import eu.europa.esig.dss.xades.validation.XAdESUnsignedSigProperties;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.xml.security.signature.Reference;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XAdESTimestampSource
extends AbstractTimestampSource<XAdESAttribute> {
    private static final Logger LOG = LoggerFactory.getLogger(XAdESTimestampSource.class);
    private final transient Element signatureElement;
    private final XPathQueryHolder xPathQueryHolder;
    private transient List<Reference> references;
    private List<ReferenceValidation> referenceValidations;
    private transient XAdESTimestampDataBuilder timestampDataBuilder;

    public XAdESTimestampSource(XAdESSignature signature, Element signatureElement, XPathQueryHolder xPathQueryHolder, CertificatePool certificatePool) {
        super((AdvancedSignature)signature);
        this.references = signature.getReferences();
        this.referenceValidations = signature.getReferenceValidations();
        this.signatureElement = signatureElement;
        this.xPathQueryHolder = xPathQueryHolder;
        this.certificatePool = certificatePool;
    }

    protected SignatureProperties<XAdESAttribute> getSignedSignatureProperties() {
        return XAdESSignedDataObjectProperties.build(this.signatureElement, this.xPathQueryHolder);
    }

    protected SignatureProperties<XAdESAttribute> getUnsignedSignatureProperties() {
        return XAdESUnsignedSigProperties.build(this.signatureElement, this.xPathQueryHolder);
    }

    protected XAdESTimestampDataBuilder getTimestampDataBuilder() {
        if (this.timestampDataBuilder == null) {
            this.timestampDataBuilder = new XAdESTimestampDataBuilder(this.signatureElement, this.references, this.xPathQueryHolder);
        }
        return this.timestampDataBuilder;
    }

    public byte[] getSignatureTimestampData(String canonicalizationMethod) {
        return this.timestampDataBuilder.getSignatureTimestampData(canonicalizationMethod);
    }

    public byte[] getTimestampX1Data(String canonicalizationMethod) {
        return this.timestampDataBuilder.getTimestampX1Data(canonicalizationMethod);
    }

    public byte[] getTimestampX2Data(String canonicalizationMethod) {
        return this.timestampDataBuilder.getTimestampX2Data(canonicalizationMethod);
    }

    public byte[] getArchiveTimestampData(String canonicalizationMethod) {
        return this.timestampDataBuilder.getArchiveTimestampData(canonicalizationMethod);
    }

    protected boolean isContentTimestamp(XAdESAttribute signedAttribute) {
        return false;
    }

    protected boolean isAllDataObjectsTimestamp(XAdESAttribute signedAttribute) {
        return "AllDataObjectsTimeStamp".equals(signedAttribute.getName());
    }

    protected boolean isIndividualDataObjectsTimestamp(XAdESAttribute signedAttribute) {
        return "IndividualDataObjectsTimeStamp".equals(signedAttribute.getName());
    }

    protected boolean isSignatureTimestamp(XAdESAttribute unsignedAttribute) {
        return "SignatureTimeStamp".equals(unsignedAttribute.getName());
    }

    protected boolean isCompleteCertificateRef(XAdESAttribute unsignedAttribute) {
        String localName = unsignedAttribute.getName();
        return "CompleteCertificateRefs".equals(localName) || "CompleteCertificateRefsV2".equals(localName);
    }

    protected boolean isAttributeCertificateRef(XAdESAttribute unsignedAttribute) {
        String localName = unsignedAttribute.getName();
        return "AttributeCertificateRefs".equals(localName) || "AttributeCertificateRefsV2".equals(localName);
    }

    protected boolean isCompleteRevocationRef(XAdESAttribute unsignedAttribute) {
        return "CompleteRevocationRefs".equals(unsignedAttribute.getName());
    }

    protected boolean isAttributeRevocationRef(XAdESAttribute unsignedAttribute) {
        return "AttributeRevocationRefs".equals(unsignedAttribute.getName());
    }

    protected boolean isRefsOnlyTimestamp(XAdESAttribute unsignedAttribute) {
        String localName = unsignedAttribute.getName();
        return "RefsOnlyTimeStamp".equals(localName) || "RefsOnlyTimeStampV2".equals(localName);
    }

    protected boolean isSigAndRefsTimestamp(XAdESAttribute unsignedAttribute) {
        String localName = unsignedAttribute.getName();
        return "SigAndRefsTimeStamp".equals(localName) || "SigAndRefsTimeStampV2".equals(localName);
    }

    protected boolean isCertificateValues(XAdESAttribute unsignedAttribute) {
        return "CertificateValues".equals(unsignedAttribute.getName());
    }

    protected boolean isRevocationValues(XAdESAttribute unsignedAttribute) {
        return "RevocationValues".equals(unsignedAttribute.getName());
    }

    protected boolean isArchiveTimestamp(XAdESAttribute unsignedAttribute) {
        return "ArchiveTimeStamp".equals(unsignedAttribute.getName());
    }

    protected boolean isTimeStampValidationData(XAdESAttribute unsignedAttribute) {
        return "TimeStampValidationData".equals(unsignedAttribute.getName());
    }

    protected TimestampToken makeTimestampToken(XAdESAttribute unsignedAttribute, TimestampType timestampType, List<TimestampedReference> references) {
        Element timestampTokenNode = unsignedAttribute.findElement(this.xPathQueryHolder.XPATH__ENCAPSULATED_TIMESTAMP);
        if (timestampTokenNode == null) {
            LOG.warn("The timestamp {} cannot be extracted from the signature!", (Object)timestampType.name());
            return null;
        }
        TimestampToken timestampToken = null;
        try {
            timestampToken = new TimestampToken(Utils.fromBase64((String)timestampTokenNode.getTextContent()), timestampType, this.certificatePool, references, TimestampLocation.XAdES);
        }
        catch (Exception e) {
            LOG.warn("Unable to build timestamp object '" + timestampTokenNode.getTextContent() + "' : ", (Throwable)e);
            return null;
        }
        timestampToken.setHashCode(unsignedAttribute.getElementHashCode());
        timestampToken.setCanonicalizationMethod(unsignedAttribute.getTimestampCanonicalizationMethod());
        timestampToken.setTimestampIncludes(unsignedAttribute.getTimestampIncludedReferences());
        return timestampToken;
    }

    protected List<TimestampedReference> getIndividualContentTimestampedReferences(XAdESAttribute signedAttribute) {
        List<TimestampInclude> includes = signedAttribute.getTimestampIncludedReferences();
        ArrayList<TimestampedReference> timestampReferences = new ArrayList<TimestampedReference>();
        for (Reference reference : this.references) {
            if (!this.isContentTimestampedReference(reference, includes)) continue;
            for (SignatureScope signatureScope : this.signatureScopes) {
                if (!Utils.endsWithIgnoreCase((String)reference.getURI(), (String)signatureScope.getName())) continue;
                timestampReferences.add(new TimestampedReference(signatureScope.getDSSIdAsString(), TimestampedObjectType.SIGNED_DATA));
            }
        }
        return timestampReferences;
    }

    private boolean isContentTimestampedReference(Reference reference, List<TimestampInclude> includes) {
        for (TimestampInclude timestampInclude : includes) {
            if (!reference.getId().equals(timestampInclude.getURI())) continue;
            return true;
        }
        return false;
    }

    protected List<TimestampedReference> getSignatureTimestampReferences() {
        List timestampedReferences = super.getSignatureTimestampReferences();
        if (this.isKeyInfoCovered()) {
            this.addReferences(timestampedReferences, this.createReferencesForCertificates(this.signatureCertificateSource.getKeyInfoCertificates()));
        }
        return timestampedReferences;
    }

    private boolean isKeyInfoCovered() {
        if (Utils.isCollectionNotEmpty(this.referenceValidations)) {
            for (ReferenceValidation referenceValidation : this.referenceValidations) {
                if (!DigestMatcherType.KEY_INFO.equals((Object)referenceValidation.getType()) || !referenceValidation.isFound() || !referenceValidation.isIntact()) continue;
                return true;
            }
        }
        return false;
    }

    protected List<Digest> getCertificateRefDigests(XAdESAttribute unsignedAttribute) {
        ArrayList<Digest> digests = new ArrayList<Digest>();
        NodeList nodeList = unsignedAttribute.getNodeList(this.xPathQueryHolder.XPATH__CERTIFICATE_REFS);
        for (int ii = 0; ii < nodeList.getLength(); ++ii) {
            Element certElement = (Element)nodeList.item(ii);
            Digest certDigest = DSSXMLUtils.getCertDigest(certElement, this.xPathQueryHolder);
            if (certDigest == null) continue;
            digests.add(certDigest);
        }
        return digests;
    }

    protected List<Digest> getRevocationRefCRLDigests(XAdESAttribute unsignedAttribute) {
        ArrayList<Digest> crlRefDigests = new ArrayList<Digest>();
        NodeList crlRefs = unsignedAttribute.getNodeList(this.xPathQueryHolder.XPATH__CRLREFS);
        for (int ii = 0; ii < crlRefs.getLength(); ++ii) {
            Element crlRef = (Element)crlRefs.item(ii);
            Digest digest = DSSXMLUtils.getRevocationDigest(crlRef, this.xPathQueryHolder);
            if (digest == null) continue;
            crlRefDigests.add(digest);
        }
        return crlRefDigests;
    }

    protected List<Digest> getRevocationRefOCSPDigests(XAdESAttribute unsignedAttribute) {
        ArrayList<Digest> ocspRefDigests = new ArrayList<Digest>();
        NodeList ocspRefs = unsignedAttribute.getNodeList(this.xPathQueryHolder.XPATH__OCSPREFS);
        for (int ii = 0; ii < ocspRefs.getLength(); ++ii) {
            Element ocspRef = (Element)ocspRefs.item(ii);
            Digest digest = DSSXMLUtils.getRevocationDigest(ocspRef, this.xPathQueryHolder);
            if (digest == null) continue;
            ocspRefDigests.add(digest);
        }
        return ocspRefDigests;
    }

    protected List<EncapsulatedCertificateTokenIdentifier> getEncapsulatedCertificateIdentifiers(XAdESAttribute unsignedAttribute) {
        ArrayList<EncapsulatedCertificateTokenIdentifier> certificateIdentifiers = new ArrayList<EncapsulatedCertificateTokenIdentifier>();
        String xPathString = this.isTimeStampValidationData(unsignedAttribute) ? this.xPathQueryHolder.XPATH__ENCAPSULATED_X509_CERT : this.xPathQueryHolder.XPATH___ENCAPSULATED_X509_CERT;
        NodeList encapsulatedNodes = unsignedAttribute.getNodeList(xPathString);
        for (int ii = 0; ii < encapsulatedNodes.getLength(); ++ii) {
            Element element = (Element)encapsulatedNodes.item(ii);
            byte[] binaries = this.getEncapsulatedTokenBinaries(element);
            EncapsulatedCertificateTokenIdentifier tokenIdentifier = new EncapsulatedCertificateTokenIdentifier(binaries);
            certificateIdentifiers.add(tokenIdentifier);
        }
        return certificateIdentifiers;
    }

    protected List<CRLBinary> getEncapsulatedCRLIdentifiers(XAdESAttribute unsignedAttribute) {
        ArrayList<CRLBinary> crlIdentifiers = new ArrayList<CRLBinary>();
        String xPathString = this.isTimeStampValidationData(unsignedAttribute) ? this.xPathQueryHolder.XPATH__ENCAPSULATED_CRL_VALUES : this.xPathQueryHolder.XPATH___ENCAPSULATED_CRL_VALUES;
        NodeList encapsulatedNodes = unsignedAttribute.getNodeList(xPathString);
        for (int ii = 0; ii < encapsulatedNodes.getLength(); ++ii) {
            Element element = (Element)encapsulatedNodes.item(ii);
            byte[] binaries = this.getEncapsulatedTokenBinaries(element);
            crlIdentifiers.add(new CRLBinary(binaries));
        }
        return crlIdentifiers;
    }

    protected List<OCSPResponseBinary> getEncapsulatedOCSPIdentifiers(XAdESAttribute unsignedAttribute) {
        ArrayList<OCSPResponseBinary> crlIdentifiers = new ArrayList<OCSPResponseBinary>();
        String xPathString = this.isTimeStampValidationData(unsignedAttribute) ? this.xPathQueryHolder.XPATH__ENCAPSULATED_OCSP_VALUES : this.xPathQueryHolder.XPATH___ENCAPSULATED_OCSP_VALUES;
        NodeList encapsulatedNodes = unsignedAttribute.getNodeList(xPathString);
        for (int ii = 0; ii < encapsulatedNodes.getLength(); ++ii) {
            Element element = (Element)encapsulatedNodes.item(ii);
            byte[] binaries = this.getEncapsulatedTokenBinaries(element);
            try {
                BasicOCSPResp basicOCSPResp = DSSRevocationUtils.loadOCSPFromBinaries((byte[])binaries);
                crlIdentifiers.add(OCSPResponseBinary.build((BasicOCSPResp)basicOCSPResp));
                continue;
            }
            catch (IOException e) {
                LOG.error("Cannot read encapsulated OCSP response. Reason: {}", (Object)e.getMessage());
            }
        }
        return crlIdentifiers;
    }

    private byte[] getEncapsulatedTokenBinaries(Element encapsulatedElement) {
        String base64String;
        Node firstChild;
        if (encapsulatedElement.hasChildNodes() && 3 == (firstChild = encapsulatedElement.getFirstChild()).getNodeType() && Utils.isBase64Encoded((String)(base64String = firstChild.getTextContent()))) {
            return Utils.fromBase64((String)base64String);
        }
        throw new DSSException(String.format("Cannot create the token reference. The element with local name [%s] must contain an encapsulated base64 token value!", encapsulatedElement.getLocalName()));
    }

    protected ArchiveTimestampType getArchiveTimestampType(XAdESAttribute unsignedAttribute) {
        if ("http://uri.etsi.org/01903/v1.4.1#".equals(unsignedAttribute.getNamespace())) {
            return ArchiveTimestampType.XAdES_141;
        }
        return ArchiveTimestampType.XAdES;
    }
}

