/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.filters;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.dizitart.no2.Document;
import org.dizitart.no2.Filter;
import org.dizitart.no2.NitriteId;
import org.dizitart.no2.exceptions.ErrorMessage;
import org.dizitart.no2.exceptions.FilterException;
import org.dizitart.no2.filters.BaseFilter;
import org.dizitart.no2.store.NitriteMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OrFilter
extends BaseFilter {
    private static final Logger log = LoggerFactory.getLogger(OrFilter.class);
    private Filter[] filters;

    OrFilter(Filter ... filters) {
        this.filters = filters;
    }

    @Override
    public Set<NitriteId> apply(NitriteMap<NitriteId, Document> documentMap) {
        LinkedHashSet<NitriteId> result = new LinkedHashSet<NitriteId>();
        ExecutorService executorService = this.nitriteService.getNitriteContext().getWorkerPool();
        try {
            List<Callable<Set<NitriteId>>> tasks = this.createTasks(this.filters, documentMap);
            List<Future<Set<NitriteId>>> futures = executorService.invokeAll(tasks);
            for (Future<Set<NitriteId>> future : futures) {
                Set<NitriteId> nitriteIds = future.get();
                if (nitriteIds == null) continue;
                result.addAll(nitriteIds);
            }
        }
        catch (FilterException fe) {
            throw fe;
        }
        catch (Throwable t) {
            throw new FilterException(ErrorMessage.INVALID_OR_FILTER, t);
        }
        return result;
    }

    public Filter[] getFilters() {
        return this.filters;
    }

    public String toString() {
        return "OrFilter(filters=" + Arrays.deepToString(this.getFilters()) + ")";
    }
}

