/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.tool;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.dizitart.no2.Nitrite;
import org.dizitart.no2.exceptions.ErrorMessage;
import org.dizitart.no2.exceptions.NitriteIOException;
import org.dizitart.no2.mapper.JacksonFacade;
import org.dizitart.no2.tool.ExportOptions;
import org.dizitart.no2.tool.NitriteJsonExporter;

public class Exporter {
    private Nitrite db;
    private JsonFactory jsonFactory;
    private ExportOptions options;

    private Exporter() {
    }

    public static Exporter of(Nitrite db) {
        Exporter exporter = new Exporter();
        exporter.db = db;
        ObjectMapper objectMapper = new JacksonFacade().getObjectMapper();
        exporter.jsonFactory = objectMapper.getFactory();
        exporter.options = new ExportOptions();
        return exporter;
    }

    public Exporter withOptions(ExportOptions options) {
        this.options = options;
        return this;
    }

    public void exportTo(String file) {
        this.exportTo(new File(file));
    }

    public void exportTo(File file) {
        try {
            boolean result;
            if (file.isDirectory()) {
                throw new IOException(file.getPath() + " is not a file");
            }
            File parent = file.getParentFile();
            if (!parent.exists() && !(result = parent.mkdirs())) {
                throw new IOException("Failed to create parent directory " + parent.getPath());
            }
            this.exportTo(new FileOutputStream(file));
        }
        catch (IOException ioe) {
            throw new NitriteIOException(ErrorMessage.errorMessage("I/O error while writing content to file " + file, 2009), (Throwable)ioe);
        }
    }

    public void exportTo(OutputStream stream) {
        this.exportTo(new OutputStreamWriter(stream));
    }

    public void exportTo(Writer writer) {
        JsonGenerator generator;
        try {
            generator = this.jsonFactory.createGenerator(writer);
            generator.setPrettyPrinter((PrettyPrinter)new DefaultPrettyPrinter());
        }
        catch (IOException ioe) {
            throw new NitriteIOException(ErrorMessage.EXPORT_WRITER_ERROR, (Throwable)ioe);
        }
        NitriteJsonExporter jsonExporter = new NitriteJsonExporter(this.db);
        jsonExporter.setGenerator(generator);
        jsonExporter.setOptions(this.options);
        try {
            jsonExporter.exportData();
        }
        catch (IOException | ClassNotFoundException e) {
            throw new NitriteIOException(ErrorMessage.EXPORT_WRITE_ERROR, (Throwable)e);
        }
    }
}

