/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.tool;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.dizitart.no2.Nitrite;
import org.dizitart.no2.exceptions.ErrorMessage;
import org.dizitart.no2.exceptions.NitriteIOException;
import org.dizitart.no2.mapper.JacksonFacade;
import org.dizitart.no2.tool.NitriteJsonImporter;

public class Importer {
    private Nitrite db;
    private JsonFactory jsonFactory;

    private Importer() {
    }

    public static Importer of(Nitrite db) {
        Importer importer = new Importer();
        importer.db = db;
        ObjectMapper objectMapper = new JacksonFacade().getObjectMapper();
        importer.jsonFactory = objectMapper.getFactory();
        return importer;
    }

    public void importFrom(String file) {
        this.importFrom(new File(file));
    }

    public void importFrom(File file) {
        try (FileInputStream stream = new FileInputStream(file);){
            this.importFrom(stream);
        }
        catch (IOException ioe) {
            throw new NitriteIOException(ErrorMessage.errorMessage("I/O error while reading content from file " + file, 2006), (Throwable)ioe);
        }
    }

    public void importFrom(InputStream stream) {
        this.importFrom(new InputStreamReader(stream));
    }

    public void importFrom(Reader reader) {
        JsonParser parser;
        try {
            parser = this.jsonFactory.createParser(reader);
        }
        catch (IOException ioe) {
            throw new NitriteIOException(ErrorMessage.IMPORT_READER_ERROR, (Throwable)ioe);
        }
        if (parser != null) {
            NitriteJsonImporter jsonImporter = new NitriteJsonImporter(this.db);
            jsonImporter.setParser(parser);
            try {
                jsonImporter.importData();
            }
            catch (IOException | ClassNotFoundException e) {
                throw new NitriteIOException(ErrorMessage.IMPORT_READ_ERROR, (Throwable)e);
            }
        }
    }
}

