/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.in.xhtml;

import com.openhtmltopdf.css.constants.CSSName;
import com.openhtmltopdf.css.constants.IdentValue;
import com.openhtmltopdf.css.parser.PropertyValue;
import com.openhtmltopdf.css.style.FSDerivedValue;
import com.openhtmltopdf.css.style.derived.LengthValue;
import com.openhtmltopdf.layout.Styleable;
import com.openhtmltopdf.render.BlockBox;
import java.math.BigInteger;
import java.util.LinkedList;
import java.util.Map;
import org.docx4j.convert.in.xhtml.DomCssValueAdaptor;
import org.docx4j.convert.in.xhtml.XHTMLImporterImpl;
import org.docx4j.jaxb.Context;
import org.docx4j.model.listnumbering.ListNumberingDefinition;
import org.docx4j.model.properties.paragraph.Indent;
import org.docx4j.openpackaging.parts.WordprocessingML.NumberingDefinitionsPart;
import org.docx4j.wml.Jc;
import org.docx4j.wml.JcEnumeration;
import org.docx4j.wml.Lvl;
import org.docx4j.wml.NumFmt;
import org.docx4j.wml.NumberFormat;
import org.docx4j.wml.Numbering;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.P;
import org.docx4j.wml.PPr;
import org.docx4j.wml.PPrBase;
import org.docx4j.wml.RFonts;
import org.docx4j.wml.RPr;
import org.docx4j.wml.STHint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSPrimitiveValue;

public class ListHelper {
    public static Logger log = LoggerFactory.getLogger(ListHelper.class);
    protected static final int INDENT_AFTER = 360;
    private XHTMLImporterImpl importer;
    private ObjectFactory wmlObjectFactory = Context.getWmlObjectFactory();
    private NumberingDefinitionsPart ndp;
    private LinkedList<BlockBox> listStack = new LinkedList();
    private Numbering.AbstractNum abstractList;
    private LinkedList<ListItemContentState> listItemStateStack = new LinkedList();

    public ListHelper(XHTMLImporterImpl importer, NumberingDefinitionsPart ndp) {
        this.importer = importer;
        this.ndp = ndp;
    }

    private Numbering.Num getConcreteList() {
        return this.listItemStateStack.peek().concreteList;
    }

    protected void pushListStack(BlockBox ca) {
        this.listStack.push(ca);
        this.pushListItemStateStack();
    }

    protected BlockBox popListStack() {
        BlockBox box = this.listStack.pop();
        if (this.listStack.size() == 0) {
            log.debug("outside list");
        }
        this.listItemStateStack.pop();
        return box;
    }

    protected BlockBox peekListStack() {
        return this.listStack.peek();
    }

    protected int getDepth() {
        return this.listStack.size();
    }

    protected ListItemContentState peekListItemStateStack() {
        return this.listItemStateStack.peek();
    }

    private void pushListItemStateStack() {
        Numbering.Num currentConcreteList = null;
        if (this.peekListItemStateStack() != null) {
            currentConcreteList = this.peekListItemStateStack().concreteList;
        }
        this.listItemStateStack.push(new ListItemContentState());
        this.peekListItemStateStack().concreteList = currentConcreteList;
    }

    protected Numbering.AbstractNum createNewAbstractList() {
        Numbering.AbstractNum numberingabstractnum = Context.getWmlObjectFactory().createNumberingAbstractNum();
        numberingabstractnum.setAbstractNumId(BigInteger.valueOf(0L));
        Numbering.AbstractNum.MultiLevelType numberingabstractnummultileveltype = Context.getWmlObjectFactory().createNumberingAbstractNumMultiLevelType();
        numberingabstractnum.setMultiLevelType(numberingabstractnummultileveltype);
        numberingabstractnummultileveltype.setVal("multilevel");
        return numberingabstractnum;
    }

    private Lvl getLevel(Numbering.AbstractNum theList, int level) {
        if (level > 8) {
            level = 8;
        }
        for (Lvl lvl : theList.getLvl()) {
            if (lvl.getIlvl().intValue() != level) continue;
            return lvl;
        }
        return null;
    }

    private NumberFormat getNumberFormatFromCSSListStyleType(String listStyleType) {
        if (listStyleType.equals("disc") || listStyleType.equals("circle") || listStyleType.equals("square")) {
            return NumberFormat.BULLET;
        }
        if (listStyleType.equals("decimal")) {
            return NumberFormat.DECIMAL;
        }
        if (listStyleType.equals("decimal-leading-zero")) {
            return NumberFormat.DECIMAL_ZERO;
        }
        if (listStyleType.equals("lower-roman")) {
            return NumberFormat.LOWER_ROMAN;
        }
        if (listStyleType.equals("upper-roman")) {
            return NumberFormat.UPPER_ROMAN;
        }
        if (listStyleType.equals("lower-greek")) {
            return NumberFormat.DECIMAL;
        }
        if (listStyleType.equals("lower-latin")) {
            return NumberFormat.LOWER_LETTER;
        }
        if (listStyleType.equals("upper-latin")) {
            return NumberFormat.UPPER_LETTER;
        }
        if (listStyleType.equals("armenian")) {
            return NumberFormat.DECIMAL;
        }
        if (listStyleType.equals("georgian")) {
            return NumberFormat.DECIMAL;
        }
        if (listStyleType.equals("lower-alpha")) {
            return NumberFormat.LOWER_LETTER;
        }
        if (listStyleType.equals("upper-alpha")) {
            return NumberFormat.UPPER_LETTER;
        }
        if (listStyleType.equals("none")) {
            return NumberFormat.NONE;
        }
        if (listStyleType.equals("inherit")) {
            return NumberFormat.DECIMAL;
        }
        return NumberFormat.DECIMAL;
    }

    private String getLvlTextFromCSSListStyleType(String listStyleType, int level) {
        if (listStyleType.equals("disc")) {
            return "\uf0b7";
        }
        if (listStyleType.equals("circle")) {
            return "o";
        }
        if (listStyleType.equals("square")) {
            return "\uf0a7";
        }
        return "%" + level + ".";
    }

    private RFonts geRFontsForCSSListStyleType(String listStyleType) {
        RFonts rfonts = null;
        if (listStyleType.equals("disc")) {
            rfonts = this.wmlObjectFactory.createRFonts();
            rfonts.setAscii("Symbol");
            rfonts.setHint(STHint.DEFAULT);
            rfonts.setHAnsi("Symbol");
        }
        if (listStyleType.equals("circle")) {
            rfonts = this.wmlObjectFactory.createRFonts();
            rfonts.setAscii("Courier New");
            rfonts.setHint(STHint.DEFAULT);
            rfonts.setHAnsi("Courier New");
            rfonts.setCs("Courier New");
        }
        if (listStyleType.equals("square")) {
            rfonts = this.wmlObjectFactory.createRFonts();
            rfonts.setAscii("Wingdings");
            rfonts.setHint(STHint.DEFAULT);
            rfonts.setHAnsi("Wingdings");
        }
        return rfonts;
    }

    protected PPrBase.Ind createIndent(int twip, boolean hanging) {
        if (twip < 40) {
            twip = 40;
        }
        PPrBase.Ind ind = Context.getWmlObjectFactory().createPPrBaseInd();
        if (hanging) {
            ind.setLeft(BigInteger.valueOf(twip + 360));
            ind.setHanging(BigInteger.valueOf(360L));
        } else {
            ind.setLeft(BigInteger.valueOf(twip));
        }
        return ind;
    }

    protected int getSelfAndAncestorIndentation() {
        int totalPadding = 0;
        for (BlockBox bb : this.listStack) {
            LengthValue padding = (LengthValue)bb.getStyle().valueByName(CSSName.PADDING_LEFT);
            PropertyValue val = new PropertyValue(XHTMLImporterImpl.getLengthPrimitiveType((FSDerivedValue)padding), padding.asFloat(), padding.asString());
            totalPadding += Indent.getTwip((CSSPrimitiveValue)new DomCssValueAdaptor(val));
            FSDerivedValue marginObj = bb.getStyle().valueByName(CSSName.MARGIN_LEFT);
            if (marginObj instanceof LengthValue) {
                LengthValue margin = (LengthValue)marginObj;
                val = new PropertyValue(XHTMLImporterImpl.getLengthPrimitiveType((FSDerivedValue)margin), margin.asFloat(), margin.asString());
                totalPadding += Indent.getTwip((CSSPrimitiveValue)new DomCssValueAdaptor(val));
                continue;
            }
            if (!(marginObj instanceof IdentValue)) continue;
            log.debug("Ignoring MARGIN_LEFT " + ((IdentValue)marginObj).asString());
        }
        return totalPadding;
    }

    protected int getAbsoluteIndent(Styleable styleable) {
        if (styleable == this.peekListStack()) {
            return this.getSelfAndAncestorIndentation();
        }
        int totalPadding = 0;
        LengthValue padding = (LengthValue)styleable.getStyle().valueByName(CSSName.PADDING_LEFT);
        PropertyValue val = new PropertyValue(XHTMLImporterImpl.getLengthPrimitiveType((FSDerivedValue)padding), padding.asFloat(), padding.asString());
        totalPadding += Indent.getTwip((CSSPrimitiveValue)new DomCssValueAdaptor(val));
        FSDerivedValue marginObj = styleable.getStyle().valueByName(CSSName.MARGIN_LEFT);
        if (marginObj instanceof LengthValue) {
            LengthValue margin = (LengthValue)marginObj;
            val = new PropertyValue(XHTMLImporterImpl.getLengthPrimitiveType((FSDerivedValue)margin), margin.asFloat(), margin.asString());
            totalPadding += Indent.getTwip((CSSPrimitiveValue)new DomCssValueAdaptor(val));
        } else if (marginObj instanceof IdentValue) {
            log.debug("Ignoring MARGIN_LEFT " + ((IdentValue)marginObj).asString());
        }
        return totalPadding += this.getSelfAndAncestorIndentation();
    }

    private Lvl createLevel(int level, Map<String, PropertyValue> cssMap) {
        if (level > 8) {
            level = 8;
        }
        Lvl lvl = this.wmlObjectFactory.createLvl();
        lvl.setIlvl(BigInteger.valueOf(level));
        PPr ppr = this.wmlObjectFactory.createPPr();
        lvl.setPPr(ppr);
        ppr.setInd(this.createIndent(this.getSelfAndAncestorIndentation(), true));
        NumFmt numfmt = this.wmlObjectFactory.createNumFmt();
        lvl.setNumFmt(numfmt);
        numfmt.setVal(this.getNumberFormatFromCSSListStyleType(cssMap.get("list-style-type").getCssText()));
        Lvl.LvlText lvllvltext = this.wmlObjectFactory.createLvlLvlText();
        lvl.setLvlText(lvllvltext);
        lvllvltext.setVal(this.getLvlTextFromCSSListStyleType(cssMap.get("list-style-type").getCssText(), level + 1));
        RFonts rfonts = this.geRFontsForCSSListStyleType(cssMap.get("list-style-type").getCssText());
        if (rfonts != null) {
            RPr rpr = this.wmlObjectFactory.createRPr();
            rpr.setRFonts(rfonts);
            lvl.setRPr(rpr);
        }
        Jc jc = this.wmlObjectFactory.createJc();
        lvl.setLvlJc(jc);
        jc.setVal(JcEnumeration.LEFT);
        Lvl.Start lvlstart = this.wmlObjectFactory.createLvlStart();
        lvl.setStart(lvlstart);
        BlockBox list = this.listStack.peek();
        Element listEl = list.getElement();
        BigInteger startVal = null;
        if (listEl.hasAttribute("start")) {
            try {
                startVal = BigInteger.valueOf(Long.parseLong(listEl.getAttribute("start")));
            }
            catch (NumberFormatException nfe) {
                log.warn("Can't parse number from @start=" + listEl.getAttribute("start"));
            }
        }
        if (startVal == null) {
            lvlstart.setVal(BigInteger.valueOf(1L));
        } else {
            lvlstart.setVal(startVal);
        }
        return lvl;
    }

    private Numbering.Num.LvlOverride findOverride(int lvl) {
        for (Numbering.Num.LvlOverride lo : this.getConcreteList().getLvlOverride()) {
            if (lo.getIlvl().intValue() != lvl) continue;
            return lo;
        }
        return null;
    }

    void addNumbering(P p, Element e, Map<String, PropertyValue> cssMap) {
        Lvl lvl;
        log.debug("add");
        if (this.getConcreteList() == null) {
            this.abstractList = this.createNewAbstractList();
            this.listItemStateStack.peek().concreteList = this.ndp.addAbstractListNumberingDefinition(this.abstractList);
            log.debug("Using abstractList " + this.abstractList.getAbstractNumId().intValue());
        }
        if ((lvl = this.getLevel(this.abstractList, this.listStack.size() - 1)) == null) {
            int level = this.listStack.size() - 1;
            this.ndp.addAbstractListNumberingDefinitionLevel(this.abstractList, this.createLevel(level, cssMap));
            this.peekListItemStateStack().isFirstItem = false;
        } else {
            Lvl overrideLvlTmp;
            log.debug("Numbering definition exists for this level " + lvl.getIlvl().intValue() + " in abstractList " + this.abstractList.getAbstractNumId().intValue());
            NumFmt numfmtExisting = null;
            Numbering.Num.LvlOverride lo = this.findOverride(this.listStack.size() - 1);
            if (lo != null && (overrideLvlTmp = lo.getLvl()).getNumFmt() != null) {
                numfmtExisting = overrideLvlTmp.getNumFmt();
            }
            if (numfmtExisting == null) {
                numfmtExisting = lvl.getNumFmt();
            }
            NumberFormat specified = this.getNumberFormatFromCSSListStyleType(cssMap.get("list-style-type").getCssText());
            if (this.peekListItemStateStack().isFirstItem || numfmtExisting == null || numfmtExisting.getVal() != specified) {
                if (log.isDebugEnabled()) {
                    if (numfmtExisting == null) {
                        log.debug(".. but it doesn't override formatting");
                    } else if (numfmtExisting.getVal() != specified) {
                        log.debug(".. but it is different: " + specified.value() + " vs " + numfmtExisting.getVal().value());
                    }
                    if (this.peekListItemStateStack().isFirstItem) {
                        log.debug(".. but it is a new HTML list");
                    }
                }
                this.peekListItemStateStack().isFirstItem = false;
                int ilvl = lvl.getIlvl().intValue();
                log.debug("concrete list points at abstract " + this.getConcreteList().getAbstractNumId().getVal().longValue());
                long newNumId = this.ndp.restart(this.getConcreteList().getNumId().longValue(), (long)ilvl, 1L);
                ListNumberingDefinition listDef = (ListNumberingDefinition)this.ndp.getInstanceListDefinitions().get("" + newNumId);
                this.listItemStateStack.peek().concreteList = listDef.getNumNode();
                log.debug("new concrete list " + this.getConcreteList().getNumId().intValue() + ", pointing at " + this.getConcreteList().getAbstractNumId().getVal().longValue());
                Lvl overrideLvl = this.wmlObjectFactory.createLvl();
                overrideLvl.setIlvl(BigInteger.valueOf(ilvl));
                PPr ppr = this.wmlObjectFactory.createPPr();
                overrideLvl.setPPr(ppr);
                ppr.setInd(this.createIndent(this.getSelfAndAncestorIndentation(), true));
                NumFmt numfmt = this.wmlObjectFactory.createNumFmt();
                overrideLvl.setNumFmt(numfmt);
                numfmt.setVal(this.getNumberFormatFromCSSListStyleType(cssMap.get("list-style-type").getCssText()));
                Lvl.LvlText lvllvltext = this.wmlObjectFactory.createLvlLvlText();
                overrideLvl.setLvlText(lvllvltext);
                lvllvltext.setVal(this.getLvlTextFromCSSListStyleType(cssMap.get("list-style-type").getCssText(), ilvl + 1));
                RFonts rfonts = this.geRFontsForCSSListStyleType(cssMap.get("list-style-type").getCssText());
                if (rfonts != null) {
                    RPr rpr = this.wmlObjectFactory.createRPr();
                    rpr.setRFonts(rfonts);
                    overrideLvl.setRPr(rpr);
                }
                ((Numbering.Num.LvlOverride)listDef.getNumNode().getLvlOverride().get(0)).setLvl(overrideLvl);
            } else {
                log.debug(".. using pre-existing definition ");
            }
        }
        this.setNumbering(p.getPPr(), this.getConcreteList().getNumId());
    }

    protected void setNumbering(PPr pPr, BigInteger numId) {
        PPrBase.NumPr numPr = Context.getWmlObjectFactory().createPPrBaseNumPr();
        pPr.setNumPr(numPr);
        PPrBase.NumPr.NumId numIdElement = Context.getWmlObjectFactory().createPPrBaseNumPrNumId();
        numPr.setNumId(numIdElement);
        numIdElement.setVal(numId);
        PPrBase.NumPr.Ilvl ilvlElement = Context.getWmlObjectFactory().createPPrBaseNumPrIlvl();
        numPr.setIlvl(ilvlElement);
        ilvlElement.setVal(BigInteger.valueOf(this.listStack.size() - 1));
    }

    class ListItemContentState {
        private Numbering.Num concreteList;
        protected boolean isFirstChild = true;
        protected boolean haveMergedFirstP = false;
        protected boolean isFirstItem = true;

        ListItemContentState() {
        }

        void init() {
            this.isFirstChild = true;
            this.haveMergedFirstP = false;
        }
    }
}

