/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.fonts.fop.fonts.base14;

import java.awt.Rectangle;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.docx4j.fonts.fop.fonts.Base14Font;
import org.docx4j.fonts.fop.fonts.CodePointMapping;
import org.docx4j.fonts.fop.fonts.FontType;

public class Helvetica
extends Base14Font {
    private static final URI fontFileURI;
    private static final String fontName = "Helvetica";
    private static final String fullName = "Helvetica";
    private static final Set familyNames;
    private static final int underlinePosition = -100;
    private static final int underlineThickness = 50;
    private static final String encoding = "WinAnsiEncoding";
    private static final int capHeight = 718;
    private static final int xHeight = 523;
    private static final int ascender = 718;
    private static final int descender = -207;
    private static final int firstChar = 32;
    private static final int lastChar = 255;
    private static final int[] width;
    private static final Rectangle[] boundingBoxes;
    private final CodePointMapping mapping = CodePointMapping.getMapping("WinAnsiEncoding");
    private static final Map kerning;
    private boolean enableKerning;

    public Helvetica() {
        this(false);
    }

    public Helvetica(boolean enableKerning) {
        this.enableKerning = enableKerning;
    }

    @Override
    public String getEncodingName() {
        return encoding;
    }

    @Override
    public URI getFontURI() {
        return fontFileURI;
    }

    @Override
    public String getFontName() {
        return "Helvetica";
    }

    @Override
    public String getEmbedFontName() {
        return this.getFontName();
    }

    @Override
    public String getFullName() {
        return "Helvetica";
    }

    public Set getFamilyNames() {
        return familyNames;
    }

    @Override
    public FontType getFontType() {
        return FontType.TYPE1;
    }

    @Override
    public int getAscender(int size) {
        return size * 718;
    }

    @Override
    public int getCapHeight(int size) {
        return size * 718;
    }

    @Override
    public int getDescender(int size) {
        return size * -207;
    }

    @Override
    public int getXHeight(int size) {
        return size * 523;
    }

    @Override
    public int getUnderlinePosition(int size) {
        return size * -100;
    }

    @Override
    public int getUnderlineThickness(int size) {
        return size * 50;
    }

    public int getFirstChar() {
        return 32;
    }

    public int getLastChar() {
        return 255;
    }

    @Override
    public int getWidth(int i, int size) {
        return size * width[i];
    }

    @Override
    public Rectangle getBoundingBox(int glyphIndex, int size) {
        Rectangle bbox = boundingBoxes[glyphIndex];
        return new Rectangle(bbox.x * size, bbox.y * size, bbox.width * size, bbox.height * size);
    }

    @Override
    public int[] getWidths() {
        int[] arr = new int[this.getLastChar() - this.getFirstChar() + 1];
        System.arraycopy(width, this.getFirstChar(), arr, 0, this.getLastChar() - this.getFirstChar() + 1);
        return arr;
    }

    @Override
    public boolean hasKerningInfo() {
        return this.enableKerning;
    }

    public Map getKerningInfo() {
        return kerning;
    }

    @Override
    public char mapChar(char c) {
        this.notifyMapOperation();
        char d = this.mapping.mapChar(c);
        if (d != '\u0000') {
            return d;
        }
        this.warnMissingGlyph(c);
        return '#';
    }

    @Override
    public boolean hasChar(char c) {
        return this.mapping.mapChar(c) > '\u0000';
    }

    static {
        URI uri = null;
        try {
            uri = new URI("base14:" + "Helvetica".toLowerCase());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        fontFileURI = uri;
        width = new int[256];
        boundingBoxes = new Rectangle[256];
        Helvetica.width[65] = 667;
        Helvetica.boundingBoxes[65] = new Rectangle(14, 0, 640, 718);
        Helvetica.width[198] = 1000;
        Helvetica.boundingBoxes[198] = new Rectangle(8, 0, 943, 718);
        Helvetica.width[193] = 667;
        Helvetica.boundingBoxes[193] = new Rectangle(14, 0, 640, 929);
        Helvetica.width[194] = 667;
        Helvetica.boundingBoxes[194] = new Rectangle(14, 0, 640, 929);
        Helvetica.width[196] = 667;
        Helvetica.boundingBoxes[196] = new Rectangle(14, 0, 640, 901);
        Helvetica.width[192] = 667;
        Helvetica.boundingBoxes[192] = new Rectangle(14, 0, 640, 929);
        Helvetica.width[197] = 667;
        Helvetica.boundingBoxes[197] = new Rectangle(14, 0, 640, 931);
        Helvetica.width[195] = 667;
        Helvetica.boundingBoxes[195] = new Rectangle(14, 0, 640, 917);
        Helvetica.width[66] = 667;
        Helvetica.boundingBoxes[66] = new Rectangle(74, 0, 553, 718);
        Helvetica.width[67] = 722;
        Helvetica.boundingBoxes[67] = new Rectangle(44, -19, 637, 756);
        Helvetica.width[199] = 722;
        Helvetica.boundingBoxes[199] = new Rectangle(44, -225, 637, 962);
        Helvetica.width[68] = 722;
        Helvetica.boundingBoxes[68] = new Rectangle(81, 0, 593, 718);
        Helvetica.width[69] = 667;
        Helvetica.boundingBoxes[69] = new Rectangle(86, 0, 530, 718);
        Helvetica.width[201] = 667;
        Helvetica.boundingBoxes[201] = new Rectangle(86, 0, 530, 929);
        Helvetica.width[202] = 667;
        Helvetica.boundingBoxes[202] = new Rectangle(86, 0, 530, 929);
        Helvetica.width[203] = 667;
        Helvetica.boundingBoxes[203] = new Rectangle(86, 0, 530, 901);
        Helvetica.width[200] = 667;
        Helvetica.boundingBoxes[200] = new Rectangle(86, 0, 530, 929);
        Helvetica.width[208] = 722;
        Helvetica.boundingBoxes[208] = new Rectangle(0, 0, 674, 718);
        Helvetica.width[128] = 556;
        Helvetica.boundingBoxes[128] = new Rectangle(0, 0, 0, 0);
        Helvetica.width[70] = 611;
        Helvetica.boundingBoxes[70] = new Rectangle(86, 0, 497, 718);
        Helvetica.width[71] = 778;
        Helvetica.boundingBoxes[71] = new Rectangle(48, -19, 656, 756);
        Helvetica.width[72] = 722;
        Helvetica.boundingBoxes[72] = new Rectangle(77, 0, 569, 718);
        Helvetica.width[73] = 278;
        Helvetica.boundingBoxes[73] = new Rectangle(91, 0, 97, 718);
        Helvetica.width[205] = 278;
        Helvetica.boundingBoxes[205] = new Rectangle(91, 0, 201, 929);
        Helvetica.width[206] = 278;
        Helvetica.boundingBoxes[206] = new Rectangle(-6, 0, 291, 929);
        Helvetica.width[207] = 278;
        Helvetica.boundingBoxes[207] = new Rectangle(13, 0, 253, 901);
        Helvetica.width[204] = 278;
        Helvetica.boundingBoxes[204] = new Rectangle(-13, 0, 201, 929);
        Helvetica.width[74] = 500;
        Helvetica.boundingBoxes[74] = new Rectangle(17, -19, 411, 737);
        Helvetica.width[75] = 667;
        Helvetica.boundingBoxes[75] = new Rectangle(76, 0, 587, 718);
        Helvetica.width[76] = 556;
        Helvetica.boundingBoxes[76] = new Rectangle(76, 0, 461, 718);
        Helvetica.width[77] = 833;
        Helvetica.boundingBoxes[77] = new Rectangle(73, 0, 688, 718);
        Helvetica.width[78] = 722;
        Helvetica.boundingBoxes[78] = new Rectangle(76, 0, 570, 718);
        Helvetica.width[209] = 722;
        Helvetica.boundingBoxes[209] = new Rectangle(76, 0, 570, 917);
        Helvetica.width[79] = 778;
        Helvetica.boundingBoxes[79] = new Rectangle(39, -19, 700, 756);
        Helvetica.width[140] = 1000;
        Helvetica.boundingBoxes[140] = new Rectangle(36, -19, 929, 756);
        Helvetica.width[211] = 778;
        Helvetica.boundingBoxes[211] = new Rectangle(39, -19, 700, 948);
        Helvetica.width[212] = 778;
        Helvetica.boundingBoxes[212] = new Rectangle(39, -19, 700, 948);
        Helvetica.width[214] = 778;
        Helvetica.boundingBoxes[214] = new Rectangle(39, -19, 700, 920);
        Helvetica.width[210] = 778;
        Helvetica.boundingBoxes[210] = new Rectangle(39, -19, 700, 948);
        Helvetica.width[216] = 778;
        Helvetica.boundingBoxes[216] = new Rectangle(39, -19, 701, 756);
        Helvetica.width[213] = 778;
        Helvetica.boundingBoxes[213] = new Rectangle(39, -19, 700, 936);
        Helvetica.width[80] = 667;
        Helvetica.boundingBoxes[80] = new Rectangle(86, 0, 536, 718);
        Helvetica.width[81] = 778;
        Helvetica.boundingBoxes[81] = new Rectangle(39, -56, 700, 793);
        Helvetica.width[82] = 722;
        Helvetica.boundingBoxes[82] = new Rectangle(88, 0, 596, 718);
        Helvetica.width[83] = 667;
        Helvetica.boundingBoxes[83] = new Rectangle(49, -19, 571, 756);
        Helvetica.width[138] = 667;
        Helvetica.boundingBoxes[138] = new Rectangle(49, -19, 571, 948);
        Helvetica.width[84] = 611;
        Helvetica.boundingBoxes[84] = new Rectangle(14, 0, 583, 718);
        Helvetica.width[222] = 667;
        Helvetica.boundingBoxes[222] = new Rectangle(86, 0, 536, 718);
        Helvetica.width[85] = 722;
        Helvetica.boundingBoxes[85] = new Rectangle(79, -19, 565, 737);
        Helvetica.width[218] = 722;
        Helvetica.boundingBoxes[218] = new Rectangle(79, -19, 565, 948);
        Helvetica.width[219] = 722;
        Helvetica.boundingBoxes[219] = new Rectangle(79, -19, 565, 948);
        Helvetica.width[220] = 722;
        Helvetica.boundingBoxes[220] = new Rectangle(79, -19, 565, 920);
        Helvetica.width[217] = 722;
        Helvetica.boundingBoxes[217] = new Rectangle(79, -19, 565, 948);
        Helvetica.width[86] = 667;
        Helvetica.boundingBoxes[86] = new Rectangle(20, 0, 627, 718);
        Helvetica.width[87] = 944;
        Helvetica.boundingBoxes[87] = new Rectangle(16, 0, 912, 718);
        Helvetica.width[88] = 667;
        Helvetica.boundingBoxes[88] = new Rectangle(19, 0, 629, 718);
        Helvetica.width[89] = 667;
        Helvetica.boundingBoxes[89] = new Rectangle(14, 0, 639, 718);
        Helvetica.width[221] = 667;
        Helvetica.boundingBoxes[221] = new Rectangle(14, 0, 639, 929);
        Helvetica.width[159] = 667;
        Helvetica.boundingBoxes[159] = new Rectangle(14, 0, 639, 901);
        Helvetica.width[90] = 611;
        Helvetica.boundingBoxes[90] = new Rectangle(23, 0, 565, 718);
        Helvetica.width[142] = 611;
        Helvetica.boundingBoxes[142] = new Rectangle(23, 0, 565, 929);
        Helvetica.width[97] = 556;
        Helvetica.boundingBoxes[97] = new Rectangle(36, -15, 494, 553);
        Helvetica.width[225] = 556;
        Helvetica.boundingBoxes[225] = new Rectangle(36, -15, 494, 749);
        Helvetica.width[226] = 556;
        Helvetica.boundingBoxes[226] = new Rectangle(36, -15, 494, 749);
        Helvetica.width[180] = 333;
        Helvetica.boundingBoxes[180] = new Rectangle(122, 593, 197, 141);
        Helvetica.width[228] = 556;
        Helvetica.boundingBoxes[228] = new Rectangle(36, -15, 494, 721);
        Helvetica.width[230] = 889;
        Helvetica.boundingBoxes[230] = new Rectangle(36, -15, 811, 553);
        Helvetica.width[224] = 556;
        Helvetica.boundingBoxes[224] = new Rectangle(36, -15, 494, 749);
        Helvetica.width[38] = 667;
        Helvetica.boundingBoxes[38] = new Rectangle(44, -15, 601, 733);
        Helvetica.width[229] = 556;
        Helvetica.boundingBoxes[229] = new Rectangle(36, -15, 494, 771);
        Helvetica.width[94] = 469;
        Helvetica.boundingBoxes[94] = new Rectangle(-14, 264, 497, 424);
        Helvetica.width[126] = 584;
        Helvetica.boundingBoxes[126] = new Rectangle(61, 180, 462, 146);
        Helvetica.width[42] = 389;
        Helvetica.boundingBoxes[42] = new Rectangle(39, 431, 310, 287);
        Helvetica.width[64] = 1015;
        Helvetica.boundingBoxes[64] = new Rectangle(147, -19, 721, 756);
        Helvetica.width[227] = 556;
        Helvetica.boundingBoxes[227] = new Rectangle(36, -15, 494, 737);
        Helvetica.width[98] = 556;
        Helvetica.boundingBoxes[98] = new Rectangle(58, -15, 459, 733);
        Helvetica.width[92] = 278;
        Helvetica.boundingBoxes[92] = new Rectangle(-17, -19, 312, 756);
        Helvetica.width[124] = 260;
        Helvetica.boundingBoxes[124] = new Rectangle(94, -225, 73, 1000);
        Helvetica.width[123] = 334;
        Helvetica.boundingBoxes[123] = new Rectangle(42, -196, 250, 918);
        Helvetica.width[125] = 334;
        Helvetica.boundingBoxes[125] = new Rectangle(42, -196, 250, 918);
        Helvetica.width[91] = 278;
        Helvetica.boundingBoxes[91] = new Rectangle(63, -196, 187, 918);
        Helvetica.width[93] = 278;
        Helvetica.boundingBoxes[93] = new Rectangle(28, -196, 187, 918);
        Helvetica.width[166] = 260;
        Helvetica.boundingBoxes[166] = new Rectangle(94, -150, 73, 850);
        Helvetica.width[149] = 350;
        Helvetica.boundingBoxes[149] = new Rectangle(18, 202, 315, 315);
        Helvetica.width[99] = 500;
        Helvetica.boundingBoxes[99] = new Rectangle(30, -15, 447, 553);
        Helvetica.width[231] = 500;
        Helvetica.boundingBoxes[231] = new Rectangle(30, -225, 447, 763);
        Helvetica.width[184] = 333;
        Helvetica.boundingBoxes[184] = new Rectangle(45, -225, 214, 225);
        Helvetica.width[162] = 556;
        Helvetica.boundingBoxes[162] = new Rectangle(51, -115, 462, 738);
        Helvetica.width[136] = 333;
        Helvetica.boundingBoxes[136] = new Rectangle(21, 593, 291, 141);
        Helvetica.width[58] = 278;
        Helvetica.boundingBoxes[58] = new Rectangle(87, 0, 104, 516);
        Helvetica.width[44] = 278;
        Helvetica.boundingBoxes[44] = new Rectangle(87, -147, 104, 253);
        Helvetica.width[169] = 737;
        Helvetica.boundingBoxes[169] = new Rectangle(-14, -19, 766, 756);
        Helvetica.width[164] = 556;
        Helvetica.boundingBoxes[164] = new Rectangle(28, 99, 500, 504);
        Helvetica.width[100] = 556;
        Helvetica.boundingBoxes[100] = new Rectangle(35, -15, 464, 733);
        Helvetica.width[134] = 556;
        Helvetica.boundingBoxes[134] = new Rectangle(43, -159, 471, 877);
        Helvetica.width[135] = 556;
        Helvetica.boundingBoxes[135] = new Rectangle(43, -159, 471, 877);
        Helvetica.width[176] = 400;
        Helvetica.boundingBoxes[176] = new Rectangle(54, 411, 292, 292);
        Helvetica.width[168] = 333;
        Helvetica.boundingBoxes[168] = new Rectangle(40, 604, 253, 102);
        Helvetica.width[247] = 584;
        Helvetica.boundingBoxes[247] = new Rectangle(39, -19, 506, 543);
        Helvetica.width[36] = 556;
        Helvetica.boundingBoxes[36] = new Rectangle(32, -115, 488, 890);
        Helvetica.width[101] = 556;
        Helvetica.boundingBoxes[101] = new Rectangle(40, -15, 476, 553);
        Helvetica.width[233] = 556;
        Helvetica.boundingBoxes[233] = new Rectangle(40, -15, 476, 749);
        Helvetica.width[234] = 556;
        Helvetica.boundingBoxes[234] = new Rectangle(40, -15, 476, 749);
        Helvetica.width[235] = 556;
        Helvetica.boundingBoxes[235] = new Rectangle(40, -15, 476, 721);
        Helvetica.width[232] = 556;
        Helvetica.boundingBoxes[232] = new Rectangle(40, -15, 476, 749);
        Helvetica.width[56] = 556;
        Helvetica.boundingBoxes[56] = new Rectangle(38, -19, 479, 722);
        Helvetica.width[133] = 1000;
        Helvetica.boundingBoxes[133] = new Rectangle(115, 0, 770, 106);
        Helvetica.width[151] = 1000;
        Helvetica.boundingBoxes[151] = new Rectangle(0, 240, 1000, 73);
        Helvetica.width[150] = 556;
        Helvetica.boundingBoxes[150] = new Rectangle(0, 240, 556, 73);
        Helvetica.width[61] = 584;
        Helvetica.boundingBoxes[61] = new Rectangle(39, 115, 506, 275);
        Helvetica.width[240] = 556;
        Helvetica.boundingBoxes[240] = new Rectangle(35, -15, 487, 752);
        Helvetica.width[33] = 278;
        Helvetica.boundingBoxes[33] = new Rectangle(90, 0, 97, 718);
        Helvetica.width[161] = 333;
        Helvetica.boundingBoxes[161] = new Rectangle(118, -195, 97, 718);
        Helvetica.width[102] = 278;
        Helvetica.boundingBoxes[102] = new Rectangle(14, 0, 248, 728);
        Helvetica.width[53] = 556;
        Helvetica.boundingBoxes[53] = new Rectangle(32, -19, 482, 707);
        Helvetica.width[131] = 556;
        Helvetica.boundingBoxes[131] = new Rectangle(-11, -207, 512, 944);
        Helvetica.width[52] = 556;
        Helvetica.boundingBoxes[52] = new Rectangle(25, 0, 498, 703);
        Helvetica.width[103] = 556;
        Helvetica.boundingBoxes[103] = new Rectangle(40, -220, 459, 758);
        Helvetica.width[223] = 611;
        Helvetica.boundingBoxes[223] = new Rectangle(67, -15, 504, 743);
        Helvetica.width[96] = 333;
        Helvetica.boundingBoxes[96] = new Rectangle(14, 593, 197, 141);
        Helvetica.width[62] = 584;
        Helvetica.boundingBoxes[62] = new Rectangle(48, 11, 488, 484);
        Helvetica.width[171] = 556;
        Helvetica.boundingBoxes[171] = new Rectangle(97, 108, 362, 338);
        Helvetica.width[187] = 556;
        Helvetica.boundingBoxes[187] = new Rectangle(97, 108, 362, 338);
        Helvetica.width[139] = 333;
        Helvetica.boundingBoxes[139] = new Rectangle(88, 108, 157, 338);
        Helvetica.width[155] = 333;
        Helvetica.boundingBoxes[155] = new Rectangle(88, 108, 157, 338);
        Helvetica.width[104] = 556;
        Helvetica.boundingBoxes[104] = new Rectangle(65, 0, 426, 718);
        Helvetica.width[45] = 333;
        Helvetica.boundingBoxes[45] = new Rectangle(44, 232, 245, 90);
        Helvetica.width[105] = 222;
        Helvetica.boundingBoxes[105] = new Rectangle(67, 0, 88, 718);
        Helvetica.width[237] = 278;
        Helvetica.boundingBoxes[237] = new Rectangle(95, 0, 197, 734);
        Helvetica.width[238] = 278;
        Helvetica.boundingBoxes[238] = new Rectangle(-6, 0, 291, 734);
        Helvetica.width[239] = 278;
        Helvetica.boundingBoxes[239] = new Rectangle(13, 0, 253, 706);
        Helvetica.width[236] = 278;
        Helvetica.boundingBoxes[236] = new Rectangle(-13, 0, 197, 734);
        Helvetica.width[106] = 222;
        Helvetica.boundingBoxes[106] = new Rectangle(-16, -210, 171, 928);
        Helvetica.width[107] = 500;
        Helvetica.boundingBoxes[107] = new Rectangle(67, 0, 434, 718);
        Helvetica.width[108] = 222;
        Helvetica.boundingBoxes[108] = new Rectangle(67, 0, 88, 718);
        Helvetica.width[60] = 584;
        Helvetica.boundingBoxes[60] = new Rectangle(48, 11, 488, 484);
        Helvetica.width[172] = 584;
        Helvetica.boundingBoxes[172] = new Rectangle(39, 108, 506, 282);
        Helvetica.width[109] = 833;
        Helvetica.boundingBoxes[109] = new Rectangle(65, 0, 704, 538);
        Helvetica.width[175] = 333;
        Helvetica.boundingBoxes[175] = new Rectangle(10, 627, 313, 57);
        Helvetica.width[181] = 556;
        Helvetica.boundingBoxes[181] = new Rectangle(68, -207, 421, 730);
        Helvetica.width[215] = 584;
        Helvetica.boundingBoxes[215] = new Rectangle(39, 0, 506, 506);
        Helvetica.width[110] = 556;
        Helvetica.boundingBoxes[110] = new Rectangle(65, 0, 426, 538);
        Helvetica.width[57] = 556;
        Helvetica.boundingBoxes[57] = new Rectangle(42, -19, 472, 722);
        Helvetica.width[241] = 556;
        Helvetica.boundingBoxes[241] = new Rectangle(65, 0, 426, 722);
        Helvetica.width[35] = 556;
        Helvetica.boundingBoxes[35] = new Rectangle(28, 0, 501, 688);
        Helvetica.width[111] = 556;
        Helvetica.boundingBoxes[111] = new Rectangle(35, -14, 486, 552);
        Helvetica.width[243] = 556;
        Helvetica.boundingBoxes[243] = new Rectangle(35, -14, 486, 748);
        Helvetica.width[244] = 556;
        Helvetica.boundingBoxes[244] = new Rectangle(35, -14, 486, 748);
        Helvetica.width[246] = 556;
        Helvetica.boundingBoxes[246] = new Rectangle(35, -14, 486, 720);
        Helvetica.width[156] = 944;
        Helvetica.boundingBoxes[156] = new Rectangle(35, -15, 867, 553);
        Helvetica.width[242] = 556;
        Helvetica.boundingBoxes[242] = new Rectangle(35, -14, 486, 748);
        Helvetica.width[49] = 556;
        Helvetica.boundingBoxes[49] = new Rectangle(101, 0, 258, 703);
        Helvetica.width[189] = 834;
        Helvetica.boundingBoxes[189] = new Rectangle(43, -19, 730, 722);
        Helvetica.width[188] = 834;
        Helvetica.boundingBoxes[188] = new Rectangle(73, -19, 683, 722);
        Helvetica.width[185] = 333;
        Helvetica.boundingBoxes[185] = new Rectangle(43, 281, 179, 422);
        Helvetica.width[170] = 370;
        Helvetica.boundingBoxes[170] = new Rectangle(24, 405, 322, 332);
        Helvetica.width[186] = 365;
        Helvetica.boundingBoxes[186] = new Rectangle(25, 405, 316, 332);
        Helvetica.width[248] = 611;
        Helvetica.boundingBoxes[248] = new Rectangle(28, -22, 509, 567);
        Helvetica.width[245] = 556;
        Helvetica.boundingBoxes[245] = new Rectangle(35, -14, 486, 736);
        Helvetica.width[112] = 556;
        Helvetica.boundingBoxes[112] = new Rectangle(58, -207, 459, 745);
        Helvetica.width[182] = 537;
        Helvetica.boundingBoxes[182] = new Rectangle(18, -173, 479, 891);
        Helvetica.width[40] = 333;
        Helvetica.boundingBoxes[40] = new Rectangle(68, -207, 231, 940);
        Helvetica.width[41] = 333;
        Helvetica.boundingBoxes[41] = new Rectangle(34, -207, 231, 940);
        Helvetica.width[37] = 889;
        Helvetica.boundingBoxes[37] = new Rectangle(39, -19, 811, 722);
        Helvetica.width[46] = 278;
        Helvetica.boundingBoxes[46] = new Rectangle(87, 0, 104, 106);
        Helvetica.width[183] = 278;
        Helvetica.boundingBoxes[183] = new Rectangle(77, 190, 125, 125);
        Helvetica.width[137] = 1000;
        Helvetica.boundingBoxes[137] = new Rectangle(7, -19, 987, 722);
        Helvetica.width[43] = 584;
        Helvetica.boundingBoxes[43] = new Rectangle(39, 0, 506, 505);
        Helvetica.width[177] = 584;
        Helvetica.boundingBoxes[177] = new Rectangle(39, 0, 506, 506);
        Helvetica.width[113] = 556;
        Helvetica.boundingBoxes[113] = new Rectangle(35, -207, 459, 745);
        Helvetica.width[63] = 556;
        Helvetica.boundingBoxes[63] = new Rectangle(56, 0, 436, 727);
        Helvetica.width[191] = 611;
        Helvetica.boundingBoxes[191] = new Rectangle(91, -201, 436, 726);
        Helvetica.width[34] = 355;
        Helvetica.boundingBoxes[34] = new Rectangle(70, 463, 215, 255);
        Helvetica.width[132] = 333;
        Helvetica.boundingBoxes[132] = new Rectangle(26, -149, 269, 255);
        Helvetica.width[147] = 333;
        Helvetica.boundingBoxes[147] = new Rectangle(38, 470, 269, 255);
        Helvetica.width[148] = 333;
        Helvetica.boundingBoxes[148] = new Rectangle(26, 463, 269, 255);
        Helvetica.width[145] = 222;
        Helvetica.boundingBoxes[145] = new Rectangle(65, 470, 104, 255);
        Helvetica.width[146] = 222;
        Helvetica.boundingBoxes[146] = new Rectangle(53, 463, 104, 255);
        Helvetica.width[130] = 222;
        Helvetica.boundingBoxes[130] = new Rectangle(53, -149, 104, 255);
        Helvetica.width[39] = 191;
        Helvetica.boundingBoxes[39] = new Rectangle(59, 463, 73, 255);
        Helvetica.width[114] = 333;
        Helvetica.boundingBoxes[114] = new Rectangle(77, 0, 255, 538);
        Helvetica.width[174] = 737;
        Helvetica.boundingBoxes[174] = new Rectangle(-14, -19, 766, 756);
        Helvetica.width[115] = 500;
        Helvetica.boundingBoxes[115] = new Rectangle(32, -15, 432, 553);
        Helvetica.width[154] = 500;
        Helvetica.boundingBoxes[154] = new Rectangle(32, -15, 432, 749);
        Helvetica.width[167] = 556;
        Helvetica.boundingBoxes[167] = new Rectangle(43, -191, 469, 928);
        Helvetica.width[59] = 278;
        Helvetica.boundingBoxes[59] = new Rectangle(87, -147, 104, 663);
        Helvetica.width[55] = 556;
        Helvetica.boundingBoxes[55] = new Rectangle(37, 0, 486, 688);
        Helvetica.width[54] = 556;
        Helvetica.boundingBoxes[54] = new Rectangle(38, -19, 480, 722);
        Helvetica.width[47] = 278;
        Helvetica.boundingBoxes[47] = new Rectangle(-17, -19, 312, 756);
        Helvetica.width[32] = 278;
        Helvetica.boundingBoxes[32] = new Rectangle(0, 0, 0, 0);
        Helvetica.width[163] = 556;
        Helvetica.boundingBoxes[163] = new Rectangle(33, -16, 506, 734);
        Helvetica.width[116] = 278;
        Helvetica.boundingBoxes[116] = new Rectangle(14, -7, 243, 676);
        Helvetica.width[254] = 556;
        Helvetica.boundingBoxes[254] = new Rectangle(58, -207, 459, 925);
        Helvetica.width[51] = 556;
        Helvetica.boundingBoxes[51] = new Rectangle(34, -19, 488, 722);
        Helvetica.width[190] = 834;
        Helvetica.boundingBoxes[190] = new Rectangle(45, -19, 765, 722);
        Helvetica.width[179] = 333;
        Helvetica.boundingBoxes[179] = new Rectangle(5, 270, 320, 433);
        Helvetica.width[152] = 333;
        Helvetica.boundingBoxes[152] = new Rectangle(-4, 606, 341, 116);
        Helvetica.width[153] = 1000;
        Helvetica.boundingBoxes[153] = new Rectangle(46, 306, 857, 412);
        Helvetica.width[50] = 556;
        Helvetica.boundingBoxes[50] = new Rectangle(26, 0, 481, 703);
        Helvetica.width[178] = 333;
        Helvetica.boundingBoxes[178] = new Rectangle(4, 281, 319, 422);
        Helvetica.width[117] = 556;
        Helvetica.boundingBoxes[117] = new Rectangle(68, -15, 421, 538);
        Helvetica.width[250] = 556;
        Helvetica.boundingBoxes[250] = new Rectangle(68, -15, 421, 749);
        Helvetica.width[251] = 556;
        Helvetica.boundingBoxes[251] = new Rectangle(68, -15, 421, 749);
        Helvetica.width[252] = 556;
        Helvetica.boundingBoxes[252] = new Rectangle(68, -15, 421, 721);
        Helvetica.width[249] = 556;
        Helvetica.boundingBoxes[249] = new Rectangle(68, -15, 421, 749);
        Helvetica.width[95] = 556;
        Helvetica.boundingBoxes[95] = new Rectangle(0, -125, 556, 50);
        Helvetica.width[118] = 500;
        Helvetica.boundingBoxes[118] = new Rectangle(8, 0, 484, 523);
        Helvetica.width[119] = 722;
        Helvetica.boundingBoxes[119] = new Rectangle(14, 0, 695, 523);
        Helvetica.width[120] = 500;
        Helvetica.boundingBoxes[120] = new Rectangle(11, 0, 479, 523);
        Helvetica.width[121] = 500;
        Helvetica.boundingBoxes[121] = new Rectangle(11, -214, 478, 737);
        Helvetica.width[253] = 500;
        Helvetica.boundingBoxes[253] = new Rectangle(11, -214, 478, 948);
        Helvetica.width[255] = 500;
        Helvetica.boundingBoxes[255] = new Rectangle(11, -214, 478, 920);
        Helvetica.width[165] = 556;
        Helvetica.boundingBoxes[165] = new Rectangle(3, 0, 550, 688);
        Helvetica.width[122] = 500;
        Helvetica.boundingBoxes[122] = new Rectangle(31, 0, 438, 523);
        Helvetica.width[158] = 500;
        Helvetica.boundingBoxes[158] = new Rectangle(31, 0, 438, 734);
        Helvetica.width[48] = 556;
        Helvetica.boundingBoxes[48] = new Rectangle(37, -19, 482, 722);
        familyNames = new HashSet();
        familyNames.add("Helvetica");
        kerning = new HashMap();
        Integer first = 107;
        Map<Integer, Integer> pairs = (HashMap<Integer, Integer>)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap<Integer, Integer>();
            kerning.put(first, pairs);
        }
        Integer second = 111;
        pairs.put(second, -20);
        second = 101;
        pairs.put(second, -20);
        first = 79;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 65;
        pairs.put(second, -20);
        second = 87;
        pairs.put(second, -30);
        second = 89;
        pairs.put(second, -70);
        second = 84;
        pairs.put(second, -40);
        second = 46;
        pairs.put(second, -40);
        second = 86;
        pairs.put(second, -50);
        second = 88;
        pairs.put(second, -60);
        second = 44;
        pairs.put(second, -40);
        first = 104;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 121;
        pairs.put(second, -30);
        first = 87;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 111;
        pairs.put(second, -30);
        second = 45;
        pairs.put(second, -40);
        second = 79;
        pairs.put(second, -20);
        second = 97;
        pairs.put(second, -40);
        second = 65;
        pairs.put(second, -50);
        second = 117;
        pairs.put(second, -30);
        second = 121;
        pairs.put(second, -20);
        second = 46;
        pairs.put(second, -80);
        second = 101;
        pairs.put(second, -30);
        second = 44;
        pairs.put(second, -80);
        first = 99;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 107;
        pairs.put(second, -20);
        second = 44;
        pairs.put(second, -15);
        first = 112;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 121;
        pairs.put(second, -30);
        second = 46;
        pairs.put(second, -35);
        second = 44;
        pairs.put(second, -35);
        first = 80;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 111;
        pairs.put(second, -50);
        second = 97;
        pairs.put(second, -40);
        second = 65;
        pairs.put(second, -120);
        second = 46;
        pairs.put(second, -180);
        second = 101;
        pairs.put(second, -50);
        second = 44;
        pairs.put(second, -180);
        first = 86;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 111;
        pairs.put(second, -80);
        second = 45;
        pairs.put(second, -80);
        second = 79;
        pairs.put(second, -40);
        second = 58;
        pairs.put(second, -40);
        second = 97;
        pairs.put(second, -70);
        second = 65;
        pairs.put(second, -80);
        second = 117;
        pairs.put(second, -70);
        second = 46;
        pairs.put(second, -125);
        second = 71;
        pairs.put(second, -40);
        second = 101;
        pairs.put(second, -80);
        second = 59;
        pairs.put(second, -40);
        second = 44;
        pairs.put(second, -125);
        first = 118;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 111;
        pairs.put(second, -25);
        second = 97;
        pairs.put(second, -25);
        second = 46;
        pairs.put(second, -80);
        second = 101;
        pairs.put(second, -25);
        second = 44;
        pairs.put(second, -80);
        first = 59;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 32;
        pairs.put(second, -50);
        first = 32;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 87;
        pairs.put(second, -40);
        second = 147;
        pairs.put(second, -30);
        second = 89;
        pairs.put(second, -90);
        second = 84;
        pairs.put(second, -50);
        second = 145;
        pairs.put(second, -60);
        second = 86;
        pairs.put(second, -50);
        first = 97;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 119;
        pairs.put(second, -20);
        second = 121;
        pairs.put(second, -30);
        second = 118;
        pairs.put(second, -20);
        first = 65;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 79;
        pairs.put(second, -30);
        second = 119;
        pairs.put(second, -40);
        second = 87;
        pairs.put(second, -50);
        second = 67;
        pairs.put(second, -30);
        second = 81;
        pairs.put(second, -30);
        second = 71;
        pairs.put(second, -30);
        second = 86;
        pairs.put(second, -70);
        second = 118;
        pairs.put(second, -40);
        second = 85;
        pairs.put(second, -50);
        second = 117;
        pairs.put(second, -30);
        second = 89;
        pairs.put(second, -100);
        second = 84;
        pairs.put(second, -120);
        second = 121;
        pairs.put(second, -40);
        first = 70;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 111;
        pairs.put(second, -30);
        second = 114;
        pairs.put(second, -45);
        second = 97;
        pairs.put(second, -50);
        second = 65;
        pairs.put(second, -80);
        second = 46;
        pairs.put(second, -150);
        second = 101;
        pairs.put(second, -30);
        second = 44;
        pairs.put(second, -150);
        first = 85;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 65;
        pairs.put(second, -40);
        second = 46;
        pairs.put(second, -40);
        second = 44;
        pairs.put(second, -40);
        first = 115;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 119;
        pairs.put(second, -30);
        second = 46;
        pairs.put(second, -15);
        second = 44;
        pairs.put(second, -15);
        first = 122;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 111;
        pairs.put(second, -15);
        second = 101;
        pairs.put(second, -15);
        first = 83;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 46;
        pairs.put(second, -20);
        second = 44;
        pairs.put(second, -20);
        first = 111;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 119;
        pairs.put(second, -15);
        second = 121;
        pairs.put(second, -30);
        second = 46;
        pairs.put(second, -40);
        second = 120;
        pairs.put(second, -30);
        second = 118;
        pairs.put(second, -15);
        second = 44;
        pairs.put(second, -40);
        first = 68;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 65;
        pairs.put(second, -40);
        second = 87;
        pairs.put(second, -40);
        second = 89;
        pairs.put(second, -90);
        second = 46;
        pairs.put(second, -70);
        second = 86;
        pairs.put(second, -70);
        second = 44;
        pairs.put(second, -70);
        first = 146;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 100;
        pairs.put(second, -50);
        second = 32;
        pairs.put(second, -70);
        second = 146;
        pairs.put(second, -57);
        second = 114;
        pairs.put(second, -50);
        second = 115;
        pairs.put(second, -50);
        first = 82;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 79;
        pairs.put(second, -20);
        second = 87;
        pairs.put(second, -30);
        second = 85;
        pairs.put(second, -40);
        second = 89;
        pairs.put(second, -50);
        second = 84;
        pairs.put(second, -30);
        second = 86;
        pairs.put(second, -50);
        first = 75;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 111;
        pairs.put(second, -40);
        second = 79;
        pairs.put(second, -50);
        second = 117;
        pairs.put(second, -30);
        second = 121;
        pairs.put(second, -50);
        second = 101;
        pairs.put(second, -40);
        first = 119;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 111;
        pairs.put(second, -10);
        second = 97;
        pairs.put(second, -15);
        second = 46;
        pairs.put(second, -60);
        second = 101;
        pairs.put(second, -10);
        second = 44;
        pairs.put(second, -60);
        first = 58;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 32;
        pairs.put(second, -50);
        first = 114;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 107;
        pairs.put(second, 15);
        second = 58;
        pairs.put(second, 30);
        second = 112;
        pairs.put(second, 30);
        second = 108;
        pairs.put(second, 15);
        second = 118;
        pairs.put(second, 30);
        second = 44;
        pairs.put(second, -50);
        second = 59;
        pairs.put(second, 30);
        second = 105;
        pairs.put(second, 15);
        second = 109;
        pairs.put(second, 25);
        second = 97;
        pairs.put(second, -10);
        second = 117;
        pairs.put(second, 15);
        second = 116;
        pairs.put(second, 40);
        second = 121;
        pairs.put(second, 30);
        second = 46;
        pairs.put(second, -50);
        second = 110;
        pairs.put(second, 25);
        first = 67;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 46;
        pairs.put(second, -30);
        second = 44;
        pairs.put(second, -30);
        first = 145;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 145;
        pairs.put(second, -57);
        first = 103;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 114;
        pairs.put(second, -10);
        first = 66;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 85;
        pairs.put(second, -10);
        second = 46;
        pairs.put(second, -20);
        second = 44;
        pairs.put(second, -20);
        first = 81;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 85;
        pairs.put(second, -10);
        first = 76;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 148;
        pairs.put(second, -140);
        second = 146;
        pairs.put(second, -160);
        second = 87;
        pairs.put(second, -70);
        second = 89;
        pairs.put(second, -140);
        second = 121;
        pairs.put(second, -30);
        second = 84;
        pairs.put(second, -110);
        second = 86;
        pairs.put(second, -110);
        first = 98;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 117;
        pairs.put(second, -20);
        second = 121;
        pairs.put(second, -20);
        second = 46;
        pairs.put(second, -40);
        second = 108;
        pairs.put(second, -20);
        second = 98;
        pairs.put(second, -10);
        second = 118;
        pairs.put(second, -20);
        second = 44;
        pairs.put(second, -40);
        first = 44;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 148;
        pairs.put(second, -100);
        second = 146;
        pairs.put(second, -100);
        first = 148;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 32;
        pairs.put(second, -40);
        first = 109;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 117;
        pairs.put(second, -10);
        second = 121;
        pairs.put(second, -15);
        first = 248;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 107;
        pairs.put(second, -55);
        second = 104;
        pairs.put(second, -55);
        second = 99;
        pairs.put(second, -55);
        second = 112;
        pairs.put(second, -55);
        second = 113;
        pairs.put(second, -55);
        second = 118;
        pairs.put(second, -70);
        second = 105;
        pairs.put(second, -55);
        second = 97;
        pairs.put(second, -55);
        second = 117;
        pairs.put(second, -55);
        second = 116;
        pairs.put(second, -55);
        second = 106;
        pairs.put(second, -55);
        second = 115;
        pairs.put(second, -55);
        second = 122;
        pairs.put(second, -55);
        second = 100;
        pairs.put(second, -55);
        second = 111;
        pairs.put(second, -55);
        second = 119;
        pairs.put(second, -70);
        second = 114;
        pairs.put(second, -55);
        second = 103;
        pairs.put(second, -55);
        second = 108;
        pairs.put(second, -55);
        second = 98;
        pairs.put(second, -55);
        second = 44;
        pairs.put(second, -95);
        second = 109;
        pairs.put(second, -55);
        second = 102;
        pairs.put(second, -55);
        second = 121;
        pairs.put(second, -70);
        second = 46;
        pairs.put(second, -95);
        second = 110;
        pairs.put(second, -55);
        second = 120;
        pairs.put(second, -85);
        second = 101;
        pairs.put(second, -55);
        first = 102;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 148;
        pairs.put(second, 60);
        second = 111;
        pairs.put(second, -30);
        second = 146;
        pairs.put(second, 50);
        second = 97;
        pairs.put(second, -30);
        second = 46;
        pairs.put(second, -30);
        second = 101;
        pairs.put(second, -30);
        second = 44;
        pairs.put(second, -30);
        first = 74;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 97;
        pairs.put(second, -20);
        second = 65;
        pairs.put(second, -20);
        second = 117;
        pairs.put(second, -20);
        second = 46;
        pairs.put(second, -30);
        second = 44;
        pairs.put(second, -30);
        first = 89;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 111;
        pairs.put(second, -140);
        second = 45;
        pairs.put(second, -140);
        second = 105;
        pairs.put(second, -20);
        second = 79;
        pairs.put(second, -85);
        second = 58;
        pairs.put(second, -60);
        second = 97;
        pairs.put(second, -140);
        second = 65;
        pairs.put(second, -110);
        second = 117;
        pairs.put(second, -110);
        second = 46;
        pairs.put(second, -140);
        second = 101;
        pairs.put(second, -140);
        second = 59;
        pairs.put(second, -60);
        second = 44;
        pairs.put(second, -140);
        first = 121;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 111;
        pairs.put(second, -20);
        second = 97;
        pairs.put(second, -20);
        second = 46;
        pairs.put(second, -100);
        second = 101;
        pairs.put(second, -20);
        second = 44;
        pairs.put(second, -100);
        first = 84;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 111;
        pairs.put(second, -120);
        second = 79;
        pairs.put(second, -40);
        second = 58;
        pairs.put(second, -20);
        second = 119;
        pairs.put(second, -120);
        second = 114;
        pairs.put(second, -120);
        second = 44;
        pairs.put(second, -120);
        second = 59;
        pairs.put(second, -20);
        second = 45;
        pairs.put(second, -140);
        second = 65;
        pairs.put(second, -120);
        second = 97;
        pairs.put(second, -120);
        second = 117;
        pairs.put(second, -120);
        second = 121;
        pairs.put(second, -120);
        second = 46;
        pairs.put(second, -120);
        second = 101;
        pairs.put(second, -120);
        first = 46;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 148;
        pairs.put(second, -100);
        second = 32;
        pairs.put(second, -60);
        second = 146;
        pairs.put(second, -100);
        first = 110;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 117;
        pairs.put(second, -10);
        second = 121;
        pairs.put(second, -15);
        second = 118;
        pairs.put(second, -20);
        first = 120;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 101;
        pairs.put(second, -30);
        first = 101;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 119;
        pairs.put(second, -20);
        second = 121;
        pairs.put(second, -20);
        second = 46;
        pairs.put(second, -15);
        second = 120;
        pairs.put(second, -30);
        second = 118;
        pairs.put(second, -30);
        second = 44;
        pairs.put(second, -15);
    }
}

