/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.bookmarks;

import java.io.IOException;
import java.io.Writer;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.docx4j.TraversalUtil;
import org.docx4j.XmlUtils;
import org.docx4j.finders.RangeFinder;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.wml.CTBookmark;
import org.docx4j.wml.CTMarkupRange;
import org.docx4j.wml.ContentAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookmarksIntegrity {
    protected static Logger log = LoggerFactory.getLogger(BookmarksIntegrity.class);
    private Writer writer;

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public BookmarksStatus check(MainDocumentPart documentPart, boolean remediate) throws Exception {
        return this.check(documentPart.getContent(), remediate);
    }

    public BookmarksStatus check(List<Object> contents, boolean remediate) throws IOException {
        List<Object> faulty = this.inspectBookmarks(contents);
        if (remediate) {
            for (Object o : faulty) {
                Object parent;
                if (o instanceof CTBookmark) {
                    CTBookmark start = (CTBookmark)o;
                    parent = start.getParent();
                    if (parent instanceof ContentAccessor) {
                        if (!BookmarksIntegrity.remove(((ContentAccessor)parent).getContent(), o)) {
                            this.write("FIXME Couldn't find start " + start.getName() + start.getId().intValue());
                            log.warn("FIXME Couldn't find start " + start.getName() + start.getId().intValue());
                        }
                    } else {
                        log.warn("TODO: handle parent:" + parent.getClass().getName());
                        this.write("TODO: handle parent:" + parent.getClass().getName());
                    }
                }
                if (!(o instanceof CTMarkupRange) || o instanceof CTBookmark) continue;
                CTMarkupRange end = (CTMarkupRange)o;
                parent = end.getParent();
                if (parent instanceof ContentAccessor) {
                    if (BookmarksIntegrity.remove(((ContentAccessor)parent).getContent(), o)) continue;
                    this.write("FIXME Couldn't find end " + end.getId().longValue());
                    log.warn("FIXME Couldn't find end " + end.getId().longValue());
                    continue;
                }
                log.warn("TODO: handle parent:" + parent.getClass().getName());
                this.write("TODO: handle parent:" + parent.getClass().getName());
            }
        }
        if (faulty.size() == 0) {
            log.debug("Nothing to fix");
            this.write("Nothing to fix");
            return BookmarksStatus.OK;
        }
        if (remediate) {
            return BookmarksStatus.FIXED;
        }
        return BookmarksStatus.BROKEN;
    }

    private static boolean remove(List list, Object deletion) {
        int i = BookmarksIntegrity.getIndex(list, deletion);
        if (i >= 0) {
            Object o = list.remove(i);
            return o != null;
        }
        return false;
    }

    private static int getIndex(List list, Object deletion) {
        int i = 0;
        for (Object o : list) {
            if (o == deletion || XmlUtils.unwrap(o) == deletion) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private List<Object> inspectBookmarks(List<Object> paragraphs) throws IOException {
        BigInteger id;
        HashSet<String> names = new HashSet<String>();
        HashSet<BigInteger> startIds = new HashSet<BigInteger>();
        HashSet<BigInteger> endIds = new HashSet<BigInteger>();
        ArrayList<Object> faulty = new ArrayList<Object>();
        RangeFinder rt = new RangeFinder();
        new TraversalUtil(paragraphs, rt);
        this.write("Checking starts ");
        for (CTBookmark cTBookmark : rt.getStarts()) {
            id = cTBookmark.getId();
            String name = cTBookmark.getName();
            if (name == null && id == null) {
                this.write("Name and ID missing!");
                faulty.add(cTBookmark);
                continue;
            }
            if (name != null && id != null) {
                if (!names.add(name)) {
                    this.write("Already have name '" + name + "'");
                    faulty.add(cTBookmark);
                }
                if (startIds.add(id)) continue;
                this.write("Already have id " + id.longValue());
                if (faulty.contains(cTBookmark)) continue;
                faulty.add(cTBookmark);
                continue;
            }
            if (name == null) {
                this.write("Name missing for id " + id.longValue());
                if (startIds.add(id)) continue;
                this.write(".. and already have id " + id.longValue());
                faulty.add(cTBookmark);
                continue;
            }
            if (id != null) continue;
            this.write("ID missing for name " + name);
            if (names.add(name)) continue;
            this.write(".. and already have name " + name);
            faulty.add(cTBookmark);
        }
        this.write("Checking ends ");
        for (CTMarkupRange cTMarkupRange : rt.getEnds()) {
            id = cTMarkupRange.getId();
            if (id == null) {
                this.write("ID missing!");
                faulty.add(cTMarkupRange);
                continue;
            }
            if (id == null || endIds.add(id)) continue;
            this.write("Already have " + id.longValue());
            faulty.add(cTMarkupRange);
        }
        this.write("Matching ends");
        for (BigInteger bigInteger : startIds) {
            if (endIds.contains(bigInteger)) continue;
            this.write("  Missing end for start " + bigInteger.longValue());
            faulty.add(this.find(rt.getStarts(), bigInteger));
        }
        this.write("Matching starts");
        for (BigInteger bigInteger : endIds) {
            if (startIds.contains(bigInteger)) continue;
            this.write("  Missing start for end " + bigInteger.longValue());
            faulty.add(this.findEnds(rt.getEnds(), bigInteger));
        }
        this.write("Total faulty objects: " + faulty.size());
        return faulty;
    }

    private CTBookmark find(List<CTBookmark> starts, BigInteger id) {
        for (CTBookmark bm : starts) {
            if (bm.getId() != id) continue;
            return bm;
        }
        return null;
    }

    private CTMarkupRange findEnds(List<CTMarkupRange> ends, BigInteger id) {
        for (CTMarkupRange bm : ends) {
            if (bm.getId() != id) continue;
            return bm;
        }
        return null;
    }

    private void write(String s) throws IOException {
        if (this.writer != null) {
            this.writer.write(s + "\n");
        }
    }

    public static enum BookmarksStatus {
        FIXED,
        OK,
        BROKEN;

    }
}

