/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.toc;

import jakarta.xml.bind.JAXBElement;
import java.util.ArrayList;
import java.util.List;
import org.docx4j.TraversalUtil;
import org.docx4j.XmlUtils;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.toc.TocException;
import org.docx4j.toc.TocSdtUtils;
import org.docx4j.wml.CTSdtDocPart;
import org.docx4j.wml.CTSimpleField;
import org.docx4j.wml.FldChar;
import org.docx4j.wml.P;
import org.docx4j.wml.STFldCharType;
import org.docx4j.wml.SdtBlock;
import org.docx4j.wml.SdtContent;
import org.docx4j.wml.SdtContentBlock;
import org.docx4j.wml.SdtPr;
import org.docx4j.wml.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TocIntoSdt {
    private static Logger log = LoggerFactory.getLogger(TocIntoSdt.class);

    public SdtBlock process(WordprocessingMLPackage wordMLPackage) throws TocException {
        List<Object> topLevelContent = wordMLPackage.getMainDocumentPart().getContent();
        TocFinder finder = new TocFinder();
        new TraversalUtil(topLevelContent, finder);
        int fromIndex = topLevelContent.indexOf(finder.pFirst);
        int toIndex = topLevelContent.indexOf(finder.pLast);
        if (fromIndex < 0 || toIndex < 0) {
            throw new TocException("Couldn't find TOC field");
        }
        ArrayList<Object> rangeList = new ArrayList<Object>(topLevelContent.subList(fromIndex, toIndex + 1));
        SdtBlock sdtBlock = TocSdtUtils.createSdt();
        SdtContentBlock sdtContent = TocSdtUtils.createSdtContent();
        sdtBlock.setSdtContent((SdtContent)sdtContent);
        sdtContent.getContent().addAll(rangeList);
        topLevelContent.subList(fromIndex, toIndex + 1).clear();
        topLevelContent.add(fromIndex, sdtBlock);
        return sdtBlock;
    }

    static class TocFinder
    extends TraversalUtil.CallbackImpl {
        P pFirst = null;
        P pLast = null;
        int depth = 0;
        String tocInstruction = null;
        private SdtBlock currentSDT = null;
        private boolean inToC = false;
        P currentP = null;

        TocFinder() {
        }

        @Override
        public List<Object> apply(Object wrapped) {
            Object unwrapped = XmlUtils.unwrap(wrapped);
            if (unwrapped instanceof P) {
                this.currentP = (P)unwrapped;
            }
            if (this.currentSDT == null || !this.isDocPartToC(this.currentSDT)) {
                CTSimpleField fldSimple;
                if (unwrapped instanceof FldChar) {
                    FldChar fldChar = (FldChar)unwrapped;
                    log.debug("FldChar " + fldChar.getFldCharType());
                    if (fldChar.getFldCharType().equals((Object)STFldCharType.BEGIN)) {
                        log.debug("Found a BEGIN, depth " + this.depth);
                        if (this.depth == 0) {
                            this.pFirst = this.currentP;
                        }
                        ++this.depth;
                    }
                    if (fldChar.getFldCharType().equals((Object)STFldCharType.END)) {
                        log.debug("Found an END, depth " + this.depth);
                        if (this.inToC && this.depth == 1) {
                            this.pLast = this.currentP;
                        }
                        --this.depth;
                    }
                } else if (wrapped instanceof JAXBElement && ((JAXBElement)wrapped).getName().getLocalPart().equals("instrText")) {
                    Text instr = (Text)unwrapped;
                    if (instr.getValue().contains("TOC")) {
                        this.tocInstruction = instr.getValue();
                        this.inToC = true;
                        log.debug("found complex field instruction!");
                    }
                } else if ((unwrapped instanceof CTSimpleField || wrapped instanceof JAXBElement && ((JAXBElement)wrapped).getName().getLocalPart().equals("fldSimple")) && (fldSimple = (CTSimpleField)XmlUtils.unwrap(wrapped)).getInstr().contains("TOC")) {
                    this.tocInstruction = fldSimple.getInstr();
                    this.inToC = true;
                    log.debug("found simple field instruction!");
                    this.pFirst = this.currentP;
                    this.pLast = this.currentP;
                }
            }
            return null;
        }

        private boolean isDocPartToC(SdtBlock currentSDT) {
            SdtPr sdtPr = currentSDT.getSdtPr();
            CTSdtDocPart docPart = this.getDocPartObj(sdtPr);
            return docPart != null && docPart.getDocPartGallery() != null && docPart.getDocPartGallery().getVal() != null && docPart.getDocPartGallery().getVal().equals("Table of Contents");
        }

        private CTSdtDocPart getDocPartObj(SdtPr sdtPr) {
            if (sdtPr == null) {
                return null;
            }
            for (Object o : sdtPr.getRPrOrAliasOrLock()) {
                if (!(XmlUtils.unwrap(o) instanceof CTSdtDocPart)) continue;
                return (CTSdtDocPart)XmlUtils.unwrap(o);
            }
            return null;
        }

        @Override
        public void walkJAXBElements(Object parent) {
            List<Object> children = this.getChildren(parent);
            if (children != null) {
                for (Object o : children) {
                    this.apply(o);
                    if (!this.shouldTraverse(o = XmlUtils.unwrap(o))) continue;
                    if (o instanceof SdtBlock) {
                        this.currentSDT = (SdtBlock)o;
                        this.walkJAXBElements(o);
                        this.currentSDT = null;
                        continue;
                    }
                    this.walkJAXBElements(o);
                }
            }
        }

        @Override
        public List<Object> getChildren(Object o) {
            return TraversalUtil.getChildrenImpl(o);
        }

        @Override
        public boolean shouldTraverse(Object o) {
            return this.pLast == null;
        }
    }
}

