/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.fonts.fop.fonts.autodetect;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.DirectoryWalker;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.docx4j.fonts.fop.fonts.FontEventListener;
import org.docx4j.fonts.fop.fonts.autodetect.FontDirFinder;
import org.docx4j.fonts.fop.fonts.autodetect.FontFinder;
import org.docx4j.fonts.fop.fonts.autodetect.MacFontDirFinder;
import org.docx4j.fonts.fop.fonts.autodetect.UnixFontDirFinder;
import org.docx4j.fonts.fop.fonts.autodetect.WindowsFontDirFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FontFileFinder
extends DirectoryWalker
implements FontFinder {
    private final Logger log = LoggerFactory.getLogger(FontFileFinder.class);
    public static final int DEFAULT_DEPTH_LIMIT = -1;
    private final FontEventListener eventListener;

    public FontFileFinder(FontEventListener listener) {
        this(-1, listener);
    }

    public FontFileFinder(int depthLimit, FontEventListener listener) {
        super(FontFileFinder.getDirectoryFilter(), FontFileFinder.getFileFilter(), depthLimit);
        this.eventListener = listener;
    }

    protected static IOFileFilter getDirectoryFilter() {
        return FileFilterUtils.andFileFilter((IOFileFilter)FileFilterUtils.directoryFileFilter(), (IOFileFilter)FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.prefixFileFilter((String)".")));
    }

    protected static IOFileFilter getFileFilter() {
        return FileFilterUtils.andFileFilter((IOFileFilter)FileFilterUtils.fileFileFilter(), (IOFileFilter)new WildcardFileFilter(new String[]{"*.ttf", "*.otf", "*.pfb", "*.ttc"}, IOCase.INSENSITIVE));
    }

    protected boolean handleDirectory(File directory, int depth, Collection results) {
        return true;
    }

    protected void handleFile(File file, int depth, Collection results) {
        try {
            results.add(file.toURI().toURL());
        }
        catch (MalformedURLException e) {
            this.log.debug("MalformedURLException" + e.getMessage());
        }
    }

    protected void handleDirectoryEnd(File directory, int depth, Collection results) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(directory + ": found " + results.size() + " font" + (results.size() == 1 ? "" : "s"));
        }
    }

    @Override
    public List<URL> find() throws IOException {
        String osName = System.getProperty("os.name");
        FontDirFinder fontDirFinder = osName.startsWith("Windows") ? new WindowsFontDirFinder() : (osName.startsWith("Mac") ? new MacFontDirFinder() : new UnixFontDirFinder());
        List<File> fontDirs = fontDirFinder.find();
        ArrayList<URL> results = new ArrayList<URL>();
        for (File dir : fontDirs) {
            super.walk(dir, results);
        }
        return results;
    }

    public List<URL> find(String dir) throws IOException {
        ArrayList<URL> results = new ArrayList<URL>();
        File directory = new File(dir);
        if (!directory.isDirectory()) {
            this.eventListener.fontDirectoryNotFound(this, dir);
        } else {
            super.walk(directory, results);
        }
        return results;
    }
}

