/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.fields.docvariable;

import java.util.HashMap;
import org.docx4j.model.fields.FieldFormattingException;
import org.docx4j.model.fields.FieldValueException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.wml.CTDocVar;
import org.docx4j.wml.CTDocVars;
import org.docx4j.wml.CTSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocVariableResolver {
    private static Logger log = LoggerFactory.getLogger(DocVariableResolver.class);
    private HashMap<String, String> docVarMap = new HashMap();

    public DocVariableResolver(WordprocessingMLPackage wordMLPackage) {
        CTSettings settings;
        CTSettings cTSettings = settings = wordMLPackage.getMainDocumentPart().getDocumentSettingsPart() == null ? null : (CTSettings)wordMLPackage.getMainDocumentPart().getDocumentSettingsPart().getJaxbElement();
        if (settings != null && settings.getDocVars() != null) {
            CTDocVars docvars = settings.getDocVars();
            for (CTDocVar docvar : docvars.getDocVar()) {
                this.docVarMap.put(docvar.getName(), docvar.getVal());
            }
        }
    }

    public String getValue(String key) throws FieldFormattingException, FieldValueException {
        String value = this.docVarMap.get(key);
        if (value == null) {
            throw new FieldValueException("No value found for DOCVARIABLE " + key);
        }
        return value;
    }
}

