/*
 * {{{ header & license
 * Copyright (c) 2007 Sean Bright
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * }}}
 */
package org.docx4j.org.xhtmlrenderer.simple.extend.form;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JComponent;

import org.docx4j.org.xhtmlrenderer.layout.LayoutContext;
import org.docx4j.org.xhtmlrenderer.render.BlockBox;
import org.docx4j.org.xhtmlrenderer.simple.extend.XhtmlForm;
import org.docx4j.org.xhtmlrenderer.util.XRLog;
import org.w3c.dom.Element;

class ResetField extends AbstractButtonField {
    public ResetField(Element e, XhtmlForm form, LayoutContext context, BlockBox box) {
        super(e, form, context, box);
    }
    
    public JComponent create() {
        JButton button = new JButton();

        String value;
        if (hasAttribute("value")) {
            value = getAttribute("value");
            if (value.length() == 0)
                value = " ";    //otherwise we get a very short button
        }
        else {
            value = "Reset";
        }

        applyComponentStyle(button);

        button.setText(value);
        
        button.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent event) {
                XRLog.layout("Reset pressed: Restore");
                
                getParentForm().reset();
            }
        });

        return button;
    }
    
    public boolean includeInSubmission(JComponent source) {
        return false;
    }

    protected String[] getFieldValues() {
        return new String[] {
                hasAttribute("value") ? getAttribute("value") : "Reset" // TODO: Don't hardcode 
        };
    }
}
