/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.common.entity;

import org.dromara.dynamictp.common.entity.Metrics;

public class ThreadPoolStats
extends Metrics {
    private String poolName;
    private String poolAliasName;
    private int corePoolSize;
    private int maximumPoolSize;
    private String queueType;
    private int queueCapacity;
    private int queueSize;
    private boolean fair;
    private int queueRemainingCapacity;
    private int activeCount;
    private long taskCount;
    private long completedTaskCount;
    private int largestPoolSize;
    private int poolSize;
    private int waitTaskCount;
    private long rejectCount;
    private String rejectHandlerName;
    private boolean dynamic;
    private long runTimeoutCount;
    private long queueTimeoutCount;
    private double tps;
    private long maxRt;
    private long minRt;
    private double avg;
    private double tp50;
    private double tp75;
    private double tp90;
    private double tp95;
    private double tp99;
    private double tp999;

    ThreadPoolStats(String poolName, String poolAliasName, int corePoolSize, int maximumPoolSize, String queueType, int queueCapacity, int queueSize, boolean fair, int queueRemainingCapacity, int activeCount, long taskCount, long completedTaskCount, int largestPoolSize, int poolSize, int waitTaskCount, long rejectCount, String rejectHandlerName, boolean dynamic, long runTimeoutCount, long queueTimeoutCount, double tps, long maxRt, long minRt, double avg, double tp50, double tp75, double tp90, double tp95, double tp99, double tp999) {
        this.poolName = poolName;
        this.poolAliasName = poolAliasName;
        this.corePoolSize = corePoolSize;
        this.maximumPoolSize = maximumPoolSize;
        this.queueType = queueType;
        this.queueCapacity = queueCapacity;
        this.queueSize = queueSize;
        this.fair = fair;
        this.queueRemainingCapacity = queueRemainingCapacity;
        this.activeCount = activeCount;
        this.taskCount = taskCount;
        this.completedTaskCount = completedTaskCount;
        this.largestPoolSize = largestPoolSize;
        this.poolSize = poolSize;
        this.waitTaskCount = waitTaskCount;
        this.rejectCount = rejectCount;
        this.rejectHandlerName = rejectHandlerName;
        this.dynamic = dynamic;
        this.runTimeoutCount = runTimeoutCount;
        this.queueTimeoutCount = queueTimeoutCount;
        this.tps = tps;
        this.maxRt = maxRt;
        this.minRt = minRt;
        this.avg = avg;
        this.tp50 = tp50;
        this.tp75 = tp75;
        this.tp90 = tp90;
        this.tp95 = tp95;
        this.tp99 = tp99;
        this.tp999 = tp999;
    }

    public static ThreadPoolStatsBuilder builder() {
        return new ThreadPoolStatsBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ThreadPoolStats)) {
            return false;
        }
        ThreadPoolStats other = (ThreadPoolStats)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getCorePoolSize() != other.getCorePoolSize()) {
            return false;
        }
        if (this.getMaximumPoolSize() != other.getMaximumPoolSize()) {
            return false;
        }
        if (this.getQueueCapacity() != other.getQueueCapacity()) {
            return false;
        }
        if (this.getQueueSize() != other.getQueueSize()) {
            return false;
        }
        if (this.isFair() != other.isFair()) {
            return false;
        }
        if (this.getQueueRemainingCapacity() != other.getQueueRemainingCapacity()) {
            return false;
        }
        if (this.getActiveCount() != other.getActiveCount()) {
            return false;
        }
        if (this.getTaskCount() != other.getTaskCount()) {
            return false;
        }
        if (this.getCompletedTaskCount() != other.getCompletedTaskCount()) {
            return false;
        }
        if (this.getLargestPoolSize() != other.getLargestPoolSize()) {
            return false;
        }
        if (this.getPoolSize() != other.getPoolSize()) {
            return false;
        }
        if (this.getWaitTaskCount() != other.getWaitTaskCount()) {
            return false;
        }
        if (this.getRejectCount() != other.getRejectCount()) {
            return false;
        }
        if (this.isDynamic() != other.isDynamic()) {
            return false;
        }
        if (this.getRunTimeoutCount() != other.getRunTimeoutCount()) {
            return false;
        }
        if (this.getQueueTimeoutCount() != other.getQueueTimeoutCount()) {
            return false;
        }
        if (Double.compare(this.getTps(), other.getTps()) != 0) {
            return false;
        }
        if (this.getMaxRt() != other.getMaxRt()) {
            return false;
        }
        if (this.getMinRt() != other.getMinRt()) {
            return false;
        }
        if (Double.compare(this.getAvg(), other.getAvg()) != 0) {
            return false;
        }
        if (Double.compare(this.getTp50(), other.getTp50()) != 0) {
            return false;
        }
        if (Double.compare(this.getTp75(), other.getTp75()) != 0) {
            return false;
        }
        if (Double.compare(this.getTp90(), other.getTp90()) != 0) {
            return false;
        }
        if (Double.compare(this.getTp95(), other.getTp95()) != 0) {
            return false;
        }
        if (Double.compare(this.getTp99(), other.getTp99()) != 0) {
            return false;
        }
        if (Double.compare(this.getTp999(), other.getTp999()) != 0) {
            return false;
        }
        String this$poolName = this.getPoolName();
        String other$poolName = other.getPoolName();
        if (this$poolName == null ? other$poolName != null : !this$poolName.equals(other$poolName)) {
            return false;
        }
        String this$poolAliasName = this.getPoolAliasName();
        String other$poolAliasName = other.getPoolAliasName();
        if (this$poolAliasName == null ? other$poolAliasName != null : !this$poolAliasName.equals(other$poolAliasName)) {
            return false;
        }
        String this$queueType = this.getQueueType();
        String other$queueType = other.getQueueType();
        if (this$queueType == null ? other$queueType != null : !this$queueType.equals(other$queueType)) {
            return false;
        }
        String this$rejectHandlerName = this.getRejectHandlerName();
        String other$rejectHandlerName = other.getRejectHandlerName();
        return !(this$rejectHandlerName == null ? other$rejectHandlerName != null : !this$rejectHandlerName.equals(other$rejectHandlerName));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ThreadPoolStats;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getCorePoolSize();
        result = result * 59 + this.getMaximumPoolSize();
        result = result * 59 + this.getQueueCapacity();
        result = result * 59 + this.getQueueSize();
        result = result * 59 + (this.isFair() ? 79 : 97);
        result = result * 59 + this.getQueueRemainingCapacity();
        result = result * 59 + this.getActiveCount();
        long $taskCount = this.getTaskCount();
        result = result * 59 + (int)($taskCount >>> 32 ^ $taskCount);
        long $completedTaskCount = this.getCompletedTaskCount();
        result = result * 59 + (int)($completedTaskCount >>> 32 ^ $completedTaskCount);
        result = result * 59 + this.getLargestPoolSize();
        result = result * 59 + this.getPoolSize();
        result = result * 59 + this.getWaitTaskCount();
        long $rejectCount = this.getRejectCount();
        result = result * 59 + (int)($rejectCount >>> 32 ^ $rejectCount);
        result = result * 59 + (this.isDynamic() ? 79 : 97);
        long $runTimeoutCount = this.getRunTimeoutCount();
        result = result * 59 + (int)($runTimeoutCount >>> 32 ^ $runTimeoutCount);
        long $queueTimeoutCount = this.getQueueTimeoutCount();
        result = result * 59 + (int)($queueTimeoutCount >>> 32 ^ $queueTimeoutCount);
        long $tps = Double.doubleToLongBits(this.getTps());
        result = result * 59 + (int)($tps >>> 32 ^ $tps);
        long $maxRt = this.getMaxRt();
        result = result * 59 + (int)($maxRt >>> 32 ^ $maxRt);
        long $minRt = this.getMinRt();
        result = result * 59 + (int)($minRt >>> 32 ^ $minRt);
        long $avg = Double.doubleToLongBits(this.getAvg());
        result = result * 59 + (int)($avg >>> 32 ^ $avg);
        long $tp50 = Double.doubleToLongBits(this.getTp50());
        result = result * 59 + (int)($tp50 >>> 32 ^ $tp50);
        long $tp75 = Double.doubleToLongBits(this.getTp75());
        result = result * 59 + (int)($tp75 >>> 32 ^ $tp75);
        long $tp90 = Double.doubleToLongBits(this.getTp90());
        result = result * 59 + (int)($tp90 >>> 32 ^ $tp90);
        long $tp95 = Double.doubleToLongBits(this.getTp95());
        result = result * 59 + (int)($tp95 >>> 32 ^ $tp95);
        long $tp99 = Double.doubleToLongBits(this.getTp99());
        result = result * 59 + (int)($tp99 >>> 32 ^ $tp99);
        long $tp999 = Double.doubleToLongBits(this.getTp999());
        result = result * 59 + (int)($tp999 >>> 32 ^ $tp999);
        String $poolName = this.getPoolName();
        result = result * 59 + ($poolName == null ? 43 : $poolName.hashCode());
        String $poolAliasName = this.getPoolAliasName();
        result = result * 59 + ($poolAliasName == null ? 43 : $poolAliasName.hashCode());
        String $queueType = this.getQueueType();
        result = result * 59 + ($queueType == null ? 43 : $queueType.hashCode());
        String $rejectHandlerName = this.getRejectHandlerName();
        result = result * 59 + ($rejectHandlerName == null ? 43 : $rejectHandlerName.hashCode());
        return result;
    }

    public String getPoolName() {
        return this.poolName;
    }

    public String getPoolAliasName() {
        return this.poolAliasName;
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    public String getQueueType() {
        return this.queueType;
    }

    public int getQueueCapacity() {
        return this.queueCapacity;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public boolean isFair() {
        return this.fair;
    }

    public int getQueueRemainingCapacity() {
        return this.queueRemainingCapacity;
    }

    public int getActiveCount() {
        return this.activeCount;
    }

    public long getTaskCount() {
        return this.taskCount;
    }

    public long getCompletedTaskCount() {
        return this.completedTaskCount;
    }

    public int getLargestPoolSize() {
        return this.largestPoolSize;
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public int getWaitTaskCount() {
        return this.waitTaskCount;
    }

    public long getRejectCount() {
        return this.rejectCount;
    }

    public String getRejectHandlerName() {
        return this.rejectHandlerName;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public long getRunTimeoutCount() {
        return this.runTimeoutCount;
    }

    public long getQueueTimeoutCount() {
        return this.queueTimeoutCount;
    }

    public double getTps() {
        return this.tps;
    }

    public long getMaxRt() {
        return this.maxRt;
    }

    public long getMinRt() {
        return this.minRt;
    }

    public double getAvg() {
        return this.avg;
    }

    public double getTp50() {
        return this.tp50;
    }

    public double getTp75() {
        return this.tp75;
    }

    public double getTp90() {
        return this.tp90;
    }

    public double getTp95() {
        return this.tp95;
    }

    public double getTp99() {
        return this.tp99;
    }

    public double getTp999() {
        return this.tp999;
    }

    public void setPoolName(String poolName) {
        this.poolName = poolName;
    }

    public void setPoolAliasName(String poolAliasName) {
        this.poolAliasName = poolAliasName;
    }

    public void setCorePoolSize(int corePoolSize) {
        this.corePoolSize = corePoolSize;
    }

    public void setMaximumPoolSize(int maximumPoolSize) {
        this.maximumPoolSize = maximumPoolSize;
    }

    public void setQueueType(String queueType) {
        this.queueType = queueType;
    }

    public void setQueueCapacity(int queueCapacity) {
        this.queueCapacity = queueCapacity;
    }

    public void setQueueSize(int queueSize) {
        this.queueSize = queueSize;
    }

    public void setFair(boolean fair) {
        this.fair = fair;
    }

    public void setQueueRemainingCapacity(int queueRemainingCapacity) {
        this.queueRemainingCapacity = queueRemainingCapacity;
    }

    public void setActiveCount(int activeCount) {
        this.activeCount = activeCount;
    }

    public void setTaskCount(long taskCount) {
        this.taskCount = taskCount;
    }

    public void setCompletedTaskCount(long completedTaskCount) {
        this.completedTaskCount = completedTaskCount;
    }

    public void setLargestPoolSize(int largestPoolSize) {
        this.largestPoolSize = largestPoolSize;
    }

    public void setPoolSize(int poolSize) {
        this.poolSize = poolSize;
    }

    public void setWaitTaskCount(int waitTaskCount) {
        this.waitTaskCount = waitTaskCount;
    }

    public void setRejectCount(long rejectCount) {
        this.rejectCount = rejectCount;
    }

    public void setRejectHandlerName(String rejectHandlerName) {
        this.rejectHandlerName = rejectHandlerName;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    public void setRunTimeoutCount(long runTimeoutCount) {
        this.runTimeoutCount = runTimeoutCount;
    }

    public void setQueueTimeoutCount(long queueTimeoutCount) {
        this.queueTimeoutCount = queueTimeoutCount;
    }

    public void setTps(double tps) {
        this.tps = tps;
    }

    public void setMaxRt(long maxRt) {
        this.maxRt = maxRt;
    }

    public void setMinRt(long minRt) {
        this.minRt = minRt;
    }

    public void setAvg(double avg) {
        this.avg = avg;
    }

    public void setTp50(double tp50) {
        this.tp50 = tp50;
    }

    public void setTp75(double tp75) {
        this.tp75 = tp75;
    }

    public void setTp90(double tp90) {
        this.tp90 = tp90;
    }

    public void setTp95(double tp95) {
        this.tp95 = tp95;
    }

    public void setTp99(double tp99) {
        this.tp99 = tp99;
    }

    public void setTp999(double tp999) {
        this.tp999 = tp999;
    }

    @Override
    public String toString() {
        return "ThreadPoolStats(poolName=" + this.getPoolName() + ", poolAliasName=" + this.getPoolAliasName() + ", corePoolSize=" + this.getCorePoolSize() + ", maximumPoolSize=" + this.getMaximumPoolSize() + ", queueType=" + this.getQueueType() + ", queueCapacity=" + this.getQueueCapacity() + ", queueSize=" + this.getQueueSize() + ", fair=" + this.isFair() + ", queueRemainingCapacity=" + this.getQueueRemainingCapacity() + ", activeCount=" + this.getActiveCount() + ", taskCount=" + this.getTaskCount() + ", completedTaskCount=" + this.getCompletedTaskCount() + ", largestPoolSize=" + this.getLargestPoolSize() + ", poolSize=" + this.getPoolSize() + ", waitTaskCount=" + this.getWaitTaskCount() + ", rejectCount=" + this.getRejectCount() + ", rejectHandlerName=" + this.getRejectHandlerName() + ", dynamic=" + this.isDynamic() + ", runTimeoutCount=" + this.getRunTimeoutCount() + ", queueTimeoutCount=" + this.getQueueTimeoutCount() + ", tps=" + this.getTps() + ", maxRt=" + this.getMaxRt() + ", minRt=" + this.getMinRt() + ", avg=" + this.getAvg() + ", tp50=" + this.getTp50() + ", tp75=" + this.getTp75() + ", tp90=" + this.getTp90() + ", tp95=" + this.getTp95() + ", tp99=" + this.getTp99() + ", tp999=" + this.getTp999() + ")";
    }

    public static class ThreadPoolStatsBuilder {
        private String poolName;
        private String poolAliasName;
        private int corePoolSize;
        private int maximumPoolSize;
        private String queueType;
        private int queueCapacity;
        private int queueSize;
        private boolean fair;
        private int queueRemainingCapacity;
        private int activeCount;
        private long taskCount;
        private long completedTaskCount;
        private int largestPoolSize;
        private int poolSize;
        private int waitTaskCount;
        private long rejectCount;
        private String rejectHandlerName;
        private boolean dynamic;
        private long runTimeoutCount;
        private long queueTimeoutCount;
        private double tps;
        private long maxRt;
        private long minRt;
        private double avg;
        private double tp50;
        private double tp75;
        private double tp90;
        private double tp95;
        private double tp99;
        private double tp999;

        ThreadPoolStatsBuilder() {
        }

        public ThreadPoolStatsBuilder poolName(String poolName) {
            this.poolName = poolName;
            return this;
        }

        public ThreadPoolStatsBuilder poolAliasName(String poolAliasName) {
            this.poolAliasName = poolAliasName;
            return this;
        }

        public ThreadPoolStatsBuilder corePoolSize(int corePoolSize) {
            this.corePoolSize = corePoolSize;
            return this;
        }

        public ThreadPoolStatsBuilder maximumPoolSize(int maximumPoolSize) {
            this.maximumPoolSize = maximumPoolSize;
            return this;
        }

        public ThreadPoolStatsBuilder queueType(String queueType) {
            this.queueType = queueType;
            return this;
        }

        public ThreadPoolStatsBuilder queueCapacity(int queueCapacity) {
            this.queueCapacity = queueCapacity;
            return this;
        }

        public ThreadPoolStatsBuilder queueSize(int queueSize) {
            this.queueSize = queueSize;
            return this;
        }

        public ThreadPoolStatsBuilder fair(boolean fair) {
            this.fair = fair;
            return this;
        }

        public ThreadPoolStatsBuilder queueRemainingCapacity(int queueRemainingCapacity) {
            this.queueRemainingCapacity = queueRemainingCapacity;
            return this;
        }

        public ThreadPoolStatsBuilder activeCount(int activeCount) {
            this.activeCount = activeCount;
            return this;
        }

        public ThreadPoolStatsBuilder taskCount(long taskCount) {
            this.taskCount = taskCount;
            return this;
        }

        public ThreadPoolStatsBuilder completedTaskCount(long completedTaskCount) {
            this.completedTaskCount = completedTaskCount;
            return this;
        }

        public ThreadPoolStatsBuilder largestPoolSize(int largestPoolSize) {
            this.largestPoolSize = largestPoolSize;
            return this;
        }

        public ThreadPoolStatsBuilder poolSize(int poolSize) {
            this.poolSize = poolSize;
            return this;
        }

        public ThreadPoolStatsBuilder waitTaskCount(int waitTaskCount) {
            this.waitTaskCount = waitTaskCount;
            return this;
        }

        public ThreadPoolStatsBuilder rejectCount(long rejectCount) {
            this.rejectCount = rejectCount;
            return this;
        }

        public ThreadPoolStatsBuilder rejectHandlerName(String rejectHandlerName) {
            this.rejectHandlerName = rejectHandlerName;
            return this;
        }

        public ThreadPoolStatsBuilder dynamic(boolean dynamic) {
            this.dynamic = dynamic;
            return this;
        }

        public ThreadPoolStatsBuilder runTimeoutCount(long runTimeoutCount) {
            this.runTimeoutCount = runTimeoutCount;
            return this;
        }

        public ThreadPoolStatsBuilder queueTimeoutCount(long queueTimeoutCount) {
            this.queueTimeoutCount = queueTimeoutCount;
            return this;
        }

        public ThreadPoolStatsBuilder tps(double tps) {
            this.tps = tps;
            return this;
        }

        public ThreadPoolStatsBuilder maxRt(long maxRt) {
            this.maxRt = maxRt;
            return this;
        }

        public ThreadPoolStatsBuilder minRt(long minRt) {
            this.minRt = minRt;
            return this;
        }

        public ThreadPoolStatsBuilder avg(double avg) {
            this.avg = avg;
            return this;
        }

        public ThreadPoolStatsBuilder tp50(double tp50) {
            this.tp50 = tp50;
            return this;
        }

        public ThreadPoolStatsBuilder tp75(double tp75) {
            this.tp75 = tp75;
            return this;
        }

        public ThreadPoolStatsBuilder tp90(double tp90) {
            this.tp90 = tp90;
            return this;
        }

        public ThreadPoolStatsBuilder tp95(double tp95) {
            this.tp95 = tp95;
            return this;
        }

        public ThreadPoolStatsBuilder tp99(double tp99) {
            this.tp99 = tp99;
            return this;
        }

        public ThreadPoolStatsBuilder tp999(double tp999) {
            this.tp999 = tp999;
            return this;
        }

        public ThreadPoolStats build() {
            return new ThreadPoolStats(this.poolName, this.poolAliasName, this.corePoolSize, this.maximumPoolSize, this.queueType, this.queueCapacity, this.queueSize, this.fair, this.queueRemainingCapacity, this.activeCount, this.taskCount, this.completedTaskCount, this.largestPoolSize, this.poolSize, this.waitTaskCount, this.rejectCount, this.rejectHandlerName, this.dynamic, this.runTimeoutCount, this.queueTimeoutCount, this.tps, this.maxRt, this.minRt, this.avg, this.tp50, this.tp75, this.tp90, this.tp95, this.tp99, this.tp999);
        }

        public String toString() {
            return "ThreadPoolStats.ThreadPoolStatsBuilder(poolName=" + this.poolName + ", poolAliasName=" + this.poolAliasName + ", corePoolSize=" + this.corePoolSize + ", maximumPoolSize=" + this.maximumPoolSize + ", queueType=" + this.queueType + ", queueCapacity=" + this.queueCapacity + ", queueSize=" + this.queueSize + ", fair=" + this.fair + ", queueRemainingCapacity=" + this.queueRemainingCapacity + ", activeCount=" + this.activeCount + ", taskCount=" + this.taskCount + ", completedTaskCount=" + this.completedTaskCount + ", largestPoolSize=" + this.largestPoolSize + ", poolSize=" + this.poolSize + ", waitTaskCount=" + this.waitTaskCount + ", rejectCount=" + this.rejectCount + ", rejectHandlerName=" + this.rejectHandlerName + ", dynamic=" + this.dynamic + ", runTimeoutCount=" + this.runTimeoutCount + ", queueTimeoutCount=" + this.queueTimeoutCount + ", tps=" + this.tps + ", maxRt=" + this.maxRt + ", minRt=" + this.minRt + ", avg=" + this.avg + ", tp50=" + this.tp50 + ", tp75=" + this.tp75 + ", tp90=" + this.tp90 + ", tp95=" + this.tp95 + ", tp99=" + this.tp99 + ", tp999=" + this.tp999 + ")";
        }
    }
}

