/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.common.parser.config;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.dromara.dynamictp.common.em.ConfigFileTypeEnum;
import org.dromara.dynamictp.common.parser.config.AbstractConfigParser;
import org.springframework.beans.factory.config.YamlPropertiesFactoryBean;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;

public class YamlConfigParser
extends AbstractConfigParser {
    private static final List<ConfigFileTypeEnum> CONFIG_TYPES = Lists.newArrayList((Object[])new ConfigFileTypeEnum[]{ConfigFileTypeEnum.YML, ConfigFileTypeEnum.YAML});

    @Override
    public List<ConfigFileTypeEnum> types() {
        return CONFIG_TYPES;
    }

    @Override
    public Map<Object, Object> doParse(String content) {
        if (StringUtils.isEmpty((CharSequence)content)) {
            return Collections.emptyMap();
        }
        YamlPropertiesFactoryBean bean = new YamlPropertiesFactoryBean();
        bean.setResources(new Resource[]{new ByteArrayResource(content.getBytes())});
        return bean.getObject();
    }
}

