/*
 * Decompiled with CFR 0.152.
 */
package org.drools.model.functions.temporal;

import java.util.concurrent.TimeUnit;
import org.drools.model.functions.temporal.AbstractTemporalPredicate;
import org.drools.model.functions.temporal.Interval;
import org.drools.model.functions.temporal.TimeUtil;

public class BeforePredicate
extends AbstractTemporalPredicate {
    private final long initRange;
    private final long finalRange;

    public BeforePredicate() {
        this(0L, Long.MAX_VALUE);
    }

    public BeforePredicate(long dev, TimeUnit devUnit) {
        this(TimeUtil.unitToLong(dev, devUnit), Long.MAX_VALUE);
    }

    public BeforePredicate(long startDev, TimeUnit startDevUnit, long endDev, TimeUnit endDevUnit) {
        this(TimeUtil.unitToLong(startDev, startDevUnit), TimeUtil.unitToLong(endDev, endDevUnit));
    }

    private BeforePredicate(long initRange, long finalRange) {
        this.initRange = initRange;
        this.finalRange = finalRange;
    }

    public String toString() {
        return (this.negated ? "not " : "") + "before[" + this.initRange + ", " + this.finalRange + "]";
    }

    @Override
    public boolean evaluate(long start1, long duration1, long end1, long start2, long duration2, long end2) {
        long diff = start2 - end1;
        return this.negated ^ (diff >= this.initRange && diff <= this.finalRange);
    }

    @Override
    public Interval getInterval() {
        long end;
        long init = this.finalRange == Long.MAX_VALUE ? Long.MIN_VALUE : -this.finalRange;
        long l = end = this.initRange == Long.MIN_VALUE ? Long.MAX_VALUE : -this.initRange;
        if (this.negated) {
            if (init == Long.MIN_VALUE && end != Long.MAX_VALUE) {
                init = this.finalRange + 1L;
                end = Long.MAX_VALUE;
            } else if (init != Long.MIN_VALUE && end == Long.MAX_VALUE) {
                init = Long.MIN_VALUE;
                end = this.initRange - 1L;
            } else if (init == Long.MIN_VALUE) {
                init = 0L;
                end = -1L;
            } else {
                init = Long.MIN_VALUE;
                end = Long.MAX_VALUE;
            }
        }
        return new Interval(init, end);
    }
}

