/*
 * Decompiled with CFR 0.152.
 */
package org.drools.model.functions.temporal;

import java.util.concurrent.TimeUnit;
import org.drools.model.functions.temporal.AbstractTemporalPredicate;
import org.drools.model.functions.temporal.Interval;
import org.drools.model.functions.temporal.TimeUtil;

public class CoincidesPredicate
extends AbstractTemporalPredicate {
    private final long startDevLong;
    private final long endDevLong;

    public CoincidesPredicate(long dev, TimeUnit devUnit) {
        this(TimeUtil.unitToLong(dev, devUnit), TimeUtil.unitToLong(dev, devUnit));
    }

    public CoincidesPredicate(long startDev, TimeUnit startDevUnit, long endDev, TimeUnit endDevUnit) {
        this(TimeUtil.unitToLong(startDev, startDevUnit), TimeUtil.unitToLong(endDev, endDevUnit));
    }

    private CoincidesPredicate(long startDev, long endDev) {
        this.startDevLong = startDev;
        this.endDevLong = endDev;
    }

    public String toString() {
        return (this.negated ? "not " : "") + "coincides[" + this.startDevLong + ", " + this.endDevLong + "]";
    }

    @Override
    public Interval getInterval() {
        return this.negated ? new Interval(Long.MIN_VALUE, Long.MAX_VALUE) : new Interval(0L, 0L);
    }

    @Override
    public boolean evaluate(long start1, long duration1, long end1, long start2, long duration2, long end2) {
        long distStart = Math.abs(start2 - start1);
        long distEnd = Math.abs(end2 - end1);
        return this.negated ^ (distStart <= this.startDevLong && distEnd <= this.endDevLong);
    }
}

