/*
 * Decompiled with CFR 0.152.
 */
package org.drools.model.impl;

import org.drools.model.From;
import org.drools.model.Variable;
import org.drools.model.functions.Function1;
import org.drools.model.impl.ModelComponent;

public class FromImpl<T>
implements From<T>,
ModelComponent {
    private final Variable<T> variable;
    private final Function1<T, ?> provider;
    private final boolean reactive;

    public FromImpl(Variable<T> variable) {
        this(variable, null, false);
    }

    public FromImpl(Variable<T> variable, Function1<T, ?> provider) {
        this(variable, provider, false);
    }

    public FromImpl(Variable<T> variable, Function1<T, ?> provider, boolean reactive) {
        this.variable = variable;
        this.provider = provider;
        this.reactive = reactive;
    }

    @Override
    public Variable<T> getVariable() {
        return this.variable;
    }

    @Override
    public Function1<T, ?> getProvider() {
        return this.provider;
    }

    @Override
    public boolean isReactive() {
        return this.reactive;
    }

    @Override
    public boolean isEqualTo(ModelComponent o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FromImpl)) {
            return false;
        }
        FromImpl from = (FromImpl)o;
        if (this.reactive != from.reactive) {
            return false;
        }
        if (!ModelComponent.areEqualInModel(this.variable, from.variable)) {
            return false;
        }
        return this.provider != null ? this.provider.equals(from.provider) : from.provider == null;
    }
}

