lexer grammar DRL;
@header {
	package org.drools.lang;
}

T72 : ';' ;
T73 : '.*' ;
T74 : ':' ;
T75 : '->' ;
T76 : '==' ;
T77 : '>' ;
T78 : '>=' ;
T79 : '<' ;
T80 : '<=' ;
T81 : '!=' ;

// $ANTLR src "/home/etirelli/workspace/jboss/jbrules-4.0.x/drools-compiler/src/main/resources/org/drools/lang/DRL.g" 1692
WS      :       (	' '
                |	'\t'
                |	'\f'
                |	EOL
                )+
                { $channel=HIDDEN; }
        ;

// $ANTLR src "/home/etirelli/workspace/jboss/jbrules-4.0.x/drools-compiler/src/main/resources/org/drools/lang/DRL.g" 1700
fragment
EOL 	:	     
   		(       ( '\r\n' )=> '\r\n'  // Evil DOS
                |       '\r'    // Macintosh
                |       '\n'    // Unix (the right way)
                )
        ;  
        
// $ANTLR src "/home/etirelli/workspace/jboss/jbrules-4.0.x/drools-compiler/src/main/resources/org/drools/lang/DRL.g" 1708
INT	
	:	('-')?('0'..'9')+
		;

// $ANTLR src "/home/etirelli/workspace/jboss/jbrules-4.0.x/drools-compiler/src/main/resources/org/drools/lang/DRL.g" 1712
FLOAT
	:	('-')?('0'..'9')+ '.' ('0'..'9')+
	;

// $ANTLR src "/home/etirelli/workspace/jboss/jbrules-4.0.x/drools-compiler/src/main/resources/org/drools/lang/DRL.g" 1716
STRING
    :  ('"' ( EscapeSequence | ~('\\'|'"') )* '"')
     | ('\'' ( EscapeSequence | ~('\\'|'\'') )* '\'')
    ;

// $ANTLR src "/home/etirelli/workspace/jboss/jbrules-4.0.x/drools-compiler/src/main/resources/org/drools/lang/DRL.g" 1721
fragment
HexDigit : ('0'..'9'|'a'..'f'|'A'..'F') ;

// $ANTLR src "/home/etirelli/workspace/jboss/jbrules-4.0.x/drools-compiler/src/main/resources/org/drools/lang/DRL.g" 1724
fragment
EscapeSequence
    :   '\\' ('b'|'B'|'t'|'n'|'f'|'r'|'\"'|'\''|'\\'|'.'|'o'|
              'x'|'a'|'e'|'c'|'d'|'D'|'s'|'S'|'w'|'W'|'p'|'A'|
              'G'|'Z'|'z'|'Q'|'E'|'*'|'['|']'|'('|')'|'$'|'^'|
              '{'|'}'|'?'|'+'|'-'|'&'|'|')
    |   UnicodeEscape
    |   OctalEscape
    ;

// $ANTLR src "/home/etirelli/workspace/jboss/jbrules-4.0.x/drools-compiler/src/main/resources/org/drools/lang/DRL.g" 1734
fragment
OctalEscape
    :   '\\' ('0'..'3') ('0'..'7') ('0'..'7')
    |   '\\' ('0'..'7') ('0'..'7')
    |   '\\' ('0'..'7')
    ;

// $ANTLR src "/home/etirelli/workspace/jboss/jbrules-4.0.x/drools-compiler/src/main/resources/org/drools/lang/DRL.g" 1741
fragment
UnicodeEscape
    :   '\\' 'u' HexDigit HexDigit HexDigit HexDigit
    ;

// $ANTLR src "/home/etirelli/workspace/jboss/jbrules-4.0.x/drools-compiler/src/main/resources/org/drools/lang/DRL.g" 1746
BOOL
	:	('true'|'false') 
	;	

// $ANTLR src "/home/etirelli/workspace/jboss/jbrules-4.0.x/drools-compiler/src/main/resources/org/drools/lang/DRL.g" 1750
PACKAGE	:	'package';

// $ANTLR src "/home/etirelli/workspace/jboss/jbrules-4.0.x/drools-compiler/src/main/resources/org/drools/lang/DRL.g" 1752
IMPORT	:	'import';

// $ANTLR src "/home/etirelli/workspace/jboss/jbrules-4.0.x/drools-compiler/src/main/resources/org/drools/lang/DRL.g" 1754
FUNCTION :	'function';

// $ANTLR src "/home/etirelli/workspace/jboss/jbrules-4.0.x/drools-compiler/src/main/resources/org/drools/lang/DRL.g" 1756
GLOBAL	:	'global';
	
// $ANTLR src "/home/etirelli/workspace/jboss/jbrules-4.0.x/drools-compiler/src/main/resources/org/drools/lang/DRL.g" 1758
RULE    :	'rule';

// $ANTLR src "/home/etirelli/workspace/jboss/jbrules-4.0.x/drools-compiler/src/main/resources/org/drools/lang/DRL.g" 1760
QUERY	:	'query';

// $ANTLR src "/home/etirelli/workspace/jboss/jbrules-4.0.x/drools-compiler/src/main/resources/org/drools/lang/DRL.g" 1762
TEMPLATE :	'template';

// $ANTLR src "/home/etirelli/workspace/jboss/jbrules-4.0.x/drools-compiler/src/main/resources/org/drools/lang/DRL.g" 1764
ATTRIBUTES :	'attributes';
	
// $ANTLR src "/home/etirelli/workspace/jboss/jbrules-4.0.x/drools-compiler/src/main/resources/org/drools/lang/DRL.g" 1766
DATE_EFFECTIVE 
	:	'date-effective';

// $ANTLR src "/home/etirelli/workspace/jboss/jbrules-4.0.x/drools-compiler/src/main/resources/org/drools/lang/DRL.g" 1769
DATE_EXPIRES 
	:	'date-expires';	
	
// $ANTLR src "/home/etirelli/workspace/jboss/jbrules-4.0.x/drools-compiler/src/main/resources/org/drools/lang/DRL.g" 1772
ENABLED :	'enabled';

// $ANTLR src "/home/etirelli/workspace/jboss/jbrules-4.0.x/drools-compiler/src/main/resources/org/drools/lang/DRL.g" 1774
SALIENCE 
	:	'salience';
	
// $ANTLR src "/home/etirelli/workspace/jboss/jbrules-4.0.x/drools-compiler/src/main/resources/org/drools/lang/DRL.g" 1777
NO_LOOP :	'no-loop';

// $ANTLR src "/home/etirelli/workspace/jboss/jbrules-4.0.x/drools-compiler/src/main/resources/org/drools/lang/DRL.g" 1779
AUTO_FOCUS 
	:	'auto-focus';
	
// $ANTLR src "/home/etirelli/workspace/jboss/jbrules-4.0.x/drools-compiler/src/main/resources/org/drools/lang/DRL.g" 1782
ACTIVATION_GROUP 
	:	'activation-group';
	
// $ANTLR src "/home/etirelli/workspace/jboss/jbrules-4.0.x/drools-compiler/src/main/resources/org/drools/lang/DRL.g" 1785
AGENDA_GROUP 
	:	'agenda-group';
	
// $ANTLR src "/home/etirelli/workspace/jboss/jbrules-4.0.x/drools-compiler/src/main/resources/org/drools/lang/DRL.g" 1788
DIALECT 
	:	'dialect';	
	
// $ANTLR src "/home/etirelli/workspace/jboss/jbrules-4.0.x/drools-compiler/src/main/resources/org/drools/lang/DRL.g" 1791
RULEFLOW_GROUP 
	:	'ruleflow-group';
	
// $ANTLR src "/home/etirelli/workspace/jboss/jbrules-4.0.x/drools-compiler/src/main/resources/org/drools/lang/DRL.g" 1794
DURATION 
	:	'duration';
	
// $ANTLR src "/home/etirelli/workspace/jboss/jbrules-4.0.x/drools-compiler/src/main/resources/org/drools/lang/DRL.g" 1797
LOCK_ON_ACTIVE
	:	'lock-on-active';	
	
// $ANTLR src "/home/etirelli/workspace/jboss/jbrules-4.0.x/drools-compiler/src/main/resources/org/drools/lang/DRL.g" 1800
FROM	:	'from';

// $ANTLR src "/home/etirelli/workspace/jboss/jbrules-4.0.x/drools-compiler/src/main/resources/org/drools/lang/DRL.g" 1802
ACCUMULATE 
	:	'accumulate';
	
// $ANTLR src "/home/etirelli/workspace/jboss/jbrules-4.0.x/drools-compiler/src/main/resources/org/drools/lang/DRL.g" 1805
INIT	:	'init';

// $ANTLR src "/home/etirelli/workspace/jboss/jbrules-4.0.x/drools-compiler/src/main/resources/org/drools/lang/DRL.g" 1807
ACTION	:	'action';

// $ANTLR src "/home/etirelli/workspace/jboss/jbrules-4.0.x/drools-compiler/src/main/resources/org/drools/lang/DRL.g" 1809
REVERSE	:	'reverse';

// $ANTLR src "/home/etirelli/workspace/jboss/jbrules-4.0.x/drools-compiler/src/main/resources/org/drools/lang/DRL.g" 1811
RESULT	:	'result';

// $ANTLR src "/home/etirelli/workspace/jboss/jbrules-4.0.x/drools-compiler/src/main/resources/org/drools/lang/DRL.g" 1813
COLLECT :	'collect';

// $ANTLR src "/home/etirelli/workspace/jboss/jbrules-4.0.x/drools-compiler/src/main/resources/org/drools/lang/DRL.g" 1815
OR	:	'or';

// $ANTLR src "/home/etirelli/workspace/jboss/jbrules-4.0.x/drools-compiler/src/main/resources/org/drools/lang/DRL.g" 1817
AND	:	'and';

// $ANTLR src "/home/etirelli/workspace/jboss/jbrules-4.0.x/drools-compiler/src/main/resources/org/drools/lang/DRL.g" 1819
CONTAINS 
	:	'contains';
	
// $ANTLR src "/home/etirelli/workspace/jboss/jbrules-4.0.x/drools-compiler/src/main/resources/org/drools/lang/DRL.g" 1822
EXCLUDES 
	:	'excludes';
	
// $ANTLR src "/home/etirelli/workspace/jboss/jbrules-4.0.x/drools-compiler/src/main/resources/org/drools/lang/DRL.g" 1825
MEMBEROF
	:	'memberOf';

// $ANTLR src "/home/etirelli/workspace/jboss/jbrules-4.0.x/drools-compiler/src/main/resources/org/drools/lang/DRL.g" 1828
MATCHES :	'matches';

// $ANTLR src "/home/etirelli/workspace/jboss/jbrules-4.0.x/drools-compiler/src/main/resources/org/drools/lang/DRL.g" 1830
SOUNDSLIKE :	'soundslike';

// $ANTLR src "/home/etirelli/workspace/jboss/jbrules-4.0.x/drools-compiler/src/main/resources/org/drools/lang/DRL.g" 1832
IN	:	'in';

// $ANTLR src "/home/etirelli/workspace/jboss/jbrules-4.0.x/drools-compiler/src/main/resources/org/drools/lang/DRL.g" 1834
NULL	:	'null';

// $ANTLR src "/home/etirelli/workspace/jboss/jbrules-4.0.x/drools-compiler/src/main/resources/org/drools/lang/DRL.g" 1836
EXISTS	:	'exists';

// $ANTLR src "/home/etirelli/workspace/jboss/jbrules-4.0.x/drools-compiler/src/main/resources/org/drools/lang/DRL.g" 1838
NOT	:	'not';

// $ANTLR src "/home/etirelli/workspace/jboss/jbrules-4.0.x/drools-compiler/src/main/resources/org/drools/lang/DRL.g" 1840
EVAL	:	'eval';

// $ANTLR src "/home/etirelli/workspace/jboss/jbrules-4.0.x/drools-compiler/src/main/resources/org/drools/lang/DRL.g" 1842
FORALL	:	'forall';							

// $ANTLR src "/home/etirelli/workspace/jboss/jbrules-4.0.x/drools-compiler/src/main/resources/org/drools/lang/DRL.g" 1844
WHEN    :	'when'; 

// $ANTLR src "/home/etirelli/workspace/jboss/jbrules-4.0.x/drools-compiler/src/main/resources/org/drools/lang/DRL.g" 1846
THEN	:    	'then';

// $ANTLR src "/home/etirelli/workspace/jboss/jbrules-4.0.x/drools-compiler/src/main/resources/org/drools/lang/DRL.g" 1848
END     :	'end';

// $ANTLR src "/home/etirelli/workspace/jboss/jbrules-4.0.x/drools-compiler/src/main/resources/org/drools/lang/DRL.g" 1850
ID	
	:	('a'..'z'|'A'..'Z'|'_'|'$'|'\u00c0'..'\u00ff')('a'..'z'|'A'..'Z'|'_'|'0'..'9'|'\u00c0'..'\u00ff')* 
	;
		
// $ANTLR src "/home/etirelli/workspace/jboss/jbrules-4.0.x/drools-compiler/src/main/resources/org/drools/lang/DRL.g" 1854
LEFT_PAREN
        :	'('
        ;

// $ANTLR src "/home/etirelli/workspace/jboss/jbrules-4.0.x/drools-compiler/src/main/resources/org/drools/lang/DRL.g" 1858
RIGHT_PAREN
        :	')'
        ;
        
// $ANTLR src "/home/etirelli/workspace/jboss/jbrules-4.0.x/drools-compiler/src/main/resources/org/drools/lang/DRL.g" 1862
LEFT_SQUARE
        :	'['
        ;

// $ANTLR src "/home/etirelli/workspace/jboss/jbrules-4.0.x/drools-compiler/src/main/resources/org/drools/lang/DRL.g" 1866
RIGHT_SQUARE
        :	']'
        ;        

// $ANTLR src "/home/etirelli/workspace/jboss/jbrules-4.0.x/drools-compiler/src/main/resources/org/drools/lang/DRL.g" 1870
LEFT_CURLY
        :	'{'
        ;

// $ANTLR src "/home/etirelli/workspace/jboss/jbrules-4.0.x/drools-compiler/src/main/resources/org/drools/lang/DRL.g" 1874
RIGHT_CURLY
        :	'}'
        ;
        
// $ANTLR src "/home/etirelli/workspace/jboss/jbrules-4.0.x/drools-compiler/src/main/resources/org/drools/lang/DRL.g" 1878
COMMA	:	','
	;
	
// $ANTLR src "/home/etirelli/workspace/jboss/jbrules-4.0.x/drools-compiler/src/main/resources/org/drools/lang/DRL.g" 1881
DOT	:	'.'
	;	
	
// $ANTLR src "/home/etirelli/workspace/jboss/jbrules-4.0.x/drools-compiler/src/main/resources/org/drools/lang/DRL.g" 1884
DOUBLE_AMPER
	:	'&&'
	;
	
// $ANTLR src "/home/etirelli/workspace/jboss/jbrules-4.0.x/drools-compiler/src/main/resources/org/drools/lang/DRL.g" 1888
DOUBLE_PIPE
	:	'||'
	;				
	
// $ANTLR src "/home/etirelli/workspace/jboss/jbrules-4.0.x/drools-compiler/src/main/resources/org/drools/lang/DRL.g" 1892
SH_STYLE_SINGLE_LINE_COMMENT	
	:	'#' ( options{greedy=false;} : .)* EOL /* ('\r')? '\n'  */
                { $channel=HIDDEN; setText("//"+getText().substring(1));}
	;
        
        
// $ANTLR src "/home/etirelli/workspace/jboss/jbrules-4.0.x/drools-compiler/src/main/resources/org/drools/lang/DRL.g" 1898
C_STYLE_SINGLE_LINE_COMMENT	
	:	'//' ( options{greedy=false;} : .)* EOL // ('\r')? '\n' 
                { $channel=HIDDEN; }
	;

// $ANTLR src "/home/etirelli/workspace/jboss/jbrules-4.0.x/drools-compiler/src/main/resources/org/drools/lang/DRL.g" 1903
MULTI_LINE_COMMENT
	:	'/*' (options{greedy=false;} : .)* '*/'
                { $channel=HIDDEN; }
	;

// $ANTLR src "/home/etirelli/workspace/jboss/jbrules-4.0.x/drools-compiler/src/main/resources/org/drools/lang/DRL.g" 1908
MISC 	:
		'!' | '@' | '$' | '%' | '^' | '*' | '_' | '-' | '+'  | '?' | '=' | '/' | '\'' | '\\' | '|' | '&'
	;
