/*
 * Decompiled with CFR 0.152.
 */
package org.drools.lang.descr;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.drools.lang.descr.AnnotatedBaseDescr;
import org.drools.lang.descr.TypeFieldDescr;
import org.drools.rule.Namespaceable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeDeclarationDescr
extends AnnotatedBaseDescr
implements Namespaceable,
Comparable<TypeDeclarationDescr> {
    private static final long serialVersionUID = 510L;
    private String namespace;
    private String typeName;
    private Map<String, TypeFieldDescr> fields;
    private String superTypeName;
    private String superTypeNamespace;

    public TypeDeclarationDescr() {
        this(null);
    }

    public TypeDeclarationDescr(String typeName) {
        this.typeName = typeName;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.namespace = (String)in.readObject();
        this.typeName = (String)in.readObject();
        this.superTypeName = (String)in.readObject();
        this.fields = (Map)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.namespace);
        out.writeObject(this.typeName);
        out.writeObject(this.superTypeName);
        out.writeObject(this.fields);
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public Map<String, TypeFieldDescr> getFields() {
        return this.fields != null ? this.fields : Collections.emptyMap();
    }

    public void setFields(Map<String, TypeFieldDescr> fields) {
        this.fields = fields;
    }

    public void addField(TypeFieldDescr field) {
        if (this.fields == null) {
            this.fields = new LinkedHashMap<String, TypeFieldDescr>();
        }
        this.fields.put(field.getFieldName(), field);
    }

    public String toString() {
        return "TypeDeclaration[ " + this.getTypeName() + " ]";
    }

    public String getSuperTypeName() {
        return this.superTypeName;
    }

    public void setSuperTypeName(String type) {
        this.superTypeName = type;
    }

    public String getSuperTypeNamespace() {
        return this.superTypeNamespace;
    }

    public void setSuperTypeNamespace(String superTypeNamespace) {
        this.superTypeNamespace = superTypeNamespace;
    }

    @Override
    public int compareTo(TypeDeclarationDescr descr) {
        int result = 0;
        if (this.getSuperTypeName() == null && descr.getSuperTypeName() == null) {
            result = 0;
        } else if (this.getSuperTypeName() != null && this.getSuperTypeName().equals(descr.getTypeName())) {
            result = -1;
        } else if (descr.getSuperTypeName() != null && descr.getSuperTypeName().equals(this.getTypeName())) {
            result = 1;
        }
        System.err.println("TypeDeclaration Descr compareTo : Compare descr " + this.getTypeName() + " vs " + descr.getTypeName() + " >>  " + result);
        return result;
    }
}

