/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder.dialect.asm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.drools.WorkingMemory;
import org.drools.base.ClassTypeResolver;
import org.drools.base.TypeResolver;
import org.drools.common.AbstractRuleBase;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.core.util.asm.MethodComparator;
import org.drools.reteoo.LeftTuple;
import org.drools.rule.Declaration;
import org.drools.rule.Package;
import org.drools.rule.Pattern;
import org.drools.rule.Rule;
import org.drools.rule.builder.RuleBuildContext;
import org.drools.rule.builder.dialect.asm.ClassGenerator;
import org.drools.rule.builder.dialect.asm.InvokerDataProvider;
import org.drools.rule.builder.dialect.asm.InvokerStub;
import org.drools.spi.CompiledInvoker;
import org.drools.spi.Tuple;
import org.drools.util.CompositeClassLoader;
import org.mvel2.asm.Label;
import org.mvel2.asm.MethodVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvokerGenerator {
    public static final Long INVOKER_SERIAL_UID = new Long(510L);
    public static final ClassGenerator.MethodBody INVOKER_EQUALS_METHOD = new EqualsMethod();

    public static ClassGenerator createInvokerStubGenerator(InvokerDataProvider data, RuleBuildContext ruleContext) {
        return InvokerGenerator.createStubGenerator(data, (ClassLoader)ruleContext.getPackageBuilder().getRootClassLoader(), ruleContext.getDialect("java").getPackageRegistry().getTypeResolver(), ruleContext.getPkg().getImports().keySet());
    }

    public static ClassGenerator createStubGenerator(final InvokerDataProvider data, ClassLoader classLoader, TypeResolver typeResolver, final Set<String> imports) {
        ClassGenerator generator = new ClassGenerator(data.getPackageName() + "." + data.getInvokerClassName(), classLoader, typeResolver);
        generator.addStaticField(18, "serialVersionUID", Long.TYPE, INVOKER_SERIAL_UID).addDefaultConstructor();
        generator.addMethod(1, "hashCode", generator.methodDescr(Integer.TYPE, new Class[0]), new ClassGenerator.MethodBody(){

            public void body(MethodVisitor mv) {
                this.push(data.hashCode());
                mv.visitInsn(172);
            }
        }).addMethod(1, "getMethodBytecode", generator.methodDescr(List.class, new Class[0]), new GetMethodBytecodeMethod(data)).addMethod(1, "equals", generator.methodDescr(Boolean.TYPE, Object.class), new EqualsMethod()).addMethod(1, "getPackageName", generator.methodDescr(String.class, new Class[0]), new ClassGenerator.MethodBody(){

            public void body(MethodVisitor mv) {
                this.push(data.getPackageName());
                mv.visitInsn(176);
            }
        }).addMethod(1, "getGeneratedInvokerClassName", generator.methodDescr(String.class, new Class[0]), new ClassGenerator.MethodBody(){

            public void body(MethodVisitor mv) {
                this.push(data.getInvokerClassName() + "Generated");
                mv.visitInsn(176);
            }
        }).addMethod(1, "getRuleClassName", generator.methodDescr(String.class, new Class[0]), new ClassGenerator.MethodBody(){

            public void body(MethodVisitor mv) {
                this.push(data.getRuleClassName());
                mv.visitInsn(176);
            }
        }).addMethod(1, "getInternalRuleClassName", generator.methodDescr(String.class, new Class[0]), new ClassGenerator.MethodBody(){

            public void body(MethodVisitor mv) {
                this.push(data.getInternalRuleClassName());
                mv.visitInsn(176);
            }
        }).addMethod(1, "getMethodName", generator.methodDescr(String.class, new Class[0]), new ClassGenerator.MethodBody(){

            public void body(MethodVisitor mv) {
                this.push(data.getMethodName());
                mv.visitInsn(176);
            }
        }).addMethod(1, "getInvokerClassName", generator.methodDescr(String.class, new Class[0]), new ClassGenerator.MethodBody(){

            public void body(MethodVisitor mv) {
                this.push(data.getInvokerClassName());
                mv.visitInsn(176);
            }
        }).addMethod(1, "getGlobals", generator.methodDescr(String[].class, new Class[0]), new ClassGenerator.MethodBody(){

            public void body(MethodVisitor mv) {
                this.returnAsArray(data.getGlobals());
            }
        }).addMethod(1, "getGlobalTypes", generator.methodDescr(String[].class, new Class[0]), new ClassGenerator.MethodBody(){

            public void body(MethodVisitor mv) {
                this.returnAsArray(data.getGlobalTypes());
            }
        }).addMethod(1, "getPackageImports", generator.methodDescr(String[].class, new Class[0]), new ClassGenerator.MethodBody(){

            public void body(MethodVisitor mv) {
                this.returnAsArray(imports, String.class);
            }
        });
        return generator;
    }

    protected static CompositeClassLoader getCompositeClassLoader(Object obj) {
        ClassLoader classLoader = obj.getClass().getClassLoader();
        while (true) {
            if (classLoader instanceof CompositeClassLoader) {
                return (CompositeClassLoader)classLoader;
            }
            ClassLoader parentLoader = classLoader.getParent();
            if (parentLoader == null || parentLoader == classLoader) break;
            classLoader = parentLoader;
        }
        return null;
    }

    protected static CompositeClassLoader getCompositeClassLoader(Object obj, WorkingMemory workingMemory) {
        CompositeClassLoader classLoader = InvokerGenerator.getCompositeClassLoader(obj);
        if (classLoader == null) {
            classLoader = ((AbstractRuleBase)workingMemory.getRuleBase()).getRootClassLoader();
        }
        return classLoader;
    }

    protected static TypeResolver getTypeResolver(InvokerStub stub, WorkingMemory workingMemory, CompositeClassLoader classLoader) {
        TypeResolver typeResolver;
        Package pkg = workingMemory.getRuleBase().getPackage(stub.getPackageName());
        TypeResolver typeResolver2 = typeResolver = pkg == null ? null : pkg.getTypeResolver();
        if (typeResolver == null) {
            HashSet<String> imports = new HashSet<String>();
            for (String imp : stub.getPackageImports()) {
                imports.add(imp);
            }
            typeResolver = new ClassTypeResolver(imports, classLoader, stub.getPackageName());
        }
        return typeResolver;
    }

    public static ClassGenerator createInvokerClassGenerator(InvokerStub stub, WorkingMemory workingMemory) {
        String className = stub.getPackageName() + "." + stub.getGeneratedInvokerClassName();
        CompositeClassLoader classLoader = InvokerGenerator.getCompositeClassLoader(stub, workingMemory);
        return InvokerGenerator.createInvokerClassGenerator(className, stub, classLoader, InvokerGenerator.getTypeResolver(stub, workingMemory, classLoader));
    }

    public static ClassGenerator createInvokerClassGenerator(InvokerDataProvider data, RuleBuildContext ruleContext) {
        String className = data.getPackageName() + "." + data.getInvokerClassName();
        return InvokerGenerator.createInvokerClassGenerator(className, data, ruleContext.getPackageBuilder().getRootClassLoader(), ruleContext.getDialect("java").getPackageRegistry().getTypeResolver());
    }

    private static ClassGenerator createInvokerClassGenerator(String className, final InvokerDataProvider data, CompositeClassLoader classLoader, TypeResolver typeResolver) {
        ClassGenerator generator = new ClassGenerator(className, (ClassLoader)classLoader, typeResolver).addStaticField(18, "serialVersionUID", Long.TYPE, INVOKER_SERIAL_UID).addDefaultConstructor();
        generator.addMethod(1, "hashCode", generator.methodDescr(Integer.TYPE, new Class[0]), new ClassGenerator.MethodBody(){

            public void body(MethodVisitor mv) {
                this.push(data.hashCode());
                mv.visitInsn(172);
            }
        }).addMethod(1, "getMethodBytecode", generator.methodDescr(List.class, new Class[0]), new GetMethodBytecodeMethod(data)).addMethod(1, "equals", generator.methodDescr(Boolean.TYPE, Object.class), INVOKER_EQUALS_METHOD);
        return generator;
    }

    protected static List<DeclarationMatcher> matchDeclarationsToTuple(Declaration[] declarations, LeftTuple tuple) {
        ArrayList<DeclarationMatcher> matchers = new ArrayList<DeclarationMatcher>();
        for (int i = 0; i < declarations.length; ++i) {
            matchers.add(new DeclarationMatcher(i, declarations[i].getPattern().getOffset()));
        }
        Collections.sort(matchers);
        return matchers;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class EvaluateMethod
    extends ClassGenerator.MethodBody {
        protected int objAstorePos;

        protected int[] parseDeclarations(Declaration[] declarations, int declarReg, int tupleReg, int wmReg, boolean readLocalsFromTuple) {
            int[] declarationsParamsPos = new int[declarations.length];
            for (int i = 0; i < declarations.length; ++i) {
                declarationsParamsPos[i] = this.objAstorePos;
                this.mv.visitVarInsn(25, declarReg);
                this.push(i);
                this.mv.visitInsn(50);
                this.mv.visitVarInsn(25, wmReg);
                this.cast(InternalWorkingMemory.class);
                if (readLocalsFromTuple) {
                    this.mv.visitVarInsn(25, tupleReg);
                    this.mv.visitVarInsn(25, declarReg);
                    this.push(i);
                    this.mv.visitInsn(50);
                    this.invokeInterface(Tuple.class, "get", InternalFactHandle.class, Declaration.class);
                    this.invokeInterface(InternalFactHandle.class, "getObject", Object.class, new Class[0]);
                } else {
                    this.mv.visitVarInsn(25, 1);
                }
                String readMethod = declarations[i].getNativeReadMethod().getName();
                boolean isObject = readMethod.equals("getValue");
                String returnedType = isObject ? "Ljava/lang/Object;" : this.typeDescr(declarations[i].getTypeName());
                this.mv.visitMethodInsn(182, "org/drools/rule/Declaration", readMethod, "(Lorg/drools/common/InternalWorkingMemory;Ljava/lang/Object;)" + returnedType);
                if (isObject) {
                    String declarationTypeName = this.internalName(declarations[i].getTypeName());
                    if (declarationTypeName.length() == 1) {
                        this.castToPrimitive(this.getPrimitiveTypeForInternalName(declarationTypeName.charAt(0)));
                    } else {
                        this.mv.visitTypeInsn(192, declarationTypeName);
                    }
                }
                this.objAstorePos += this.store(this.objAstorePos, declarations[i].getTypeName());
            }
            return declarationsParamsPos;
        }

        private Class<?> getPrimitiveTypeForInternalName(char ch) {
            switch (ch) {
                case 'I': {
                    return Integer.TYPE;
                }
                case 'Z': {
                    return Boolean.TYPE;
                }
                case 'C': {
                    return Character.TYPE;
                }
                case 'B': {
                    return Byte.TYPE;
                }
                case 'S': {
                    return Short.TYPE;
                }
                case 'F': {
                    return Float.TYPE;
                }
                case 'J': {
                    return Long.TYPE;
                }
                case 'D': {
                    return Double.TYPE;
                }
            }
            throw new RuntimeException("Unkown primitive type: " + ch);
        }

        protected void parseGlobals(String[] globals, String[] globalTypes, int wmReg, StringBuilder methodDescr) {
            for (int i = 0; i < globals.length; ++i) {
                this.mv.visitVarInsn(25, wmReg);
                this.push(globals[i]);
                this.invokeInterface(WorkingMemory.class, "getGlobal", Object.class, String.class);
                this.mv.visitTypeInsn(192, this.internalName(globalTypes[i]));
                methodDescr.append(this.typeDescr(globalTypes[i]));
            }
        }

        protected LeftTuple traverseTuplesUntilDeclaration(LeftTuple currentLeftTuple, int declarIndex, int declarOffset, int declarReg, int tupleReg, int declarOffsetReg) {
            this.mv.visitVarInsn(25, declarReg);
            this.push(declarIndex);
            this.mv.visitInsn(50);
            this.invokeVirtual(Declaration.class, "getPattern", Pattern.class, new Class[0]);
            this.invokeVirtual(Pattern.class, "getOffset", Integer.TYPE, new Class[0]);
            this.mv.visitVarInsn(54, declarOffsetReg);
            while (currentLeftTuple.getIndex() > declarOffset) {
                this.mv.visitVarInsn(25, tupleReg);
                this.invokeInterface(LeftTuple.class, "getParent", LeftTuple.class, new Class[0]);
                this.mv.visitVarInsn(58, tupleReg);
                currentLeftTuple = currentLeftTuple.getParent();
            }
            return currentLeftTuple;
        }

        protected void traverseTuplesUntilDeclarationWithOr(int declarIndex, int declarReg, int tupleReg, int declarOffsetReg) {
            this.mv.visitVarInsn(25, declarReg);
            this.push(declarIndex);
            this.mv.visitInsn(50);
            this.invokeVirtual(Declaration.class, "getPattern", Pattern.class, new Class[0]);
            this.invokeVirtual(Pattern.class, "getOffset", Integer.TYPE, new Class[0]);
            this.mv.visitVarInsn(54, declarOffsetReg);
            Label whileStart = new Label();
            Label whileExit = new Label();
            this.mv.visitLabel(whileStart);
            this.mv.visitVarInsn(25, tupleReg);
            this.invokeInterface(LeftTuple.class, "getIndex", Integer.TYPE, new Class[0]);
            this.mv.visitVarInsn(21, declarOffsetReg);
            this.mv.visitJumpInsn(164, whileExit);
            this.mv.visitVarInsn(25, tupleReg);
            this.invokeInterface(LeftTuple.class, "getParent", LeftTuple.class, new Class[0]);
            this.mv.visitVarInsn(58, tupleReg);
            this.mv.visitJumpInsn(167, whileStart);
            this.mv.visitLabel(whileExit);
        }

        protected void storeObjectFromDeclaration(Declaration declaration, String declarationType) {
            String readMethod = declaration.getNativeReadMethod().getName();
            boolean isObject = readMethod.equals("getValue");
            String returnedType = isObject ? "Ljava/lang/Object;" : this.typeDescr(declarationType);
            this.mv.visitMethodInsn(182, "org/drools/rule/Declaration", readMethod, "(Lorg/drools/common/InternalWorkingMemory;Ljava/lang/Object;)" + returnedType);
            if (isObject) {
                this.mv.visitTypeInsn(192, this.internalName(declarationType));
            }
            this.objAstorePos += this.store(this.objAstorePos, declarationType);
        }
    }

    public static class EqualsMethod
    extends ClassGenerator.MethodBody {
        public void body(MethodVisitor mv) {
            Label l1 = new Label();
            Label l2 = new Label();
            mv.visitVarInsn(25, 1);
            mv.visitJumpInsn(198, l1);
            mv.visitVarInsn(25, 1);
            this.instanceOf(CompiledInvoker.class);
            mv.visitJumpInsn(154, l2);
            mv.visitLabel(l1);
            mv.visitInsn(3);
            mv.visitInsn(172);
            mv.visitLabel(l2);
            mv.visitVarInsn(25, 0);
            this.invokeThis("getMethodBytecode", List.class, new Class[0]);
            mv.visitVarInsn(25, 1);
            this.cast(CompiledInvoker.class);
            this.invokeInterface(CompiledInvoker.class, "getMethodBytecode", List.class, new Class[0]);
            this.invokeStatic(MethodComparator.class, "compareBytecode", Boolean.TYPE, List.class, List.class);
            mv.visitInsn(172);
        }
    }

    public static class GetMethodBytecodeMethod
    extends ClassGenerator.MethodBody {
        private InvokerDataProvider data;

        public GetMethodBytecodeMethod(InvokerDataProvider data) {
            this.data = data;
        }

        public void body(MethodVisitor mv) {
            mv.visitVarInsn(25, 0);
            this.invokeVirtual(Object.class, "getClass", Class.class, new Class[0]);
            this.push(this.data.getRuleClassName());
            this.push(this.data.getPackageName());
            this.push(this.data.getMethodName());
            this.push(this.data.getInternalRuleClassName() + ".class");
            this.invokeStatic(Rule.class, "getMethodBytecode", List.class, Class.class, String.class, String.class, String.class, String.class);
            mv.visitInsn(176);
        }
    }

    protected static class DeclarationMatcher
    implements Comparable {
        private final int originalIndex;
        private final int rootDistance;

        public DeclarationMatcher(int originalIndex, int rootDistance) {
            this.originalIndex = originalIndex;
            this.rootDistance = rootDistance;
        }

        public int getOriginalIndex() {
            return this.originalIndex;
        }

        public int getRootDistance() {
            return this.rootDistance;
        }

        public int compareTo(Object obj) {
            return ((DeclarationMatcher)obj).rootDistance - this.rootDistance;
        }
    }
}

