/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder;

import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.drools.base.ClassObjectType;
import org.drools.base.DroolsQuery;
import org.drools.base.EvaluatorWrapper;
import org.drools.base.ValueType;
import org.drools.base.evaluators.EvaluatorDefinition;
import org.drools.base.evaluators.Operator;
import org.drools.base.mvel.MVELCompilationUnit;
import org.drools.compiler.AnalysisResult;
import org.drools.compiler.DescrBuildError;
import org.drools.compiler.Dialect;
import org.drools.core.util.index.IndexUtil;
import org.drools.lang.descr.BaseDescr;
import org.drools.lang.descr.LiteralRestrictionDescr;
import org.drools.lang.descr.OperatorDescr;
import org.drools.lang.descr.PredicateDescr;
import org.drools.lang.descr.RelationalExprDescr;
import org.drools.rule.Declaration;
import org.drools.rule.Pattern;
import org.drools.rule.ReturnValueRestriction;
import org.drools.rule.builder.ConstraintBuilder;
import org.drools.rule.builder.PatternBuilder;
import org.drools.rule.builder.RuleBuildContext;
import org.drools.rule.builder.dialect.DialectUtil;
import org.drools.rule.builder.dialect.mvel.MVELAnalysisResult;
import org.drools.rule.builder.dialect.mvel.MVELDialect;
import org.drools.rule.constraint.EvaluatorConstraint;
import org.drools.rule.constraint.MvelConstraint;
import org.drools.spi.Constraint;
import org.drools.spi.Evaluator;
import org.drools.spi.FieldValue;
import org.drools.spi.InternalReadAccessor;
import org.drools.spi.KnowledgeHelper;
import org.drools.spi.Restriction;
import org.mvel2.ConversionHandler;
import org.mvel2.DataConversion;
import org.mvel2.util.CompatibilityStrategy;

public class MVELConstraintBuilder
implements ConstraintBuilder {
    public static final boolean USE_MVEL_EXPRESSION = true;
    protected static Set<String> mvelOperators;

    public boolean isMvelOperator(String operator) {
        return mvelOperators.contains(operator);
    }

    public boolean useMvelExpression() {
        return true;
    }

    public Constraint buildVariableConstraint(RuleBuildContext context, Pattern pattern, String expression, Declaration[] declarations, String leftValue, OperatorDescr operatorDescr, String rightValue, InternalReadAccessor extractor, Declaration requiredDeclaration, RelationalExprDescr relDescr) {
        boolean isUnification;
        if (!this.isMvelOperator(operatorDescr.getOperator())) {
            EvaluatorDefinition.Target right = this.getRightTarget(extractor);
            EvaluatorDefinition.Target left = requiredDeclaration.isPatternDeclaration() && !Date.class.isAssignableFrom(requiredDeclaration.getExtractor().getExtractToClass()) && !Number.class.isAssignableFrom(requiredDeclaration.getExtractor().getExtractToClass()) ? EvaluatorDefinition.Target.HANDLE : EvaluatorDefinition.Target.FACT;
            Evaluator evaluator = this.getEvaluator(context, relDescr, extractor.getValueType(), operatorDescr.getOperator(), relDescr.isNegated(), relDescr.getParametersText(), left, right);
            return new EvaluatorConstraint(new Declaration[]{requiredDeclaration}, evaluator, extractor);
        }
        boolean bl = isUnification = requiredDeclaration != null && requiredDeclaration.getPattern().getObjectType().equals(new ClassObjectType(DroolsQuery.class)) && Operator.EQUAL.getOperatorString().equals(operatorDescr.getOperator());
        if (isUnification) {
            expression = MVELConstraintBuilder.resolveUnificationAmbiguity(expression, declarations, leftValue, rightValue);
        }
        IndexUtil.ConstraintType constraintType = IndexUtil.ConstraintType.decode((String)operatorDescr.getOperator());
        MVELCompilationUnit compilationUnit = isUnification ? null : this.buildCompilationUnit(context, pattern, expression);
        return new MvelConstraint(context.getPkg().getName(), expression, declarations, compilationUnit, constraintType, requiredDeclaration, extractor, isUnification);
    }

    public Constraint buildMvelConstraint(String packageName, String expression, Declaration[] declarations, MVELCompilationUnit compilationUnit, boolean isDynamic) {
        return new MvelConstraint(packageName, expression, declarations, compilationUnit, isDynamic);
    }

    public Constraint buildMvelConstraint(String packageName, String expression, Declaration[] declarations, MVELCompilationUnit compilationUnit, boolean isDynamic, PredicateDescr base) {
        return new MvelConstraint(packageName, expression, declarations, compilationUnit, isDynamic);
    }

    public Constraint buildMvelConstraint(String packageName, String expression, Declaration[] declarations, MVELCompilationUnit compilationUnit, IndexUtil.ConstraintType constraintType, Declaration indexingDeclaration, InternalReadAccessor extractor, boolean isUnification) {
        return new MvelConstraint(packageName, expression, declarations, compilationUnit, constraintType, indexingDeclaration, extractor, isUnification);
    }

    public Constraint buildLiteralConstraint(RuleBuildContext context, Pattern pattern, ValueType vtype, FieldValue field, String expression, String leftValue, String operator, String rightValue, InternalReadAccessor extractor, LiteralRestrictionDescr restrictionDescr) {
        if (!this.isMvelOperator(operator)) {
            Evaluator evaluator = this.buildLiteralEvaluator(context, extractor, restrictionDescr, vtype);
            return new EvaluatorConstraint(field, evaluator, extractor);
        }
        String mvelExpr = MVELConstraintBuilder.normalizeMVELLiteralExpression(vtype, field, expression, leftValue, operator, rightValue, restrictionDescr);
        IndexUtil.ConstraintType constraintType = IndexUtil.ConstraintType.decode((String)operator);
        MVELCompilationUnit compilationUnit = this.buildCompilationUnit(context, pattern, mvelExpr);
        return new MvelConstraint(context.getPkg().getName(), mvelExpr, compilationUnit, constraintType, field, extractor);
    }

    protected static String resolveUnificationAmbiguity(String expr, Declaration[] declrations, String leftValue, String rightValue) {
        if (leftValue.equals(rightValue)) {
            rightValue = rightValue + "__";
            for (Declaration declaration : declrations) {
                if (!declaration.getIdentifier().equals(leftValue)) continue;
                declaration.setBindingName(rightValue);
            }
            expr = leftValue + " == " + rightValue;
        }
        return expr;
    }

    protected static String normalizeMVELLiteralExpression(ValueType vtype, FieldValue field, String expr, String leftValue, String operator, String rightValue, LiteralRestrictionDescr restrictionDescr) {
        if (vtype == ValueType.DATE_TYPE) {
            Date date = (Date)field.getValue();
            return leftValue + " " + operator + (date != null ? " new java.util.Date(" + date.getTime() + ")" : " null");
        }
        if (operator.equals("str")) {
            String method = restrictionDescr.getParameterText();
            if (method.equals("length")) {
                return leftValue + ".length()" + (restrictionDescr.isNegated() ? " != " : " == ") + rightValue;
            }
            return (restrictionDescr.isNegated() ? "!" : "") + leftValue + "." + method + "(" + rightValue + ")";
        }
        if (expr.startsWith("empty") && (operator.equals("==") || operator.equals("!="))) {
            expr = "isEmpty()" + expr.substring(5);
        }
        return expr;
    }

    protected static Declaration getIndexingDeclaration(Restriction restriction) {
        if (restriction instanceof ReturnValueRestriction) {
            return null;
        }
        Declaration[] declarations = restriction.getRequiredDeclarations();
        return declarations != null && declarations.length > 0 ? declarations[0] : null;
    }

    public Evaluator buildLiteralEvaluator(RuleBuildContext context, InternalReadAccessor extractor, LiteralRestrictionDescr literalRestrictionDescr, ValueType vtype) {
        EvaluatorDefinition.Target right = this.getRightTarget(extractor);
        EvaluatorDefinition.Target left = EvaluatorDefinition.Target.FACT;
        return this.getEvaluator(context, literalRestrictionDescr, vtype, literalRestrictionDescr.getEvaluator(), literalRestrictionDescr.isNegated(), literalRestrictionDescr.getParameterText(), left, right);
    }

    public EvaluatorDefinition.Target getRightTarget(InternalReadAccessor extractor) {
        return extractor.isSelfReference() && !Date.class.isAssignableFrom(extractor.getExtractToClass()) && !Number.class.isAssignableFrom(extractor.getExtractToClass()) ? EvaluatorDefinition.Target.HANDLE : EvaluatorDefinition.Target.FACT;
    }

    public Evaluator getEvaluator(RuleBuildContext context, BaseDescr descr, ValueType valueType, String evaluatorString, boolean isNegated, String parameters, EvaluatorDefinition.Target left, EvaluatorDefinition.Target right) {
        EvaluatorDefinition def = context.getConfiguration().getEvaluatorRegistry().getEvaluatorDefinition(evaluatorString);
        if (def == null) {
            context.addError(new DescrBuildError(context.getParentDescr(), descr, null, "Unable to determine the Evaluator for ID '" + evaluatorString + "'"));
            return null;
        }
        Evaluator evaluator = def.getEvaluator(valueType, evaluatorString, isNegated, parameters, left, right);
        if (evaluator == null) {
            context.addError(new DescrBuildError(context.getParentDescr(), descr, null, "Evaluator '" + (isNegated ? "not " : "") + evaluatorString + "' does not support type '" + valueType));
        }
        return evaluator;
    }

    public EvaluatorWrapper wrapEvaluator(Evaluator evaluator, Declaration left, Declaration right) {
        return new EvaluatorWrapper(evaluator, left, right);
    }

    public MVELCompilationUnit buildCompilationUnit(RuleBuildContext context, Pattern pattern, String expression) {
        Dialect dialect = context.getDialect();
        context.setDialect(context.getDialect("mvel"));
        PredicateDescr predicateDescr = new PredicateDescr(context.getRuleDescr().getResource(), expression);
        AnalysisResult analysis = PatternBuilder.buildAnalysis(context, pattern, predicateDescr, null);
        if (analysis == null) {
            return null;
        }
        Declaration[][] usedDeclarations = PatternBuilder.getUsedDeclarations(context, pattern, analysis);
        MVELCompilationUnit compilationUnit = this.buildCompilationUnit(context, usedDeclarations[0], usedDeclarations[1], predicateDescr, analysis);
        context.setDialect(dialect);
        return compilationUnit;
    }

    public MVELCompilationUnit buildCompilationUnit(RuleBuildContext context, Declaration[] previousDeclarations, Declaration[] localDeclarations, PredicateDescr predicateDescr, AnalysisResult analysis) {
        Class returnClass;
        if (context.isTypesafe() && analysis instanceof MVELAnalysisResult && (returnClass = ((MVELAnalysisResult)analysis).getReturnType()) != Boolean.class && returnClass != Boolean.TYPE) {
            context.addError(new DescrBuildError(context.getParentDescr(), predicateDescr, null, "Predicate '" + predicateDescr.getContent() + "' must be a Boolean expression\n" + predicateDescr.positionAsString()));
        }
        MVELDialect dialect = (MVELDialect)context.getDialect(context.getDialect().getId());
        MVELCompilationUnit unit = null;
        try {
            Map declIds = context.getDeclarationResolver().getDeclarationClasses(context.getRule());
            Pattern p = (Pattern)context.getBuildStack().peek();
            if (p.getObjectType() instanceof ClassObjectType) {
                declIds.put("this", ((ClassObjectType)p.getObjectType()).getClassType());
            }
            unit = dialect.getMVELCompilationUnit((String)predicateDescr.getContent(), analysis, previousDeclarations, localDeclarations, null, context, "drools", KnowledgeHelper.class, false);
        }
        catch (Exception e) {
            DialectUtil.copyErrorLocation(e, predicateDescr);
            context.addError(new DescrBuildError(context.getParentDescr(), predicateDescr, e, "Unable to build expression for 'inline-eval' : " + e.getMessage() + "'" + predicateDescr.getContent() + "'\n" + e.getMessage()));
        }
        return unit;
    }

    static {
        CompatibilityStrategy.setCompatibilityEvaluator((CompatibilityStrategy.CompatibilityEvaluator)StringCoercionCompatibilityEvaluator.INSTANCE);
        DataConversion.addConversionHandler(Boolean.class, (ConversionHandler)BooleanConversionHandler.INSTANCE);
        DataConversion.addConversionHandler(Boolean.TYPE, (ConversionHandler)BooleanConversionHandler.INSTANCE);
        mvelOperators = new HashSet<String>(){
            {
                this.add("==");
                this.add("!=");
                this.add(">");
                this.add(">=");
                this.add("<");
                this.add("<=");
                this.add("~=");
                this.add("str");
                this.add("contains");
                this.add("matches");
                this.add("excludes");
                this.add("memberOf");
                this.add("instanceof");
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StringCoercionCompatibilityEvaluator
    extends CompatibilityStrategy.DefaultCompatibilityEvaluator {
        private static final CompatibilityStrategy.CompatibilityEvaluator INSTANCE = new StringCoercionCompatibilityEvaluator();

        private StringCoercionCompatibilityEvaluator() {
        }

        public boolean areEqualityCompatible(Class<?> c1, Class<?> c2) {
            return true;
        }

        public boolean areComparisonCompatible(Class<?> c1, Class<?> c2) {
            return super.areEqualityCompatible(c1, c2);
        }
    }

    public static class BooleanConversionHandler
    implements ConversionHandler {
        private static final BooleanConversionHandler INSTANCE = new BooleanConversionHandler();

        private BooleanConversionHandler() {
        }

        public Object convertFrom(Object in) {
            if (in.getClass() == Boolean.class || in.getClass() == Boolean.TYPE) {
                return in;
            }
            return in instanceof String && ((String)in).equalsIgnoreCase("true");
        }

        public boolean canConvertFrom(Class cls) {
            return cls == Boolean.class || cls == Boolean.TYPE || cls == String.class;
        }
    }
}

