/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder.dialect.asm;

import java.util.List;
import java.util.Set;
import org.drools.base.TypeResolver;
import org.drools.rule.builder.RuleBuildContext;
import org.drools.rule.builder.dialect.asm.ClassGenerator;
import org.drools.rule.builder.dialect.asm.GeneratorHelper;
import org.drools.rule.builder.dialect.asm.InvokerDataProvider;
import org.drools.util.CompositeClassLoader;
import org.mvel2.asm.MethodVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvokerGenerator {
    public static ClassGenerator createInvokerStubGenerator(InvokerDataProvider data, RuleBuildContext ruleContext) {
        return InvokerGenerator.createStubGenerator(data, (ClassLoader)ruleContext.getPackageBuilder().getRootClassLoader(), ruleContext.getDialect("java").getPackageRegistry().getTypeResolver(), ruleContext.getPkg().getImports().keySet());
    }

    public static ClassGenerator createStubGenerator(final InvokerDataProvider data, ClassLoader classLoader, TypeResolver typeResolver, final Set<String> imports) {
        ClassGenerator generator = new ClassGenerator(data.getPackageName() + "." + data.getInvokerClassName(), classLoader, typeResolver);
        generator.addStaticField(18, "serialVersionUID", Long.TYPE, (Object)GeneratorHelper.INVOKER_SERIAL_UID).addDefaultConstructor();
        generator.addMethod(1, "hashCode", generator.methodDescr(Integer.TYPE, new Class[0]), new ClassGenerator.MethodBody(){

            public void body(MethodVisitor mv) {
                this.push(data.hashCode());
                mv.visitInsn(172);
            }
        }).addMethod(1, "getMethodBytecode", generator.methodDescr(List.class, new Class[0]), (ClassGenerator.MethodBody)new GeneratorHelper.GetMethodBytecodeMethod(data)).addMethod(1, "equals", generator.methodDescr(Boolean.TYPE, new Class[]{Object.class}), (ClassGenerator.MethodBody)new GeneratorHelper.EqualsMethod()).addMethod(1, "getPackageName", generator.methodDescr(String.class, new Class[0]), new ClassGenerator.MethodBody(){

            public void body(MethodVisitor mv) {
                this.push(data.getPackageName());
                mv.visitInsn(176);
            }
        }).addMethod(1, "getGeneratedInvokerClassName", generator.methodDescr(String.class, new Class[0]), new ClassGenerator.MethodBody(){

            public void body(MethodVisitor mv) {
                this.push(data.getInvokerClassName() + "Generated");
                mv.visitInsn(176);
            }
        }).addMethod(1, "getRuleClassName", generator.methodDescr(String.class, new Class[0]), new ClassGenerator.MethodBody(){

            public void body(MethodVisitor mv) {
                this.push(data.getRuleClassName());
                mv.visitInsn(176);
            }
        }).addMethod(1, "getInternalRuleClassName", generator.methodDescr(String.class, new Class[0]), new ClassGenerator.MethodBody(){

            public void body(MethodVisitor mv) {
                this.push(data.getInternalRuleClassName());
                mv.visitInsn(176);
            }
        }).addMethod(1, "getMethodName", generator.methodDescr(String.class, new Class[0]), new ClassGenerator.MethodBody(){

            public void body(MethodVisitor mv) {
                this.push(data.getMethodName());
                mv.visitInsn(176);
            }
        }).addMethod(1, "getInvokerClassName", generator.methodDescr(String.class, new Class[0]), new ClassGenerator.MethodBody(){

            public void body(MethodVisitor mv) {
                this.push(data.getInvokerClassName());
                mv.visitInsn(176);
            }
        }).addMethod(1, "getGlobals", generator.methodDescr(String[].class, new Class[0]), new ClassGenerator.MethodBody(){

            public void body(MethodVisitor mv) {
                this.returnAsArray(data.getGlobals());
            }
        }).addMethod(1, "getGlobalTypes", generator.methodDescr(String[].class, new Class[0]), new ClassGenerator.MethodBody(){

            public void body(MethodVisitor mv) {
                this.returnAsArray(data.getGlobalTypes());
            }
        }).addMethod(1, "getPackageImports", generator.methodDescr(String[].class, new Class[0]), new ClassGenerator.MethodBody(){

            public void body(MethodVisitor mv) {
                this.returnAsArray(imports, String.class);
            }
        });
        return generator;
    }

    static ClassGenerator createInvokerClassGenerator(InvokerDataProvider data, RuleBuildContext ruleContext) {
        String className = data.getPackageName() + "." + data.getInvokerClassName();
        return GeneratorHelper.createInvokerClassGenerator((String)className, (InvokerDataProvider)data, (CompositeClassLoader)ruleContext.getPackageBuilder().getRootClassLoader(), (TypeResolver)ruleContext.getDialect("java").getPackageRegistry().getTypeResolver());
    }
}

