/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.compiler;

import java.io.InputStream;
import java.io.Reader;
import org.antlr.runtime.ANTLRInputStream;
import org.antlr.runtime.ANTLRReaderStream;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognizerSharedState;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.drools.compiler.lang.DRL5Expressions;
import org.drools.compiler.lang.DRL5Lexer;
import org.drools.compiler.lang.DRL5Parser;
import org.drools.compiler.lang.DRL6Expressions;
import org.drools.compiler.lang.DRL6Lexer;
import org.drools.compiler.lang.DRL6Parser;
import org.drools.compiler.lang.DRLExpressions;
import org.drools.compiler.lang.DRLLexer;
import org.drools.compiler.lang.DRLParser;
import org.drools.compiler.lang.ParserHelper;
import org.kie.internal.builder.conf.LanguageLevelOption;

public class DRLFactory {
    private DRLFactory() {
    }

    public static DRLLexer buildLexer(String text, LanguageLevelOption languageLevel) {
        return DRLFactory.getDRLLexer((CharStream)new ANTLRStringStream(text), languageLevel);
    }

    public static DRLLexer buildLexer(Reader reader, LanguageLevelOption languageLevel) {
        try {
            return DRLFactory.getDRLLexer((CharStream)new ANTLRReaderStream(reader), languageLevel);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to parser Reader", e);
        }
    }

    public static DRLLexer buildLexer(InputStream is, String encoding, LanguageLevelOption languageLevel) {
        try {
            return DRLFactory.getDRLLexer((CharStream)(encoding != null ? new ANTLRInputStream(is, encoding) : new ANTLRInputStream(is)), languageLevel);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to parser Reader", e);
        }
    }

    public static DRLParser buildParser(DRLLexer lexer, LanguageLevelOption languageLevel) {
        CommonTokenStream stream = new CommonTokenStream((TokenSource)lexer);
        return DRLFactory.getDRLParser(stream, languageLevel);
    }

    public static DRLParser buildParser(CharStream input, LanguageLevelOption languageLevel) {
        return DRLFactory.buildParser(DRLFactory.getDRLLexer(input, languageLevel), languageLevel);
    }

    public static DRLParser buildParser(String text, LanguageLevelOption languageLevel) {
        return DRLFactory.buildParser((CharStream)new ANTLRStringStream(text), languageLevel);
    }

    public static DRLParser buildParser(Reader reader, LanguageLevelOption languageLevel) {
        try {
            return DRLFactory.buildParser((CharStream)new ANTLRReaderStream(reader), languageLevel);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to parser Reader", e);
        }
    }

    public static DRLParser buildParser(InputStream is, String encoding, LanguageLevelOption languageLevel) {
        try {
            return DRLFactory.buildParser((CharStream)(encoding != null ? new ANTLRInputStream(is, encoding) : new ANTLRInputStream(is)), languageLevel);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to parser Reader", e);
        }
    }

    public static DRLParser getDRLParser(CommonTokenStream stream, LanguageLevelOption languageLevel) {
        switch (languageLevel) {
            case DRL5: {
                return new DRL5Parser((TokenStream)stream);
            }
            case DRL6: {
                return new DRL6Parser((TokenStream)stream);
            }
        }
        throw new RuntimeException("Unknown language level");
    }

    public static DRLLexer getDRLLexer(CharStream input, LanguageLevelOption languageLevel) {
        switch (languageLevel) {
            case DRL5: {
                return new DRL5Lexer(input);
            }
            case DRL6: {
                return new DRL6Lexer(input);
            }
        }
        throw new RuntimeException("Unknown language level");
    }

    public static DRLExpressions getDRLExpressions(TokenStream input, RecognizerSharedState state, ParserHelper helper, LanguageLevelOption languageLevel) {
        switch (languageLevel) {
            case DRL5: {
                return new DRL5Expressions(input, state, helper);
            }
            case DRL6: {
                return new DRL6Expressions(input, state, helper);
            }
        }
        throw new RuntimeException("Unknown language level");
    }

    public static int lexerId(LanguageLevelOption languageLevel) {
        switch (languageLevel) {
            case DRL5: {
                return 69;
            }
            case DRL6: {
                return 69;
            }
        }
        throw new RuntimeException("Unknown language level");
    }

    public static String getBetterToken(int tokenType, String defaultValue, LanguageLevelOption languageLevel) {
        switch (languageLevel) {
            case DRL5: {
                return DRLFactory.getBetterTokenForDRL5(tokenType, defaultValue);
            }
            case DRL6: {
                return DRLFactory.getBetterTokenForDRL6(tokenType, defaultValue);
            }
        }
        throw new RuntimeException("Unknown language level");
    }

    private static String getBetterTokenForDRL5(int tokenType, String defaultValue) {
        switch (tokenType) {
            case 13: {
                return defaultValue == null ? "int" : defaultValue;
            }
            case 9: {
                return defaultValue == null ? "float" : defaultValue;
            }
            case 15: {
                return defaultValue == null ? "string" : defaultValue;
            }
            case 19: {
                return defaultValue == null ? "boolean" : defaultValue;
            }
            case 20: {
                return "null";
            }
            case 34: {
                return ";";
            }
            case 35: {
                return ":";
            }
            case 36: {
                return "==";
            }
            case 37: {
                return "!=";
            }
            case 40: {
                return ">";
            }
            case 38: {
                return ">=";
            }
            case 41: {
                return "<";
            }
            case 39: {
                return "<=";
            }
            case 33: {
                return "->";
            }
            case 69: {
                return defaultValue == null ? "identifier" : defaultValue;
            }
            case 43: {
                return "(";
            }
            case 44: {
                return ")";
            }
            case 45: {
                return "[";
            }
            case 46: {
                return "]";
            }
            case 47: {
                return "{";
            }
            case 48: {
                return "}";
            }
            case 49: {
                return ",";
            }
            case 50: {
                return ".";
            }
            case 52: {
                return "&&";
            }
            case 53: {
                return "||";
            }
            case 71: {
                return defaultValue == null ? "misc" : defaultValue;
            }
            case -1: {
                return "<eof>";
            }
        }
        return defaultValue;
    }

    private static String getBetterTokenForDRL6(int tokenType, String defaultValue) {
        switch (tokenType) {
            case 13: {
                return defaultValue == null ? "int" : defaultValue;
            }
            case 9: {
                return defaultValue == null ? "float" : defaultValue;
            }
            case 15: {
                return defaultValue == null ? "string" : defaultValue;
            }
            case 19: {
                return defaultValue == null ? "boolean" : defaultValue;
            }
            case 20: {
                return "null";
            }
            case 34: {
                return ";";
            }
            case 35: {
                return ":";
            }
            case 36: {
                return "==";
            }
            case 37: {
                return "!=";
            }
            case 40: {
                return ">";
            }
            case 38: {
                return ">=";
            }
            case 41: {
                return "<";
            }
            case 39: {
                return "<=";
            }
            case 33: {
                return "->";
            }
            case 69: {
                return defaultValue == null ? "identifier" : defaultValue;
            }
            case 43: {
                return "(";
            }
            case 44: {
                return ")";
            }
            case 45: {
                return "[";
            }
            case 46: {
                return "]";
            }
            case 47: {
                return "{";
            }
            case 48: {
                return "}";
            }
            case 49: {
                return ",";
            }
            case 50: {
                return ".";
            }
            case 52: {
                return "&&";
            }
            case 53: {
                return "||";
            }
            case 71: {
                return defaultValue == null ? "misc" : defaultValue;
            }
            case -1: {
                return "<eof>";
            }
        }
        return defaultValue;
    }
}

