/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.kie.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.drools.compiler.compiler.DrlParser;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.util.ChangeType;
import org.drools.compiler.kie.util.KieJarChangeSet;
import org.drools.compiler.kie.util.ResourceChange;
import org.drools.compiler.kie.util.ResourceChangeSet;
import org.drools.compiler.lang.descr.PackageDescr;
import org.drools.compiler.lang.descr.RuleDescr;
import org.drools.core.io.impl.ByteArrayResource;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeSetBuilder {
    private final Logger logger = LoggerFactory.getLogger(ChangeSetBuilder.class);

    public KieJarChangeSet build(InternalKieModule original, InternalKieModule currentJar) {
        KieJarChangeSet result = new KieJarChangeSet();
        Collection<String> originalFiles = original.getFileNames();
        Collection<String> currentFiles = currentJar.getFileNames();
        ArrayList<String> removedFiles = new ArrayList<String>(originalFiles);
        removedFiles.removeAll(currentFiles);
        if (!removedFiles.isEmpty()) {
            for (String file : removedFiles) {
                result.getChanges().put(file, new ResourceChangeSet(file, ChangeType.REMOVED));
            }
        }
        for (String file : currentFiles) {
            if (originalFiles.contains(file)) {
                byte[] cb;
                byte[] ob = original.getBytes(file);
                if (Arrays.equals(ob, cb = currentJar.getBytes(file))) continue;
                result.getChanges().put(file, this.diffResource(file, ob, cb));
                continue;
            }
            result.getChanges().put(file, new ResourceChangeSet(file, ChangeType.ADDED));
        }
        return result;
    }

    public ResourceChangeSet diffResource(String file, byte[] ob, byte[] cb) {
        ResourceChangeSet pkgcs = new ResourceChangeSet(file, ChangeType.UPDATED);
        ResourceType type = ResourceType.determineResourceType((String)file);
        if (ResourceType.DRL.equals((Object)type)) {
            try {
                PackageDescr opkg = new DrlParser().parse((Resource)new ByteArrayResource(ob));
                PackageDescr cpkg = new DrlParser().parse((Resource)new ByteArrayResource(cb));
                ArrayList<RuleDescr> orules = new ArrayList<RuleDescr>(opkg.getRules());
                List<RuleDescr> crules = cpkg.getRules();
                for (RuleDescr crd : crules) {
                    boolean found = false;
                    Iterator it = orules.iterator();
                    while (it.hasNext()) {
                        RuleDescr ord = (RuleDescr)it.next();
                        if (!ord.getName().equals(crd)) continue;
                        found = true;
                        it.remove();
                        if (ord.equals(crd)) break;
                        pkgcs.getChanges().add(new ResourceChange(ChangeType.UPDATED, ResourceChange.Type.RULE, crd.getName()));
                        break;
                    }
                    if (found) continue;
                    pkgcs.getChanges().add(new ResourceChange(ChangeType.ADDED, ResourceChange.Type.RULE, crd.getName()));
                }
                for (RuleDescr ord : orules) {
                    pkgcs.getChanges().add(new ResourceChange(ChangeType.REMOVED, ResourceChange.Type.RULE, ord.getName()));
                }
            }
            catch (Exception e) {
                this.logger.error("Error analyzing the contents of " + file + ". Skipping.", (Throwable)e);
            }
        }
        Collections.sort(pkgcs.getChanges(), new Comparator<ResourceChange>(){

            @Override
            public int compare(ResourceChange o1, ResourceChange o2) {
                return o1.getChangeType().ordinal() - o2.getChangeType().ordinal();
            }
        });
        return pkgcs;
    }

    public String toProperties(KieJarChangeSet kcs) {
        StringBuilder builder = new StringBuilder();
        builder.append("kiejar.changeset.version=1.0\n");
        int i = 0;
        for (ResourceChangeSet rcs : kcs.getChanges().values()) {
            String prefix = "kiejar.changeset." + (Object)((Object)rcs.getChangeType()) + ".r" + i++;
            builder.append(prefix).append("=").append(rcs.getResourceName()).append("\n");
            int j = 0;
            for (ResourceChange change : rcs.getChanges()) {
                builder.append(prefix).append(".").append((Object)change.getChangeType()).append(".").append((Object)change.getType()).append(j++).append("=").append(change.getName()).append("\n");
            }
        }
        return builder.toString();
    }
}

