/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.lang.descr;

import java.util.HashMap;
import java.util.Map;
import org.drools.compiler.lang.descr.BaseDescr;

public class AnnotationDescr
extends BaseDescr {
    private static final String VALUE = "value";
    private static final long serialVersionUID = 520L;
    private final String name;
    private Map<String, String> values;

    public static String unquote(String s) {
        if (s.startsWith("\"") && s.endsWith("\"") || s.startsWith("'") && s.endsWith("'")) {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    public AnnotationDescr(String name) {
        this.name = name;
        this.values = new HashMap<String, String>();
    }

    public AnnotationDescr(String name, String value) {
        this.name = name;
        this.values = new HashMap<String, String>();
        this.values.put(VALUE, value);
    }

    public String getName() {
        return this.name;
    }

    public boolean hasValue() {
        return !this.values.isEmpty();
    }

    public void setValue(String value) {
        this.values.put(VALUE, value);
    }

    public void setKeyValue(String key, String value) {
        this.values.put(key, value);
    }

    public String getValue(String key) {
        return this.values.get(key);
    }

    public Map<String, String> getValues() {
        return this.values;
    }

    public Object getValue() {
        String single = this.getSingleValue();
        return single != null ? single : this.values;
    }

    public Object getValueStripped() {
        String single = this.getSingleValueStripped();
        if (single != null) {
            return single;
        }
        HashMap<String, String> sMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.values.entrySet()) {
            sMap.put(entry.getKey(), AnnotationDescr.unquote(entry.getValue()));
        }
        return sMap;
    }

    public Map<String, String> getValueMap() {
        return this.values;
    }

    public String getSingleValue() {
        if (this.values.size() == 1 && this.values.containsKey(VALUE)) {
            return this.values.get(VALUE);
        }
        return null;
    }

    public String getSingleValueStripped() {
        if (this.values.size() == 1 && this.values.containsKey(VALUE)) {
            return AnnotationDescr.unquote(this.values.get(VALUE));
        }
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AnnotationDescr other = (AnnotationDescr)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

