/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.rule.builder.dialect.mvel;

import java.util.Map;
import org.drools.compiler.compiler.AnalysisResult;
import org.drools.compiler.compiler.BoundIdentifiers;
import org.drools.compiler.compiler.DescrBuildError;
import org.drools.compiler.lang.descr.PredicateDescr;
import org.drools.compiler.rule.builder.PredicateBuilder;
import org.drools.compiler.rule.builder.RuleBuildContext;
import org.drools.compiler.rule.builder.dialect.DialectUtil;
import org.drools.compiler.rule.builder.dialect.mvel.MVELAnalysisResult;
import org.drools.compiler.rule.builder.dialect.mvel.MVELDialect;
import org.drools.core.base.ClassObjectType;
import org.drools.core.base.mvel.MVELCompilationUnit;
import org.drools.core.base.mvel.MVELCompileable;
import org.drools.core.base.mvel.MVELPredicateExpression;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.MVELDialectRuntimeData;
import org.drools.core.rule.Pattern;
import org.drools.core.rule.PredicateConstraint;
import org.drools.core.spi.KnowledgeHelper;
import org.drools.core.spi.PredicateExpression;
import org.drools.core.spi.Wireable;

public class MVELPredicateBuilder
implements PredicateBuilder {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void build(RuleBuildContext context, BoundIdentifiers usedIdentifiers, Declaration[] previousDeclarations, Declaration[] localDeclarations, PredicateConstraint predicate, PredicateDescr predicateDescr, AnalysisResult analysis) {
        Class returnClass;
        boolean typesafe = context.isTypesafe();
        if (typesafe && analysis instanceof MVELAnalysisResult && (returnClass = ((MVELAnalysisResult)analysis).getReturnType()) != Boolean.class && returnClass != Boolean.TYPE) {
            context.addError(new DescrBuildError(context.getParentDescr(), predicateDescr, null, "Predicate '" + predicateDescr.getContent() + "' must be a Boolean expression\n" + predicateDescr.positionAsString()));
        }
        MVELDialect dialect = (MVELDialect)context.getDialect(context.getDialect().getId());
        try {
            Map declIds = context.getDeclarationResolver().getDeclarationClasses(context.getRule());
            Pattern p = (Pattern)context.getBuildStack().peek();
            if (p.getObjectType() instanceof ClassObjectType) {
                declIds.put("this", ((ClassObjectType)p.getObjectType()).getClassType());
            }
            MVELCompilationUnit unit = dialect.getMVELCompilationUnit((String)predicateDescr.getContent(), analysis, previousDeclarations, localDeclarations, null, context, "drools", KnowledgeHelper.class, false);
            MVELPredicateExpression expr = new MVELPredicateExpression(unit, context.getDialect().getId());
            predicate.setPredicateExpression((PredicateExpression)expr);
            MVELDialectRuntimeData data = (MVELDialectRuntimeData)context.getPkg().getDialectRuntimeRegistry().getDialectData("mvel");
            data.addCompileable((Wireable)predicate, (MVELCompileable)expr);
            expr.compile(data);
        }
        catch (Exception e) {
            DialectUtil.copyErrorLocation(e, predicateDescr);
            context.addError(new DescrBuildError(context.getParentDescr(), predicateDescr, e, "Unable to build expression for 'inline-eval' : " + e.getMessage() + "'" + predicateDescr.getContent() + "'\n" + e.getMessage()));
        }
        finally {
            context.setTypesafe(typesafe);
        }
    }
}

