/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.builder.impl;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.builder.impl.TypeDeclarationUtils;
import org.drools.compiler.builder.impl.TypeDefinition;
import org.drools.compiler.compiler.PackageRegistry;
import org.drools.compiler.compiler.TypeDeclarationError;
import org.drools.compiler.lang.descr.AbstractClassTypeDeclarationDescr;
import org.drools.compiler.lang.descr.EnumDeclarationDescr;
import org.drools.compiler.lang.descr.PackageDescr;
import org.drools.compiler.lang.descr.QualifiedName;
import org.drools.compiler.lang.descr.TypeDeclarationDescr;
import org.drools.compiler.lang.descr.TypeFieldDescr;
import org.drools.core.base.TypeResolver;
import org.drools.core.rule.TypeDeclaration;
import org.drools.core.util.ClassUtils;

public class TypeDeclarationNameResolver {
    private KnowledgeBuilderImpl kbuilder;

    public TypeDeclarationNameResolver(KnowledgeBuilderImpl kbuilder) {
        this.kbuilder = kbuilder;
    }

    public void resolveTypes(Collection<? extends PackageDescr> packageDescrs, Collection<AbstractClassTypeDeclarationDescr> unsortedDescrs, List<TypeDefinition> unresolvedTypes, Map<String, AbstractClassTypeDeclarationDescr> unprocesseableDescrs) {
        this.ensureQualifiedNames(packageDescrs, unresolvedTypes, unprocesseableDescrs);
    }

    protected void ensureQualifiedNames(Collection<? extends PackageDescr> packageDescrs, List<TypeDefinition> unresolvedTypes, Map<String, AbstractClassTypeDeclarationDescr> unprocesseableDescrs) {
        for (PackageDescr packageDescr : packageDescrs) {
            for (AbstractClassTypeDeclarationDescr descr : packageDescr.getClassAndEnumDeclarationDescrs()) {
                this.ensureQualifiedDeclarationName(descr, packageDescr, this.kbuilder.getPackageRegistry(packageDescr.getName()).getTypeResolver(), unresolvedTypes);
            }
        }
        for (PackageDescr packageDescr : packageDescrs) {
            for (TypeDeclarationDescr declarationDescr : packageDescr.getTypeDeclarations()) {
                this.qualifyNames(declarationDescr, packageDescr, unresolvedTypes, unprocesseableDescrs);
                this.discoverHierarchyForRedeclarations(declarationDescr, packageDescr);
            }
            for (EnumDeclarationDescr enumDeclarationDescr : packageDescr.getEnumDeclarations()) {
                this.qualifyNames(enumDeclarationDescr, packageDescr, unresolvedTypes, unprocesseableDescrs);
            }
        }
    }

    private void qualifyNames(AbstractClassTypeDeclarationDescr declarationDescr, PackageDescr packageDescr, List<TypeDefinition> unresolvedTypes, Map<String, AbstractClassTypeDeclarationDescr> unprocesseableDescrs) {
        this.ensureQualifiedSuperType(declarationDescr, packageDescr, this.kbuilder.getPackageRegistry(packageDescr.getName()).getTypeResolver(), unresolvedTypes);
        this.ensureQualifiedFieldType(declarationDescr, packageDescr, this.kbuilder.getPackageRegistry(packageDescr.getName()).getTypeResolver(), unresolvedTypes);
    }

    private void discoverHierarchyForRedeclarations(TypeDeclarationDescr typeDescr, PackageDescr packageDescr) {
        PackageRegistry pkReg = this.kbuilder.getPackageRegistry(packageDescr.getName());
        if (!TypeDeclarationUtils.isNovelClass(typeDescr, pkReg)) {
            Class<?> typeClass = TypeDeclarationUtils.getExistingDeclarationClass(typeDescr, pkReg);
            if (typeClass != null && typeDescr.isTrait()) {
                this.fillStaticInterfaces(typeDescr, typeClass);
            } else {
                typeDescr.getSuperTypes().clear();
                typeDescr.addSuperType(typeClass.isInterface() || typeClass == Object.class ? Object.class.getName() : typeClass.getSuperclass().getName());
            }
        }
    }

    private void ensureQualifiedDeclarationName(AbstractClassTypeDeclarationDescr declarationDescr, PackageDescr packageDescr, TypeResolver typeResolver, List<TypeDefinition> unresolvedTypes) {
        if (!declarationDescr.getType().isFullyQualified()) {
            String resolved = this.resolveName(declarationDescr.getType().getFullName(), declarationDescr, packageDescr, typeResolver, unresolvedTypes, false);
            if (resolved != null && !this.alreadyDefinedInPackage(resolved, declarationDescr, packageDescr)) {
                declarationDescr.setTypeName(resolved);
            } else {
                declarationDescr.setNamespace(packageDescr.getNamespace());
            }
        }
    }

    private boolean alreadyDefinedInPackage(String resolved, AbstractClassTypeDeclarationDescr current, PackageDescr pd) {
        for (AbstractClassTypeDeclarationDescr typeDeclaration : pd.getClassAndEnumDeclarationDescrs()) {
            if (typeDeclaration == current || !typeDeclaration.getType().getFullName().equals(resolved)) continue;
            return true;
        }
        return false;
    }

    private void ensureQualifiedSuperType(AbstractClassTypeDeclarationDescr typeDescr, PackageDescr packageDescr, TypeResolver typeResolver, List<TypeDefinition> unresolvedTypes) {
        for (QualifiedName qname : typeDescr.getSuperTypes()) {
            String declaredSuperType = qname.getFullName();
            String resolved = this.resolveName(declaredSuperType, typeDescr, packageDescr, typeResolver, unresolvedTypes, true);
            if (resolved != null) {
                qname.setName(resolved);
                continue;
            }
            this.kbuilder.addBuilderResult(new TypeDeclarationError(typeDescr, "Cannot resolve supertype '" + declaredSuperType + " for declared type " + typeDescr.getTypeName()));
        }
    }

    public void ensureQualifiedFieldType(AbstractClassTypeDeclarationDescr typeDescr, PackageDescr packageDescr, TypeResolver typeResolver, List<TypeDefinition> unresolvedTypes) {
        for (TypeFieldDescr field : typeDescr.getFields().values()) {
            String declaredType = field.getPattern().getObjectType();
            String resolved = this.resolveName(declaredType, typeDescr, packageDescr, typeResolver, unresolvedTypes, true);
            if (resolved != null) {
                field.getPattern().setObjectType(resolved);
                continue;
            }
            this.kbuilder.addBuilderResult(new TypeDeclarationError(typeDescr, "Cannot resolve type '" + declaredType + " for field " + field.getFieldName() + " in declared type " + typeDescr.getTypeName()));
        }
    }

    private String resolveName(String type, AbstractClassTypeDeclarationDescr typeDescr, PackageDescr packageDescr, TypeResolver typeResolver, List<TypeDefinition> unresolvedTypes, boolean forceResolution) {
        if (!TypeDeclarationUtils.isQualified(type)) {
            type = TypeDeclarationUtils.lookupSimpleNameByImports(type, typeDescr, packageDescr, this.kbuilder.getRootClassLoader());
        }
        if (!TypeDeclarationUtils.isQualified(type)) {
            type = TypeDeclarationUtils.resolveType(type, packageDescr, this.kbuilder.getPackageRegistry(packageDescr.getNamespace()));
        }
        if (!TypeDeclarationUtils.isQualified(type)) {
            try {
                Class klass = typeResolver.resolveType(type, (TypeResolver.ClassFilter)TypeResolver.EXCLUDE_ANNOTATION_CLASS_FILTER);
                type = klass.getCanonicalName();
                return type;
            }
            catch (ClassNotFoundException e) {}
        } else {
            type = TypeDeclarationUtils.typeName2ClassName(type, this.kbuilder.getRootClassLoader());
        }
        if (forceResolution && !TypeDeclarationUtils.isQualified(type)) {
            TypeDeclaration temp = new TypeDeclaration(type);
            temp.setTypeClassName(type);
            unresolvedTypes.add(new TypeDefinition(temp, null));
        }
        return TypeDeclarationUtils.isQualified(type) ? type : null;
    }

    private void fillStaticInterfaces(TypeDeclarationDescr typeDescr, Class<?> typeClass) {
        for (Class iKlass : ClassUtils.getAllImplementedInterfaceNames(typeClass)) {
            typeDescr.addSuperType(iKlass.getName());
        }
    }
}

