/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.lang.descr;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.drools.compiler.lang.descr.AnnotationDescr;
import org.drools.compiler.lang.descr.BaseDescr;
import org.drools.compiler.rule.builder.util.AnnotationFactory;
import org.drools.core.rule.Annotated;

public class AnnotatedBaseDescr
extends BaseDescr
implements Annotated,
Externalizable {
    private Map<String, AnnotationDescr> annotations = new HashMap<String, AnnotationDescr>();
    private static final long serialVersionUID = 520L;

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.annotations = (Map)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.annotations);
    }

    public AnnotationDescr addAnnotation(AnnotationDescr annotation) {
        return this.addAnnotation(annotation.getName(), annotation);
    }

    public AnnotationDescr addQualifiedAnnotation(AnnotationDescr annotation) {
        return this.addAnnotation(annotation.getFullyQualifiedName(), annotation);
    }

    protected AnnotationDescr addAnnotation(String name, AnnotationDescr annotation) {
        if (this.annotations == null) {
            this.annotations = new HashMap<String, AnnotationDescr>();
        } else {
            AnnotationDescr existingAnnotation = this.annotations.get(name);
            if (existingAnnotation != null) {
                existingAnnotation.setDuplicated();
                return existingAnnotation;
            }
        }
        return this.annotations.put(name, annotation);
    }

    public AnnotationDescr addAnnotation(String name, String value) {
        if (this.annotations == null) {
            this.annotations = new HashMap<String, AnnotationDescr>();
        } else {
            AnnotationDescr existingAnnotation = this.annotations.get(name);
            if (existingAnnotation != null) {
                existingAnnotation.setDuplicated();
                return existingAnnotation;
            }
        }
        AnnotationDescr annotation = new AnnotationDescr(name, value);
        annotation.setResource(this.getResource());
        return this.annotations.put(annotation.getName(), annotation);
    }

    public AnnotationDescr getAnnotation(String name) {
        return this.annotations == null ? null : this.annotations.get(name);
    }

    public AnnotationDescr getAnnotation(Class<? extends Annotation> annotationClass) {
        return this.annotations == null ? null : this.annotations.get(annotationClass.getCanonicalName());
    }

    public <A extends Annotation> A getTypedAnnotation(Class<A> annotationClass) {
        AnnotationDescr annotationDescr = this.getAnnotation(annotationClass);
        return (A)(annotationDescr == null ? null : AnnotationFactory.buildAnnotation(annotationDescr, annotationClass));
    }

    public boolean hasAnnotation(Class<? extends Annotation> annotationClass) {
        return this.getAnnotation(annotationClass) != null;
    }

    public Set<String> getAnnotationNames() {
        return this.annotations == null ? null : this.annotations.keySet();
    }

    public Collection<AnnotationDescr> getAnnotations() {
        return this.annotations != null ? this.annotations.values() : Collections.emptySet();
    }

    public void indexByFQN(boolean isStrict) {
        HashMap<String, AnnotationDescr> fqnAnnotations = new HashMap<String, AnnotationDescr>();
        for (AnnotationDescr annotationDescr : this.annotations.values()) {
            if (annotationDescr.getFullyQualifiedName() != null) {
                fqnAnnotations.put(annotationDescr.getFullyQualifiedName(), annotationDescr);
                continue;
            }
            if (isStrict) continue;
            fqnAnnotations.put(annotationDescr.getName(), annotationDescr);
        }
        this.annotations = fqnAnnotations;
    }
}

